<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';
$title = "ユーザー詳細";

$user_id = filter_input(INPUT_POST,"user_id");

$posted_log = "user_id -> {$user_id}";

if(empty($user_id)){
	$log = "必要な情報がない | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

try {
	$pdo = DBopen();

	$update_sql = "UPDATE user SET fixed_date = '', fixed_ring_type = '', fixed_ring_size = '', fixed_ring_width = '', fixed_ring_thickness = '', updated = ? WHERE user_id = ?";
	$update = $pdo->prepare($update_sql);

	$date = new DateTime();
	$updated = $date->format("Y-m-d H:i:s");

	$update->bindValue(1,$updated,PDO::PARAM_STR);
	$update->bindValue(2,$user_id,PDO::PARAM_STR);
	$update->execute();

} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error} | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

$_SESSION["details"]["action"] = "指輪の確定情報を取り消しました。";

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<script>
window.onload = function(){
	document.f.submit();
}
</script>
</head>
<body>
	<form method="post" action="details.php" name="f">
		<input type="hidden" id="user_id" name="user_id" value="<?=$user_id?>">
	</form>
</body>
</html>
