<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/server_check.php';
require_once '../include/functions.php';
require_once '../include/db.php';
require_once '../include/config.php';

$password = filter_input(INPUT_POST,"password");
$error = filter_input(INPUT_POST,"error");

if(empty($error) && !empty($password)){
	// 成功した
	$display_text =<<<EOD
	<p>パスワードを再発行しました。</p>
	<p><span class="">パスワード：</span><span class="">{$password}</span></p>
	<p>表示されたパスワードは大切に保管してください。</p>
EOD;
} else if(!empty($error)){
	// 失敗した
	$display_text = $error;
} else {
	// POSTがない
	$display_text = "エラーが発生しました。";
}

$title = "パスワード再発行";
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="../img/favicon.ico">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<style>
html, body {
	margin: 0;
	font-family: "Helvetica Neue", Arial, "Hiragino Kaku Gothic ProN", "Hiragino Sans", Meiryo, sans-serif;
	min-height: 100vh;
}
#wrapper {
	display: flex;
	flex-direction: column;
	justify-content: space-between;
	min-height: 100vh;
}
#header {
	width: 100%;
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	text-align: center;
	padding: 20px 0 10px;
}
#header img {
	width: 200px;
	margin: 10px;
}
#title_box {
	width: 100%;
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	text-align: center;
	padding: 10px 0 20px;
}
#title_block {
	width: 80%;
	max-width: 600px;
	margin: auto;
	padding: 10px;
	border: 1px solid #fff;
}
.title_block_text {
	display: block;
	color: #fff;
}
#head_text {
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	color: #fff;
	text-align: center;
}
#main {
	margin: 50px auto;
	width: 100%;
	max-width: 600px;
}
#post_form {
	width: 90%;
	margin: auto;
}
.login_input {
	width: 100%;
	box-sizing: border-box;
	height: 35px;
}
.login_button_margin {
	margin-top: 50px;
	text-align: center;
}
.login_button {
	width: 100%;
	height: 35px;
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	color: #fff;
}
#error_text {
	text-align: center;
	color: red;
}
.nodisp {
	display: none;
}
.active {
	display: block;
}
#footer {
	height: 10vh;
}
.link_text {
	color: #0070C0;
	cursor: pointer;
}
.display_box {
	width: 90%;
	margin: auto;
}
</style>
<title><?=$title?></title>
</head>
<body>
	<div id="wrapper">
		<div>
			<div id="header">
				<img src="../img/Logo.png" width="150px">
			</div>
			<div id="title_box">
				<div id="title_block">
					<span class="title_block_text">tanzo.fit</span>
					<span class="title_block_text">入籍指輪システム</span>
				</div>
			</div>
			<div id="head_text">
				パスワード再発行
			</div>
		</div>
		<div id="main">
			<div class="display_box">
				<?= $display_text ?>
			</div>
		</div>
		<div id="footer"></div>
	</div>
</body>
</html>
