<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/server_check.php';
require_once './include/functions.php';
require_once './include/db.php';
require_once './include/config.php';

$post_mail = filter_input(INPUT_POST,'input_mail');
$error_text = "";
$error_class = "nodisp";

if(!empty($post_mail)){
	// メールアドレスを確認する
	try {
		$pdo = DBopen();

		$select_sql = "SELECT * FROM user WHERE mail = ?";
		$select = $pdo->prepare($select_sql);
		$select->bindValue(1,$post_mail,PDO::PARAM_STR);
		$select->execute();

		if($row = $select->fetch()){
			// 存在する
			$user_id = $row["user_id"];

			// トークンのセットとメールを送信する
			$token = RandomToken();
			$date = new DateTime();
			$created = $date->format("Y-m-d H:i:s");

			$insert_sql = "INSERT INTO token (user_id, token, created) VALUES (?,?,?)";
			$insert = $pdo->prepare($insert_sql);
			$insert->bindValue(1,$user_id,PDO::PARAM_STR);
			$insert->bindValue(2,$token,PDO::PARAM_STR);
			$insert->bindValue(3,$created,PDO::PARAM_STR);
			$insert->execute();

			$id = $pdo->lastInsertId();

			// メール送信する
			$id_encript = openssl_encrypt($id,'aes-256-ecb',id_cript_key);
			$id_hex = bin2hex($id_encript);

			$user_encript = openssl_encrypt($user_id,'aes-256-ecb',user_cript_key);
			$user_hex = bin2hex($user_encript);

			$token_encript = openssl_encrypt($token,'aes-256-ecb',token_cript_key);
			$token_hex = bin2hex($token_encript);

			mb_language("Japanese");
			mb_internal_encoding("UTF-8");

			if(SERVER_CHECK === 1){
				// 本番
				$to = $post_mail;
				$from = mail_from;
				$url = "https://tanzo.fit/system/password_reset.php?i={$id_hex}&u={$user_hex}&t={$token_hex}";
			} else {
				// 開発
				$to = "hirota@apteq.jp";
				$from = "test@demo55.jp";
				$url = "https://demo55.jp/tanzo/system/password_reset.php?i={$id_hex}&u={$user_hex}&t={$token_hex}";
			}

			$headers = [];

			$charset = "UTF-8";
			$headers['MIME-Version'] = "1.0";

			$From_name = "入籍指輪システム";
			//$From_encoded = mb_convert_encoding($From_name, 'UTF-8', 'AUTO'); // mb_encode_mimeheaderに渡す前にUTF-8に変換しなくてはダメ
			$From_address = $from;
			$headers['From'] = mb_encode_mimeheader($From_name, 'UTF-8') ."<". $From_address .">";
			$headers['Content-Type'] = "text/plain; charset=".$charset;
			$headers['Reply-to'] = $From_address;
			$headers['Sender'] = $From_address;
			$headers['Return-Path'] = $From_address;
			//$headers['Content-Transfer-Encoding'] = "BASE64";

			//配列から連結させる
			foreach ($headers as $key => $val) {
				$arrheader[] = $key . ': ' . $val;
			}
			$strHeader = implode("\n", $arrheader);

			$title = "パスワード再発行";

			$content = "こちらはTANZO.「入籍指輪システム」のパスワード再発行の為のご案内です。
身に覚えのない場合はURLにアクセスせずにこのメールを破棄してください。

パスワード再発行用URL
{$url}

URLにアクセスするとパスワードを再発行します。
表示されたパスワードを大切に保管してください。";

			if(!mail($to, $title, $content, $strHeader,"-f {$From_address}")){
				// メールの送信に失敗
				$log = "メールの送信に失敗";
				Writelog($log,"mail_send_false");
				$result = "N";
			} else {
				$result = "Y";
			}

			header("Location: request_finish.php?r={$result}");
			exit;

		} else {
			throw new RuntimeException("アカウントが存在しない");
		}

	} catch(Exception $e){
		$error = $e->getMessage();
		$log = "error -> {$error}";
		Writelog($log,basename(__FILE__));
		$error_text = "メールアドレスが間違っています。";
	}

	$error_text = "メールアドレスが間違っています。";
	$error_class = "active";
}

$title = "パスワード再発行";
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<style>
html, body {
	margin: 0;
	font-family: "Helvetica Neue", Arial, "Hiragino Kaku Gothic ProN", "Hiragino Sans", Meiryo, sans-serif;
	min-height: 100vh;
}
#wrapper {
	display: flex;
	flex-direction: column;
	justify-content: space-between;
	min-height: 100vh;
}
#header {
	width: 100%;
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	text-align: center;
	padding: 20px 0 10px;
}
#header img {
	width: 200px;
	margin: 10px;
}
#title_box {
	width: 100%;
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	text-align: center;
	padding: 10px 0 20px;
}
#title_block {
	width: 80%;
	max-width: 600px;
	margin: auto;
	padding: 10px;
	border: 1px solid #fff;
}
.title_block_text {
	display: block;
	color: #fff;
}
#head_text {
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	color: #fff;
	text-align: center;
}
#main {
	margin: 50px auto;
	width: 100%;
	max-width: 600px;
}
#post_form {
	width: 90%;
	margin: auto;
}
.login_input {
	width: 100%;
	box-sizing: border-box;
	height: 35px;
}
.login_button_margin {
	margin-top: 50px;
	text-align: center;
}
.login_button {
	width: 100%;
	height: 35px;
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	color: #fff;
}
#error_text {
	text-align: center;
	color: red;
}
.nodisp {
	display: none;
}
.active {
	display: block;
}
#footer {
	height: 10vh;
}
.link_text {
	color: #0070C0;
	cursor: pointer;
}
.margin-top {
	margin-top: 50px;
}
</style>
<title><?=$title?></title>
</head>
<body>
	<div id="wrapper">
		<div>
			<div id="header">
				<img src="./img/Logo.png">
			</div>
			<div id="title_box">
				<div id="title_block">
					<span class="title_block_text">tanzo.fit</span>
					<span class="title_block_text">入籍指輪システム</span>
				</div>
			</div>
			<div id="head_text">
				パスワード再発行
			</div>
		</div>
		<div id="main">
			<form id="post_form" name="post_form" method="post">
				<p>
					<div class="">メールアドレス</div>
					<input type="text" id="input_mail" name="input_mail" class="login_input" required>
				</p>
				<p class="login_button_margin">
					<button type="submit" class="login_button">送信する</button>
				</p>
				<p id="error_text" class="<?=$error_class?>">
					<?=$error_text?>
				</p>
				<p class="margin-top">
					登録されているメールアドレスに案内を送信します。<br>登録したメールアドレスを入力してください。
				</p>
				<p>
					<a href="./" class="link_text">戻る</a>
				</p>
				<?php
				if(SERVER_CHECK !== 1){
				?>
				<p>開発環境では開発者に送信します。</p>
				<?php
				}
				?>
			</form>
		</div>
		<div id="footer"></div>
	</div>
</body>
</html>
