<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/include.php';

$title = "記録の閲覧";
$date = new DateTime();
$date = $date->format("YmdHis");

$report_id = filter_input(INPUT_POST,"report_id");

/*
$report_date = new DateTime("{$report_date}");
$report_date = $report_date->format("Y年n月j日H:i");
*/

try {
	$pdo = DBopen();

	$select_sql = "SELECT * FROM report WHERE report_id = ? AND deleted != 1";
	$select = $pdo->prepare($select_sql);
	$select->bindValue(1,$report_id,PDO::PARAM_STR);
	$select->execute();
	if($row = $select->fetch()){
		$report1 = $row["report1"];
		$report2 = $row["report2"];
		$report3 = $row["report3"];
		$report4 = $row["report4"];
		$memo = nl2br(h($row["memo"]));
		$created = $row["created"];
	} else {
		throw new RuntimeException("対象が存在しない | report_id -> {$report_id}");
	}

	// 前の記録が存在するか？
	$select_prev_sql = "SELECT * FROM report WHERE user_id = ? AND report_id < ? AND deleted != 1 ORDER BY report_id DESC LIMIT 1";
	$select_prev = $pdo->prepare($select_prev_sql);
	$select_prev->bindValue(1,$_SESSION["user"],PDO::PARAM_STR);
	$select_prev->bindValue(2,$report_id,PDO::PARAM_STR);
	$select_prev->execute();
	if($row = $select_prev->fetch()){
		// 前の記録がある場合
		$prev_report_id = $row["report_id"];
		$prev_data_class = "active";
		$prev_report = "details_post('{$prev_report_id}')";
	} else {
		$prev_data_class = "";
		$prev_report = "";
	}

	// 次の記録が存在するか？
	$select_prev_sql = "SELECT * FROM report WHERE user_id = ? AND report_id > ? AND deleted != 1 ORDER BY report_id ASC LIMIT 1";
	$select_prev = $pdo->prepare($select_prev_sql);
	$select_prev->bindValue(1,$_SESSION["user"],PDO::PARAM_STR);
	$select_prev->bindValue(2,$report_id,PDO::PARAM_STR);
	$select_prev->execute();
	if($row = $select_prev->fetch()){
		// 次の記録がある場合
		$next_report_id = $row["report_id"];
		$next_data_class = "active";
		$next_report = "details_post('{$next_report_id}')";
	} else {
		$next_data_class = "";
		$next_report = "";
	}

} catch (Exception $e) { // PDOエラーが来ると思われる
	$error = $e->getMessage();
	$log = "error -> {$error}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

$report_date = new DateTime($created);
$report_date = $report_date->format("Y年n月j日H:i");

$report_text = report_text_list[$report1 - 1];
$report2_text = report2_text_list[$report2 - 1];
$report3_text = report3_text_list[array_rand(report3_text_list)];
$report4_text = report4_text_list[array_rand(report4_text_list)];
//$memo = "適当なテキストを入力してある場合の表示を確認したい。適当なテキストを入力してある場合の表示を確認したい。適当なテキストを入力してある場合の表示を確認したい。適当なテキストを入力してある場合の表示を確認したい。適当なテキストを入力してある場合の表示を確認したい。";
//$memo = "";

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<link rel="apple-touch-icon" href="./img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="./js/script.js"></script>
<link href="./css/style.css" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
function delete_post(e){
	loading();
	let data = {url:"delete.php",data:{report_id:e}};
	data_submit(data);
}
function details_post(e){
	loading();
	let data = {url:"details.php",data:{report_id:e}};
	data_submit(data);
}
</script>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>

	<div id="details_main">
		<div id="date_text">
			記録日時：<?=$report_date?>
		</div>
		<ul id="details_list">
			<li>着け外し<br><?=$report_text?></li>
			<li>着け心地<br><?=$report2_text?></li>
			<!--
			<li>内側指あたり<br><?=$report3_text?></li>
			<li>外側指あたり<br><?=$report4_text?></li>
			-->
			<li>メモの入力<br><div id="details_memo_display"><?=$memo?></div></li>
		</ul>
		<div id="delete_box">
			<span id="details_delete_button" onclick="popup('delete')">この記録を削除</span>
		</div>
		<div id="footer">
			<div id="footer_button_details_prev" class="<?=$prev_data_class?>" onclick="<?=$prev_report?>">前の記録</div>
			<div id="footer_button_details_list" onclick="window.location.href='./list.php'">一覧</div>
			<div id="footer_button_details_next" class="<?=$next_data_class?>" onclick="<?=$next_report?>">次の記録</div>
		</div>
	</div>

	<div id="delete" class="popup-main">
		<p>この記録を削除しますか？</p>
		<p class="popup-button-box"><span class="popup-close button_red" onclick="delete_post('<?=$report_id?>')">削除する</span><span class="popup-close button_no_color">キャンセル</span></p>
	</div>
</body>
</html>
