<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';
$title = "新規ユーザー登録";
$date = new DateTime();
$date = $date->format("YmdHis");


?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="../img/favicon.ico">
<link rel="apple-touch-icon" href="../img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="../js/script.js?v=<?=$date?>"></script>
<link href="../css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<link href="./css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<title><?=$title?></title>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>

	<div id="main">
	</div>

</body>
</html>
