<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/include.php';

$title = "お客様情報の入力/変更";

$date = new DateTime();
$date = $date->format("YmdHis");

$info_flag = filter_input(INPUT_POST,"info_flag");
if($info_flag === "Y"){
	// 初回
	$url = "top.php";
} else {
	$url = "info.php";
}

$hand = filter_input(INPUT_POST,"hand");
$joint = filter_input(INPUT_POST,"joint");
$working = filter_input(INPUT_POST,"working");
if(empty($working)){
	$working = "";
}
$frequency = filter_input(INPUT_POST,"frequency");
$alcohol = filter_input(INPUT_POST,"alcohol");
$taste = filter_input(INPUT_POST,"taste");

if(empty($hand) || empty($joint) || empty($frequency) || empty($alcohol) || empty($taste) ){
	// 必要なデータがない
	require_once './error.php';
	exit;
}

$date = new DateTime();
$date = $date->format("Y-m-d H:i:s");

try {
	$pdo = DBopen();

	$update_sql = "UPDATE user SET handedness = ?, joint = ?, working = ?, frequency = ?, alcohol = ?, taste = ?, updated = ? WHERE user_id = ?";
	$update = $pdo->prepare($update_sql);

	$update->bindValue(1,$hand,PDO::PARAM_STR);
	$update->bindValue(2,$joint,PDO::PARAM_STR);
	$update->bindValue(3,$working,PDO::PARAM_STR);
	$update->bindValue(4,$frequency,PDO::PARAM_STR);
	$update->bindValue(5,$alcohol,PDO::PARAM_STR);
	$update->bindValue(6,$taste,PDO::PARAM_STR);
	$update->bindValue(7,$date,PDO::PARAM_STR);
	$update->bindValue(8,$_SESSION["user"],PDO::PARAM_STR);
	$update->execute();

} catch (Exception $e) { // PDOエラーが来ると思われる
	$error = $e->getMessage();
	$log = "error -> {$error}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

$_SESSION["info"]["save"] = true;

header("Location: ./{$url}");
exit;
