<?php
// 確定していない状態で60日間経過している人に対してメールを送信する
// ワークディレクトリを変更する
// 相対パスで書いているファイルを読み込めないため
chdir(__DIR__);

require_once '../include/server_check.php';
require_once '../include/functions.php';
require_once '../include/db.php';
require_once '../include/config.php';

if(isset($argv[1])){
	$test_mail = $argv[1];
} else {
	$test_mail = "";
}

try {
	$pdo = DBopen();

	$date = new DateTime();
	// 60日間経過したことを確認する
	$date->modify("-60 days");
	$check_date = $date->format("Y-m-d");
	$check_datetime = $date->format("Y-m-d 00:00:00");
	$next_datetime = $date->modify("+1 days")->format("Y-m-d 00:00:00");

	// 対象者を取得する
	// 作成日と確定情報とフラグを見る
	// 作成日はDT型
	// 確認日の00:00:00 <= created
	// 翌日の00:00:00 > created
	// 確定日はデフォルトの日付が入っている
	$select_user_sql = "SELECT * FROM user WHERE created >= ? AND created < ? AND (fixed_date = ? OR fixed_date = '') AND fixed_ring_type = '' AND mail_flag = ''";
	$select_user = $pdo->prepare($select_user_sql);
	$select_user->bindValue(1,$check_datetime,PDO::PARAM_STR);
	$select_user->bindValue(2,$next_datetime,PDO::PARAM_STR);
	$select_user->bindValue(3,default_date,PDO::PARAM_STR);
	$select_user->execute();
	while($row = $select_user->fetch()){
		$user_id = $row["user_id"];
		$created = $row["created"];
		$fixed_ring_type = $row["fixed_ring_type"];
		$fixed_ring_size = $row["fixed_ring_size"];
		$fixed_ring_width = $row["fixed_ring_width"];
		$fixed_ring_thickness = $row["fixed_ring_thickness"];
		$mail_flag = $row["mail_flag"]; // 1で送信済み

		$db_date = new DateTime($created);
		$db_date = $db_date->format("Y-m-d");

		if($mail_flag != 1 && $check_date === $db_date && empty($fixed_ring_type)){
			// 未送信の対象者
			// 対象者にメールを送る
			exec("cd ".DIR_PATH."; /usr/local/bin/php exec_demand_mail.php $user_id '$test_mail' > demand1.txt 2> demand2.txt &", $out, $ret); // > /dev/null
		}
	}
} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error}";
	WriteOnlylog($log,basename(__FILE__));
}
