<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/include.php';

$title = "指輪着用感の記録";
$page = "メモ";
$menu_class = "v_hide";
$return_report = "Y"; // エラー時用

$date = new DateTime();
$date = $date->format("YmdHis");

$from_page = filter_input(INPUT_POST,"page");
if(empty($from_page)){
	$from_page = "report";
}

$token = filter_input(INPUT_POST,"token");
if(empty($token)){
	$error_text = "エラーが発生しました。<br>記録をやり直してください。";
	require_once './error.php';
	exit;
}

if(!isset($_SESSION[$token])){
	$error_text = "エラーが発生しました。<br>記録をやり直してください。";
	require_once './error.php';
	exit;
}

if(isset($_SESSION[$token]["report_memo"])){
	$textarea_value = $_SESSION[$token]["report_memo"];
} else {
	$textarea_value = "";
}

$post_value = filter_input(INPUT_POST,"select");
if($from_page === "report2" && !empty($post_value)){
	// report4からPOSTされている
	$_SESSION[$token][$from_page] = $post_value;
}

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<link rel="apple-touch-icon" href="./img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="./js/script.js?v=<?=$date?>"></script>
<link href="./css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<title><?=$title?></title>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		[<?=$title?>] <?=$page?>
	</div>
	<div id="main">
		<div id="memo_box">
			<form id="post_form" name="post_form" method="post" action="">
				<p>今回の記録に関連してメモしておきたいことがあれば下記の入力欄に書き込んでください。</p>
				<textarea id="memo" name="select"><?=$textarea_value?></textarea>
				<input type="hidden" id="page" name="page" value="report_memo">
				<input type="hidden" id="token" name="token" value="<?=$token?>">
				<input type="hidden" id="save_flag" name="save_flag" value="">
			</form>
		</div>
		<div id="footer">
			<?php
			if($from_page === "report_confirm"){
				echo "<div id=\"footer_button_next\"  onclick=\"set_save_flag();post_move('{$from_page}')\">一時保存して戻る</div>";
				echo "<div id=\"footer_button_prev\" onclick=\"post_move('{$from_page}')\">戻る</div>";
			} else {
				echo "<div id=\"footer_button_next\" onclick=\"set_save_flag();post_move('report_confirm')\">一時保存して次へ</div>";
				echo "<div id=\"footer_button_prev\" onclick=\"post_move('report2')\">戻る</div>";
			}
			?>
		</div>
	</div>
</body>
</html>
