<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/include.php';

$title = "指輪着用感の記録";
$page = "入力の確認";
$max = 5;
$return_report = "Y"; // エラー時用

$date = new DateTime();
$date = $date->format("YmdHis");

$from_page = filter_input(INPUT_POST,"page");
if(empty($from_page)){
	$from_page = "memo";
}

$token = filter_input(INPUT_POST,"token");
if(empty($token)){
	header("Location: report.php");
	exit;
}

// ここにはどこからでも戻ってこられる
// その時のデータの保存をここで行う
$save_flag = filter_input(INPUT_POST,"save_flag");
$post_value = filter_input(INPUT_POST,"select");
if(!empty($save_flag) && !empty($post_value)){
	// 保存フラグが存在するかつ値が存在する場合は更新
	$_SESSION[$token][$from_page] = $post_value;
}

// SESSIONから選択したデータを取得
if(!isset($_SESSION[$token])){
	$error_text = "エラーが発生しました。<br>記録をやり直してください。";
	require_once './error.php';
	exit;
}

if(isset($_SESSION[$token]["report"])){
	$report_value = $_SESSION[$token]["report"];
	$key = $report_value - 1;
	$report_text = report_text_list[$key];
} else {
	// データがない -> エラー
	$error_text = "エラーが発生しました。<br>記録をやり直してください。";
	require_once './error.php';
	exit;
}

if(isset($_SESSION[$token]["report2"])){
	$report2_value = $_SESSION[$token]["report2"];
	$key = $report2_value - 1;
	$report2_text = report2_text_list[$key];
} else {
	// データがない -> エラー
	$error_text = "エラーが発生しました。<br>記録をやり直してください。";
	require_once './error.php';
	exit;
}

/*
if(isset($_SESSION[$token]["report3"])){
	$report3_value = $_SESSION[$token]["report3"];
	if($report3_value === "skip"){
		// スキップした
		$report3_text = "※記録なし";
	} else {
		$key = $report3_value - 1;
		$report3_text = report3_text_list[$key];
	}
} else {
	// データがない -> エラー
	$error_text = "エラーが発生しました。<br>記録をやり直してください。";
	require_once './error.php';
	exit;
}

if(isset($_SESSION[$token]["report4"])){
	$report4_value = $_SESSION[$token]["report4"];
	if($report4_value === "skip"){
		// スキップした
		$report4_text = "※記録なし";
	} else {
		$key = $report4_value - 1;
		$report4_text = report4_text_list[$key];
	}
} else {
	// データがない -> エラー
	$error_text = "エラーが発生しました。<br>記録をやり直してください。";
	require_once './error.php';
	exit;
}
*/

if(isset($_SESSION[$token]["report_memo"])){
	$report_memo_text = nl2br($_SESSION[$token]["report_memo"]);
} else {
	// メモなのでデータなしもOK
	$report_memo_text = "";
}

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<link rel="apple-touch-icon" href="./img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="./js/script.js"></script>
<link href="./css/style.css" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
</script>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		[<?=$title?>] <?=$page?>
	</div>
	<div id="main">
		<form id="post_form" name="post_form" method="post" action="">
			<table id="confirm_table">
				<tr>
					<td class="item_title">着け外し</td>
					<td rowspan="2"><button type="button" onclick="post_move('report')">変更</button></td>
				</tr>
				<tr>
					<td class="item_text"><?=$report_text?></td>
				</tr>
				<tr>
					<td class="item_title">装着感</td>
					<td rowspan="2"><button type="button" onclick="post_move('report2')">変更</button></td>
				</tr>
				<tr>
					<td class="item_text"><?=$report2_text?></td>
				</tr>
				<!--
				<tr>
					<td class="item_title">内側指あたり</td>
					<td rowspan="2"><button type="button" onclick="post_move('report3')">変更</button></td>
				</tr>
				<tr>
					<td class="item_text"><?=$report3_text?></td>
				</tr>
				<tr>
					<td class="item_title">外側指あたり</td>
					<td rowspan="2"><button type="button" onclick="post_move('report4')">変更</button></td>
				</tr>
				<tr>
					<td class="item_text"><?=$report4_text?></td>
				</tr>
				-->
				<tr>
					<td class="item_title">メモの入力</td>
					<td rowspan="2"><button type="button" onclick="post_move('report_memo')">変更</button></td>
				</tr>
				<tr>
					<td class="item_text"><?=$report_memo_text?></td>
				</tr>
			</table>
			<input type="hidden" id="page" name="page" value="report_confirm">
			<input type="hidden" id="token" name="token" value="<?=$token?>">
			<input type="hidden" id="save_flag" name="save_flag" value="">
		</form>
		<div id="footer">
			<div id="footer_button_next" onclick="set_save_flag();post_move('report_save')">記録して終了</div>
			<div id="footer_button_prev" onclick="post_move('report_save')">記録せず終了</div>
		</div>
	</div>
</body>
</html>
