<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/include.php';

$title = "記録の閲覧";
$date = new DateTime();
$date = $date->format("YmdHis");

$report_id = filter_input(INPUT_POST,"report_id");

if(empty($report_id)){
	// 必要なデータがない
	require_once './error.php';
	exit;
}

try {
	$pdo = DBopen();

	$update_sql = "UPDATE report SET deleted = 1 WHERE report_id = ?";
	$update = $pdo->prepare($update_sql);
	$update->bindValue(1,$report_id,PDO::PARAM_STR);
	$update->execute();

} catch (Exception $e) { // PDOエラーが来ると思われる
	$error = $e->getMessage();
	$log = "error -> {$error}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

$_SESSION["details"]["delete"] = true;

header("Location: ./list.php");
exit;
