<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/include.php';

$title = "指輪着用感の記録";
$report_id = "";
$return_report = "Y"; // エラー時用

$token = filter_input(INPUT_POST,"token");
if(empty($token)){
	header("Location: report.php");
	exit;
}

$save_flag = filter_input(INPUT_POST,"save_flag");
if($save_flag === "Y"){
	// 記録する
	if(!isset($_SESSION[$token])){
		$error_text = "エラーが発生しました。<br>記録をやり直してください。";
		require_once './error.php';
		exit;
	}

	// SESSIONから選択したデータを取得
	if(isset($_SESSION[$token]["report"])){
		$report_value = $_SESSION[$token]["report"];
	} else {
		// データがない -> エラー
		$error_text = "エラーが発生しました。<br>記録をやり直してください。";
		require_once './error.php';
		exit;
	}

	if(isset($_SESSION[$token]["report2"])){
		$report2_value = $_SESSION[$token]["report2"];
	} else {
		// データがない -> エラー
		$error_text = "エラーが発生しました。<br>記録をやり直してください。";
		require_once './error.php';
		exit;
	}

	/*
	if(isset($_SESSION[$token]["report3"])){
		$report3_value = $_SESSION[$token]["report3"];
	} else {
		// データがない -> エラー
		$error_text = "エラーが発生しました。<br>記録をやり直してください。";
		require_once './error.php';
		exit;
	}

	if(isset($_SESSION[$token]["report4"])){
		$report4_value = $_SESSION[$token]["report4"];
	} else {
		// データがない -> エラー
		$error_text = "エラーが発生しました。<br>記録をやり直してください。";
		require_once './error.php';
		exit;
	}
	*/

	if(isset($_SESSION[$token]["report_memo"])){
		$report_memo_value = $_SESSION[$token]["report_memo"];
	} else {
		// メモなのでデータなしもOK
		$report_memo_value = "";
	}

	try {
		$pdo = DBopen();

		$insert_sql = "INSERT INTO report (user_id, report1, report2, memo, created, created_date, created_time) VALUES (?,?,?,?,?,?,?)";
		$insert = $pdo->prepare($insert_sql);

		$date = new DateTime();
		$created = $date->format("Y-m-d H:i:s");
		$created_date = $date->format("Y-m-d");
		$created_time = $date->format("H:i:s");

		$insert->bindValue(1,$_SESSION["user"],PDO::PARAM_STR);
		$insert->bindValue(2,$report_value,PDO::PARAM_STR);
		$insert->bindValue(3,$report2_value,PDO::PARAM_STR);
		$insert->bindValue(4,$report_memo_value,PDO::PARAM_STR);
		$insert->bindValue(5,$created,PDO::PARAM_STR);
		$insert->bindValue(6,$created_date,PDO::PARAM_STR);
		$insert->bindValue(7,$created_time,PDO::PARAM_STR);
		$insert->execute();

		$report_id = $pdo->lastInsertId();

	} catch (Exception $e) { // PDOエラーが来ると思われる
		$error = $e->getMessage();
		$log = "error -> {$error}";
		Writelog($log,basename(__FILE__));
		require_once './error.php';
		exit;
	}
} else {
	$save_flag = "N";
}

unset($_SESSION[$token]);

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<script>
window.onload = function(){
	document.f.submit();
}
</script>
</head>
<body>
	<form method="post" action="report_finish.php" name="f">
		<input type="hidden" id="report_id" name="report_id" value="<?=$report_id?>">
		<input type="hidden" id="save_flag" name="save_flag" value="<?=$save_flag?>">
	</form>
</body>
</html>
