<?php
require_once __DIR__.'/../../include/server_check.php';
require_once __DIR__.'/../../include/functions.php';
require_once __DIR__.'/../../include/db.php';

$user_id = filter_input(INPUT_POST,"user_id");
$mail = filter_input(INPUT_POST,"mail");
$return = true;

if(!empty($user_id) && !empty($mail)){
	try {
		$pdo = DBopen();

		$select_sql = "SELECT COUNT(mail) FROM user WHERE user_id != ? AND mail = ?";
		$select = $pdo->prepare($select_sql);
		$select->bindValue(1,$user_id,PDO::PARAM_STR);
		$select->bindValue(2,$mail,PDO::PARAM_STR);
		$select->execute();
		$result = $select->fetchColumn();
		if($result > 0){
			// 存在する
			$return = false;
		}
	} catch(Exception $e){
		$error = $e->getMessage();
		$log = "error -> {$error} | user_id -> {$user_id} | mail -> {$mail}";
		Writelog($log,basename(__FILE__));
		$return = false;
	}
} else {
	$return = false;
}

echo $return;
