<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';
$title = "パスワード再発行";

$user_id = filter_input(INPUT_POST,"user_id");
if(empty($user_id)){
	require_once './error.php';
	exit;
}

$posted_log = "user_id -> {$user_id}";

if(empty($user_id)){
	$log = "必要な情報がない | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

// パスワードはDBに平文で保存しない
// しかしながら案内のために元のパスワードを見られる必要がある
// 作成時は最終画面でアカウントのIDとパスワードを表示するようにする
$account_data = [];

mb_language("Japanese");
mb_internal_encoding("UTF-8");

require_once '../include/mail_data_reset.php';

try {
	$pdo = DBopen();

	$update_sql = "UPDATE user SET password = ?, updated = ? WHERE user_id = ?";
	$update = $pdo->prepare($update_sql);

	$randompass = RandomPass();
	$addpass = password_hash($randompass, PASSWORD_DEFAULT);

	$date = new DateTime();
	$updated = $date->format("Y-m-d H:i:s");

	$update->bindValue(1,$addpass,PDO::PARAM_STR);
	$update->bindValue(2,$updated,PDO::PARAM_STR);
	$update->bindValue(3,$user_id,PDO::PARAM_STR);
	$update->execute();

	$account_data["user_id"] = $user_id;
	$account_data["password"] = $randompass;

	$select_sql = "SELECT * FROM user WHERE user_id = ?";
	$select = $pdo->prepare($select_sql);

	$select->bindValue(1,$user_id,PDO::PARAM_STR);
	$select->execute();

	if($row = $select->fetch()){
		$mail = $row["mail"];
	} else {
		throw new RuntimeException("SELECTできない");
	}

	// メールを送信する
	if(SERVER_CHECK === 1){
		// 本番
		$to = $mail;
		$from = mail_from;
	} else {
		// 開発
		$to = "hirota@apteq.jp";
		$from = "test@demo55.jp";
	}

	$headers = [];

	$charset = "UTF-8";
	$headers['MIME-Version'] = "1.0";

	$From_name = "入籍指輪システム";
	//$From_encoded = mb_convert_encoding($From_name, 'UTF-8', 'AUTO'); // mb_encode_mimeheaderに渡す前にUTF-8に変換しなくてはダメ
	$From_address = $from;
	$headers['From'] = mb_encode_mimeheader($From_name, 'UTF-8') ."<". $From_address .">";
	$headers['Content-Type'] = "text/plain; charset=".$charset;
	$headers['Reply-to'] = $From_address;
	$headers['Sender'] = $From_address;
	$headers['Return-Path'] = $From_address;
	//$headers['Content-Transfer-Encoding'] = "BASE64";

	//配列から連結させる
	foreach ($headers as $key => $val) {
		$arrheader[] = $key . ': ' . $val;
	}
	$strHeader = implode("\n", $arrheader);

	// テンプレートを置換する
	// タイトル
	$title = MAIL_TITLE;

	// 本文
	// パスワードを置換する
	$content = sprintf(MAIL_CONTENT,$randompass);

	if(!mail($to, $title, $content, $strHeader,"-f {$From_address}")){
		// メールの送信に失敗
		$log = "メールの送信に失敗";
		Writelog($log,"reset_mail_send_false");
	}

} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error} | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<script>
window.onload = function(){
	document.f.submit();
}
</script>
</head>
<body>
	<form method="post" action="password_reset_finish.php" name="f">
		<?php
		foreach($account_data as $key => $value){
			echo "<input type=\"hidden\" id=\"{$key}\" name=\"{$key}\" value=\"{$value}\">";
		}
		?>
	</form>
</body>
</html>
