<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';

$name1 = filter_input(INPUT_POST,"name1");
$name2 = filter_input(INPUT_POST,"name2");
$kana1 = filter_input(INPUT_POST,"kana1");
$kana2 = filter_input(INPUT_POST,"kana2");
$gender = filter_input(INPUT_POST,"gender");
$mail = filter_input(INPUT_POST,"mail");
$ring_type = filter_input(INPUT_POST,"ring_type");
$ring_material = filter_input(INPUT_POST,"ring_material");
$ring_size = filter_input(INPUT_POST,"ring_size");
$ring_width = filter_input(INPUT_POST,"ring_width");
$ring_thickness = filter_input(INPUT_POST,"ring_thickness");
$remarks = filter_input(INPUT_POST,"remarks");
$pair_select = filter_input(INPUT_POST,"pair_select");

if(empty($kana1)){
	$kana1 = "";
}
if(empty($kana2)){
	$kana2 = "";
}

$posted_log = "name1 -> {$name1} | name2 -> {$name2} | kana1 -> {$kana1} | kana2 -> {$kana2} | gender -> {$gender} | mail -> {$mail} | ring_type -> {$ring_type} | ring_material -> {$ring_material} | ring_size -> {$ring_size} | ring_width -> {$ring_width} | ring_thickness -> {$ring_thickness} | pair_select -> {$pair_select}";

if(empty($name1) || empty($name2) || empty($gender) || empty($mail) || empty($ring_type) || empty($ring_size) || empty($ring_width) || empty($ring_thickness) || empty($pair_select)){
	$log = "必要な情報がない | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

if($pair_select === "2"){
	// ペアを新しく作る
	$pair_name1 = filter_input(INPUT_POST,"pair_name1");
	$pair_name2 = filter_input(INPUT_POST,"pair_name2");
	$pair_kana1 = filter_input(INPUT_POST,"pair_kana1");
	$pair_kana2 = filter_input(INPUT_POST,"pair_kana2");
	$pair_gender = filter_input(INPUT_POST,"pair_gender");
	$pair_mail = filter_input(INPUT_POST,"pair_mail");
	$pair_ring_type = filter_input(INPUT_POST,"pair_ring_type");
	$pair_ring_material = filter_input(INPUT_POST,"pair_ring_material");
	$pair_ring_size = filter_input(INPUT_POST,"pair_ring_size");
	$pair_ring_width = filter_input(INPUT_POST,"pair_ring_width");
	$pair_ring_thickness = filter_input(INPUT_POST,"pair_ring_thickness");
	$pair_remarks = filter_input(INPUT_POST,"pair_remarks");
	if(empty($pair_kana1)){
		$pair_kana1 = "";
	}
	if(empty($pair_kana2)){
		$pair_kana2 = "";
	}
	if(empty($pair_name1) || empty($pair_name2) || empty($pair_gender) || empty($pair_mail) || empty($pair_ring_type) || empty($pair_ring_size) || empty($pair_ring_width) || empty($pair_ring_thickness)){
		$pair_log = "\n PAIR | name1 -> {$pair_name1} | name2 -> {$pair_name2} | kana1 -> {$pair_kana1} | kana2 -> {$pair_kana2} | gender -> {$pair_gender} | mail -> {$pair_mail} | ring_type -> {$pair_ring_type} | pair_ring_material -> {$pair_ring_material} | ring_size -> {$pair_ring_size} | ring_width -> {$pair_ring_width} | ring_thickness -> {$pair_ring_thickness}";
		$log = "必要な情報がない | {$posted_log} | {$pair_log}";
		Writelog($log,basename(__FILE__));
		require_once './error.php';
		exit;
	}
} else if($pair_select === "3"){
	// ペアを登録する
	$pair_id = filter_input(INPUT_POST,"pair_id");
	if(empty($pair_id)){
		$log = "必要な情報がない | pair_id -> {$paid_id} | {$posted_log}";
		Writelog($log,basename(__FILE__));
		require_once './error.php';
		exit;
	}
}

// メールアドレスが存在する場合はエラーにする
$mail_exist = 0;
$pair_mail_exist = 0;
// 登録しようとしているアカウントにすでにペアが存在する場合はエラーにする
$pair_num_check = 0;

// パスワードはDBに平文で保存しない
// しかしながら案内のために元のパスワードを見られる必要がある
// 作成時は最終画面でアカウントのIDとパスワードを表示するようにする
$account_data = [];

mb_language("Japanese");
mb_internal_encoding("UTF-8");

require_once '../include/mail_data_create.php';

try {
	$pdo = DBopen();

	$mail_check_sql = "SELECT COUNT(mail) FROM user WHERE mail = ?";
	$mail_check = $pdo->prepare($mail_check_sql);
	$mail_check->bindValue(1,$mail,PDO::PARAM_STR);
	$mail_check->execute();
	$mail_check_result = $mail_check->fetchColumn();
	if($mail_check_result > 0){
		// 存在する
		$mail_exist = 1;
	}

	if($pair_select === "2"){
		// ペアを新しく作る
		$mail_check->bindValue(1,$pair_mail,PDO::PARAM_STR);
		$mail_check->execute();
		$mail_check_result = $mail_check->fetchColumn();
		if($mail_check_result > 0){
			// 存在する
			$pair_mail_exist = 1;
		}
	}

	if($pair_select === "3"){
		// ペアを登録する
		// 対象がすでにペアを持っている場合はエラー
		$pair_check_sql = "SELECT COUNT(pair) FROM user WHERE pair != '' AND user_id = ?";
		$pair_check = $pdo->prepare($pair_check_sql);
		$pair_check->bindValue(1,$pair_id,PDO::PARAM_STR);
		$pair_check->execute();
		$pair_check_result = $pair_check->fetchColumn();
		if($pair_check_result > 0){
			// 存在する
			$pair_num_check = 1;
		}
		Writelog($pair_id,"check");
	}

	if($mail_exist !== 1 && $pair_mail_exist !== 1 && $pair_num_check !== 1){
		// チェックOKなら作る
		$insert_sql = "INSERT INTO user (password, mail, name1, name2, kana_name1, kana_name2, gender, pair, shop, ring_type, ring_material, ring_size, ring_width, ring_thickness, remarks, created, updated) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		$insert = $pdo->prepare($insert_sql);

		// ペア番号の取得
		// F,Mをつける必要があるのか？
		$select_pair_num_sql = "SELECT pair FROM user WHERE pair != '' ORDER BY pair DESC LIMIT 1";
		// ソートできない問題対策, 数値に変換してソート
		//$select_pair_num_sql = "SELECT pair FROM user WHERE pair != '' ORDER BY cast(pair as SIGNED) DESC LIMIT 1";
		$select_pair_num = $pdo->query($select_pair_num_sql);
		if($row = $select_pair_num->fetch()){
			// 存在している
			$pair_num = $row["pair"];
		} else {
			// 存在していない
			$pair_num = 0;
		}
		// 新しいペア番号
		$pair_num += 1;
		if($pair_select === "1"){
			// ペアを作らない
			$pair_num = "";
		}

		$randompass = RandomPass();
		$addpass = password_hash($randompass, PASSWORD_DEFAULT);

		if($_SESSION["shop"] === "マスター"){
			$shop = "東京";
		} else {
			$shop = $_SESSION["shop"];
		}

		$date = new DateTime();
		$created = $date->format("Y-m-d H:i:s");
		$updated = $created;

		$insert->bindValue(1,$addpass,PDO::PARAM_STR);
		$insert->bindValue(2,$mail,PDO::PARAM_STR);
		$insert->bindValue(3,$name1,PDO::PARAM_STR);
		$insert->bindValue(4,$name2,PDO::PARAM_STR);
		$insert->bindValue(5,$kana1,PDO::PARAM_STR);
		$insert->bindValue(6,$kana2,PDO::PARAM_STR);
		$insert->bindValue(7,$gender,PDO::PARAM_STR);
		$insert->bindValue(8,$pair_num,PDO::PARAM_STR);
		$insert->bindValue(9,$shop,PDO::PARAM_STR);
		$insert->bindValue(10,$ring_type,PDO::PARAM_STR);
		$insert->bindValue(11,$ring_material,PDO::PARAM_STR);
		$insert->bindValue(12,$ring_size,PDO::PARAM_STR);
		$insert->bindValue(13,$ring_width,PDO::PARAM_STR);
		$insert->bindValue(14,$ring_thickness,PDO::PARAM_STR);
		$insert->bindValue(15,$remarks,PDO::PARAM_STR);
		$insert->bindValue(16,$created,PDO::PARAM_STR);
		$insert->bindValue(17,$updated,PDO::PARAM_STR);
		$insert->execute();

		$user_id = $pdo->lastInsertId();

		$account_data["user_id"] = $user_id;
		$account_data["password"] = $randompass;

		// 1人目にメールを送信する
		if(SERVER_CHECK === 1){
			// 本番
			$to = $mail;
			$from = mail_from;
		} else {
			// 開発
			$to = "hirota@apteq.jp";
			$from = "test@demo55.jp";
		}

		$headers = [];

		$charset = "UTF-8";
		$headers['MIME-Version'] = "1.0";

		$From_name = "入籍指輪システム";
		//$From_encoded = mb_convert_encoding($From_name, 'UTF-8', 'AUTO'); // mb_encode_mimeheaderに渡す前にUTF-8に変換しなくてはダメ
		$From_address = $from;
		$headers['From'] = mb_encode_mimeheader($From_name, "UTF-8") ."<". $From_address .">";
		$headers['Content-Type'] = "text/plain; charset=".$charset;
		$headers['Reply-to'] = $From_address;
		$headers['Sender'] = $From_address;
		$headers['Return-Path'] = $From_address;
		//$headers['Content-Transfer-Encoding'] = "BASE64";

		//配列から連結させる
		foreach ($headers as $key => $val) {
			$arrheader[] = $key . ': ' . $val;
		}
		$strHeader = implode("\n", $arrheader);

		// テンプレートを置換する
		// タイトル
		$title = MAIL_TITLE;

		// 本文
		// パスワードを置換する
		$content = sprintf(MAIL_CONTENT,$randompass);

		if(!mail($to, $title, $content, $strHeader,"-f {$From_address}")){
			// メールの送信に失敗
			$log = "メールの送信に失敗";
			Writelog($log,"create_mail_send_false");
		}

		if($pair_select === "2"){
			// ペアを新しく作る
			$randompass = RandomPass();
			$addpass = password_hash($randompass, PASSWORD_DEFAULT);

			$insert->bindValue(1,$addpass,PDO::PARAM_STR);
			$insert->bindValue(2,$pair_mail,PDO::PARAM_STR);
			$insert->bindValue(3,$pair_name1,PDO::PARAM_STR);
			$insert->bindValue(4,$pair_name2,PDO::PARAM_STR);
			$insert->bindValue(5,$pair_kana1,PDO::PARAM_STR);
			$insert->bindValue(6,$pair_kana2,PDO::PARAM_STR);
			$insert->bindValue(7,$pair_gender,PDO::PARAM_STR);
			$insert->bindValue(8,$pair_num,PDO::PARAM_STR);
			$insert->bindValue(9,$shop,PDO::PARAM_STR);
			$insert->bindValue(10,$pair_ring_type,PDO::PARAM_STR);
			$insert->bindValue(11,$pair_ring_material,PDO::PARAM_STR);
			$insert->bindValue(12,$pair_ring_size,PDO::PARAM_STR);
			$insert->bindValue(13,$pair_ring_width,PDO::PARAM_STR);
			$insert->bindValue(14,$pair_ring_thickness,PDO::PARAM_STR);
			$insert->bindValue(15,$pair_remarks,PDO::PARAM_STR);
			$insert->bindValue(16,$created,PDO::PARAM_STR);
			$insert->bindValue(17,$updated,PDO::PARAM_STR);
			$insert->execute();

			$user_id = $pdo->lastInsertId();

			$account_data["pair_user_id"] = $user_id;
			$account_data["pair_password"] = $randompass;

			// 2人目にメールを送信する
			if(SERVER_CHECK === 1){
				// 本番
				$to = $pair_mail;
				$from = mail_from;
			} else {
				// 開発
				$to = "hirota@apteq.jp";
				$from = "test@demo55.jp";
			}

			/*
			$headers = [];

			$charset = "UTF-8";
			$headers['MIME-Version'] = "1.0";

			$From_name = "入籍指輪システム";
			$From_encoded = mb_convert_encoding($From_name, 'UTF-8', 'AUTO'); // mb_encode_mimeheaderに渡す前にUTF-8に変換しなくてはダメ
			$From_address = $from;
			$headers['From'] = mb_encode_mimeheader($From_encoded) ."<". $From_address .">";
			$headers['Content-Type'] = "text/plain; charset=".$charset;

			//配列から連結させる
			foreach ($headers as $key => $val) {
				$arrheader[] = $key . ': ' . $val;
			}
			$strHeader = implode("\n", $arrheader);
			*/

			// テンプレートを置換する
			// タイトル
			$title = MAIL_TITLE;

			// 本文
			// パスワードを置換する
			$content = sprintf(MAIL_CONTENT,$randompass);

			if(!mail($to, $title, $content, $strHeader,"-f {$From_address}")){
				// メールの送信に失敗
				$log = "メールの送信に失敗";
				Writelog($log,"mail_send_false");
			}
		} else if($pair_select === "3"){
			// ペアを登録する
			$update_sql = "UPDATE user SET pair = ?, updated = ? WHERE user_id = ?";
			$update = $pdo->prepare($update_sql);
			$update->bindvalue(1,$pair_num,PDO::PARAM_STR);
			$update->bindvalue(2,$updated,PDO::PARAM_STR);
			$update->bindvalue(3,$pair_id,PDO::PARAM_STR);
			$update->execute();

			$account_data["pair_user_id"] = $pair_id;
		}
	}
} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error} | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<script>
window.onload = function(){
	document.f.submit();
}
</script>
</head>
<body>
	<form method="post" action="create_new_account_finish.php" name="f">
		<input type="hidden" id="mail_exist" name="mail_exist" value="<?=$mail_exist?>">
		<input type="hidden" id="pair_mail_exist" name="pair_mail_exist" value="<?=$pair_mail_exist?>">
		<input type="hidden" id="pair_num_check" name="pair_num_check" value="<?=$pair_num_check?>">
		<input type="hidden" id="pair_select" name="pair_select" value="<?=$pair_select?>">
		<?php
		foreach($account_data as $key => $value){
			echo "<input type=\"hidden\" id=\"{$key}\" name=\"{$key}\" value=\"{$value}\">";
		}
		?>
	</form>
</body>
</html>
