<?php
// ログを出力する
function Writelog($log,$w=""){
	// ディレクトリが存在しなければならないので存在チェックとなければ作成する
	$directory = "./log";
	if(!file_exists($directory)){
		if(!mkdir($directory)){
			echo "ディレクトリの作成に失敗しました";
		}
	}

	$d = new DateTime();
	$day = $d->format('Y-m-d');

	if($w !== ""){
		$file = "./log/".$w.$day.".log";
	} else {
		$file = "./log/error".$day.".log";
	}

	$date = date('Y/m/d H:i:d');
	$requestUrl = $_SERVER['REQUEST_URI'];
	$requestbrowser = $_SERVER['HTTP_USER_AGENT'];
	$requestIp = $_SERVER['REMOTE_ADDR'];

	$head = "{$date} | {$requestUrl} | {$requestbrowser} | {$requestIp}";

	error_log($head." | ".$log."\n",3,$file);
}

// ログを出力する 環境変数を使わない
function WriteOnlylog($log,$w=""){
	// ディレクトリが存在しなければならないので存在チェックとなければ作成する
	$directory = "./log";
	if(!file_exists($directory)){
		if(!mkdir($directory)){
			echo "ディレクトリの作成に失敗しました";
		}
	}

	$d = new DateTime();
	$day = $d->format('Y-m-d');

	if($w !== ""){
		$file = "./log/".$w.$day.".log";
	} else {
		$file = "./log/error".$day.".log";
	}

	$date = $d->format('Y/m/d H:i:s');

	$head = "{$date}";

	error_log($head." | ".$log."\n",3,$file);
}

// バックスラッシュを追加してエスケープ処理をする → あいまい検索時に使う
function AddSlash($e){
	return addcslashes($e, '\_%');
}

// html出力するときに特殊文字をエスケープ処理をする
function h($e){
	return htmlspecialchars($e, ENT_QUOTES, "UTF-8");
}

// NULLを空白にする
function null_to_blank($e){
	if($e === NULL){
		$e = "";
	}
	return $e;
}

// 最後についている空白を削除する
function delete_end_blank($e){
	return preg_replace('/\s+$/u', '', $e);
}

// 2つ以上の空白を1つにする
function unify_space($e){
	// 2つ続く半角スペースを検索
	if(strpos($e,'  ') !== false){
		$e = str_replace("  "," ",$e);
		$e = unify_space($e);
	}
	return $e;
}

// ランダムでパスワードを生成する
function RandomPass(){
	return substr(str_shuffle(str_repeat('23456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ',2)), 0, 8);
}

// トークンを発行する
function RandomToken($length = 32){
	if(!isset($length) || intval($length) <= 8 ){
		$length = 32;
	}
	if (function_exists('random_bytes')) {
		return bin2hex(random_bytes($length));
	}
	if (function_exists('mcrypt_create_iv')) {
		return bin2hex(mcrypt_create_iv($length, MCRYPT_DEV_URANDOM));
	}
	if (function_exists('openssl_random_pseudo_bytes')) {
		return bin2hex(openssl_random_pseudo_bytes($length));
	}
}
