<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';
$title = "ユーザー一覧";
$date = new DateTime();
$date = $date->format("YmdHis");

$return_flag = filter_input(INPUT_GET,"r");

$search_shop = filter_input(INPUT_POST,"search_shop");
if(empty($search_shop)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["shop"])){
		// 戻ってきた
		$search_shop = $_SESSION["list"]["search"]["shop"];
	} else {
		if($_SESSION["shop"] === "マスター"){
			$search_shop = "";
		} else {
			$search_shop = $_SESSION["shop"];
		}
	}
} else if($search_shop === "すべて"){
	$search_shop = "";
}

$search_status = filter_input(INPUT_POST,"search_status");
if(empty($search_status)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["status"])){
		// 戻ってきた
		$search_status = $_SESSION["list"]["search"]["status"];
	} else {
		$search_status = "調整中";
	}
}

$search_name = filter_input(INPUT_POST,"search_name");
if(empty($search_name)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["name"])){
		// 戻ってきた
		$search_name = $_SESSION["list"]["search"]["name"];
	} else {
		$search_name = "";
	}
}

$search_mail = filter_input(INPUT_POST,"search_mail");
if(empty($search_mail)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["mail"])){
		// 戻ってきた
		$search_mail = $_SESSION["list"]["search"]["mail"];
	} else {
		$search_mail = "";
	}
}

$search_pair = filter_input(INPUT_POST,"search_pair");
if(empty($search_pair)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["pair"])){
		// 戻ってきた
		$search_pair = $_SESSION["list"]["search"]["pair"];
	} else {
		$search_pair = "";
	}
}

$search_pair_num = filter_input(INPUT_POST,"search_pair_num");
if(empty($search_pair_num)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["pair_num"])){
		// 戻ってきた
		$search_pair_num = $_SESSION["list"]["search"]["pair_num"];
	} else {
		$search_pair_num = "";
	}
}

$search_keyword = filter_input(INPUT_POST,"search_keyword");
if(empty($search_keyword)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["keyword"])){
		// 戻ってきた
		$search_keyword = $_SESSION["list"]["search"]["keyword"];
	} else {
		$search_keyword = "";
	}
}

$search_date1 = filter_input(INPUT_POST,"search_date1");
if(empty($search_date1)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["search_date1"])){
		// 戻ってきた
		$search_date1 = $_SESSION["list"]["search"]["search_date1"];
	} else {
		$search_date1 = "";
	}
}

$search_date_checkbox = filter_input(INPUT_POST,"search_date_checkbox");
if(empty($search_date_checkbox)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["search_date_checkbox"])){
		// 戻ってきた
		$search_date_checkbox = $_SESSION["list"]["search"]["search_date_checkbox"];
	} else {
		$search_date_checkbox = "";
	}
}

$search_date2 = filter_input(INPUT_POST,"search_date2");
if(empty($search_date2)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["search_date2"])){
		// 戻ってきた
		$search_date2 = $_SESSION["list"]["search"]["search_date2"];
	} else {
		$search_date2 = "";
	}
}
if($search_date_checkbox !== "Y"){
	$search_date2 = "";
}


$PAGE_NUM = filter_input(INPUT_POST,"page");
if(empty($PAGE_NUM)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["page"])){
		// 戻ってきた
		$PAGE_NUM = $_SESSION["list"]["search"]["page"];
	} else {
		$PAGE_NUM = 0;
	}
}

$DISPLAY_NUM = filter_input(INPUT_POST,"display_num");
if(empty($DISPLAY_NUM)){
	if($return_flag === "Y" && isset($_SESSION["list"]["search"]["display"])){
		// 戻ってきた
		$DISPLAY_NUM = $_SESSION["list"]["search"]["display"];
	} else {
		$DISPLAY_NUM = 50;
	}
}

$OFFSET = $PAGE_NUM * $DISPLAY_NUM;

$LIST_HTML = "";

$gender_list = [
	"M",
	"F"
];


try {
	$pdo = DBopen();

	$select_sql = "SELECT * FROM user WHERE 1";
	$count_sql = "SELECT COUNT(user_id) FROM user WHERE 1";

	$WHERE = "";
	$VALUES = [];

	if(!empty($search_shop)){
		$WHERE .= " AND shop = ?";
		$VALUES[] = $search_shop;
	}

	if($search_status === "確定済"){
		$WHERE .= " AND fixed_date != ?";
		$VALUES[] = default_date;
	} else if($search_status === "調整中"){
		$WHERE .= " AND fixed_date = ?";
		$VALUES[] = default_date;
	}

	if(!empty($search_name)){
		$WHERE .= " AND CONCAT(name1,name2,kana_name1,kana_name2) LIKE ?";
		$VALUES[] = "%{$search_name}%";
	}

	if(!empty($search_mail)){
		$WHERE .= " AND mail LIKE ?";
		$VALUES[] = "%{$search_mail}%";
	}

	if($search_pair === "1"){
		// ペアあり
		$WHERE .= " AND pair != ''";

		if(!empty($search_pair_num)){
			/*
			$WHERE .= " AND pair LIKE ?";
			$VALUES[] = "%{$search_pair_num}%";
			*/
			// 完全一致であるべきか？
			$WHERE .= " AND pair = ?";
			$VALUES[] = $search_pair_num;
		}
	} else if($search_pair === "2"){
		// ペアなし
		$WHERE .= " AND pair = ''";
	} else {
		if(!empty($search_pair_num)){
			/*
			$WHERE .= " AND pair LIKE ?";
			$VALUES[] = "%{$search_pair_num}%";
			*/
			// 完全一致であるべきか？
			$WHERE .= " AND pair = ?";
			$VALUES[] = $search_pair_num;
		}
	}

	/*
	if(!empty($search_keyword)){
		$WHERE .= " AND pair LIKE ?";
		$VALUES[] = "%{$search_keyword}%";
	}
	*/

	if($search_date_checkbox === "Y"){
		// 期間での検索
		// スタートの 00:00:00 から エンドの 23:59:59
		// スタートが指定されていなければ default_date
		// エンドが指定されていなければ 現在の日時
		$WHERE .= " AND (created >= ? AND created <= ?)";
		if(!empty($search_date1)){
			$value_date1 = new DateTime($search_date1);
		} else {
			$value_date1 = new DateTime(default_date);
		}
		$value_date1 = $value_date1->format("Y-m-d 00:00:00");

		if(!empty($search_date2)){
			$value_date2 = new DateTime($search_date2);
		} else {
			$value_date2 = new DateTime();
		}
		$value_date2 = $value_date2->format("Y-m-d 23:59:59");

		$VALUES[] = $value_date1;
		$VALUES[] = $value_date2;
	} else {
		if(!empty($search_date1)){
			// 日付の検索
			// その日の 00:00:00 から 23:59:59
			$WHERE .= " AND (created >= ? AND created <= ?)";
			$value_date = new DateTime($search_date1);
			$value_date1 = $value_date->format("Y-m-d 00:00:00");
			$value_date2 = $value_date->format("Y-m-d 23:59:59");
			$VALUES[] = $value_date1;
			$VALUES[] = $value_date2;
		}
	}

	$select_sql .= $WHERE;
	$count_sql .= $WHERE;

	$select_sql .= " ORDER BY user_id DESC LIMIT ? OFFSET ?";

	$select = $pdo->prepare($select_sql);
	$count = $pdo->prepare($count_sql);

	$i = 0;
	foreach($VALUES as $value){
		$i++;
		$select->bindValue($i,$value,PDO::PARAM_STR);
		$count->bindValue($i,$value,PDO::PARAM_STR);
	}

	$i++;
	$select->bindValue($i,$DISPLAY_NUM,PDO::PARAM_STR);
	$i++;
	$select->bindValue($i,$OFFSET,PDO::PARAM_STR);

	$select->execute();
	$count->execute();

	$count_result = $count->fetchColumn();
	$max_page = ceil($count_result/$DISPLAY_NUM) - 1;

	while($row = $select->fetch()){
		$user_id = $row["user_id"];
		$name = $row["name1"].$row["name2"];
		$mail = $row["mail"];
		$pair_num = $row["pair"];
		$fixed_date = $row["fixed_date"];
		$shop = $row["shop"];
		$created = $row["created"];

		if(empty($pair_num)){
			$pair_num = "";
		}

		$status = $fixed_date === default_date ? "調整中" : "確定済";

		$created = new DateTime($created);
		$created = $created->format("Y年n月j日");

		$LIST_HTML .=<<<EOD
		<tr>
			<td>{$shop}</td>
			<td>{$pair_num}</td>
			<td>{$created}</td>
			<td>{$name}</td>
			<td>{$mail}</td>
			<td>{$status}</td>
			<td><span class="operation_button" onclick="select_person('{$user_id}')">詳細</span></td>
		</tr>\n
EOD;
	}


} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

$display_page_start = $PAGE_NUM * $DISPLAY_NUM + 1;
$display_page_end = ($PAGE_NUM + 1) * $DISPLAY_NUM;
if($count_result < $display_page_end){
	$display_page_end = $count_result;
}

$prev_page = $PAGE_NUM - 1;
$next_page = $PAGE_NUM + 1;

$shop_options = "";
foreach(shop_list as $value){
	if($value == "マスター"){
		continue;
	}
	if($search_shop === $value){
		$selected = " selected";
	} else {
		$selected = "";
	}
	$shop_options .= "<option value=\"{$value}\"{$selected}>{$value}</option>";
}

$status_options = "";
foreach(status_list as $value){
	if($value == "マスター"){
		continue;
	}
	if($search_status === $value){
		$selected = " selected";
	} else {
		$selected = "";
	}
	$status_options .= "<option value=\"{$value}\"{$selected}>{$value}</option>";
}

$_SESSION["list"]["search"] = [
	"shop" => $search_shop,
	"status" => $search_status,
	"name" => $search_name,
	"mail" => $search_mail,
	"pair" => $search_pair,
	"pair_num" => $search_pair_num,
	"keyword" => $search_keyword,
	"search_date1" => $search_date1,
	"search_date_checkbox" => $search_date_checkbox,
	"search_date2" => $search_date2,
	"page" => $PAGE_NUM,
	"display" => $DISPLAY_NUM,
];

$action_flag = false;
$action_text = "";
if(isset($_SESSION["details"]["delete"])){
	$action_flag = true;
	$action_text = $_SESSION["details"]["delete"];
	unset($_SESSION["details"]["delete"]);
}

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="../img/favicon.ico">
<link rel="apple-touch-icon" href="../img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="../js/script.js?v=<?=$date?>"></script>
<link href="../css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<link href="./css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
function search(e){
	document.getElementById('page').value = e;

	search_form.submit();
}
function change_display_num(e){
	let display_num = e.value;
	document.getElementById('display_num').value = display_num;

	search(0);
}
function select_person(e){
	let post_data = {
		"url":"details.php",
		"data":{"user_id":e}
	};
	data_submit(post_data);
}
function list_download(){
	search_form.action = "./download_data.php";
	search_form.target = "download";
	search_form.submit();
	search_form.action = "./list.php";
	search_form.target = "";
}
window.onload = function(){
	<?php
	if($action_flag){
	?>
	popup('action');
	<?php
	}
	?>
}
</script>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>

	<div id="main">
		<div id="search_box">
			<form id="search_form" name="search_form" action="./list.php" method="post" autocomplete="off">
				<!--
				<table id="search_form_table">
					<tr>
						<td colspan="4" class="right"><a href="./create_new_account.php" class="button_blue nodec">新規登録</a></td>
					</tr>
					<tr>
						<td class="search_item_name">店舗</td>
						<td class="search_item_content">
							<select id="search_shop" name="search_shop">
								<option value="すべて">すべて</option>
								<?= $shop_options ?>
							</select>
						</td>
						<td class="search_item_name">ステータス</td>
						<td class="search_item_content">
							<select id="search_status" name="search_status">
								<option value="すべて">すべて</option>
								<?= $status_options ?>
							</select>
						</td>
					</tr>
					<tr>
						<td class="search_item_name">名前</td>
						<td class="search_item_content"><input type="text" id="search_name" name="search_name" placeholder="名前、かな" value="<?=$search_name?>"></td>
						<td class="search_item_name">メールアドレス</td>
						<td class="search_item_content"><input type="text" id="search_mail" name="search_mail" value="<?=$search_mail?>"></td>
					</tr>
					<tr>
						<td class="search_item_name">ペア番号</td>
						<td class="search_item_content"><input type="text" id="search_pair_num" name="search_pair_num" value="<?=$search_pair_num?>"></td>
						<td class="search_item_name">作成日</td>
						<td class="search_item_content">
							<input type="date" id="search_date1" name="search_date1" value="">
							<input type="checkbox" id="search_date_checkbox">
							<input type="date" id="search_date2" name="search_date2" value="">
						</td>
					</tr>
					<tr>
						<td class="search_item_name">キーワード</td>
						<td class="search_item_content"><input type="text" id="search_keyword" name="search_keyword" value="<?=$search_keyword?>"></td>
						<td class="search_item_name"></td>
						<td class="search_item_content"></td>
					</tr>
					<tr>
						<td colspan="4">
							<span class="search_button_td">
								<span class="button_blue" onclick="list_download()">記録ダウンロード</span>
								<span class="button_blue" onclick="search(0)">検索</span>
							</td>
					</tr>
				</table>
				-->


				<div id="search_flex_box">
					<div class="one_column flex_right">
						<a href="./create_new_account.php" class="button_blue nodec">新規登録</a>
					</div>

					<div class="two_column">
						<div class="search_item">
							店舗
						</div>
						<div class="search_content">
							<select id="search_shop" name="search_shop">
								<option value="すべて">すべて</option>
								<?= $shop_options ?>
							</select>
						</div>
					</div>
					<div class="two_column">
						<div class="search_item">
							ステータス
						</div>
						<div class="search_content">
							<select id="search_status" name="search_status">
								<option value="すべて">すべて</option>
								<?= $status_options ?>
							</select>
						</div>
					</div>

					<div class="two_column">
						<div class="search_item">
							名前
						</div>
						<div class="search_content">
							<input type="text" id="search_name" name="search_name" placeholder="名前" value="<?=$search_name?>">
						</div>
					</div>
					<div class="two_column">
						<div class="search_item">
							メールアドレス
						</div>
						<div class="search_content">
							<input type="text" id="search_mail" name="search_mail" value="<?=$search_mail?>">
						</div>
					</div>

					<div class="two_column">
						<div class="search_item">
							ペア番号
						</div>
						<div class="search_content">
							<input type="text" id="search_pair_num" name="search_pair_num" value="<?=$search_pair_num?>">
						</div>
					</div>
					<div class="two_column">
						<div class="search_item">
							作成日
						</div>
						<div class="search_content">
							<input type="date" id="search_date1" name="search_date1" value="<?=$search_date1?>">
							<input type="checkbox" id="search_date_checkbox" name="search_date_checkbox" value="Y"<?=$search_date_checkbox === "Y" ? " checked" : ""?>>
							<input type="date" id="search_date2" name="search_date2" value="<?=$search_date2?>">
						</div>
					</div>

					<div class="one_column flex_buttons">
						<span class="button_blue" onclick="list_download()">記録ダウンロード</span>
						<!--<span class="button_blue" onclick="search(0)">検索</span>-->
						<input type="submit" class="button_blue" value="検索">
					</div>
				</div>

				<input type="hidden" id="page" name="page" value=""><!--<?=$PAGE_NUM?>-->
				<input type="hidden" id="display_num" name="display_num" value="<?=$DISPLAY_NUM?>">
			</form>
		</div>

		<div id="list_box">
			<div class="display_menu">
				<div class="display_num">
					表示件数：
					<select onchange="change_display_num(this)">
						<option value="10"<?= $DISPLAY_NUM == 10 ? " selected" : ""?>>10件</option>
						<option value="20"<?= $DISPLAY_NUM == 20 ? " selected" : ""?>>20件</option>
						<option value="50"<?= $DISPLAY_NUM == 50 ? " selected" : ""?>>50件</option>
						<option value="100"<?= $DISPLAY_NUM == 100 ? " selected" : ""?>>100件</option>
					</select>
				</div>
				<?php
				if($LIST_HTML !== ""){
				?>
				<div class="pagenation">
					<?php
					if($PAGE_NUM == 0){
						// 初めのページ
						echo "<span class=\"non-active\">≪ 最初</span>";
						echo "<span class=\"non-active\">＜ 前</span>";
					} else {
						echo "<span class=\"active\" onclick=\"search(0)\">≪ 最初</span>";
						echo "<span class=\"active\" onclick=\"search({$prev_page})\">＜ 前</span>";
					}

					echo "<span>{$display_page_start} - {$display_page_end} 件目 / {$count_result} 件</span>";
					if($PAGE_NUM == $max_page){
						// 最後のページ
						echo "<span class=\"non-active\">次 ＞</span>";
						echo "<span class=\"non-active\">最後 ≫</span>";
					} else {
						echo "<span class=\"active\" onclick=\"search({$next_page})\">次 ＞</span>";
						echo "<span class=\"active\" onclick=\"search({$max_page})\">最後 ≫</span>";
					}
					?>
				</div>
				<?php
				}
				?>
			</div>

			<?php
			if($LIST_HTML !== ""){
			?>
			<table id="list_content">
				<tr class="table_head">
					<th>対応店舗</th>
					<th>ペア番号</th>
					<th>作成日</th>
					<th>名前</th>
					<th>メールアドレス</th>
					<th>ステータス</th>
					<th></th>
				</tr>

				<?= $LIST_HTML;?>
			</table>
			<?php
			} else {
			?>
			<p id="no_result_text">検索結果がありません。</p>
			<?php
			}
			?>

			<div class="display_menu">
				<div class="display_num">
					表示件数：
					<select onchange="change_display_num(this)">
						<option value="10"<?= $DISPLAY_NUM == 10 ? " selected" : ""?>>10件</option>
						<option value="20"<?= $DISPLAY_NUM == 20 ? " selected" : ""?>>20件</option>
						<option value="50"<?= $DISPLAY_NUM == 50 ? " selected" : ""?>>50件</option>
						<option value="100"<?= $DISPLAY_NUM == 100 ? " selected" : ""?>>100件</option>
					</select>
				</div>
				<?php
				if($LIST_HTML !== ""){
				?>
				<div class="pagenation">
					<?php
					if($PAGE_NUM == 0){
						// 初めのページ
						echo "<span class=\"non-active\">≪ 最初</span>";
						echo "<span class=\"non-active\">＜ 前</span>";
					} else {
						echo "<span class=\"active\" onclick=\"search(0)\">≪ 最初</span>";
						echo "<span class=\"active\" onclick=\"search({$prev_page})\">＜ 前</span>";
					}
					echo "<span>{$display_page_start} - {$display_page_end} 件目 / {$count_result} 件</span>";
					if($PAGE_NUM == $max_page){
						// 最後のページ
						echo "<span class=\"non-active\">次 ＞</span>";
						echo "<span class=\"non-active\">最後 ≫</span>";
					} else {
						echo "<span class=\"active\" onclick=\"search({$next_page})\">次 ＞</span>";
						echo "<span class=\"active\" onclick=\"search({$max_page})\">最後 ≫</span>";
					}
					?>
				</div>
				<?php
				}
				?>
			</div>
		</div>
	</div>

	<?php
	if($action_flag){
	?>
	<div id="action" class="popup-main">
		<p><?=$action_text?></p>
		<p class="popup-button-box"><span class="popup-close button">閉じる</span></p>
	</div>
	<?php
	}
	?>

</body>
</html>
