<?php
/************************************
* 記録からユーザーのタイプを計算する *
* 必要なのは                        *
* ・着け外しのデータ                *
* ・装着感のデータ                  *
* ・着け外し頻度                    *
* ・飲酒頻度                        *
* ・フィットの好み                  *
* ・薬指の節                        *
************************************/

function calc($report1_data,$report2_data,$frequency,$alcohol,$taste,$joint){
	$return_data = [];

	// 空ではない、配列ではない、データが2つ以下はエラーである（最大、最小を排除するため）
	if(empty($report1_data) || !is_array($report1_data) || count($report1_data) <= 2 || empty($report2_data) || !is_array($report2_data) || count($report2_data) <= 2){
		$return_data = [
			"result" => false,
			"report1_fit" => "", // 着け外しフィット率
			"report2_fit" => "", // 装着フィット率
			"fit_percent" => "", // 総合フィット率
			"total_fit_percent" => "", // 着け心地総合フィット率
			"total_swelling_percent" => "", // むくみ率
			"user_type1" => "", // 着け心地総合フィット率のタイプ
			"user_type2" => "", // むくみ率のタイプ
		];
		return $return_data;
	}

	// 着け外しフィット率
	$report1_sum = 0;
	foreach($report1_data as $value){
		switch($value){
			case "1":
			$point = 50;
			break;
			case "2":
			$point = 75;
			break;
			case "3":
			$point = 100;
			break;
			case "4":
			$point = 125;
			break;
			case "5":
			$point = 150;
			break;
			default:
			continue 2;
		}
		$report1_sum += $point;
	}
	$report1_ave = round(($report1_sum/count($report1_data)),1); // 小数点第2位を四捨五入

	// 装着フィット率
	$report2_sum = 0;
	foreach($report2_data as $value){
		switch($value){
			case "1":
			$point = 50;
			break;
			case "2":
			$point = 75;
			break;
			case "3":
			$point = 100;
			break;
			case "4":
			$point = 125;
			break;
			case "5":
			$point = 150;
			break;
			default:
			continue 2;
		}
		$report2_sum += $point;
	}
	$report2_ave = round(($report2_sum/count($report2_data)),1); // 小数点第2位を四捨五入

	// 総合フィット率
	switch($frequency){
		case "1":
		// 毎日外す
		$ratio1 = 8;
		$ratio2 = 2;
		break;
		case "2":
		// たまに外す
		$ratio1 = 4;
		$ratio2 = 6;
		break;
		case "3":
		// 外さない
		$ratio1 = 2;
		$ratio2 = 8;
		break;
		default:
		$ratio1 = 4;
		$ratio2 = 6;
		break;
	}
	$fit_percent = round(($report1_ave * ($ratio1 / 10)) + ($report2_ave * ($ratio2 / 10)),1); // 小数点第2位を四捨五入

	// 補正 飲酒
	switch($alcohol){
		case "1":
		// よく飲む
		$correction1 = 0.9;
		break;
		case "2":
		// たまに飲む
		$correction1 = 0.95;
		break;
		case "3":
		// 飲まない
		$correction1 = 1;
		break;
		default:
		$correction1 = 0.95;
		break;
	}

	// 補正 好み
	switch($taste){
		case "1":
		// きつめ
		$correction2 = 1.1;
		break;
		case "2":
		// 多少きつめ
		$correction2 = 1.05;
		break;
		case "3":
		// ちょうどいい
		$correction2 = 1;
		break;
		case "4":
		// 多少ゆるめ
		$correction2 = 0.95;
		break;
		case "5":
		// ゆるめ
		$correction2 = 0.9;
		break;
		default:
		$correction2 = 1;
		break;
	}

	// 補正 薬指の節
	switch($joint){
		case "3":
		// なし
		$correction3 = 0.9;
		break;
		default:
		$correction3 = 1;
		break;
	}

	// 着け心地総合フィット率
	$total_fit_percent = round(($fit_percent * $correction1 * $correction2 * $correction3),1); // 小数点第2位を四捨五入

	// むくみ率
	// 個人データによる補正をかけずに記録データからのみ算出する
	// 【むくみ率用のフィット率】＝【着け外し感】＋【装着感】の平均値を使ってむくみ率をだす
	// 着け外し、装着感それぞれの最小値、最大値を1回ずつ排除して計算する
	// 値でソートして先頭と最後尾を取ればいい
	$swelling_ave = round((($report1_ave + $report2_ave) / 2),1); // 小数点第2位を四捨五入

	sort($report1_data);
	array_shift($report1_data);
	array_pop($report1_data);

	$report1_max = max($report1_data);
	$report1_min = min($report1_data);

	sort($report2_data);
	array_shift($report2_data);
	array_pop($report2_data);

	$report2_max = max($report2_data);
	$report2_min = min($report2_data);

	$array = [$report1_max,$report1_min,$report2_max,$report2_min];

	$total_max = max($array);
	$total_min = min($array);

	switch($total_max){
		case 1:
		$total_max_value = 50;
		break;
		case 2:
		$total_max_value = 75;
		break;
		case 3:
		$total_max_value = 100;
		break;
		case 4:
		$total_max_value = 125;
		break;
		case 5:
		$total_max_value = 150;
		break;
	}

	switch($total_min){
		case 1:
		$total_min_value = 50;
		break;
		case 2:
		$total_min_value = 75;
		break;
		case 3:
		$total_min_value = 100;
		break;
		case 4:
		$total_min_value = 125;
		break;
		case 5:
		$total_min_value = 150;
		break;
	}

	/*
	使用する値を変更した(2022/07/29)
	$swelling_percent1 = abs($total_fit_percent - $total_max_value);
	$swelling_percent2 = abs($total_fit_percent - $total_min_value);
	*/
	$swelling_percent1 = abs($swelling_ave - $total_max_value);
	$swelling_percent2 = abs($swelling_ave - $total_min_value);

	// 大きい方
	if($swelling_percent1 > $swelling_percent2){
		$total_swelling_percent = $swelling_percent1;
	} else {
		$total_swelling_percent = $swelling_percent2;
	}

	// ユーザーのタイプを算出する
	// 着け心地総合フィット率のタイプ
	if($total_fit_percent < user_type1_condition_list[0]){
		$user_type1 = 1;
	} else if(user_type1_condition_list[0] <= $total_fit_percent && $total_fit_percent < user_type1_condition_list[1]){
		$user_type1 = 2;
	} else if(user_type1_condition_list[1] <= $total_fit_percent && $total_fit_percent < user_type1_condition_list[2]){
		$user_type1 = 3;
	} else if(user_type1_condition_list[2] <= $total_fit_percent && $total_fit_percent < user_type1_condition_list[3]){
		$user_type1 = 4;
	} else if(user_type1_condition_list[3] <= $total_fit_percent){
		$user_type1 = 5;
	}
	// むくみ率のタイプ
	if($total_swelling_percent < user_type2_condition_list[0]){
		$user_type2 = 1;
	} else if(user_type2_condition_list[0] <= $total_swelling_percent && $total_swelling_percent < user_type2_condition_list[1]){
		$user_type2 = 2;
	} else if(user_type2_condition_list[1] <= $total_swelling_percent && $total_swelling_percent < user_type2_condition_list[2]){
		$user_type2 = 3;
	} else if(user_type2_condition_list[2] <= $total_swelling_percent && $total_swelling_percent < user_type2_condition_list[3]){
		$user_type2 = 4;
	} else if(user_type2_condition_list[3] <= $total_swelling_percent){
		$user_type2 = 5;
	}

	$user_type3 = user_type3_condition_list[$user_type1][$user_type2];

	$return_data = [
		"result" => true,
		"report1_fit" => $report1_ave, // 着け外しフィット率
		"report2_fit" => $report2_ave, // 装着フィット率
		"fit_percent" => $fit_percent, // 総合フィット率
		"total_fit_percent" => $total_fit_percent, // 着け心地総合フィット率
		"total_swelling_percent" => $total_swelling_percent, // むくみ率
		"user_type1" => $user_type1, // 着け心地総合フィット率のタイプ
		"user_type2" => $user_type2, // むくみ率のタイプ
		"user_type3" => $user_type3, // 総合的な診断タイプ
	];
	return $return_data;
}

function diagnosis($pdo,$user_id){
	// 結果を計算してユーザーのタイプを確定する
	$select_calc_user_sql = "SELECT * FROM user WHERE user_id = ?";
	$select_calc_user = $pdo->prepare($select_calc_user_sql);
	$select_calc_user->bindValue(1,$user_id,PDO::PARAM_STR);
	$select_calc_user->execute();
	if($calc_user_row = $select_calc_user->fetch()){
		$frequency = $calc_user_row["frequency"];
		$alcohol = $calc_user_row["alcohol"];
		$taste = $calc_user_row["taste"];
		$joint = $calc_user_row["joint"];
	} else {
		$frequency = null;
		$alcohol = null;
		$taste = null;
		$joint = null;
	}

	$select_calc_report_sql = "SELECT * FROM report WHERE user_id = ? AND deleted != 1";
	$select_calc_report = $pdo->prepare($select_calc_report_sql);

	$report1_data = [];
	$report2_data = [];

	$select_calc_report->bindValue(1,$user_id,PDO::PARAM_STR);
	$select_calc_report->execute();
	while($calc_report_row = $select_calc_report->fetch()){
		$report1 = $calc_report_row["report1"];
		$report2 = $calc_report_row["report2"];

		$report1_data[] = $report1;
		$report2_data[] = $report2;
	}

	$calc_result = calc($report1_data,$report2_data,$frequency,$alcohol,$taste,$joint);
	$calc_check = $calc_result["result"];
	if($calc_check){
		// 算出した
		$report1_fit = $calc_result["report1_fit"];
		$report2_fit = $calc_result["report2_fit"];
		$fit_percent = $calc_result["fit_percent"];
		$user_type1 = $calc_result["user_type1"];
		$user_type1_value = $calc_result["total_fit_percent"];
		$user_type2 = $calc_result["user_type2"];
		$user_type2_value = $calc_result["total_swelling_percent"];
		$user_type3 = $calc_result["user_type3"];
	} else {
		// 算出できていない
		$report1_fit = "";
		$report2_fit = "";
		$fit_percent = "";
		$user_type1 = "";
		$user_type1_value = "";
		$user_type2 = "";
		$user_type2_value = "";
		$user_type3 = "";
	}

	$update_sql = "UPDATE user SET report1_fit = ?, report2_fit = ?, total_fit = ?, user_type1 = ?, user_type1_value = ?, user_type2 = ?, user_type2_value = ?, user_type3 = ? WHERE user_id = ?";
	$update = $pdo->prepare($update_sql);

	$update->bindValue(1,$report1_fit,PDO::PARAM_STR);
	$update->bindValue(2,$report2_fit,PDO::PARAM_STR);
	$update->bindValue(3,$fit_percent,PDO::PARAM_STR);
	$update->bindValue(4,$user_type1,PDO::PARAM_STR);
	$update->bindValue(5,$user_type1_value,PDO::PARAM_STR);
	$update->bindValue(6,$user_type2,PDO::PARAM_STR);
	$update->bindValue(7,$user_type2_value,PDO::PARAM_STR);
	$update->bindValue(8,$user_type3,PDO::PARAM_STR);
	$update->bindValue(9,$user_id,PDO::PARAM_STR);
	$update->execute();

	$return_data = [
		"result" => true,
		"report1_fit" => $report1_fit, // 着け外しフィット率
		"report2_fit" => $report2_fit, // 装着フィット率
		"fit_percent" => $fit_percent, // 総合フィット率
		"user_type1" => $user_type1,
		"user_type1_value" => $user_type1_value,
		"user_type2" => $user_type2,
		"user_type2_value" => $user_type2_value,
		"user_type3" => $user_type3,
	];

	return $return_data;
}
