<?php
/****************************************************
*  ユーザーのタイプを診断してDBの更新をする用        *
*  tryの中で読み込む                                *
*  ユーザーは $user_id で持っていること             *
*  診断結果は                                       *
*  $user_type1 着け心地総合フィット率                *
*  $user_type1_value 着け心地総合フィット率のタイプ  *
*  $user_type2 むくみ率                             *
*  $user_type2_value むくみ率のタイプ                *
*****************************************************/

require_once __DIR__.'/calc.php';

// 結果を計算してユーザーのタイプを確定する
$select_calc_user_sql = "SELECT * FROM user WHERE user_id = ?";
$select_calc_user = $pdo->prepare($select_calc_user_sql);
$select_calc_user->bindValue(1,$user_id,PDO::PARAM_STR);
$select_calc_user->execute();
if($calc_user_row = $select_calc_user->fetch()){
	$frequency = $calc_user_row["frequency"];
	$alcohol = $calc_user_row["alcohol"];
	$taste = $calc_user_row["taste"];
} else {
	$frequency = null;
	$alcohol = null;
	$taste = null;
}

$select_calc_report_sql = "SELECT * FROM report WHERE user_id = ? AND deleted != 1";
$select_calc_report = $pdo->prepare($select_calc_report_sql);

$report1_data = [];
$report2_data = [];

$select_calc_report->bindValue(1,$user_id,PDO::PARAM_STR);
$select_calc_report->execute();
while($calc_report_row = $select_calc_report->fetch()){
	$report1 = $calc_report_row["report1"];
	$report2 = $calc_report_row["report2"];

	$report1_data[] = $report1;
	$report2_data[] = $report2;
}

$calc_result = calc($report1_data,$report2_data,$frequency,$alcohol,$taste);
$calc_check = $calc_result["result"];
if($calc_check){
	// 算出した
	$user_type1 = $calc_result["user_type1"];
	$user_type1_value = $calc_result["total_fit_ratio"];
	$user_type2 = $calc_result["user_type2"];
	$user_type2_value = $calc_result["total_swelling_ratio"];
} else {
	// 算出できていない
	$user_type1 = "";
	$user_type1_value = "";
	$user_type2 = "";
	$user_type2_value = "";
}

$update_sql = "UPDATE user SET user_type1 = ?, user_type1_value = ?, user_type2 = ?, user_type2_value = ? WHERE user_id = ?";
$update = $pdo->prepare($update_sql);

$update->bindValue(1,$user_type1,PDO::PARAM_STR);
$update->bindValue(2,$user_type1_value,PDO::PARAM_STR);
$update->bindValue(3,$user_type2,PDO::PARAM_STR);
$update->bindValue(4,$user_type2_value,PDO::PARAM_STR);
$update->bindValue(5,$user_id,PDO::PARAM_STR);
$update->execute();
