<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/server_check.php';
require_once '../include/functions.php';
require_once '../include/db.php';
require_once '../include/config.php';

$id_hex = filter_input(INPUT_GET,"i");
$user_hex = filter_input(INPUT_GET,"u");
$token_hex = filter_input(INPUT_GET,"t");

$posted_log = "i -> {$id_hex} | u -> {$user_hex} | t -> {$token_hex}";

$account_data = [];
$account_data["error"] = "";

if(empty($id_hex) || empty($user_hex) || empty($token_hex)){
	$log = "必要な情報がない | {$posted_log}";
	Writelog($log,basename(__FILE__));
	$account_data["error"] = "エラーが発生しました。";
} else {
	// 復号する
	$id = hex2bin($id_hex);
	$id = openssl_decrypt($id,'aes-256-ecb',id_cript_key);

	$user = hex2bin($user_hex);
	$user = openssl_decrypt($user,'aes-256-ecb',user_cript_key);

	$token = hex2bin($token_hex);
	$token = openssl_decrypt($token,'aes-256-ecb',token_cript_key);

	try {
		$pdo = DBopen();

		$select_sql = "SELECT * FROM token WHERE id = ? AND user_id = ? AND token = ?";
		$select = $pdo->prepare($select_sql);
		$select->bindValue(1,$id,PDO::PARAM_STR);
		$select->bindValue(2,$user,PDO::PARAM_STR);
		$select->bindValue(3,$token,PDO::PARAM_STR);
		$select->execute();
		if($row = $select->fetch()){
			$created = $row["created"];
			$used = $row["used"]; // 使用済みか？
		} else {
			throw new RuntimeException("対象が存在しない");
		}

		if($used == 1){
			// 使用済み
			$account_data["error"] = "無効なリクエストです。";
		} else {
			$now = new DateTime();
			$created = new DateTime($created);
			$diff = $now->diff($created);
			$check_time = $diff->days * 24 * 60 * 60 + $diff->h * 60 * 60 + $diff->i * 60 + $diff->s; //秒数で確認
			$check_max = 30 * 60; // 30分
			if($check_time > $check_max){
				// 期限切れ
				$account_data["error"] = "有効期限切れです。";
			} else {
				// 期限内
				// パスワード再発行
				$update_sql = "UPDATE user SET password = ?, updated = ? WHERE user_id = ?";
				$update = $pdo->prepare($update_sql);

				$randompass = RandomPass();
				$addpass = password_hash($randompass, PASSWORD_DEFAULT);

				$date = new DateTime();
				$updated = $date->format("Y-m-d H:i:s");

				$update->bindValue(1,$addpass,PDO::PARAM_STR);
				$update->bindValue(2,$updated,PDO::PARAM_STR);
				$update->bindValue(3,$user,PDO::PARAM_STR);
				$update->execute();

				$account_data["password"] = $randompass;

				// 使用済みフラグを建てる
				$update_token_sql = "UPDATE token SET used = 1 WHERE id = ?";
				$update_token = $pdo->prepare($update_token_sql);
				$update_token->bindValue(1,$id,PDO::PARAM_STR);
				$update_token->execute();
			}
		}
	} catch(Exception $e){
		$error = $e->getMessage();
		$log = "error -> {$error} | {$posted_log}";
		Writelog($log,basename(__FILE__));
		$account_data["error"] = "エラーが発生しました。";
	}
}

$title = "パスワード再発行";
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<script>
window.onload = function(){
	document.f.submit();
}
</script>
</head>
<body>
	<form method="post" action="password_reset_finish.php" name="f">
		<?php
		foreach($account_data as $key => $value){
			echo "<input type=\"hidden\" id=\"{$key}\" name=\"{$key}\" value=\"{$value}\">";
		}
		?>
	</form>
</body>
</html>
