<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/include.php';

$title = "着け外しの記録";
$return_report = "Y"; // エラー時用

$date = new DateTime();
$date = $date->format("YmdHis");

// 初回用
unset($_SESSION["info"]["save"]);

$from_page = filter_input(INPUT_POST,"page");
$token = filter_input(INPUT_POST,"token");
if(empty($token)){
	// 初回
	$token = RandomToken();
	$_SESSION[$token] = [];
	$selected_value = 1;
} else {
	if(isset($_SESSION[$token]["report"])){
		$selected_value = $_SESSION[$token]["report"];
	} else {
		$selected_value = 1;
	}
}

$text_list = report_text_list;
$max = count($text_list);


?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<link rel="apple-touch-icon" href="./img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="./js/script.js"></script>
<link href="./css/style.css" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
window.onload = function(){
	select_radio(0);
	// スワイプ／フリック
	document.getElementById("img_scroll_box").addEventListener('touchmove', get_end_swipe);
	// タッチ開始
	document.getElementById("img_scroll_box").addEventListener('touchstart', get_start_swipe);
	// タッチ終了
	document.getElementById("img_scroll_box").addEventListener('touchend', get_swipe_width);
}
</script>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>
	<div id="main">
		<div id="report_header_text">
			まずは、着け外しの記録です。<span class="attention">節の通り具合</span>をご確認ください。
		</div>
		<div id="img_box">
			<div id="move_left">
				<i class="fa-solid fa-angle-left" onclick="allow_prev()"></i>
			</div>
			<div id="img_scroll_box">
				<?php
				for($i=1;$i<=$max;$i++){
					echo "<div id=\"img_elm{$i}\" class=\"img_scroll_elm\">
						<img id=\"img{$i}\" class=\"imgs\" src=\"./img/report1_{$i}_2.png\">
					</div>";
				}
				?>
			</div>
			<div id="move_right">
				<i class="fa-solid fa-angle-right" onclick="allow_next()"></i>
			</div>
		</div>
		<div id="radio_box">
			<form id="post_form" name="post_form" method="post" action="">
				<?php
				for($i=0;$i<$max;$i++){
					$text = $text_list[$i];
					$value = $i + 1;
					if($value == $selected_value){
						$checked = " checked";
					} else {
						$checked = "";
					}
					echo "<p class=\"radio_elm\"><label for=\"select{$i}\">
						<input type=\"radio\" id=\"select{$i}\" name=\"select\" value=\"{$value}\" onchange=\"select_radio(0)\"{$checked}>
						<span class=\"radio_text\">{$text}</span>
					</label></p>";
				}
				?>
				<input type="hidden" id="page" name="page" value="report">
				<input type="hidden" id="token" name="token" value="<?=$token?>">
				<input type="hidden" id="save_flag" name="save_flag" value="">
			</form>
		</div>
		<div id="footer">
			<?php
			if($from_page === "report_confirm"){
				echo "<div id=\"footer_button_next\"  onclick=\"set_save_flag();post_move('{$from_page}')\">一時保存して戻る</div>";
			} else {
				echo "<div id=\"footer_button_next\" onclick=\"post_move('report2')\">一時保存して次へ</div>";
			}
			if(!empty($from_page)){
				echo "<div id=\"footer_button_prev\"  onclick=\"post_move('{$from_page}')\">戻る</div>";
			}
			?>
		</div>
	</div>
</body>
</html>
