<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';

$user_id = filter_input(INPUT_POST,"user_id");
$pair_id = filter_input(INPUT_POST,"pair_id");

$posted_log = "user_id -> {$user_id} | pair_id -> {$pair_id}";

if(empty($user_id) || empty($pair_id)){
	$log = "必要な情報がない | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

try {
	$pdo = DBopen();

	// ペア番号の取得
	$select_pair_num_sql = "SELECT pair FROM user WHERE pair != '' ORDER BY pair DESC LIMIT 1";
	$select_pair_num = $pdo->query($select_pair_num_sql);
	if($row = $select_pair_num->fetch()){
		// 存在している
		$pair_num = $row["pair"];
	} else {
		// 存在していない
		$pair_num = 0;
	}
	// 新しいペア番号
	$pair_num += 1;

	$update_sql = "UPDATE user SET pair = ?, updated = ? WHERE user_id = ?";
	$update = $pdo->prepare($update_sql);

	$date = new DateTime();
	$updated = $date->format("Y-m-d H:i:s");

	$update->bindValue(1,$pair_num,PDO::PARAM_STR);
	$update->bindValue(2,$updated,PDO::PARAM_STR);
	$update->bindValue(3,$user_id,PDO::PARAM_STR);
	$update->execute();

	$update->bindValue(1,$pair_num,PDO::PARAM_STR);
	$update->bindValue(2,$updated,PDO::PARAM_STR);
	$update->bindValue(3,$pair_id,PDO::PARAM_STR);
	$update->execute();

} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error} | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

$_SESSION["details"]["action"] = "ペアを登録しました。";

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<script>
window.onload = function(){
	document.f.submit();
}
</script>
</head>
<body>
	<form method="post" action="details.php" name="f">
		<input type="hidden" id="user_id" name="user_id" value="<?=$user_id?>">
	</form>
</body>
</html>
