<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';
$title = "パスワード再発行";

$user_id = filter_input(INPUT_POST,"user_id");
$user_password = filter_input(INPUT_POST,"password");

$posted_log = "user_id -> {$user_id}";

if(empty($user_id) || empty($user_password)){
	$log = "必要な情報がない | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

try {
	$pdo = DBopen();

	$select_user_sql = "SELECT * FROM user WHERE user_id = ?";
	$select_user = $pdo->prepare($select_user_sql);
	$select_user->bindValue(1,$user_id,PDO::PARAM_STR);
	$select_user->execute();
	if($row = $select_user->fetch()){
		$user_name1 = h($row["name1"]);
		$user_name2 = h($row["name2"]);
		$user_mail = h($row["mail"]);
		$pair_num = $row["pair"];
	} else {
		// 対象が存在しない
		throw new RuntimeException("対象が存在しない");
	}

} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error} | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="../img/favicon.ico">
<link rel="apple-touch-icon" href="../img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="../js/script.js"></script>
<link href="../css/style.css" rel="stylesheet" type="text/css">
<link href="./css/style.css" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
function select_person(e){
	let post_data = {
		"url":"details.php",
		"data":{"user_id":e}
	};
	data_submit(post_data);
}
</script>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>

	<div id="main">
		<div class="content_box">
			<table class="create_new_account_table">
				<tr>
					<td class="create_table_head" colspan="2">パスワードを再発行しました。</td>
				</tr>
				<tr>
					<td class="account_table_item">名前</td>
					<td class="account_table_content"><span class="display_user_name"><?=$user_name1?></span><span class="display_user_name"><?=$user_name2?></span></td>
				</tr>
				<tr>
					<td class="account_table_item">メールアドレス</td>
					<td class="account_table_content"><?=$user_mail?></td>
				</tr>
				<tr>
					<td class="account_table_item">パスワード</td>
					<td class="account_table_content"><?=$user_password?></td>
				</tr>
			</table>
		</div>
		<div class="details_flex_box">
			<span class="link_text" onclick="select_person('<?=$user_id?>')">戻る</span>
			<span></span>
		</div>
	</div>
</body>
</html>
