<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';
$title = "ユーザー詳細";

$user_id = filter_input(INPUT_POST,"user_id");

$posted_log = "user_id -> {$user_id}";

if(empty($user_id)){
	$log = "必要な情報がない | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

try {
	$pdo = DBopen();

	// ペア番号を取得する
	$select_sql = "SELECT * FROM user WHERE user_id = ?";
	$select = $pdo->prepare($select_sql);
	$select->bindValue(1,$user_id,PDO::PARAM_STR);
	$select->execute();
	if($row = $select->fetch()){
		$pair_num = $row["pair"];
	} else {
		throw new RuntimeException("対象が存在しない");
	}

	if(!empty($pair_num)){
		// ペアを解除する
		$update_sql = "UPDATE user SET pair = '', updated = ? WHERE pair = ?";
		$update = $pdo->prepare($update_sql);

		$date = new DateTime();
		$updated = $date->format("Y-m-d H:i:s");

		$update->bindValue(1,$updated,PDO::PARAM_STR);
		$update->bindValue(2,$pair_num,PDO::PARAM_STR);
		$update->execute();
	}


	// ユーザーを削除する
	$delete_sql = "DELETE FROM user WHERE user_id = ?";
	$delete = $pdo->prepare($delete_sql);
	$delete->bindValue(1,$user_id,PDO::PARAM_STR);
	$delete->execute();

} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error} | {$posted_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

$_SESSION["details"]["delete"] = "ユーザーを削除しました。";
/*
header("Loction: ./list.php?r=Y");
exit;
*/
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<script>
window.onload = function(){
	document.f.submit();
}
</script>
</head>
<body>
	<form method="post" action="list.php?r=Y" name="f">
		<!--<input type="hidden" id="user_id" name="user_id" value="<?=$user_id?>">-->
	</form>
</body>
</html>
