<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/server_check.php';
require_once './include/functions.php';
require_once './include/db.php';
require_once './include/config.php';

$post_id = filter_input(INPUT_POST,'input_id');
$post_pass = filter_input(INPUT_POST,'input_pass');
$error_text = "";
$error_class = "nodisp";


if(!empty($post_id) && !empty($post_pass)){
	// ログイン処理
	try {
		$pdo = DBopen();

		$select_sql = "SELECT * FROM user WHERE mail = ?";
		$select = $pdo->prepare($select_sql);
		$select->bindValue(1,$post_id,PDO::PARAM_STR);
		$select->execute();

		if($row = $select->fetch()){
			// パスワードの比較
			$db_pass = $row["password"];
			if((password_verify($post_pass, $db_pass))){
				// ログイン成功

				// 初回かどうかを確認する
				$user_id = $row["user_id"];
				$handedness = $row["handedness"];
				$joint = $row["joint"];
				$working = $row["working"];
				$frequency = $row["frequency"];
				$alcohol = $row["alcohol"];
				$taste = $row["taste"];

				if(empty($handedness) || empty($joint) || empty($frequency) || empty($alcohol) || empty($taste)){
					// 初回ならお客様情報の入力
					session_regenerate_id(TRUE);
					$_SESSION["user"] = $user_id;
					header("Location:./info.php");
					exit;
				} else {
					// 初回ではないならトップ
					session_regenerate_id(TRUE);
					$_SESSION["user"] = $user_id;
					header("Location:./top.php");
					exit;
				}
			} else {
				// パスワードが間違っている
				$error_text = "ログインに失敗しました";
			}
		} else {
			throw new RuntimeException("ログインしようとしたアカウントが存在しない");
		}

	} catch(Exception $e){
		$error = $e->getMessage();
		$log = "error -> {$error}";
		Writelog($log,basename(__FILE__));
		$error_text = "ログインに失敗しました";
	}

	$error_text = "ログインに失敗しました。";
	$error_class = "active";
}


$title = "ログイン";
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<link rel="apple-touch-icon" href="./img/home_icon.jpg">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<style>
html, body {
	margin: 0;
	font-family: "Helvetica Neue", Arial, "Hiragino Kaku Gothic ProN", "Hiragino Sans", Meiryo, sans-serif;
	min-height: 100vh;
}
#wrapper {
	display: flex;
	flex-direction: column;
	justify-content: space-between;
	min-height: 100vh;
}
#header {
	width: 100%;
	/*
	background: rgb(89,70,57);
	background: linear-gradient(90deg, rgba(89,70,57,1) 0%, rgba(109, 50, 32, 1) 50%, rgba(89,70,57,1) 100%);
	*/
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	text-align: center;
	padding: 20px 0 10px;
}
#header img {
	width: 200px;
	margin: 10px;
}
#title_box {
	width: 100%;
	/*
	background: rgb(89,70,57);
	background: linear-gradient(90deg, rgba(89,70,57,1) 0%, rgba(109, 50, 32, 1) 50%, rgba(89,70,57,1) 100%);
	*/
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	text-align: center;
	padding: 10px 0 20px;
}
#title_block {
	width: 80%;
	max-width: 600px;
	margin: auto;
	padding: 10px;
	border: 1px solid #fff;
}
.title_block_text {
	display: block;
	color: #fff;
}
#head_text {
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	color: #fff;
	text-align: center;
}
#main {
	margin: 50px auto;
	width: 100%;
	max-width: 600px;
}
#post_form {
	width: 90%;
	margin: auto;
}
.login_input {
	width: 100%;
	box-sizing: border-box;
	height: 35px;
}
.login_button_margin {
	margin-top: 50px;
	text-align: center;
}
.login_button {
	width: 100%;
	height: 35px;
	background: rgb(71, 33, 21);
	background: linear-gradient(90deg, rgba(71, 33, 21, 1) 0%, rgba(109, 50, 32, 1) 50%, rgba(71, 33, 21, 1) 100%);
	color: #fff;
}
#error_text {
	text-align: center;
	color: red;
}
.nodisp {
	display: none;
}
.active {
	display: block;
}
#footer {
	height: 10vh;
}
.link_text {
	color: #0070C0;
	cursor: pointer;
}
div#wrapper {
	background: linear-gradient( to right, rgba(255,255,255,0.6), rgba(255,255,255,0.7)),url(https://www.tanzo.jp/img/tanzo/specialty_img2.jpg);
	background-size: cover;
	background-position: center center;
}
</style>
<title><?=$title?></title>
</head>
<body>
	<div id="wrapper">
		<div>
			<div id="header">
				<img src="./img/Logo.png" width="150px">
			</div>
			<div id="title_box">
				<div id="title_block">
					<span class="title_block_text">tanzo.fit</span>
					<span class="title_block_text">入籍指輪システム</span>
				</div>
			</div>
		</div>
		<div id="main">
			<form id="post_form" name="post_form" method="post">
				<p>
					<div class="">メールアドレス</div>
					<input type="text" id="input_id" name="input_id" class="login_input" required>
				</p>
				<p>
					<div class="">パスワード</div>
					<input type="password" id="input_pass" name="input_pass" class="login_input" required>
				</p>
				<p class="login_button_margin">
					<button type="submit" class="login_button">ログイン</button>
				</p>
				<p id="error_text" class="<?=$error_class?>">
					<?=$error_text?>
				</p>
				<p class="login_button_margin">
					パスワードを忘れた方は<a href="./request_reset.php" class="link_text">こちら</a>
				</p>
			</form>
		</div>
		<div id="footer"></div>
	</div>
</body>
</html>
