<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_name("tanzo_master");
session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once '../include/include.php';
$title = "ユーザー詳細";
$date = new DateTime();
$date = $date->format("YmdHis");

$user_id = filter_input(INPUT_POST,"user_id");
if(empty($user_id)){
	require_once './error.php';
	exit;
}

$person_log = "user_id -> {$user_id}";

$table_pair_info = "";

$pair_list = "";
$pair_array = [];

$cancel_pair_button = "";

try {
	$pdo = DBopen();

	// 情報
	$select_sql = "SELECT * FROM user WHERE user_id = ?";
	$select = $pdo->prepare($select_sql);
	$select->bindValue(1,$user_id,PDO::PARAM_STR);
	$select->execute();
	if($row = $select->fetch()){
		$name1 = $row["name1"];
		$name2 = $row["name2"];
		$kana1 = $row["kana_name1"];
		$kana2 = $row["kana_name2"];
		$mail = $row["mail"];
		$gender = $row["gender"];
		$pair = $row["pair"];
		$shop = $row["shop"];
		$ring_type = $row["ring_type"];
		$ring_size = $row["ring_size"];
		$ring_width = $row["ring_width"];
		$ring_thickness = $row["ring_thickness"];
		$ring_material = $row["ring_material"];
		$remarks = nl2br($row["remarks"]);

		// 確定後
		$fixed_date = $row["fixed_date"];
		$fixed_ring_type = $row["fixed_ring_type"];
		$fixed_ring_size = $row["fixed_ring_size"];
		$fixed_ring_width = $row["fixed_ring_width"];
		$fixed_ring_thickness = $row["fixed_ring_thickness"];
		$fixed_ring_material = $row["fixed_ring_material"];
		$user_type1 = $row["user_type1"];
		$user_type1_value = $row["user_type1_value"];
		$user_type2 = $row["user_type2"];
		$user_type2_value = $row["user_type2_value"];

		$user_type1_value = round(($user_type1_value),1); // 小数点第2位を四捨五入
		$user_type2_value = round(($user_type2_value),1); // 小数点第2位を四捨五入

		// ユーザー入力
		$handedness = $row["handedness"];
		$joint = $row["joint"];
		$working = $row["working"];
		$frequency = $row["frequency"];
		$alcohol = $row["alcohol"];
		$taste = $row["taste"];

		$created = $row["created"];
		$updated = $row["updated"];

		$gender = $gender == "1" ? "男性" : "女性";

		// 確定しているかどうか
		if($fixed_date === default_date){
			$not_fixed_flag = true;
			$status = "調整中";

			$ring_size_changed = "";
		} else {
			$not_fixed_flag = false;
			$status = "確定済";

			if(empty($fixed_ring_type)){
				$fixed_ring_type = $ring_type;
			}

			// サイズの変動
			// 小数点のある計算はそもそもが問題が起こり得てしまう
			// BC Mathを使用して計算をする必要がある
			// $ring_size_changed = $fixed_ring_size - $ring_size;
			$ring_size_changed = bcsub($fixed_ring_size, $ring_size, 1);
			if($ring_size_changed > 0){
				$ring_size_changed = "+{$ring_size_changed}";
			}
			$ring_size_changed = "({$ring_size_changed})";

			$fixed_ring_type = ring_type_list[$fixed_ring_type - 1];
			$fixed_ring_size .= ring_size_unit . $ring_size_changed;
			$fixed_ring_width .= ring_width_unit;
			$fixed_ring_thickness .= ring_thickness_unit;
			$fixed_ring_material = isset(material_list[$fixed_ring_material]) ? material_list[$fixed_ring_material] : "";
			$fixed_date = new DateTime($fixed_date);
			$fixed_date = $fixed_date->format("Y年n月j日 G:i:s");
		}

		$ring_type = ring_type_list[$ring_type - 1];
		$ring_size .= ring_size_unit;
		$ring_width .= ring_width_unit;
		$ring_thickness .= ring_thickness_unit;
		$ring_material = isset(material_list[$ring_material]) ? material_list[$ring_material] : "";

		if(!empty($handedness)){
			$handedness = hand_list[$handedness - 1];
		}
		if(!empty($joint)){
			$joint = joint_list[$joint - 1];
		}
		if(!empty($working)){
			$working = working_list[$working - 1];
		}
		if(!empty($frequency)){
			$frequency = frequency_list[$frequency - 1];
		}
		if(!empty($alcohol)){
			$alcohol = alcohol_list[$alcohol - 1];
		}
		if(!empty($taste)){
			$taste = taste_list[$taste - 1];
		}

		$created = new DateTime($created);
		$created = $created->format("Y年n月j日");
		$updated = new DateTime($updated);
		$updated = $updated->format("Y年n月j日 G:i:s");

	} else {
		throw new RuntimeException("対象が存在しない");
	}

	if(!empty($pair)){
		// ペア番号が存在する
		$select_pair_sql = "SELECT * FROM user WHERE pair = ? AND user_id != ?";
		$select_pair = $pdo->prepare($select_pair_sql);
		$select_pair->bindvalue(1,$pair,PDO::PARAM_STR);
		$select_pair->bindvalue(2,$user_id,PDO::PARAM_STR);
		$select_pair->execute();
		if($row = $select_pair->fetch()){
			$pair_user_id = $row["user_id"];
			$pair_name1 = $row["name1"];
			$pair_name2 = $row["name2"];
			$pair_mail = $row["mail"];

			// ペアが存在する
			$table_pair_info .=<<<EOD
			<tr>
				<td class="create_table_head" colspan="4">ペア情報</td>
			</tr>
			<tr>
				<td class="account_table_item">ペア番号</td>
				<td class="account_table_content" colspan="3">{$pair}</td>
			</tr>
			<tr>
				<td class="account_table_item">名前</td>
				<td class="account_table_content" colspan="3"><span class="link_text" onclick="select_person('{$pair_user_id}')"><span class="display_user_name">{$pair_name1}</span><span class="display_user_name">{$pair_name2}</span></span></td>
			</tr>
			<tr>
				<td class="account_table_item">メールアドレス</td>
				<td class="account_table_content" colspan="3">{$pair_mail}</td>
			</tr>
EOD;

			$cancel_pair_button = "<span class=\"button_red\" onclick=\"popup('cancel_pair')\">ペアを解消する</span>";
		}
	} else {
		// ペアが存在しない
		// ペアを持たないアカウントを探す
		// 自身を除外する必要がある
		$select_sql = "SELECT * FROM user WHERE pair = '' AND user_id != ?";
		$select = $pdo->prepare($select_sql);
		$select->bindValue(1,$user_id,PDO::PARAM_STR);
		$select->execute();
		while($row = $select->fetch()){
			$pair_id = $row["user_id"];
			$pair_name = $row["name1"].$row["name2"];
			$pair_mail = $row["mail"];
			$pair_array[$pair_id] = [
				"name" => $pair_name,
				"mail" => $pair_mail
			];

			$pair_list .=<<<EOD
			<tr>
				<td>{$pair_name}</td>
				<td>{$pair_mail}</td>
				<td><span class="pair_list_button modal-del" onclick="select_pair('{$pair_id}')">選択</span></td>
			</tr>
EOD;
		}

		$table_pair_info .=<<<EOD
		<tr>
			<td class="create_table_head" colspan="4">ペア情報</td>
		</tr>
		<tr>
			<td colspan="4" class="center">なし</td>
		</tr>
		<tr>
			<td colspan="4"><span class="details_button_block"><span class="button_blue" onclick="modal('pair')">登録する</span><span class="button_blue" onclick="create_pair('{$user_id}')">作成する</span></span></td>
		</tr>
EOD;
	}

	// 記録
	$select_report_sql = "SELECT * FROM report WHERE user_id = ? AND deleted != 1 ORDER BY report_id DESC";
	$select_report = $pdo->prepare($select_report_sql);
	$select_report->bindValue(1,$user_id,PDO::PARAM_STR);
	$select_report->execute();
	$report_html = "";
	$report_count = 0;
	while($row = $select_report->fetch()){
		$report_id = $row["report_id"];
		$report1 = $row["report1"];
		$report2 = $row["report2"];
		$memo = nl2br(h($row["memo"]));
		$report_date = $row["created"];

		$key = $report1 - 1;
		$report1_text = report_text_list[$key];

		$key = $report2 - 1;
		$report2_text = report2_text_list[$key];

		$report_date = new DateTime($report_date);
		$report_date = $report_date->format("Y年n月j日 G:i:s");

		$report_html .=<<<EOD
		<div class="report_data_box">
			<label for="report_data_{$report_id}" class="report_data_box_head">{$report_date}</label>
			<input type="checkbox" id="report_data_{$report_id}" class="report_data_checkbox nodisp" checked>
			<div class="report_data_block nodisp">
				<table class="report_data_table">
					<tr>
						<td class="report_data_table_head">着け外し</td>
						<td class="report_data_table_content">{$report1_text}</td>
					</tr>
					<tr>
						<td class="report_data_table_head">装着感</td>
						<td class="report_data_table_content">{$report2_text}</td>
					</tr>
					<tr>
						<td class="report_data_table_head">メモ</td>
						<td class="report_data_table_content">{$memo}</td>
					</tr>
				</table>
			</div>
		</div>
EOD;
		$report_count++;
	}

	// 集計
	// 今までにどれだけ記録があるかを調べる
	$count_asa_sql = "SELECT COUNT(DISTINCT created_date) FROM report WHERE user_id = ? AND created_time >= '04:00:00' AND created_time < '11:00:00' AND deleted != 1";
	$count_asa = $pdo->prepare($count_asa_sql);
	$count_asa->bindValue(1,$user_id,PDO::PARAM_STR);
	$count_asa->execute();
	$count_asa_result = $count_asa->fetchcolumn();

	$count_hiru_sql = "SELECT COUNT(DISTINCT created_date) FROM report WHERE user_id = ? AND created_time >= '11:00:00' AND created_time < '17:00:00' AND deleted != 1";
	$count_hiru = $pdo->prepare($count_hiru_sql);
	$count_hiru->bindValue(1,$user_id,PDO::PARAM_STR);
	$count_hiru->execute();
	$count_hiru_result = $count_hiru->fetchcolumn();

	// 夜の記録の場合は0～4時の記録を前日にするために調整する
	$count_yoru_sql = "SELECT COUNT(DISTINCT CAST((created - INTERVAL 4 HOUR) AS DATE)) FROM report WHERE user_id = ? AND (created_time < '04:00:00' OR created_time >= '17:00:00') AND deleted != 1";
	$count_yoru = $pdo->prepare($count_yoru_sql);
	$count_yoru->bindValue(1,$user_id,PDO::PARAM_STR);
	$count_yoru->execute();
	$count_yoru_result = $count_yoru->fetchcolumn();

	$another_data_list = [
		"1" => 0, // 1.5以上アップ
		"2" => 0, // 1 アップ
		"3" => 0, // 0.5 アップ
		"4" => 0, // 変わらない
		"5" => 0, // 0.5 ダウン
		"6" => 0, // 1 ダウン
		"7" => 0 // 1.5以上ダウン
	];
	$matrix_flag = false;
	$graph_flag = false;

	$all_count = $count_asa_result + $count_hiru_result + $count_yoru_result;

	//if($count_asa_result >= 5 && $count_hiru_result >= 5 && $count_yoru_result >= 5){
	if($all_count > 2){
		// 十分に集計があれば
		require_once '../include/calc.php';
		$return_data = diagnosis($pdo,$user_id);
		$user_type1 = $return_data["user_type1"];
		$user_type1_value = $return_data["user_type1_value"];
		$user_type2 = $return_data["user_type2"];
		$user_type2_value = $return_data["user_type2_value"];
		$matrix_flag = true;

		$user_type1_value = round(($user_type1_value),1); // 小数点第2位を四捨五入
		$user_type2_value = round(($user_type2_value),1); // 小数点第2位を四捨五入

		// 同じ分類の人がどのようにしたか？
		// サイズアップ, 変更なし, サイズダウン
		$select_another_data_sql = "SELECT * FROM user WHERE user_id != ? AND fixed_date != ? AND user_type1 = ? AND user_type2 = ?";
		$select_another_data = $pdo->prepare($select_another_data_sql);
		$select_another_data->bindValue(1,$user_id,PDO::PARAM_STR);
		$select_another_data->bindValue(2,default_date,PDO::PARAM_STR);
		$select_another_data->bindValue(3,$user_type1,PDO::PARAM_STR);
		$select_another_data->bindValue(4,$user_type2,PDO::PARAM_STR);
		$select_another_data->execute();
		$count_another_data = 0;
		while($row = $select_another_data->fetch()){
			$another_ring_size = $row["ring_size"];
			$another_fixed_ring_size = $row["fixed_ring_size"];
			// 小数点のある計算はそもそもが問題が起こり得てしまう
			// BC Mathを使用して計算をする必要がある
			// $another_ring_size_changed = $another_fixed_ring_size - $another_ring_size;
			$another_ring_size_changed = bcsub($another_fixed_ring_size, $another_ring_size, 1);
			// 0は変更なし, +0.1～+0.5は+0.5, +0.6～+1.0は+1, +1.1～は+1.5以上
			if($another_ring_size_changed > 1){
				$size_changed_key = 1;
			} else if($another_ring_size_changed > 0.5 && $another_ring_size_changed <= 1){
				$size_changed_key = 2;
			} else if($another_ring_size_changed > 0 && $another_ring_size_changed <= 0.5){
				$size_changed_key = 3;
			} else if($another_ring_size_changed == 0){
				$size_changed_key = 4;
			} else if($another_ring_size_changed < 0 && $another_ring_size_changed >= -0.5){
				$size_changed_key = 5;
			} else if($another_ring_size_changed < -0.5 && $another_ring_size_changed >= -1){
				$size_changed_key = 6;
			} else if($another_ring_size_changed < -1){
				$size_changed_key = 7;
			} else {
				continue;
			}
			$another_data_list[$size_changed_key]++;

			$count_another_data++;
		}
		if($count_another_data > 3){
			// 同じグループの集計が3件以下の場合はグラフ表示をせずに「表示されない」テキストを表示する
			$graph_flag = true;
		}
	}
} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error} | {$person_log}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

$action_flag = false;
$action_text = "";
if(isset($_SESSION["details"]["action"])){
	$action_flag = true;
	$action_text = $_SESSION["details"]["action"];
	unset($_SESSION["details"]["action"]);
}

if($matrix_flag){
	// 集計を出す
	$item_count = count($another_data_list);
	$another_data_values_json = json_encode($another_data_list);

	$item1_count = $another_data_list[1];
	$item2_count = $another_data_list[2];
	$item3_count = $another_data_list[3];
	$item4_count = $another_data_list[4];
	$item5_count = $another_data_list[5];
	$item6_count = $another_data_list[6];
	$item7_count = $another_data_list[7];

	$item_total = $item1_count + $item2_count + $item3_count + $item4_count + $item5_count + $item6_count + $item7_count;
	if($item_total != 0){
		$item1_percent = round(($item1_count / $item_total * 100),1);
		$item2_percent = round(($item2_count / $item_total * 100),1);
		$item3_percent = round(($item3_count / $item_total * 100),1);
		$item4_percent = round(($item4_count / $item_total * 100),1);
		$item5_percent = round(($item5_count / $item_total * 100),1);
		$item6_percent = round(($item6_count / $item_total * 100),1);
		$item7_percent = round(($item7_count / $item_total * 100),1);

		$item1_text = "{$item1_percent}%".graph_item_legend_list[0];
		$item2_text = "{$item2_percent}%".graph_item_legend_list[1];
		$item3_text = "{$item3_percent}%".graph_item_legend_list[2];
		$item4_text = "{$item4_percent}%".graph_item_legend_list[3];
		$item5_text = "{$item5_percent}%".graph_item_legend_list[4];
		$item6_text = "{$item6_percent}%".graph_item_legend_list[5];
		$item7_text = "{$item7_percent}%".graph_item_legend_list[6];
	} else {
		$item1_percent = 0;
		$item2_percent = 0;
		$item3_percent = 0;
		$item4_percent = 0;
		$item5_percent = 0;
		$item6_percent = 0;
		$item7_percent = 0;

		$item1_text = "{$item1_percent}%".graph_item_legend_list[0];
		$item2_text = "{$item2_percent}%".graph_item_legend_list[1];
		$item3_text = "{$item3_percent}%".graph_item_legend_list[2];
		$item4_text = "{$item4_percent}%".graph_item_legend_list[3];
		$item5_text = "{$item5_percent}%".graph_item_legend_list[4];
		$item6_text = "{$item6_percent}%".graph_item_legend_list[5];
		$item7_text = "{$item7_percent}%".graph_item_legend_list[6];
	}

	$matrix = "";
	$matrix .= "<tr><td class=\"noborder\"></td><td class=\"noborder2\"></td><td id=\"matrix_user_type2\" colspan=\"5\">むくみ率</td></tr>";
	for($i=0;$i<6;$i++){
		for($j=0;$j<6;$j++){
			if($j === 0){
				// 1列目
				// フィット率をつける
				$matrix .= "<tr>";
				switch($i){
					case 0:
					$matrix .= "<td class=\"noborder\"></td>";
					$matrix .= "<td class=\"noborder2\"></td>";
					break;
					case 1:
					$matrix .= "<td id=\"matrix_user_type1\" rowspan=\"5\"><span class=\"vertical\">リングフィット率</span></td>";
					$user_type1_min = "";
					$user_type1_max = user_type1_condition_list[0] - 1;
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type1_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type1_max}</span></td>";
					break;
					case 2:
					$user_type1_min = user_type1_condition_list[0];
					$user_type1_max = user_type1_condition_list[1] - 1;
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type1_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type1_max}</span></td>";
					break;
					case 3:
					$user_type1_min = user_type1_condition_list[1];
					$user_type1_max = user_type1_condition_list[2] - 1;
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type1_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type1_max}</span></td>";
					break;
					case 4:
					$user_type1_min = user_type1_condition_list[2];
					$user_type1_max = user_type1_condition_list[3] - 1;
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type1_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type1_max}</span></td>";
					break;
					case 5:
					$user_type1_min = user_type1_condition_list[3];
					$user_type1_max = "";
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type1_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type1_max}</span></td>";
					break;
					default:
					$matrix .= "<td></td>";
					break;
				}
			} else if($i === 0){
				// 1行目
				// むくみ率をつける
				switch($j){
					case 0:
					// $j === 0 はフィット率でつけている
					break;
					case 1:
					$user_type2_min = "";
					$user_type2_max = user_type2_condition_list[0] - 1;
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type2_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type2_max}</span></td>";
					break;
					case 2:
					$user_type2_min = user_type2_condition_list[0];
					$user_type2_max = user_type2_condition_list[1] - 1;
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type2_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type2_max}</span></td>";
					break;
					case 3:
					$user_type2_min = user_type2_condition_list[1];
					$user_type2_max = user_type2_condition_list[2] - 1;
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type2_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type2_max}</span></td>";
					break;
					case 4:
					$user_type2_min = user_type2_condition_list[2];
					$user_type2_max = user_type2_condition_list[3] - 1;
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type2_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type2_max}</span></td>";
					break;
					case 5:
					$user_type2_min = user_type2_condition_list[3];
					$user_type2_max = "";
					$matrix .= "<td class=\"midashi\"><span class=\"matrix_spans\">{$user_type2_min}</span><span class=\"matrix_spans\">-</span><span class=\"matrix_spans\">{$user_type2_max}</span></td>";
					break;
					default:
					$matrix .= "<td></td>";
					break;
				}
			} else {
				if($user_type1 == $i && $user_type2 == $j){
					// 診断結果
					$matrix .= "<td>★</td>";
				} else {
					$matrix .= "<td></td>";
				}
			}

			if($j === 5){
				$matrix .= "</tr>";
			}
		}
		$matrix .= "</tr>";
	}
}

$json_pair_array = json_encode($pair_array);
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="../img/favicon.ico">
<link rel="apple-touch-icon" href="../img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="../js/jquery.searcher.js"></script>
<link href="../c3-0.7.18/c3.css" rel="stylesheet">
<script src="../d3/d3.min.js"></script>
<script src="../c3-0.7.18/c3.min.js"></script>
<script src="../js/script.js?v=<?=$date?>"></script>
<link href="../css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<link href="./css/style.css?v=<?=$date?>" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
const pair_list = <?=$json_pair_array?>;
var pie = null;
function select_person(e){
	let post_data = {
		"url":"details.php",
		"data":{"user_id":e}
	};
	data_submit(post_data);
}
function edit_person(e){
	let post_data = {
		"url":"edit.php",
		"data":{"user_id":e}
	};
	data_submit(post_data);
}
function determine(e){
	let post_data = {
		"url":"determine.php",
		"data":{"user_id":e}
	};
	data_submit(post_data);
}
function cancel_determine(e){
	let post_data = {
		"url":"cancel_determine.php",
		"data":{"user_id":e}
	};
	data_submit(post_data);
}
function create_pair(e){
	let post_data = {
		"url":"create_new_account.php",
		"data":{"user_id":e}
	};
	data_submit(post_data);
}
function select_pair(e){
	let pair_data = pair_list[e];
	let pair_name = pair_data.name;
	let pair_mail = pair_data.mail;

	let pair_name_elm = document.getElementById("pair_name");
	let pair_mail_elm = document.getElementById("pair_mail");

	pair_name_elm.innerText = pair_name;
	pair_mail_elm.innerText = pair_mail;

	let pair_id_elm = document.getElementById("pair_id");
	pair_id_elm.value = e;

	popup("pair_confirm");
}
function register_pair(){
	let pair_id_elm = document.getElementById("pair_id");
	pair_id = pair_id_elm.value;

	let post_data = {
		"url":"register_pair.php",
		"data":{"user_id":'<?=$user_id?>',"pair_id":pair_id}
	};
	data_submit(post_data);
}
function cancel_pair(e){
	let post_data = {
		"url":"cancel_pair.php",
		"data":{"user_id":e}
	};
	data_submit(post_data);
}
function delete_user(e){
	let post_data = {
		"url":"delete_user.php",
		"data":{"user_id":e}
	};
	data_submit(post_data);
}

function tab_select(e){
	let tabs = document.querySelectorAll(".tab_select_button");
	let tabs_length = tabs.length;
	for(let i=0;i<tabs_length;i++){
		let tab_elm = tabs[i];
		tab_elm.classList.remove("tab_selected");
	}

	let selected_tab_label = document.getElementById("tab_select_button_"+e);
	selected_tab_label.classList.add("tab_selected");

	// radio + divでやってるからクリックイベント発生時は要素が表示されていない
	// pie のリフレッシュやサイズ変更が不可能な状態
	// 事前にチャートを囲う要素が表示されている必要がある
	$("#tab_select_radio_"+e).prop('checked', true);

	if(e === 3){
		if(pie !== null){
			pie.flush();
		}
	}
}

function password_reset(){
	let post_data = {
		"url":"password_reset.php",
		"data":{"user_id":'<?=$user_id?>'}
	};
	data_submit(post_data);
}

function download(){
	let post_url = "./download_data.php";

	let form = document.createElement("form");
	form.setAttribute("action", post_url);
	form.setAttribute("method", "post");
	form.setAttribute("target", "download");
	form.style.display = "none";
	document.body.appendChild(form);

	let input = document.createElement('input');
	input.setAttribute('type', 'hidden');
	input.setAttribute('name', 'user_id');
	input.setAttribute('value', '<?=$user_id?>');
	form.appendChild(input);

	// submit
	form.submit();
}

function graph(){
	console.log("graph");
	<?php
	if($graph_flag && $matrix_flag){
	?>
	var values = <?php echo $another_data_values_json; ?>;
	var columns = [];
	var names = {};
	let sum = 0;

	for(let i=1;i<=values.length;i++){
		let value = values[i];
		let data_num = "data" + i;
		let data_name = "データ" + i;
		let column = [data_num, value];
		columns.push(column);
		names[data_num] = data_name;
		sum += value;
	}

	pie = c3.generate({
		bindto: '#pie',
		data: {
			columns: [
				<?php
				for($i=1;$i<=$item_count;$i++){
					$column = $another_data_list[$i];
					$num = $i;

					echo "['data{$num}', {$column}],\n";
				}
				?>
			],
			names: {
				<?php
				for($i=0;$i<$item_count;$i++){
					$item_name = graph_item_list[$i];
					$num = $i + 1;

					echo "data{$num}: \"{$item_name}\",\n";
				}
				?>
			},
			type : 'pie',
			order : null,
			/*
			colors: {
				data1: '#ff0000',
				data2: '#00ff00',
				data3: '#0000ff'
			},

			onclick: function (d, i) { console.log("onclick", d, i); },
			onmouseover: function (d, i) { console.log("onmouseover", d, i); },
			onmouseout: function (d, i) { console.log("onmouseout", d, i); }
			*/
		},
		legend: {
			//position: 'right',
			item: {
				onclick: function(data){
					// do not toggle
				}
			}
		},
	});
	<?php
	}
	?>
}

window.onload = function(){
	tab_select(1);
	$("#pair_list").searcher({
		inputSelector: "#pair_search"
	});
	graph();
	<?php
	if($action_flag){
	?>
	popup('action');
	<?php
	}
	?>
}
</script>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>

	<div id="main">
		<div class="details_flex_box">
			<a href="./list.php?r=Y" class="link_text">一覧に戻る</a>
			<span class="">
				<label for="tab_select_radio_1" id="tab_select_button_1" class="tab_select_button" onclick="tab_select(1)">情報</label>
				<label for="tab_select_radio_2" id="tab_select_button_2" class="tab_select_button" onclick="tab_select(2)">記録</label>
				<label for="tab_select_radio_3" id="tab_select_button_3" class="tab_select_button" onclick="tab_select(3)">集計</label>
			</span>
		</div>

		<input type="radio" id="tab_select_radio_1" name="tab_select_radio" class="tab_select_radio nodisp" checked>
		<div id="details_tab_1" class="details_tab nodisp">
			<div class="details_flex_box">
				<span></span>
				<span class="">更新日：<?=$updated?></span>
			</div>
			<div class="content_box">
				<table class="details_table">
					<tr>
						<td class="create_table_head" colspan="4">ユーザー情報</td>
					</tr>
					<tr>
						<td class="account_table_item">ステータス</td>
						<td class="account_table_content" colspan="3"><?=$status?></td>
					</tr>
					<tr>
						<td class="account_table_item">名前</td>
						<td class="account_table_content" colspan="3"><span class="display_user_name"><?=$name1?></span><span class="display_user_name"><?=$name2?></span></td>
					</tr>
					<!--
					<tr>
						<td class="account_table_item">かな</td>
						<td class="account_table_content"><span class="display_user_name"><?=$kana1?></span><span class="display_user_name"><?=$kana2?></span></td>
					</tr>
					-->
					<tr>
						<td class="account_table_item">性別</td>
						<td class="account_table_content" colspan="3"><?=$gender?></td>
					</tr>
					<tr>
						<td class="account_table_item">メールアドレス</td>
						<td class="account_table_content" colspan="3"><?=$mail?></td>
					</tr>
					<tr>
						<td class="account_table_item">作成日</td>
						<td class="account_table_content" colspan="3"><?=$created?></td>
					</tr>
					<tr>
						<td class="account_table_item">対応店舗</td>
						<td class="account_table_content" colspan="3"><?=$shop?></td>
					</tr>

					<?php
					if($not_fixed_flag){
					?>
					<tr>
						<td class="account_table_item">指輪の形状</td>
						<td class="account_table_content" colspan="3"><?=$ring_type?></td>
					</tr>
					<tr>
						<td class="account_table_item">指輪の素材</td>
						<td class="account_table_content" colspan="3"><?=$ring_material?></td>
					</tr>
					<tr>
						<td class="account_table_item">指輪のサイズ</td>
						<td class="account_table_content" colspan="3"><?=$ring_size?></td>
					</tr>
					<tr>
						<td class="account_table_item">指輪の幅</td>
						<td class="account_table_content" colspan="3"><?=$ring_width?></td>
					</tr>
					<tr>
						<td class="account_table_item">指輪の厚み</td>
						<td class="account_table_content" colspan="3"><?=$ring_thickness?></td>
					</tr>
					<tr>
						<td class="account_table_item">備考</td>
						<td class="account_table_content" colspan="3"><?=$remarks?></td>
					</tr>
					<?php
					} else {
					?>

					<tr>
						<td class="account_table_item">指輪の形状</td>
						<td class="account_table_content"><?=$ring_type?></td>
						<td class="account_table_item"><i class="fa-solid fa-right-long"></i></td>
						<td class="account_table_content"><?=$fixed_ring_type?></td>
					</tr>
					<tr>
						<td class="account_table_item">指輪の素材</td>
						<td class="account_table_content"><?=$ring_material?></td>
						<td class="account_table_item"><i class="fa-solid fa-right-long"></i></td>
						<td class="account_table_content"><?=$fixed_ring_material?></td>
					</tr>
					<tr>
						<td class="account_table_item">指輪のサイズ</td>
						<td class="account_table_content"><?=$ring_size?></td>
						<td class="account_table_item"><i class="fa-solid fa-right-long"></i></td>
						<td class="account_table_content"><?=$fixed_ring_size?></td>
					</tr>
					<tr>
						<td class="account_table_item">指輪の幅</td>
						<td class="account_table_content"><?=$ring_width?></td>
						<td class="account_table_item"><i class="fa-solid fa-right-long"></i></td>
						<td class="account_table_content"><?=$fixed_ring_width?></td>
					</tr>
					<tr>
						<td class="account_table_item">指輪の厚み</td>
						<td class="account_table_content"><?=$ring_thickness?></td>
						<td class="account_table_item"><i class="fa-solid fa-right-long"></i></td>
						<td class="account_table_content"><?=$fixed_ring_thickness?></td>
					</tr>
					<tr>
						<td class="account_table_item">備考</td>
						<td class="account_table_content" colspan="3"><?=$remarks?></td>
					</tr>
					<tr>
						<td class="account_table_item">確定日</td>
						<td class="account_table_content" colspan="3"><?=$fixed_date?></td>
					</tr>
					<?php
					}
					?>

					<tr>
						<td class="account_table_item">利き手</td>
						<td class="account_table_content" colspan="3"><?=$handedness?></td>
					</tr>
					<tr>
						<td class="account_table_item">薬指の節</td>
						<td class="account_table_content" colspan="3"><?=$joint?></td>
					</tr>
					<!--
					<tr>
						<td class="account_table_item">仕事で指輪</td>
						<td class="account_table_content" colspan="3"><?=$working?></td>
					</tr>
					-->
					<tr>
						<td class="account_table_item">外す頻度</td>
						<td class="account_table_content" colspan="3"><?=$frequency?></td>
					</tr>
					<tr>
						<td class="account_table_item">お酒</td>
						<td class="account_table_content" colspan="3"><?=$alcohol?></td>
					</tr>
					<tr>
						<td class="account_table_item">フィット感の好み</td>
						<td class="account_table_content" colspan="3"><?=$taste?></td>
					</tr>
					<?= $table_pair_info ?>
				</table>
			</div>
			<div class="details_flex_box">
				<span><?=$cancel_pair_button?></span>
				<span>
					<span class="button_blue" onclick="popup('password_reset')">パスワード再発行</span>
					<?php
					if($not_fixed_flag){
					?>
					<span class="button_blue button_margin" onclick="edit_person('<?=$user_id?>')">情報を編集する</span>
					<span class="button_blue button_margin" onclick="determine('<?=$user_id?>')">指輪を確定する</span>
					<?php
					} else {
					?>
					<span class="button_red button_margin" onclick="popup('cancel_determine')">確定を取り消す</span>

					<div id="cancel_determine" class="popup-main">
						<p>指輪の確定情報を取り消しますか？</p>
						<p class="popup-button-box"><span class="popup-close button_red" onclick="cancel_determine('<?=$user_id?>')">取り消す</span><span class="popup-close button">キャンセル</span></p>
					</div>
					<?php
					}
					?>
				</span>
			</div>
		</div>

		<input type="radio" id="tab_select_radio_2" name="tab_select_radio" class="tab_select_radio nodisp">
		<div id="details_tab_2" class="details_tab nodisp">
			<div class="content_box">
				<?php
				if(!empty($report_html)){
				?>
				<div class="details_flex_box">
					<span></span>
					<span class="button_blue" onclick="download()">記録ダウンロード</span>
				</div>
				<?php
					echo $report_html;
				} else {
				?>
				<p>記録がありません。</p>
				<?php
				}
				?>
			</div>
		</div>

		<input type="radio" id="tab_select_radio_3" name="tab_select_radio" class="tab_select_radio nodisp">
		<div id="details_tab_3" class="details_tab nodisp">
			<div class="content_box">
				<?php
				if($matrix_flag){
				?>
				<div id="fit_text_box">
					<div class="fit_text_block">
						<table class="fit_text_table">
							<tr class="noborder">
								<td class="fit_text_head">リングフィット率</td>
							</tr>
							<tr class="noborder">
								<td class="value_display_body">
									<span class="type_value_display"><?=$user_type1_value?><span class="percent">%</span></span>
								</td>
							</tr>
						</table>
					</div>
					<div class="fit_text_block">
						<table class="fit_text_table">
							<tr class="noborder">
								<td class="fit_text_head">指のむくみ率</td>
							</tr>
							<tr class="noborder">
								<td class="value_display_body">
									<span class="type_value_display"><?=$user_type2_value?><span class="percent">%</span></span>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div id="user_type_matrix_box" class="block_margin">
					<table id="user_type_matrix">
						<?=$matrix?>
					</table>
				</div>
				<div class="separation">同タイプの方のサイズ変更データ</div>
				<?php
				if($graph_flag){
				?>
				<div id="pie" class="block_margin"></div>
				<div id="pie_text_list">
					<ul>
						<li><?=$item1_text?></li>
						<li><?=$item2_text?></li>
						<li><?=$item3_text?></li>
						<li><?=$item4_text?></li>
						<li><?=$item5_text?></li>
						<li><?=$item6_text?></li>
						<li><?=$item7_text?></li>
					</ul>
				</div>
				<?php
				} else {
				?>
				<p>現時点で、お客様と同タイプの方のデータが少ないため、過去のお客様データは表示されません。</p>
				<?php
				}
				?>
				<?php
				} else {
				?>
				<p>データが集まり次第開放予定です。</p>
				<?php
				}
				?>
			</div>
		</div>

		<div class="details_flex_box">
			<a href="./list.php?r=Y" class="link_text">一覧に戻る</a>
			<span>
				<span class="button_red" onclick="popup('delete_user')">削除</span>
			</span>
		</div>
	</div>

	<div id="password_reset" class="popup-main">
		<p>パスワードを再発行しますか？</p>
		<p class="popup-button-box"><span class="popup-close button_blue" onclick="password_reset()">再発行する</span><span class="popup-close button">キャンセル</span></p>
	</div>

	<?php
	if($not_fixed_flag){
	?>

	<?php
	}
	?>

	<?php
	if($action_flag){
	?>
	<div id="action" class="popup-main">
		<p><?=$action_text?></p>
		<p class="popup-button-box"><span class="popup-close button">閉じる</span></p>
	</div>
	<?php
	}
	?>

	<?php
	if(!empty($pair)){
	?>
	<div id="cancel_pair" class="popup-main">
		<p>ペアを解消しますか？</p>
		<p class="popup-button-box"><span class="popup-close button_red" onclick="cancel_pair('<?=$user_id?>')">解消する</span><span class="popup-close button">キャンセル</span></p>
	</div>
	<?php
	} else {
	?>
	<div id="modal-pair" class="modal-main">
		<div id="modal-pair-content" class="modal-content">
			<div class="modal-header">ペアの選択</div>
			<div class="modal-search"><input type="text" id="pair_search"></div>
			<div class="modal-items">
				<table id="pair_list">
					<thead>
						<tr>
							<th>名前</th>
							<th>メールアドレス</th>
						</tr>
					</thead>
					<tbody>
						<?= $pair_list ?>
					</tbody>
				</table>
			</div>
			<div class="modal-action">
				<span></span>
				<span>
					<span class="modal-del">キャンセル</span>
				</span>
			</div>
		</div>
	</div>
	<div id="pair_confirm" class="popup-main">
		<table class="modal-table">
			<tr>
				<td>名前</td>
				<td id="pair_name"></td>
			</tr>
			<tr>
				<td>メールアドレス</td>
				<td id="pair_mail"></td>
			</tr>
		</table>
		<input type="hidden" id="pair_id" name="pair_id" value="">
		<p>上記のアカウントとペアにしますか？</p>
		<p class="popup-button-box"><span class="popup-close button_blue" onclick="register_pair()">ペアにする</span><span class="popup-close button">キャンセル</span></p>
	</div>
	<?php
	}
	?>

	<div id="delete_user" class="popup-main">
		<p>このユーザーを削除しますか？</p>
		<p class="popup-button-box"><span class="popup-close button_red" onclick="delete_user('<?=$user_id?>')">削除する</span><span class="popup-close button">キャンセル</span></p>
	</div>
</body>
</html>
