<?php
// セッションクッキーに httponly 属性を設定
ini_set('session.cookie_httponly', 1);
// セッションクッキーに secure 属性を設定
ini_set('session.cookie_secure', 1);

session_start();

// XSS攻撃を検知し、検知したら実行させない
header("X-XSS-Protection: 1; mode=block");
// クリックジャッキング対策
header('X-FRAME-OPTIONS: DENY');

require_once './include/include.php';

$title = "記録の一覧と閲覧";
$date = new DateTime();
$date = $date->format("YmdHis");

if(isset($_SESSION["details"]["delete"])){
	// 保存した
	$deleted_flag = true;
	unset($_SESSION["details"]["delete"]);
} else {
	$deleted_flag = false;
}

$list_html = "";

try {
	$pdo = DBopen();

	$select_sql = "SELECT * FROM report WHERE user_id = ? AND deleted != 1 ORDER BY report_id DESC";
	$select = $pdo->prepare($select_sql);
	$select->bindValue(1,$_SESSION["user"],PDO::PARAM_STR);
	$select->execute();
	while($row = $select->fetch()){
		$report_id = $row["report_id"];
		$created = $row["created"];
		$report_date = new DateTime($created);
		$report_date = $report_date->format("Y/m/d H:i");

		$list_html .=<<<EOD
		<div class="report_data_item">
			<span onclick="details_post('{$report_id}')">
				{$report_date}
				<span class="list_icon"><i class="fa-solid fa-caret-right"></i></span>
			</span>
		</div>
EOD;
	}

} catch (Exception $e) { // PDOエラーが来ると思われる
	$error = $e->getMessage();
	$log = "error -> {$error}";
	Writelog($log,basename(__FILE__));
	require_once './error.php';
	exit;
}

?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1, maximum-scale=1">
<link rel="icon" href="./img/favicon.ico">
<link rel="apple-touch-icon" href="./img/home_icon2.png">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" integrity="sha512-KfkfwYDsLkIlwQp6LFnl8zNdLGxu9YAA1QvwINks4PhcElQSvqcyVLLD9aMhXd13uQjoXtEKNosOWaZqXgel0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="./js/script.js"></script>
<link href="./css/style.css" rel="stylesheet" type="text/css">
<title><?=$title?></title>
<script>
function details_post(e){
	loading();
	let data = {url:"details.php",data:{report_id:e}};
	data_submit(data);
}
window.onload = function(){
	<?php
	if($deleted_flag){
	?>
	popup("deleted");
	<?php
	}
	?>
}
</script>
</head>
<body>
	<?php
	require_once './header.php';
	?>
	<div id="page_title">
		<?=$title?>
	</div>
	<div id="list_main">
		<?php
		if(!empty($list_html)){
			// 記録がある
			echo $list_html;
		} else {
			// 記録がない
			echo "<div class=\"no_data_text\">記録がありません。</div>";
		}
		?>
	</div>

	<?php
	if($deleted_flag){
	?>
	<div id="deleted" class="popup-main">
		<p>削除しました。</p>
		<p class="popup-button-box"><span class="popup-close button">閉じる</span></p>
	</div>
	<?php
	}
	?>
</body>
</html>
