<?php
// ワークディレクトリを変更する
// 相対パスで書いているファイルを読み込めないため
chdir(__DIR__);

require_once '../include/server_check.php';
require_once '../include/functions.php';
require_once '../include/db.php';
require_once '../include/config.php';

mb_language("Japanese");
mb_internal_encoding("UTF-8");

require_once '../include/mail_data_demand.php';

$user_id = $argv[1];
WriteOnlylog($user_id,basename(__FILE__));
if(isset($argv[2])){
	$test_mail = $argv[2];
} else {
	$test_mail = "";
}


try {
	$pdo = DBopen();

	$select_user_sql = "SELECT * FROM user WHERE user_id = ? AND mail_flag = ''";
	$select_user = $pdo->prepare($select_user_sql);
	$select_user->bindValue(1,$user_id,PDO::PARAM_STR);
	$select_user->execute();
	if($row = $select_user->fetch()){
		$created = $row["created"];
		$fixed_ring_type = $row["fixed_ring_type"];
		$fixed_ring_size = $row["fixed_ring_size"];
		$fixed_ring_width = $row["fixed_ring_width"];
		$fixed_ring_thickness = $row["fixed_ring_thickness"];
		$mail_flag = $row["mail_flag"]; // 1で送信済み
		$mail = $row["mail"];

		$shop = $row["shop"]; // 担当店舗

		$name1 = $row["name1"];
		$name2 = $row["name2"];

		$name = $name1 . $name2;

		$db_date = new DateTime($created);
		$db_date = $db_date->format("Y-m-d");

		$date = new DateTime();
		// 60日間経過したことを確認する
		$date->modify("-60 days");
		$check_date = $date->format("Y-m-d");

		if($mail_flag != 1 && $check_date === $db_date && empty($fixed_ring_type)){
			// メール送信対象である

			// メールを送信する
			if(SERVER_CHECK === 1){
				// 本番
				$to = $mail;
				$from = mail_from;
				$bcc = isset(CRON_SHOP_MAIL_LIST[$shop]) ? CRON_SHOP_MAIL_LIST[$shop] : "hirota@apteq.jp";
			} else {
				// 開発
				if(!empty($test_mail)){
					$to = $test_mail;
				} else {
					$to = "hirota@apteq.jp";
				}
				$from = "test@demo55.jp";
				$bcc = "hirota@apteq.jp";

				$check_bcc = isset(CRON_SHOP_MAIL_LIST[$shop]) ? CRON_SHOP_MAIL_LIST[$shop] : "hirota@apteq.jp";
				WriteOnlylog($check_bcc,basename(__FILE__));
			}

			$headers = [];

			$charset = "UTF-8";
			$headers['MIME-Version'] = "1.0";

			$From_name = "入籍指輪システム";
			//$From_encoded = mb_convert_encoding($From_name, 'UTF-8', 'AUTO'); // mb_encode_mimeheaderに渡す前にUTF-8に変換しなくてはダメ
			$From_address = $from;
			$headers['From'] = mb_encode_mimeheader($From_name, 'UTF-8') ."<". $From_address .">";
			$headers['Bcc'] = $bcc;
			$headers['Content-Type'] = "text/plain; charset=".$charset;
			$headers['Reply-to'] = $From_address;
			$headers['Sender'] = $From_address;
			$headers['Return-Path'] = $From_address;

			//配列から連結させる
			foreach ($headers as $key => $val) {
				$arrheader[] = $key . ': ' . $val;
			}
			$strHeader = implode("\n", $arrheader);

			// テンプレートを置換する
			// タイトル
			$title = MAIL_TITLE;

			// 本文
			// 名前を置換する
			$content = sprintf(MAIL_CONTENT,$name);

			if(!mail($to, $title, $content, $strHeader,"-f {$From_address}")){
				// メールの送信に失敗
				throw new RuntimeException("メール送信に失敗 user_id -> {$user_id} | mail_flag -> {$mail_flag} | db_date -> {$db_date} | fixed_ring_type -> {$fixed_ring_type}");
			}
		} else {
			// メール送信対象ではない
			throw new RuntimeException("メール送信対象ではない user_id -> {$user_id} | mail_flag -> {$mail_flag} | db_date -> {$db_date} | fixed_ring_type -> {$fixed_ring_type}");
		}
	} else {
		throw new RuntimeException("対象者が存在しない user_id -> {$user_id}");
	}

	// フラグを更新する
	$update_user_sql = "UPDATE user SET mail_flag = 1 WHERE user_id = ?";
	$update_user = $pdo->prepare($update_user_sql);
	$update_user->bindValue(1,$user_id,PDO::PARAM_STR);
	$update_user->execute();

} catch(Exception $e){
	$error = $e->getMessage();
	$log = "error -> {$error}";
	WriteOnlylog($log,basename(__FILE__));
}
