<?php
namespace Plugin\Atobaraidotcom4\Service;

use Eccube\Common\EccubeConfig;
use Plugin\Atobaraidotcom4\Repository\ConfigRepository;
use GuzzleHttp\Client;
use Guzzle\Http\Exception\BadResponseException;
use Guzzle\Http\Exception\CurlException;

class AtobaraidotcomRequestService
{
    /**
     * @var eccubeConfig
     */
    protected $eccubeConfig;

    /**
     * @var Config
     */
    protected $Config;

    public function __construct(
        EccubeConfig $eccubeConfig,
        ConfigRepository $configRepository
    ) {
        $this->eccubeConfig = $eccubeConfig;

        $this->Config = $configRepository->get();
    }

    function sendRequest($endpoint, $arrRequests = array()) {
        
        $body = http_build_query($arrRequests);

        if (PHP_OS == "WIN32" || PHP_OS == "WINNT" || !function_exists("curl_init")) {

            $header = array('Content-Type: application/x-www-form-urlencoded; charset=UTF-8', 'Content-Length: '.strlen($body));
            $options = array('http' => array(
                'method' => 'POST',
                'header'  => implode("\r\n", $header),
                'content' => $body,
            ));

            $req = file_get_contents($endpoint, false, stream_context_create($options));

        } else {

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $endpoint);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
            curl_setopt($ch, CURLOPT_POST, TRUE);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded; charset=UTF-8', 'Content-Length: '.strlen($body)));

            $req = curl_exec($ch);
            curl_close($ch);
        }

        return $req;

    }
    function xml2arr($xml_obj) {
        $response_arr["resultdeliv"] = array();
                foreach ($xml_obj->results->result as $value) {
                    array_push( $response_arr["resultdeliv"] , array(   'delivId' => (string) $value->delivId,
                                                                        'name' => (string) $value->name, ));
                }
        $response_arr = array();
        if ($xml_obj->status == "success") {
            $response_arr["status"] = "success";
            $response_arr["orderId"] = (string) $xml_obj->orderId;
            $response_arr["systemOrderId"] = (string) $xml_obj->systemOrderId;
            $response_arr["messages"] = array();
            $response_arr["orderStatus"] = (string) $xml_obj->orderStatus;
            $response_arr["orderStatusCd"] = (string) $xml_obj->orderStatus->attributes()->{'cd'};
            foreach ($xml_obj->results->result as $value) {
                $response_arr["result"] = array(   'orderId' => (string) $value->orderId,
                                                    'entOrderId' => (string) $value->entOrderId,
                                                    'orderStatus' => (string) $value->orderStatus->attributes()->{'cd'},
                                                    'reason' => (string) $value->reason,
                                                    'cancelStatus' => (string) $value->cancelStatus,
                                                    'error' => (string) $value->error,
                                                    'errorCd' => (string) $value->error->attributes()->{'cd'},);
            }
            $response_arr["resultdeliv"] = array();
            foreach ($xml_obj->results->result as $value) {
                array_push( $response_arr["resultdeliv"] , array(   'delivId' => (string) $value->delivId,
                                                                    'name' => (string) $value->name, ));
            }
            // Regist tracking number API
            $response_arr["orderId"] = (string) $xml_obj->orderId;
            $response_arr["delivId"] = (string) $xml_obj->delivId;
            $response_arr["delivName"] = (string) $xml_obj->delivName->attributes()->{'name'};
            $response_arr["journalNum"] = (string) $xml_obj->journalNum;
            
        } else {
            $response_arr["status"] = "error";
            $response_arr["orderId"] = (string) $xml_obj->orderId;
            foreach ($xml_obj->messages->message as $value) {
                $cd = (string) $value->attributes()->{'cd'};
                $message = (string) $value;
                $response_arr["messages"][$cd] = $message;
            }
        }
        return $response_arr;
    }

    function get_error_code() {
        $error_code_table = array(  "E00101" => array(  "FrontendMess" => "現在のお支払方法は使用不可となっております。別のお支払方法をお選びください。",
                                                        "DetailMess" => "リクエスト元のIPアドレスとAPIユーザーIDの関連性誤り"),
                                    "E00102" => array(  "FrontendMess" => "現在のお支払方法は使用不可となっております。別のお支払方法をお選びください。",
                                                        "DetailMess" => "事業者ID、サイトID、APIユーザーIDの関連性誤り"),
                                    "E00201" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "必須項目に値が設定されていない"),
                                    "E00202" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "入力形式不正（属性誤り）・　入力形式不正（文字数誤り）"),
                                    "E00203" => array(  "FrontendMess" => "現在、後払い.com支払い方法は使用不可です。",
                                                        "DetailMess" => "商品情報の「購入品目」「数量」「単価」のセットのうち、いずれかの入力が誤っている"),
                                    "E00204" => array(  "FrontendMess" => "現在、後払い.com支払い方法は使用不可です。",
                                                        "DetailMess" => "注文日、役務提供予定日が、日付として妥当な形式でない"),
                                    "E00301" => array(  "FrontendMess" => "メールアドレスを入力してください。",
                                                        "DetailMess" => "メールアドレスの登録が必須のサイトで、メールアドレスが未指定。"),
                                    "E00302" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "商品情報が1件も存在していない"),
                                    "E00303" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "各商品の「単価×数量」、送料、手数料の合計が、請求金額合計と一致しない"),
                                    "E00304" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "役務提供予定日に過去日が入力された"),
                                    "E00305" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "役務対象ではないサイトで役務提供予定日が入力された"),
                                    "E00901" => array(  "FrontendMess" => "現在、後払い.com支払い方法は使用不可です。",
                                                        "DetailMess" => "システム上で障害が発生した場合"),
                                    "E00902" => array(  "FrontendMess" => "現在、後払い.com支払い方法は使用不可です。",
                                                        "DetailMess" => "システムメンテナンス中の場合"),
                                    "E01101" => array(  "FrontendMess" => "不正なリクエストと判定されました。サポートセンターまでお問合せください。",
                                                        "DetailMess" => "リクエスト元のIPアドレスとAPIユーザーIDの関連性誤り"),
                                    "E01102" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "事業者ID、APIユーザーIDの関連性誤り"),
                                    "E01201" => array(  "FrontendMess" => "注文IDの指定は必須です",
                                                        "DetailMess" => "注文IDの指定が0件"),
                                    "E01202" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "指定注文IDがすべて不正"),
                                    "E01901" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "システム上で障害が発生した場合"),
                                    "E01902" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "システムメンテナンス中の場合"),
                                    "E05101" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "リクエスト元のIPアドレスとAPIユーザーIDの関連性誤り"),
                                    "E05102" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "事業者ID、APIユーザーIDの関連性誤り"),
                                    "E05201" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "注文番号の指定が0件"),
                                    "E05202" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "指定注文IDがすべて不正"),
                                    "E05301" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "指定注文IDがすべてキャンセル不可※"),
                                    "E05901" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "システム上で障害が発生した場合"),
                                    "E05902" => array(  "FrontendMess" => "",
                                                        "DetailMess" => "システムメンテナンス中の場合"),
                                );
        return $error_code_table;
    }
}
?>
