<?php

namespace Plugin\ApgSimpleCalendar\DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200611120900 extends AbstractMigration
{
    const SAMPLE_HOLIDAY = [
        '2020-01-01' => '元日',
        '2020-01-13' => '成人の日',
        '2020-02-11' => '建国記念の日',
        '2020-02-23' => '天皇誕生日',
        '2020-02-24' => '休日',
        '2020-03-20' => '春分の日',
        '2020-04-29' => '昭和の日',
        '2020-05-03' => '憲法記念日',
        '2020-05-04' => 'みどりの日',
        '2020-05-05' => 'こどもの日',
        '2020-05-06' => '休日',
        '2020-07-23' => '海の日',
        '2020-07-24' => 'スポーツの日',
        '2020-08-10' => '山の日',
        '2020-09-21' => '敬老の日',
        '2020-09-22' => '秋分の日',
        '2020-11-03' => '文化の日',
        '2020-11-23' => '勤労感謝の日',
        '2021-01-01' => '元日',
        '2021-01-11' => '成人の日',
        '2021-02-11' => '建国記念の日',
        '2021-02-23' => '天皇誕生日',
        '2021-03-20' => '春分の日',
        '2021-04-29' => '昭和の日',
        '2021-05-03' => '憲法記念日',
        '2021-05-04' => 'みどりの日',
        '2021-05-05' => 'こどもの日',
        '2021-07-19' => '海の日',
        '2021-08-11' => '山の日',
        '2021-09-20' => '敬老の日',
        '2021-09-23' => '秋分の日',
        '2021-10-11' => 'スポーツの日',
        '2021-11-03' => '文化の日',
        '2021-11-23' => '勤労感謝の日',
    ];

    public function up(Schema $schema): void
    {
        $config = $this->connection->fetchAll('select * from plg_apg_simple_calendar_config where id = 1');
        if (count($config) === 0) {
            $sql = "insert into plg_apg_simple_calendar_config (id, regular_holidays)  values (1, '6,7');";
            $this->addSql($sql);
        }


        $holidays = $this->connection->fetchAll('select * from plg_apg_simple_calendar_holidays');
        if (count($holidays) === 0) {
            $count = 0;
            foreach (self::SAMPLE_HOLIDAY as $targetDate => $name) {
                $count++;
                $sql = "insert into plg_apg_simple_calendar_holidays (id, name, target_date)  values ({$count}, '{$name}', '{$targetDate}');";
                $this->addSql($sql);
            }
            if ($this->platform->getName() == 'postgresql') {
                // シーケンスをセット
                $sql = "select setval('plg_apg_simple_calendar_holidays_id_seq',(select max(id) from plg_apg_simple_calendar_holidays));";
                $this->addSql($sql);
            }
        }
    }

    public function down(Schema $schema): void
    {
        $this->addSql('delete from plg_apg_simple_calendar_holidays');
    }
}
