<?php

namespace Plugin\AdminOrderPlus\Form\Extension;

use Eccube\Form\Type\Admin\SearchOrderType;
use Eccube\Entity\Shipping;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

/**
 * Class SearchOrderTypePlusExtension
 * @FormExtension
 */
class SearchOrderTypePlusExtension extends AbstractTypeExtension
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('shipping_schedule_date_start', DateType::class, array(
                'label' => '発送予定日(開始)',
                'required' => false,
                'input' => 'datetime',
                'widget' => 'single_text',
                'format' => 'yyyy-MM-dd',
                'placeholder' => ['year' => '----', 'month' => '--', 'day' => '--'],
                'attr' => [
                    'class' => 'datetimepicker-input',
                    'data-target' => '#admin_search_order_shipping_schedule_date_start',
                    'data-toggle' => 'datetimepicker',
                ],

            ))
            ->add('shipping_schedule_date_end', DateType::class, array(
                'label' => '発送予定日(終了)',
                'required' => false,
                'input' => 'datetime',
                'widget' => 'single_text',
                'format' => 'yyyy-MM-dd',
                'placeholder' => ['year' => '----', 'month' => '--', 'day' => '--'],
                'attr' => [
                    'class' => 'datetimepicker-input',
                    'data-target' => '#admin_search_order_shipping_schedule_date_start',
                    'data-toggle' => 'datetimepicker',
                ],
            ));
    }

    public function getExtendedType()
    {
        return SearchOrderType::class;
    }
}