<?php

namespace Customize\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Eccube\Entity\BaseInfo;
use Eccube\Entity\Customer;
use Eccube\Entity\MailHistory;
use Eccube\Repository\BaseInfoRepository;
use Eccube\Repository\CustomerRepository;
use Eccube\Repository\MailHistoryRepository;
use Plugin\ApteqPeriodical\Entity\Periodical;
use Plugin\ApteqPeriodical\Entity\PeriodicalDetail;
use Plugin\ApteqPeriodical\Repository\PeriodicalRepository;
use Plugin\ApteqPeriodical\Repository\PeriodicalDetailRepository;
use Eccube\Controller\AbstractController;

class MypagePeriodicalPauseController extends AbstractController
{
    /**
     * @var CustomerRepository
     */
    protected $customerRepository;

    /**
     * @var BaseInfoRepository
     */
    protected $baseInfoRepository;
    
    /**
     * @var \Swift_Mailer
     */
    protected $mailer;

    public function __construct(
        CustomerRepository $customerRepository,
        BaseInfoRepository $baseInfoRepository, 
        \Swift_Mailer $mailer
    ) {
        $this->customerRepository = $customerRepository;
        $this->baseInfoRepository = $baseInfoRepository;
        $this->mailer = $mailer;
    }
    /**
     * @Method("GET")
     * @Route("/mypage/periodical_pause"), name="mypage_periodical_pause"
     * @Template("Mypage/periodical_pause.twig")
     */
    public function periodicalPause(Request $request)
    {   
        $customer_id = null;
        $customer_id = $request->query->get('cid');
        
        if (!($customer_id)) {
            return [
                'name' => 'periodical_pause',
                'Periodicals' => null,
                'customer_id' => null,
                'pause_end' => false,
            ];    
        }
        $mode = $request->query->get('mode');
        
        $Periodicals = $this->entityManager->createQueryBuilder() 
            ->select("p")
            ->from("\Plugin\ApteqPeriodical\Entity\Periodical", "p")
            ->where('p.customer_id = :customer_id')
            ->setParameter('customer_id', $customer_id)
            ->andWhere('p.periodical_status = 1')
            ->OrderBy('p.id', 'DESC')
            ->getQuery()
            ->getResult();
        
        if ($Periodicals) {
            
            switch ($mode) {
                case 'pause_confirm':
                    log_info('定期購入休止手続き処理開始', ['customer_id' => $customer_id]);

                    $BaseInfo = $this->baseInfoRepository->get();

                    // 以下メール本文 「\n」は改行文字  
                    //$body = date('Y年m月d日H時i分').'  定期購入休止手続きを受け付けました。'."\n"."\n";
                    //$body= '【会員ＩＤ】 '. $Periodicals[0]->getCustomerId()."\n";
                    $body = $Periodicals[0]->getName01().' '.$Periodicals[0]->getName02().'　様'."\n";
                    $body .= '
        マメビオショップでございます。
        定期購入の休止を受け付けました。
        マメビオシリーズをご愛用いただきましてまことに有り難うございました。

        ************************************************
         定期購買　受注詳細
        ************************************************'."\n";
                    $body .= '            定期課金額：'.$Periodicals[0]->getPaymentTotal().'円.'."\n";
                    $body .= '            商品名：'.$Periodicals[0]->getClassCategoryName01().$Periodicals[0]->getClassCategoryName02()."\n";
                    $body .= '            休止受付日時：'.date('Y年m月d日')."\n";
                    $body .= '
        休止処理が完了致しましたら、改めてメールにてご連絡をさせて頂きます。
        ご不明な点等ございましたら、メール又はお電話(0120-160-312)にてご連絡頂けますと幸いです。

        ☆…☆…☆…☆　腸からシアワセに。 ☆…☆…☆…☆

        株式会社 プロバイオテック
        〒186-0002
        東京都国立市東1-16-20
        フリーダイアル:0120-160-312
        マメビオショップ
        URL:http://www.probiotech.jp/
        メール:info@probiotech.jp

        ☆…☆…☆…☆…☆…☆…☆…☆…☆…☆…☆…☆…☆';

                    $message = (new \Swift_Message())
                        ->setSubject('['.$BaseInfo->getShopName().'] '.'定期購入休止手続きを受け付けました')
                        ->setFrom([$BaseInfo->getEmail01() => $BaseInfo->getShopName()])
                        ->setTo($Periodicals[0]->getEmail())
                        ->setBcc($BaseInfo->getEmail01())
                        ->setReplyTo($BaseInfo->getEmail03())
                        ->setReturnPath($BaseInfo->getEmail04())
                        ->setBody($body);

                    $count = $this->mailer->send($message);

                    log_info('定期購入休止手続き処理終了', ['customer_id' => $customer_id]);
                    
                    return [
                        'name' => 'periodical_pause',
                        'Periodicals' => $Periodicals,
                        'customer_id' => $customer_id,
                        'pause_end' => true,
                    ];
                    
                default:
                    return [
                        'name' => 'periodical_pause',
                        'Periodicals' => $Periodicals,
                        'customer_id' => $customer_id,
                        'pause_end' => false,
                    ];                    
            }
        }
        
        return [
            'name' => 'periodical_pause',
            'Periodicals' => $Periodicals,
            'customer_id' => $customer_id,
            'pause_end' => false,
        ];
    }
}