<?php

namespace Plugin\ApgSimpleCalendar\Form\Type\Admin;

use Plugin\ApgSimpleCalendar\Entity\Config;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ConfigType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('regular_holidays_arr', ChoiceType::class, [
            'label' => '定休日',
            'placeholder' => false,
            'mapped' => true,
            'choices' => [
                '月曜日' => 1,
                '火曜日' => 2,
                '水曜日' => 3,
                '木曜日' => 4,
                '金曜日' => 5,
                '土曜日' => 6,
                '日曜日' => 7,
            ],
            'expanded' => true,
            'multiple' => true,
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Config::class,
        ]);
    }
}
