<?php

namespace Plugin\Atobaraidotcom4\Entity;

use Doctrine\ORM\Mapping as ORM;
use Eccube\Entity\AbstractEntity;

/**
 * Config
 * 
 * @ORM\Table(name="plg_atobaraidotcom_config")
 * @ORM\Entity(repositoryClass="Plugin\Atobaraidotcom4\Repository\ConfigRepository")
 */
class Config extends AbstractEntity
{

    /**
     * @var int
     * 
     * @ORM\Column(name="id", type="integer", options={"unsigned":true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     * 
     * @ORM\Column(name="enterprise_id", type="string", length=255, nullable=true)
     */
    private $enterprise_id;

    /**
     * @var string
     * 
     * @ORM\Column(name="site_id", type="string", length=255, nullable=true)
     */
    private $site_id;

    /**
     * @var string
     * 
     * @ORM\Column(name="api_user_id", type="string", length=255, nullable=true)
     */
    private $api_user_id;

    /**
     * @var string
     * 
     * @ORM\Column(name="tax_rate", type="string", length=255, nullable=true)
     */
    private $tax_rate;

    /**
     * @var string
     * 
     * @ORM\Column(name="delivery", type="string", length=255, nullable=true)
     */
    private $delivery;
    
    /**
     * Constructor
     */
    public function __construct()
    {
    }

    /**
     * {@inheritdoc}
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * {@inheritdoc}
     */
    public function getEnterpriseId()
    {
        return $this->enterprise_id;
    }

    /**
     * {@inheritdoc}
     */
    public function setEnterpriseId($enterprise_id)
    {
        $this->enterprise_id = $enterprise_id;

        return $this;
    }
    
    /**
     * {@inheritdoc}
     */
    public function getSiteId()
    {
        return $this->site_id;
    }

    /**
     * {@inheritdoc}
     */
    public function setSiteId($site_id)
    {
        $this->site_id = $site_id;

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function getApiUserId()
    {
        return $this->api_user_id;
    }

    /**
     * {@inheritdoc}
     */
    public function setApiUserId($api_user_id)
    {
        $this->api_user_id = $api_user_id;

        return $this;
    }
    /**
     * {@inheritdoc}
     */
    public function getTaxRate()
    {
        return $this->tax_rate;
    }

    /**
     * {@inheritdoc}
     */
    public function setTaxRate($tax_rate)
    {
        $this->tax_rate = $tax_rate;

        return $this;
    }
    /**
     * {@inheritdoc}
     */
    public function getDelivery()
    {
        return $this->delivery;
    }

    /**
     * {@inheritdoc}
     */
    public function setDelivery($delivery)
    {
        $this->delivery = $delivery;

        return $this;
    }

}
