<?php


namespace Plugin\ApteqPeriodical\Repository\Query;

use Doctrine\ORM\QueryBuilder;
use Eccube\Repository\QueryKey;
use Eccube\Doctrine\Query\QueryCustomizer;
use Plugin\ApteqPeriodical\Entity\Periodical;
use Plugin\ApteqPeriodical\Entity\PeriodicalDetail;
use Plugin\ApteqPeriodical\Repository\PeriodicalRepository;
use Plugin\ApteqPeriodical\Repository\PeriodicalDetailRepository;

class ApteqPeriodicalQueryCustomizer implements QueryCustomizer
{

    /**
     * クエリをカスタマイズする
     。
     *
     * @param QueryBuilder $builder
     * @param array $params
     * @param string $queryKey
     */
    public function customize(QueryBuilder $qb, $params, $queryKey)
    {
        $qb
            ->addSelect('pc')
            ->leftJoin('oi.ProductClass', 'pc')
            ->leftJoin('\Plugin\ApteqPeriodical\Entity\PeriodicalDetail', 'pd', 'WITH', 'pd.order_id = o.id')
            ->leftJoin('\Plugin\ApteqPeriodical\Entity\Periodical', 'pr', 'WITH', 'pr.id = pd.periodical_id');
    }

    /**
     * ProductRepository::getQueryBuilderBySearchDataForAdmin に適用する.
     *
     * @return string
     * @see \Eccube\Repository\OrderRepository::getQueryBuilderBySearchDataForAdmin()
     * @see QueryKey
     */
    public function getQueryKey()
    {
        return QueryKey::ORDER_SEARCH_ADMIN;
    }

}