<?php

namespace Plugin\ApteqPeriodical\Repository;

use Doctrine\ORM\QueryBuilder;
use Eccube\Repository\AbstractRepository;
use Eccube\Doctrine\Query\Queries;
use Plugin\ApteqPeriodical\Entity\Periodical;
use Plugin\ApteqPeriodical\Entity\PeriodicalDetail;
use Plugin\ApteqPeriodical\Entity\PeriodicalShipping;
use Doctrine\Common\Persistence\ManagerRegistry;
use Doctrine\ORM\NoResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * ApteqPeriodicalShippingRepository.
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PeriodicalShippingRepository extends AbstractRepository
{
    
    /**
     * PeriodicalShippingRepository constructor.
     *
     * @param RegistryInterface $registry
     */
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, PeriodicalShipping::class);
    }
    /**
     * 定期情報詳細を取得する.
     *
     * @param $PeriodicalId
     *
     * @return QueryBuilder
     *
     */
    public function searchByPeriodicalId($PeriodicalId)
    {
        $result = $this->createQueryBuilder('ps')
            ->select('ps')
            ->where('ps.priodical_id = :PeriodicalId')
            ->setParameter('PeriodicalId', $PeriodicalId)
            ->getQuery()
            ->getResult();        

        return $result;
    }
 
}
