<?php

namespace Plugin\ApteqPeriodical\Repository;

use Doctrine\ORM\QueryBuilder;
use Eccube\Repository\AbstractRepository;
use Eccube\Doctrine\Query\Queries;
use Plugin\ApteqPeriodical\Entity\Periodical;
use Plugin\ApteqPeriodical\Entity\PeriodicalDetail;
use Plugin\ApteqPeriodical\Repositry\PeriodicalDetailRepositry;
use Doctrine\Common\Persistence\ManagerRegistry;
use Doctrine\ORM\NoResultException;
use Symfony\Bridge\Doctrine\RegistryInterface;


/**
 * ApteqPeriodicalDetailRepository.
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PeriodicalDetailRepository extends AbstractRepository
{
    
    /**
     * PeriodicalDetailRepository constructor.
     *
     * @param RegistryInterface $registry
     */
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, PeriodicalDetail::class);
    }
    /**
     * 定期情報詳細を取得する.
     *
     * @param $OrderId
     *
     * @return Plugin\ApteqPeriodical\Entity\PeriodicalDetail[]
     *
     */
    public function searchByOrderId($OrderId)
    {
        $result = $this->createQueryBuilder('pd')
            ->select('pd')
            ->where('pd.order_id = :OrderId')
            ->setParameter('OrderId', $OrderId)
            ->getQuery()
            ->getResult();        

        return $result;
    }
    public function searchPeriodicalStatusByOrderId($OrderId)
    {
        $result = $this->createQueryBuilder('pd')
            ->select('pd')
            ->where('pd.order_id = :OrderId')
            ->setParameter('OrderId', $OrderId)
            ->getQuery()
            ->getResult();
        if($result) {
            $periodical_id = $result[0]['periodical_id'];
        } else {
            $periodical_id = null;
        }
        
        $result1 = $this->createQueryBuilder('pr')
            ->select('pr')
            ->where('pr.id = :PeriodicalId')
            ->setParameter('PeriodicalId', $periodical_id)
            ->getQuery()
            ->getResult();
        //dump($result1);exit;
        $periodical_status = $result[0].['id'];

        return $periodical_status;
    }
    
    /**
     * 次回お届け日を作成する（1か月後）.
     *
     * @param \DateTime $this_shipping_date
     *
     * @return \DateTime
     *
     */
    public function makeNextShippingDate($this_shipping_date)
    {
        $next_shipping_date = new \DateTime();
        
        if ($this_shipping_date) {
            $next_shipping_date = clone $this_shipping_date;
        }else {
            
        }
        $next_shipping_date = $next_shipping_date->modify('+1 month');
        
        return $next_shipping_date;
    }
   
    /**
     * 定期購入詳細の件数を取得する.（「(〇回目の注文まで受付済み）」）
     *
     * @param $PeriodicalId
     *
     * @return int
     *
     */
    public function countTotalPeriodicalDetail($PeriodicalId)
    {
        $result = $this->createQueryBuilder('pd')
            ->select('pd')
            ->where('pd.periodical_id = :PeriodicalId')
            ->setParameter('PeriodicalId', $PeriodicalId)
            ->getQuery()
            ->getResult();
        
        $total_count = count($result);

        return $total_count;
    }    
    /**
     * 定期購入詳細の何番目かを取得する.（「〇回目」）
     *
     * @param $PeriodicalId
     * @param $PeriodicalDetailId
     *
     * @return int
     *
     */
    public function countPeriodicalDetail($PeriodicalId, $PeriodicalDetailId)
    {
        $result = $this->createQueryBuilder('pd')
            ->select('pd')
            ->where('pd.periodical_id = :PeriodicalId')
            ->setParameter('PeriodicalId', $PeriodicalId)
            ->OrderBy('pd.id', 'ASC')
            ->getQuery()
            ->getResult();
        
        $i = 0;
        foreach ($result as $detail) {
            $i++;
            if ($detail->getId() == $PeriodicalDetailId) {
                break;
            }            
        }

        return $i;
    }    
 
}
