<?php

namespace Plugin\ApgSimpleCalendar\Form\Type\Admin;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\File;
use Symfony\Component\Validator\Constraints\NotBlank;

class HolidayImportType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {

        $builder->add('file', FileType::class, [
            'label' => false,
            'mapped' => false,
            'required' => true,
            'constraints' => [
                new NotBlank(),
                new File([
//                    'mimeTypes' => ['text/plain'],
//                    'mimeTypesMessage' => 'CSVファイルをアップロードしてください',
                    'maxSize' => '1M',
                ]),
            ],
        ]);
    }


    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'apg_simple_calendar_import_holiday';
    }
}
