<?php
namespace Plugin\RemisePayment4\Form\Type\Admin;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\Callback;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Context\ExecutionContextInterface;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * 定期購買取込一覧画面
 */
class AcImportType extends AbstractType
{

    /**
     *
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        // メンバーID（ルミーズ発番のID）
        $builder->add('member_id', TextType::class, [
            'label' => trans('remise_payment4.ac.admin_import_index.label.import_form.member_id'),
            'constraints' => array(
                new Assert\Regex(array(
                    'pattern' => "/^[a-zA-Z0-9]+$/u",
                    'message' => trans('remise_payment4.ac.admin_import_index.label.import_form.member_id.regex'),
                )),
            ),
            'required' => false,
            'mapped' => false,
        ]);

        // 取込対象の課金日
        $builder->add('import_date', DateType::class, [
            'label' => trans('remise_payment4.ac.admin_import_index.label.import_form.import_date'),
            'required' => false,
            'mapped' => false,
            'input' => 'datetime',
            'widget' => 'single_text',
            'format' => 'yyyy-MM-dd',
            'placeholder' => ['year' => '----', 'month' => '--', 'day' => '--'],
            'attr' => [
                'class' => 'datetimepicker-input',
                'data-target' => '#'.$this->getBlockPrefix().'_import_date',
                'data-toggle' => 'datetimepicker',
            ],
            'data' => new \DateTime()
        ]);

    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'ac_import';
    }
}
