<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('ja', array (
  'validators' => 
  array (
    'This value should be false.' => 'falseでなければなりません。',
    'This value should be true.' => 'trueでなければなりません。',
    'This value should be of type {{ type }}.' => '型は{{ type }}でなければなりません。',
    'This value should be blank.' => '空でなければなりません。',
    'The value you selected is not a valid choice.' => '有効な選択肢ではありません。',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => '{{ limit }}個以上選択してください。',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => '{{ limit }}個以内で選択してください。',
    'One or more of the given values is invalid.' => '無効な選択肢が含まれています。',
    'This field was not expected.' => 'このフィールドは予期されていませんでした。',
    'This field is missing.' => 'このフィールドは、欠落しています。',
    'This value is not a valid date.' => '有効な日付ではありません。',
    'This value is not a valid datetime.' => '有効な日時ではありません。',
    'This value is not a valid email address.' => '有効なメールアドレスではありません。',
    'The file could not be found.' => 'ファイルが見つかりません。',
    'The file is not readable.' => 'ファイルを読み込めません。',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'ファイルのサイズが大きすぎます({{ size }} {{ suffix }})。有効な最大サイズは{{ limit }} {{ suffix }}です。',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'ファイルのMIMEタイプが無効です({{ type }})。有効なMIMEタイプは{{ types }}です。',
    'This value should be {{ limit }} or less.' => '{{ limit }}以下でなければなりません。',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => '値が長すぎます。{{ limit }}文字以内でなければなりません。',
    'This value should be {{ limit }} or more.' => '{{ limit }}以上でなければなりません。',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => '値が短すぎます。{{ limit }}文字以上でなければなりません。',
    'This value should not be blank.' => '入力されていません。',
    'This value should not be null.' => 'nullであってはなりません。',
    'This value should be null.' => 'nullでなければなりません。',
    'This value is not valid.' => '有効な値ではありません。',
    'This value is not a valid time.' => '有効な時刻ではありません。',
    'This value is not a valid URL.' => '有効なURLではありません。',
    'The two values should be equal.' => '2つの値が同じでなければなりません。',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'ファイルのサイズが大きすぎます。有効な最大サイズは{{ limit }} {{ suffix }}です。',
    'The file is too large.' => 'ファイルのサイズが大きすぎます。',
    'The file could not be uploaded.' => 'ファイルをアップロードできませんでした。',
    'This value should be a valid number.' => '有効な数字ではありません。',
    'This file is not a valid image.' => 'ファイルが画像ではありません。',
    'This is not a valid IP address.' => '有効なIPアドレスではありません。',
    'This value is not a valid language.' => '有効な言語名ではありません。',
    'This value is not a valid locale.' => '有効なロケールではありません。',
    'This value is not a valid country.' => '有効な国名ではありません。',
    'This value is already used.' => '既に使用されています。',
    'The size of the image could not be detected.' => '画像のサイズが検出できません。',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => '画像の幅が大きすぎます({{ width }}ピクセル)。{{ max_width }}ピクセルまでにしてください。',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => '画像の幅が小さすぎます({{ width }}ピクセル)。{{ min_width }}ピクセル以上にしてください。',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => '画像の高さが大きすぎます({{ height }}ピクセル)。{{ max_height }}ピクセルまでにしてください。',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => '画像の高さが小さすぎます({{ height }}ピクセル)。{{ min_height }}ピクセル以上にしてください。',
    'This value should be the user\'s current password.' => 'ユーザーの現在のパスワードでなければなりません。',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'ちょうど{{ limit }}文字でなければなりません。',
    'The file was only partially uploaded.' => 'ファイルのアップロードは完全ではありません。',
    'No file was uploaded.' => 'ファイルがアップロードされていません。',
    'No temporary folder was configured in php.ini.' => 'php.iniで一時フォルダが設定されていません。',
    'Cannot write temporary file to disk.' => '一時ファイルをディスクに書き込むことができません。',
    'A PHP extension caused the upload to fail.' => 'PHP拡張によってアップロードに失敗しました。',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => '{{ limit }}個以上の要素を含んでなければいけません。',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => '要素は{{ limit }}個までです。',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => '要素はちょうど{{ limit }}個でなければなりません。',
    'Invalid card number.' => '無効なカード番号です。',
    'Unsupported card type or invalid card number.' => '未対応のカード種類又は無効なカード番号です。',
    'This is not a valid International Bank Account Number (IBAN).' => '有効なIBANコードではありません。',
    'This value is not a valid ISBN-10.' => '有効なISBN-10コードではありません。',
    'This value is not a valid ISBN-13.' => '有効なISBN-13コードではありません。',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => '有効なISBN-10コード又はISBN-13コードではありません。',
    'This value is not a valid ISSN.' => '有効なISSNコードではありません。',
    'This value is not a valid currency.' => '有効な貨幣ではありません。',
    'This value should be equal to {{ compared_value }}.' => '{{ compared_value }}と等しくなければなりません。',
    'This value should be greater than {{ compared_value }}.' => '{{ compared_value }}より大きくなければなりません。',
    'This value should be greater than or equal to {{ compared_value }}.' => '{{ compared_value }}以上でなければなりません。',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => '{{ compared_value_type }}としての{{ compared_value }}と等しくなければなりません。',
    'This value should be less than {{ compared_value }}.' => '{{ compared_value }}未満でなければなりません。',
    'This value should be less than or equal to {{ compared_value }}.' => '{{ compared_value }}以下でなければなりません。',
    'This value should not be equal to {{ compared_value }}.' => '{{ compared_value }}と等しくてはいけません。',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => '{{ compared_value_type }}としての{{ compared_value }}と等しくてはいけません。',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => '画像のアスペクト比が大きすぎます({{ ratio }})。{{ max_ratio }}までにしてください。',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => '画像のアスペクト比が小さすぎます({{ ratio }})。{{ min_ratio }}以上にしてください。',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => '画像が正方形になっています({{ width }}x{{ height }}ピクセル)。正方形の画像は許可されていません。',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => '画像が横向きになっています({{ width }}x{{ height }}ピクセル)。横向きの画像は許可されていません。',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => '画像が縦向きになっています({{ width }}x{{ height }}ピクセル)。縦向きの画像は許可されていません。',
    'An empty file is not allowed.' => '空のファイルは許可されていません。',
    'The host could not be resolved.' => 'ホストを解決できませんでした。',
    'This value does not match the expected {{ charset }} charset.' => 'この値は予期される文字コード（{{ charset }}）と異なります。',
    'This is not a valid Business Identifier Code (BIC).' => '有効なSWIFTコードではありません。',
    'Error' => 'エラー',
    'This is not a valid UUID.' => '有効なUUIDではありません。',
    'This value should be a multiple of {{ compared_value }}.' => '{{ compared_value }}の倍数でなければなりません。',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'このSWIFTコードはIBANコード（{{ iban }}）に関連付けられていません。',
    'This value should be valid JSON.' => 'JSONでなければなりません。',
    'This collection should contain only unique elements.' => '要素は重複してはなりません。',
    'This value should be positive.' => '正の数でなければなりません。',
    'This value should be either positive or zero.' => '正の数、または0でなければなりません。',
    'This value should be negative.' => '負の数でなければなりません。',
    'This value should be either negative or zero.' => '負の数、または0でなければなりません。',
    'This value is not a valid timezone.' => '有効なタイムゾーンではありません。',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'このパスワードは漏洩している為使用できません。',
    'This form should not contain extra fields.' => 'フィールドグループに追加のフィールドを含んではなりません。',
    'The uploaded file was too large. Please try to upload a smaller file.' => 'アップロードされたファイルが大きすぎます。小さなファイルで再度アップロードしてください。',
    'The CSRF token is invalid. Please try to resubmit the form.' => 'CSRFトークンが無効です、再送信してください。',
    'This value should be the user\\\'s current password.' => '現在のパスワードが正しくありません。',
    'Invalid credentials.' => 'ログインできませんでした。
入力内容に誤りがないかご確認ください。
',
    'Invalid CSRF token.' => 'ログインできませんでした。
入力内容に誤りがないかご確認ください。
',
    'Invalid twig format. {{ error }}' => 'Twigのフォーマットが正しくありません。{{ error }}',
    'form_error.numeric_only' => '数字で入力してください。',
    'form_error.kana_only' => 'カタカナで入力してください。',
    'form_error.graph_only' => '半角英数字で入力してください。',
    'form_error.not_contain_spaces' => 'スペース、タブ、改行は含めないで下さい。',
    'form_error.graph_and_hyphen_only' => '半角英数字かハイフンのみを入力してください。',
    'form_error.not_selected' => '選択されていません。',
    'form_error.select_is_future_or_now_date' => '生年月日が不正な日付です。',
    'form_error.float_only' => '数字と小数点のみ入力できます。',
    'form_error.same_password' => '同じパスワードを入力してください。',
    'form_error.same_email' => '同じメールアドレスを入力してください。',
    'form_error.admin_is_not_available' => 'ディレクトリ名に「admin」を使用することはできません。',
    'form_error.member_already_exists' => '既に利用されているログインIDです。',
    'form_error.customer_already_exists' => 'このメールアドレスは利用できません。',
    'errors.numeric_only' => '数字で入力してください。',
    'errors.float_only' => '数字と小数点のみ入力できます。',
    'errors.graph_only' => '半角英数字で入力してください。',
    'errors.kana_only' => 'カタカナで入力してください。',
    'errors.not_contain_spaces' => 'スペース、タブ、改行は含めないで下さい。',
    'errors.not_selected' => '選択されていません。',
    'errors.graph_and_hyphen' => '半角英数字かハイフンのみを入力してください。',
    'form.type.graph.invalid' => '半角英数字で入力してください。',
    'form.type.name.firstname.nothasspace' => 'お名前(名)にスペース、タブ、改行は含めないで下さい。',
    'form.type.name.lastname.nothasspace' => 'お名前(性)にスペース、タブ、改行は含めないで下さい。',
    'form.type.customer.password.too_short' => 'パスワードが短すぎます。{{ limit }}文字以上でなければなりません。',
    'form.type.customer.password.too_long' => 'パスワードが長すぎます。{{ limit }}文字以内でなければなりません。',
    'form.type.customer.company.nothasspace' => '会社名にスペース、タブ、改行は含めないで下さい。',
    'form.type.admin.nottelstyle' => '電話番号は半角数字かハイフンのみを入力してください。',
    'form.type.admin.notkanastyle' => 'お名前(フリガナ)はカタカナで入力してください。',
    'form.type.select.notselect' => '入力されていません。',
    'form.type.select.classcategory' => '項目が選択されていません。',
    'form.type.add.quantity' => '1以上で入力してください。',
    'form.type.select.select_is_future_or_now_date' => '生年月日が不正な日付です。',
    'form.type.admin.nottrackingnumberstyle' => '送り状番号は半角英数字かハイフンのみを入力してください。',
    'form.type.float.invalid' => '数字と小数点のみ入力できます。',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => '認証エラーが発生しました。',
    'Authentication credentials could not be found.' => '認証資格がありません。',
    'Authentication request could not be processed due to a system problem.' => 'システムの問題により認証要求を処理できませんでした。',
    'Invalid credentials.' => '資格が無効です。',
    'Cookie has already been used by someone else.' => 'Cookie が別のユーザーで使用されています。',
    'Not privileged to request the resource.' => 'リソースをリクエストする権限がありません。',
    'Invalid CSRF token.' => 'CSRF トークンが無効です。',
    'Digest nonce has expired.' => 'Digest の nonce 値が期限切れです。',
    'No authentication provider found to support the authentication token.' => '認証トークンをサポートする認証プロバイダーが見つかりません。',
    'No session available, it either timed out or cookies are not enabled.' => '利用可能なセッションがありません。タイムアウトしたか、Cookie が無効になっています。',
    'No token could be found.' => 'トークンが見つかりません。',
    'Username could not be found.' => 'ユーザー名が見つかりません。',
    'Account has expired.' => 'アカウントが有効期限切れです。',
    'Credentials have expired.' => '資格が有効期限切れです。',
    'Account is disabled.' => 'アカウントが無効です。',
    'Account is locked.' => 'アカウントはロックされています。',
  ),
  'messages' => 
  array (
    'remise_payment4.common.label.plugin_code' => 'RemisePayment4',
    'remise_payment4.common.label.plugin_name' => 'ルミーズ決済プラグイン',
    'remise_payment4.common.label.payment.kind.card' => 1,
    'remise_payment4.common.label.payment.card' => 'クレジットカード決済',
    'remise_payment4.common.label.payment.kind.cvs' => 2,
    'remise_payment4.common.label.payment.cvs' => 'コンビニ・電子マネー・銀行決済',
    'remise_payment4.common.label.card.state.payment' => 1,
    'remise_payment4.common.label.card.state.result' => 2,
    'remise_payment4.common.label.card.state.complete' => 3,
    'remise_payment4.common.label.card.state.result.deleted' => 4,
    'remise_payment4.common.label.card.state.result.ac.failed' => 5,
    'remise_payment4.common.label.card.state.result.ac.success' => 6,
    'remise_payment4.common.text.card.state.payment' => '決済処理中',
    'remise_payment4.common.text.card.state.result' => '受注未確定',
    'remise_payment4.common.text.card.state.result.customer' => '入金確認中',
    'remise_payment4.common.text.card.state.complete' => '決済完了',
    'remise_payment4.common.text.card.state.result.deleted' => '受注確定処理済',
    'remise_payment4.common.text.card.state.result.ac.failed' => '課金失敗',
    'remise_payment4.common.text.card.state.result.ac.success' => '課金処理済',
    'remise_payment4.common.label.mail_template.kind.acpt' => 1,
    'remise_payment4.common.label.mail_template.name.acpt' => '入金お知らせメール（REMISEマルチ決済）',
    'remise_payment4.common.label.mail_template.subject.acpt' => 'ご入金が確認できました',
    'remise_payment4.common.label.mail_template.kind.ac_order' => 2,
    'remise_payment4.common.label.mail_template.name.ac_order' => '定期購買注文受付メール（REMISE定期購買）',
    'remise_payment4.common.label.mail_template.subject.ac_order' => 'ご注文ありがとうございます',
    'remise_payment4.common.label.mail_template.kind.mypage.card_update' => 3,
    'remise_payment4.common.label.mail_template.name.mypage.card_update' => '定期購買カード情報更新通知メール（REMISE定期購買）',
    'remise_payment4.common.label.mail_template.subject.mypage.card_update' => 'ご登録カードの更新が完了しました',
    'remise_payment4.common.label.mail_template.kind.mypage.cancel' => 4,
    'remise_payment4.common.label.mail_template.name.mypage.cancel' => '定期購買解約通知メール（REMISE定期購買）',
    'remise_payment4.common.label.mail_template.subject.mypage.cancel' => '定期購買の解約処理が完了しました',
    'remise_payment4.common.label.mail_template.kind.mypage.skip' => 5,
    'remise_payment4.common.label.mail_template.name.mypage.skip' => '定期購買スキップ通知メール（REMISE定期購買）',
    'remise_payment4.common.label.mail_template.subject.mypage.skip' => '定期購買のスキップ処理が完了しました',
    'remise_payment4.common.label.mail_template.kind.result_import.success' => 6,
    'remise_payment4.common.label.mail_template.name.result_import.success' => '定期購買結果取込通知メール（REMISE定期購買）',
    'remise_payment4.common.label.mail_template.subject.result_import.success' => '定期購買の結果取込処理が完了しました',
    'remise_payment4.common.label.mail_template.kind.result_import.error' => 7,
    'remise_payment4.common.label.mail_template.name.result_import.error' => '定期購買結果取込エラー通知メール（REMISE定期購買）',
    'remise_payment4.common.label.mail_template.subject.result_import.error' => '定期購買の結果取込処理でエラーが発生しました',
    'remise_payment4.common.label.mail_template.kind.result_import_stack.accept' => 8,
    'remise_payment4.common.label.mail_template.name.result_import_stack.accept' => '定期購買結果バッチ取込受付通知メール（REMISE定期購買）',
    'remise_payment4.common.label.mail_template.subject.result_import_stack.accept' => '定期購買の結果取込処理を受付しました',
    'remise_payment4.common.label.mail_template.kind.result_import_stack.error' => 9,
    'remise_payment4.common.label.mail_template.name.result_import_stack.error' => '定期購買結果バッチ取込エラー通知メール（REMISE定期購買）',
    'remise_payment4.common.label.mail_template.subject.result_import_stack.error' => '定期購買の結果取込処理でエラーが発生しました',
    'remise_payment4.common.label.r_code.success' => '0:0000',
    'remise_payment4.common.label.errinfo.success' => 0,
    'remise_payment4.common.label.errlevel.success' => 0,
    'remise_payment4.common.label.result.card.success' => '<SDBKDATA>STATUS=800</SDBKDATA>',
    'remise_payment4.common.label.receipt.cvs.success' => '<SDBKDATA>STATUS=800</SDBKDATA>',
    'remise_payment4.common.label.pay_csv.D001' => 'セブンイレブン',
    'remise_payment4.common.label.pay_csv.D002' => 'ローソン',
    'remise_payment4.common.label.pay_csv.D005' => 'ミニストップ',
    'remise_payment4.common.label.pay_csv.D015' => 'セイコーマート',
    'remise_payment4.common.label.pay_csv.D405' => 'ペイジー',
    'remise_payment4.common.label.pay_csv.D003' => 'サンクス',
    'remise_payment4.common.label.pay_csv.D004' => 'サークルＫ',
    'remise_payment4.common.label.pay_csv.D010' => 'デイリーヤマザキ',
    'remise_payment4.common.label.pay_csv.D011' => 'ヤマザキデイリーストア',
    'remise_payment4.common.label.pay_csv.D030' => 'ファミリーマート',
    'remise_payment4.common.label.pay_csv.D401' => '楽天Ｅｄｙ',
    'remise_payment4.common.label.pay_csv.D403' => 'モバイルSuica',
    'remise_payment4.common.label.pay_csv.D404' => '楽天銀行',
    'remise_payment4.common.label.pay_csv.D406' => 'ジャパンネット銀行',
    'remise_payment4.common.label.pay_csv.D407' => 'Suicaインターネットサービス',
    'remise_payment4.common.label.pay_csv.D451' => 'ウェブマネー',
    'remise_payment4.common.label.pay_csv.D452' => 'ビットキャッシュ',
    'remise_payment4.common.label.pay_csv.D453' => 'JCBプレモカード',
    'remise_payment4.common.label.pay_csv.P901' => 'コンビニ払込票',
    'remise_payment4.common.label.pay_csv.P902' => 'コンビニ払込票（郵便局・ゆうちょ銀行）',
    'remise_payment4.common.label.pay_csv.P903' => 'コンビニ払込票（ハガキ）',
    'remise_payment4.common.label.pay_csv.P904' => 'コンビニ払込票（ハガキ）',
    'remise_payment4.common.label.pay_csv.P905' => 'コンビニ払込票（ハガキ）',
    'remise_payment4.common.label.pay_csv.P906' => 'コンビニ払込票（ハガキ）',
    'remise_payment4.common.label.pay_csv.C501' => 'クレジットカード',
    'remise_payment4.common.label.pay_csv.C502' => 'クレジットカード',
    'remise_payment4.common.label.pay_csv.C511' => 'PayPal',
    'remise_payment4.common.label.pay_csv.M601' => 'ドコモ払い',
    'remise_payment4.common.label.pay_csv.M602' => 'ドコモ払い',
    'remise_payment4.common.label.pay_csv.M603' => 'ドコモ払い（継続課金）',
    'remise_payment4.common.label.pay_csv.M611' => 'auかんたん決済 / au WALLET',
    'remise_payment4.common.label.pay_csv.M612' => 'auかんたん決済 / au WALLET',
    'remise_payment4.common.label.pay_csv.M613' => 'auかんたん決済 / au WALLET（継続課金）',
    'remise_payment4.common.label.pay_csv.M621' => 'ソフトバンクまとめて支払い',
    'remise_payment4.common.label.pay_csv.M622' => 'ソフトバンクまとめて支払い',
    'remise_payment4.common.label.pay_csv.M623' => 'ソフトバンクまとめて支払い（継続課金）',
    'remise_payment4.common.label.cvs_name' => 'お支払い先：',
    'remise_payment4.common.label.cvs_paydate' => 'お支払い期限：',
    'remise_payment4.common.label.payment_no' => '払込票番号：',
    'remise_payment4.common.label.receipt_no' => '受付番号：',
    'remise_payment4.common.label.confirm_no' => '確認番号：',
    'remise_payment4.common.label.regist_telno' => '登録電話番号：',
    'remise_payment4.common.label.online_no' => 'オンライン決済番号：',
    'remise_payment4.common.label.company_code' => '企業コード：',
    'remise_payment4.common.label.order_no' => '注文番号：',
    'remise_payment4.common.label.payment_url' => 'お支払い方法：',
    'remise_payment4.common.label.dsk_url' => 'http://www.remise.jp/data/paycvs/dsk/index.html',
    'remise_payment4.common.label.message_seveneleven' => '上記URLのページを表示の上プリントアウトされるか、払込票番号(13桁)をメモして頂いてセブン－イレブンのレジでお支払いください。
手書きメモの場合、「インターネットの代金支払」とレジにてお申し出の上、払込票番号を記したメモをご提示ください。
',
    'remise_payment4.common.label.message_lawson' => '以下のいずれかの方法で、画面に従って申込券を発行の上、レジへご提示ください。
＜Loppi専用バーコードでのお支払いの場合＞
上記支払方法案内URLのページをプリントアウトした書面、もしくは携帯・スマートフォン画面に表示されたLoppi専用バーコードを、店頭のLoppi専用バーコードリーダーにかざしてください。
＜受付番号と確認番号を利用してのお支払いの場合＞
店頭のLoppi端末のトップ画面から「各種番号をお持ちの方」を選択し、番号検索画面で受付番号を入力後、モバライ☆お支払い画面で確認番号を入力してください。
',
    'remise_payment4.common.label.message_seikomart' => '店舗レジにて「インターネット支払い」であることをお申し出いただき、以下のいずれかの方法でお手続きを行ってください。
　
＜番号でのお支払いの場合＞
　レジ操作画面にて「受付番号」を入力、次画面で「登録電話番号」をご入力ください。確認画面にて内容をご確認のうえ、お支払いください。
　
＜バーコードでのお支払いの場合＞
　支払方法案内URLのお支払方法案内画面にバーコードが表示されます。バーコードを印刷した紙、またはバーコードを表示したスマートフォンをご提示ください。
　店員がバーコードをスキャン後、レジ操作画面に確認画面が表示されますので、内容をご確認のうえ、お支払いください。
',
    'remise_payment4.common.label.message_payeasy' => '「Pay-easy」マークが貼付されているATM、インターネットバンキング、モバイルバンキングでのお支払いができます。
各収納機関の画面指示に従ってお支払いください。
「収納機関番号」は「58091」、「お客様番号」は「ご登録のお電話番号」となります。
なお、支払方法案内URLからログインされた場合は「収納機関番号」・「お客様番号」・「確認番号」の入力は不要になります。
',
    'remise_payment4.common.label.message_circlek' => '店頭のカルワザステーション端末のメニュー画面から「各種支払い」を選択し、次に「6ケタの番号をお持ちの方」を選択してください。
受付番号、登録電話番号を入力して、画面に従い受付票を発行の上、レジへご提示ください。
',
    'remise_payment4.common.label.message_yamazaki' => '上記URLのページを表示の上プリントアウトされるか、オンライン決済番号(11桁)をメモして頂いてデイリーヤマザキ・ヤマザキデイリーストアのレジにご提示いただき、手順に従ってお支払いください。
手書きメモの場合、「オンライン決済」とレジにてお申し出の上、オンライン決済番号を記したメモをご提示ください。
',
    'remise_payment4.common.label.message_familymart' => '店頭のFamiポートの画面から「代金支払い・チャージ」→「収納票発行」を選択してください。
企業コード(5桁)、注文番号(12桁)を入力して申込券を発行し、レジへご提示ください。
',
    'remise_payment4.common.label.message_paperpay' => 'コンビニ払込票は、後日、郵送にてお送りさせて頂きますので、お近くのコンビニエンスストアでお支払手続きをお願いいたします。
なお、ご利用店舗によっては、コンビニ払込票が商品に同梱される場合もございます。予め、ご了承ください。
',
    'remise_payment4.common.label.message_other' => '上記URLのページを表示の上、画面の指示に従ってお支払いください。',
    'remise_payment4.common.label.card_method.10' => '一括払い',
    'remise_payment4.common.label.card_method.61' => '分割払い',
    'remise_payment4.common.label.card_method.80' => 'リボルビング',
    'remise_payment4.common.label.card_ptimes' => '2',
    'remise_payment4.common.label.card_ptimes_count' => '回',
    'remise_payment4.common.label.card' => 'カード番号',
    'remise_payment4.common.label.expire' => '有効期限',
    'remise_payment4.common.label.month' => '月',
    'remise_payment4.common.label.year' => '年',
    'remise_payment4.front.payment.label.flow' => 'お支払い',
    'remise_payment4.front.button.payment' => '決済する',
    'remise_payment4.front.text.processing' => '只今、処理中です。<br />しばらくお待ちください。',
    'remise_payment4.front.text.notfound.order' => '注文情報が見つかりません。',
    'remise_payment4.front.text.invalid.payment' => '支払方法が正しくありません。',
    'remise_payment4.front.text.unsetting.plugin' => 'プラグインの設定に不備があります。管理者にご連絡ください。',
    'remise_payment4.front.text.payment.error' => '決済処理エラー',
    'remise_payment4.front.text.r_code.1:0000' => '提携サイトの一時的なサーバ負荷により受付できませんでした。',
    'remise_payment4.front.text.r_code.2:0000' => '提携サイトのメンテナンス中により受付できませんでした。',
    'remise_payment4.front.text.r_code.5:1000' => '結果通知トランザクションにおいて正常なステータスが取得できませんでした。',
    'remise_payment4.front.text.r_code.5:2000' => '結果通知トランザクションにおいて原因不明なエラーが発生しました。',
    'remise_payment4.front.text.r_code.8:1xxx' => '送信データにおいて設定されていない項目が存在します。',
    'remise_payment4.front.text.r_code.8:2xxx' => '送信データにおいて桁不足もしくは桁あふれの項目が存在します。',
    'remise_payment4.front.text.r_code.8:3xxx' => '送信データにおいて不正なデータが設定されている項目が存在します。',
    'remise_payment4.front.text.r_code.8:x008' => 'メールアドレスのご変更をお願いいたします。',
    'remise_payment4.front.text.r_code.8:4003' => 'メンテナンス中により受付できませんでした。',
    'remise_payment4.front.text.r_code.8:5801' => '取引停止中により受付できませんでした。',
    'remise_payment4.front.text.r_code.8:5804' => 'お取扱できないカードです。',
    'remise_payment4.front.text.r_code.8:5805' => 'お取扱できないカードです。',
    'remise_payment4.front.text.r_code.8:5810' => '売上対象のトランザクションが見つかりませんでした。',
    'remise_payment4.front.text.r_code.8:5812' => 'キャンセル対象のトランザクションが見つかりませんでした。',
    'remise_payment4.front.text.r_code.8:5819' => 'このカード番号での送信は制限されました。',
    'remise_payment4.front.text.r_code.8:5820' => 'この取引は制限されました。既に決済が済んでいます。',
    'remise_payment4.front.text.r_code.8:5821' => '3-D Secure取引中に原因不明なエラーが発生しました。お客様には大変ご迷惑をおかけしますが、しばらく時間を置いて、再度お手続きをお願い致します。',
    'remise_payment4.front.text.r_code.8:5822' => 'オーソリ保持期限を過ぎています。',
    'remise_payment4.front.text.r_code.8:5823' => '取消可能期限を過ぎています。',
    'remise_payment4.front.text.r_code.8:5824' => '継続課金の受付において原因不明なエラーが発生しました。',
    'remise_payment4.front.text.r_code.8:5825' => '継続課金の会員が見つかりませんでした。',
    'remise_payment4.front.text.r_code.8:5826' => '同一リモートIPアドレスによる送信制限がかかっています。',
    'remise_payment4.front.text.r_code.9:0000' => '原因不明なエラーが発生しました。',
    'remise_payment4.front.text.r_code.9:0001' => '原因不明なエラーが発生しました。',
    'remise_payment4.front.text.r_code.error' => 'クレジットカード決済においてエラーが発生しました。',
    'remise_payment4.front.button.payment_url' => 'こちらよりご確認ください',
    'remise_payment4.front.label.card_info' => 'カードご利用情報',
    'remise_payment4.front.label.use_payquick.use' => '登録されているクレジットカードを利用する',
    'remise_payment4.front.label.use_payquick.notuse' => '新しいクレジットカードを利用する',
    'remise_payment4.front.label.method' => 'お支払方法',
    'remise_payment4.front.label.ptimes' => '分割回数',
    'remise_payment4.front.label.regist_payquick' => '今回利用するクレジットカードを登録する',
    'remise_payment4.front.label.not_regist_payquick' => 'クレジットカードは登録しない',
    'remise_payment4.front.text.payquick' => '登録を行うと、次回のお買い物からクレジットカード情報の入力を省略することができます。
カード情報は当サイトには保持しません。
',
    'remise_payment4.front.label.card_info.delete' => 'カードご利用情報の削除',
    'remise_payment4.front.text.card_info.delete' => 'カードご利用情報を削除します。よろしいですか？',
    'remise_payment4.front.text.card_info.delete.complete' => 'カードご利用情報を削除しました。',
    'remise_payment4.admin_config.label.title' => 'ルミーズ決済プラグイン',
    'remise_payment4.admin_config.label.about_plugin' => '本プラグインについて',
    'remise_payment4.admin_config.button.manual' => '設定マニュアルはこちら',
    'remise_payment4.admin_config.label.info' => 'お知らせ',
    'remise_payment4.admin_config.text.info' => 'ルミーズ決済プラグインをご利用頂く為には、ユーザ様ご自身でルミーズ株式会社とご契約を行っていただく必要があります。<br/>
お申し込みにつきましては、下記のページから、お申し込みを行ってください。
',
    'remise_payment4.admin_config.button.homepage' => 'ルミーズ株式会社オフィシャルサイト',
    'remise_payment4.admin_config.label.basic_setting' => '基本設定',
    'remise_payment4.admin_config.label.required' => '必須',
    'remise_payment4.admin_config.label.example' => '例',
    'remise_payment4.admin_config.label.shopco' => '加盟店コード',
    'remise_payment4.admin_config.text.shopco' => '「設定情報連絡票」に記載の「加盟店コード」を設定してください。',
    'remise_payment4.admin_config.text.shopco.blank' => '「加盟店コード」を入力してください。',
    'remise_payment4.admin_config.text.shopco.unmatch.length' => '「加盟店コード」は"RMS"+5文字の英数字で入力してください。',
    'remise_payment4.admin_config.label.hostid' => 'ホスト番号',
    'remise_payment4.admin_config.text.hostid' => 'ルミーズ加盟店バックヤードシステムにて初期設定後、発番されるホスト番号を入力してください。',
    'remise_payment4.admin_config.text.hostid.blank' => '「ホスト番号」を入力してください。',
    'remise_payment4.admin_config.text.hostid.unmatch.length' => '「ホスト番号」は5文字の英数字+3文字の数字で入力してください。',
    'remise_payment4.admin_config.label.use_payment' => 'ご利用の決済方法',
    'remise_payment4.admin_config.label.use_payment.card' => 'カード決済',
    'remise_payment4.admin_config.label.use_payment.cvs' => 'マルチ決済',
    'remise_payment4.admin_config.text.use_payment.blank' => '「ご利用の決済方法」を選択してください。',
    'remise_payment4.admin_config.label.use_option' => 'ご利用の追加オプション',
    'remise_payment4.admin_config.label.use_option.extset' => 'カード決済拡張セット',
    'remise_payment4.admin_config.label.use_option.ac' => '定期購買',
    'remise_payment4.admin_config.text.use_option' => '追加オプションをご利用頂くにはご契約が必要です。ご契約がない状態で設定した場合、正常に動作致しません。',
    'remise_payment4.admin_config.label.card_setting' => 'カード決済設定',
    'remise_payment4.admin_config.label.recv_url' => '結果通知URL',
    'remise_payment4.admin_config.text.recv_url' => '上記URLをルミーズ加盟店バックヤードシステムの「各種設定」-「ホスト設定」-「カード決済設定」タブ -「結果通知URL」に設定してください。',
    'remise_payment4.admin_config.label.card_url' => '決済情報送信先URL',
    'remise_payment4.admin_config.label.card_url.blank' => '「決済情報送信先URL」を入力してください。',
    'remise_payment4.admin_config.label.job' => '処理区分',
    'remise_payment4.admin_config.label.job.auth' => 'AUTH(仮売上)',
    'remise_payment4.admin_config.label.job.capture' => 'CAPTURE(売上)',
    'remise_payment4.admin_config.text.job.auth' => 'AUTH：与信枠を確保します。後で実売上処理が必要です。',
    'remise_payment4.admin_config.text.job.capture' => 'CAPTURE：売上処理を行います。',
    'remise_payment4.admin_config.label.job.blank' => '「処理区分」を選択してください。',
    'remise_payment4.admin_config.label.payquick_flag' => 'ペイクイック',
    'remise_payment4.admin_config.label.payquick_flag.use' => '利用する',
    'remise_payment4.admin_config.label.payquick_flag.notuse' => '利用しない',
    'remise_payment4.admin_config.label.payquick_flag.blank' => '「ペイクイック」の利用可否を選択してください。',
    'remise_payment4.admin_config.text.payquick_flag' => '「利用する」を選択した場合、2回目以降のお買い物でカード情報入力画面を省略できます。',
    'remise_payment4.admin_config.label.use_method' => '支払方法',
    'remise_payment4.admin_config.label.use_method.blank' => '「支払方法」を選択してください。',
    'remise_payment4.admin_config.text.use_method' => 'ペイクイック「利用する」を選択した場合、ご契約済の「支払方法」を選択してください。',
    'remise_payment4.admin_config.label.ptimes' => '分割回数',
    'remise_payment4.admin_config.label.ptimes.blank' => '「分割回数」を選択してください。',
    'remise_payment4.admin_config.text.ptimes' => '「支払方法」に分割払いを選択した場合は、分割回数を選択してください。',
    'remise_payment4.admin_config.label.cvs_setting' => 'マルチ決済設定',
    'remise_payment4.admin_config.label.acpt_url' => '収納情報通知URL',
    'remise_payment4.admin_config.text.acpt_url' => '上記URLをルミーズ加盟店バックヤードシステムの「各種設定」-「マルチ決済設定」-「収納情報通知URL」に設定してください。',
    'remise_payment4.admin_config.label.cvs_url' => '決済情報送信先URL',
    'remise_payment4.admin_config.label.cvs_url.blank' => '「決済情報送信先URL」を入力してください。',
    'remise_payment4.admin_config.label.pay_date' => '支払期限',
    'remise_payment4.admin_config.label.pay_date.blank' => '「支払期限」を選択してください。',
    'remise_payment4.admin_config.label.acpt_mail_flag' => '入金お知らせメール',
    'remise_payment4.admin_config.label.acpt_mail_flag.use' => '利用する',
    'remise_payment4.admin_config.label.acpt_mail_flag.notuse' => '利用しない',
    'remise_payment4.admin_config.label.acpt_mail_flag.blank' => '「入金お知らせメール」の利用可否を選択してください。',
    'remise_payment4.admin_config.text.acpt_mail_flag' => 'ルミーズより収納情報通知があった際に入金に関するお知らせメールが顧客宛て(Bcc:管理者)に送信されます。',
    'remise_payment4.admin_config.label.tax_rate' => '税率設定',
    'remise_payment4.admin_config.label.tax_rate_id' => 'ID',
    'remise_payment4.admin_config.label.tax_rate_tax_rate' => '消費税率（%）',
    'remise_payment4.admin_config.label.tax_rate_calc_rule' => '課税規則',
    'remise_payment4.admin_config.label.tax_rate_apply_date' => '適用日時',
    'remise_payment4.admin_config.label.tax_rate_status' => '適用状態',
    'remise_payment4.admin_config.label.tax_rate_calc_rule.1' => '四捨五入',
    'remise_payment4.admin_config.label.tax_rate_calc_rule.2' => '切り捨て',
    'remise_payment4.admin_config.label.tax_rate_calc_rule.3' => '切り上げ',
    'remise_payment4.admin_config.label.tax_rate_status.1' => '適用中',
    'remise_payment4.admin_config.label.tax_rate_status.2' => '適用予定',
    'remise_payment4.admin_config.label.tax_rate_status.3' => '無効',
    'remise_payment4.admin_config.label.tax_rate_status.4' => '新規追加',
    'remise_payment4.admin_config.label.tax_rate_button.add' => '新規追加',
    'remise_payment4.admin_config.label.tax_rate_button.del' => '削除',
    'remise_payment4.admin_config.label.tax_rate_button.del_cancel' => '削除解除',
    'remise_payment4.admin_config.label.tax_rate_primary' => '送料、手数料に対する税率設定を行います。商品に対する税率設定とは異なります。<br>コンビニ払込票、コンビニ払込票（郵便局・ゆうちょ銀行）をご利用の場合に、収入印紙の要・不要を判定するために利用されます。<br>詳しくはマニュアルをご確認ください。',
    'remise_payment4.admin_config.text.tax_rate_errmsg.1' => 'マルチ決済設定＞税率設定が設定されていません。',
    'remise_payment4.admin_config.text.tax_rate_errmsg.2' => 'マルチ決済設定＞税率設定に不正な値が設定されています。(id=%errId%)',
    'remise_payment4.admin_config.text.tax_rate_errmsg.3' => 'マルチ決済設定＞税率設定が設定されていません。(id=%errId%)',
    'remise_payment4.admin_config.text.tax_rate_errmsg.4' => 'マルチ決済設定＞税率設定の消費税率が正しく設定されていません。(id=%errId%)',
    'remise_payment4.admin_config.text.tax_rate_errmsg.5' => 'マルチ決済設定＞税率設定の課税規則が正しく設定されていません。(id=%errId%)',
    'remise_payment4.admin_config.text.tax_rate_errmsg.6' => 'マルチ決済設定＞税率設定の適用日時が正しく設定されていません。(id=%errId%)',
    'remise_payment4.admin_config.text.tax_rate_errmsg.7' => 'マルチ決済設定＞税率設定に適用中となる設定がありません。',
    'remise_payment4.admin_config.button.pluginlist' => 'プラグイン一覧',
    'remise_payment4.admin_config.button.regist' => '登録',
    'remise_payment4.admin_config.text.complete' => '登録しました。',
    'remise_payment4.admin_config.text.warning.card' => 'カード決済設定欄に値が入力されていますが、カード決済は有効になっていません。',
    'remise_payment4.admin_config.text.warning.cvs' => 'マルチ決済設定欄に値が入力されていますが、マルチ決済は有効になっていません。',
    'remise_payment4.admin_config.text.warning.extset' => 'カード決済拡張セット設定欄に値が入力されていますが、カード決済拡張セットは有効になっていません。',
    'remise_payment4.admin_config.text.warning.ac' => '定期購買設定欄に値が入力されていますが、定期購買は有効になっていません。',
    'remise_payment4.admin_payment.button.copy_payment' => '支払方法複製',
    'remise_payment4.admin_payment.text.copy_complete' => '支払方法を複製しました。',
    'remise_payment4.admin_order_edit.label.payment' => 'ルミーズ決済情報',
    'remise_payment4.admin_order_edit.label.card.job' => '処理区分',
    'remise_payment4.admin_order_edit.label.card.job.auth' => '仮売上',
    'remise_payment4.admin_order_edit.label.card.job.capture' => '売上',
    'remise_payment4.admin_order_edit.label.card.job.sales' => '売上済',
    'remise_payment4.admin_order_edit.label.card.job.void' => 'キャンセル',
    'remise_payment4.admin_order_edit.label.card.job.return' => 'キャンセル',
    'remise_payment4.admin_order_edit.label.card.job.other' => '―',
    'remise_payment4.admin_order_edit.label.card.salesdate' => '売上日',
    'remise_payment4.admin_order_edit.label.card.canceldate' => '取消日',
    'remise_payment4.admin_order_edit.label.card.tranid' => 'トランザクションID',
    'remise_payment4.admin_order_edit.label.cvs.acpt_state' => '収納状況',
    'remise_payment4.admin_order_edit.label.cvs.acpt_state.done' => '済',
    'remise_payment4.admin_order_edit.label.cvs.acpt_state.notyet' => '未',
    'remise_payment4.admin_order_edit.label.cvs.recdate' => '収納日',
    'remise_payment4.admin_order_edit.label.cvs.jobid' => 'ジョブID',
    'remise_payment4.admin_order_edit.button.cvs.detail' => 'お支払情報詳細',
    'remise_payment4.admin_order_edit.label.card.state.result.delete' => '受注確定処理',
    'remise_payment4.admin_order_edit.label.card.state.result.ac.failed' => '状態変更処理（課金失敗⇒課金成功）',
    'remise_payment4.admin_order_edit.text.card.state.result.warning' => '受注未確定の状態です。ルミーズ決済情報を確認してください。',
    'remise_payment4.admin_order_edit.text.card.state.result.ac.failed.warning' => '課金失敗の状態です。ルミーズ決済情報を確認してください。',
    'remise_payment4.admin_order_edit.text.card.state.result.help' => 'EC-CUBE 上で正常に注文処理が完了していない状態です。消費者様や管理者様への注文受付メールは送信されておりません。',
    'remise_payment4.admin_order_edit.text.card.state.result.ac.failed.help' => 'ルミーズの課金処理が失敗しています。 エラーの詳細はルミーズ加盟店バックヤードシステムにてご確認ください。',
    'remise_payment4.admin_order_edit.text.card.state.result.delete' => '「受注未確定」の状態を「受注確定済み」に変更します。よろしいですか？

ルミーズ加盟店バックヤードシステムにて対象となる決済が正常に成立している事を確認の上、実行ボタンを押して確定処理を行ってください。
また、加盟店様からの注文完了メールが消費者様に届いていないため、消費者様によっては2回決済をしてしまうことも想定されますので、メールの再送信やご購入意思の確認等のご対応をお願いいたします。

※一度確定を行うと、「受注未確定」の状態には戻せません。

＜受注未確定とは＞
注文手続きが正常に終了していない状態です。
EC-CUBE 上で正常に注文処理が完了していないため、消費者様や管理者様への注文受付メールは送信されておりません。
受注未確定となる原因は、消費者様が完了画面を見る前にブラウザを閉じてしまった、通信エラーで完了画面が表示できなかった等の理由が考えられます。
',
    'remise_payment4.admin_order_edit.text.card.state.result.ac.failed' => '「課金失敗」の状態を「課金成功」に変更します。よろしいですか？

課金失敗した受注情報について、消費者様から料金のお支払いが確認できましたら、課金成功に変更してください。

※一度確定を行うと、「課金失敗」の状態には戻せません。

＜課金失敗となる原因＞
「与信限度額のオーバー」、「有効期限切れ」などの、登録されているクレジットカードに問題がある場合が考えられます。
エラーの詳細は、ルミーズ加盟店バックヤードシステムにてご確認ください。

＜課金失敗した場合の対応方法＞
代表的な対応方法は以下の通りです。
・消費者様にクレジットカードを利用可能な状態にしていただき、
　ルミーズ加盟店バックヤードシステムにて再決済処理を行う。
　（クレジットカード情報の更新はマイページより行えます。）
・クレジットカード決済以外の手段で料金の請求を消費者様へ行う。
',
    'remise_payment4.admin_order_edit.button.card.state.result.delete' => '解除',
    'remise_payment4.admin_order_edit.text.card.state.result.delete.completed' => '受注確定処理が完了しました。',
    'remise_payment4.admin_order_edit.text.card.state.result.ac.success' => '状態変更処理（課金失敗⇒課金成功）が完了しました。',
    'remise_payment4.admin_customer_edit.label.payquick' => 'カードご利用情報',
    'remise_payment4.admin_customer_edit.text.payquick_delete.completed' => 'カードご利用情報を削除しました。',
    'remise_payment4.extset.common.label.plugin_code' => 'RemisePaymentExtset4',
    'remise_payment4.extset.common.label.plugin_name' => 'ルミーズカード決済拡張セットプラグイン',
    'remise_payment4.extset.admin_order_index.text.warning.plugin' => '拡張セットの設定情報がありません。プラグインの設定を見直してください。',
    'remise_payment4.extset.admin_order_index.text.warning.bat_request' => 'リクエストデータが正しくありません。',
    'remise_payment4.extset.admin_order_index.text.warning.notfound_card' => 'カード決済情報が見つかりません。',
    'remise_payment4.extset.admin_order_index.text.warning.not_auth' => '状態が「仮売上」でないため、処理できません。',
    'remise_payment4.extset.admin_order_index.text.success.sales' => '売上処理が完了しました。',
    'remise_payment4.extset.admin_order_index.text.failed.sales' => '一括売上処理においてエラーが発生しました。',
    'remise_payment4.extset.admin_order_index.text.failed.url' => '「ルミーズカード決済拡張セットプラグイン」で設定された決済情報送信先URLに接続できません。',
    'remise_payment4.extset.admin_order_edit.text.warning.plugin' => '拡張セットの設定情報がありません。プラグインの設定を見直してください。',
    'remise_payment4.extset.admin_order_edit.text.warning.bat_request' => 'リクエストデータが正しくありません。',
    'remise_payment4.extset.admin_order_edit.text.warning.notfound_card' => 'カード決済情報が見つかりません。',
    'remise_payment4.extset.admin_order_edit.text.warning.not_auth' => '状態が「仮売上」でないため、処理できません。',
    'remise_payment4.extset.admin_order_edit.text.warning.not_auth_or_capture' => '状態が「仮売上」または「売上」でないため、処理できません。',
    'remise_payment4.extset.admin_order_edit.text.success.sales' => '売上処理が完了しました。',
    'remise_payment4.extset.admin_order_edit.text.success.void' => '即日取消処理が完了しました。',
    'remise_payment4.extset.admin_order_edit.text.success.return' => '返品処理が完了しました。',
    'remise_payment4.extset.admin_order_edit.text.success.change' => '金額変更処理が完了しました。',
    'remise_payment4.extset.admin_order_edit.text.failed.error' => 'エラーが発生しました。',
    'remise_payment4.extset.admin_order_edit.text.failed.sales' => '売上処理においてエラーが発生しました。',
    'remise_payment4.extset.admin_order_edit.text.failed.void' => '即日取消処理においてエラーが発生しました。',
    'remise_payment4.extset.admin_order_edit.text.failed.return' => '返品処理においてエラーが発生しました。',
    'remise_payment4.extset.admin_order_edit.text.failed.change' => '金額変更処理においてエラーが発生しました。',
    'remise_payment4.extset.admin_order_edit.text.failed.url' => '「ルミーズカード決済拡張セットプラグイン」で設定された決済情報送信先URLに接続できません。',
    'remise_payment4.extset.admin_order_index.label.tooltip.description' => 'チェックを入れた受注に対して、ルミーズの一括処理を行います。充分に確認をしてから実行してください。',
    'remise_payment4.extset.admin_order_index.label.tooltip.title' => 'ルミーズ一括操作',
    'remise_payment4.extset.admin_order_index.label.remise_payment_extset4_select_sales' => 'ルミーズ一括売上処理',
    'remise_payment4.extset.admin_order_index.text.remise_payment_extset4_select_sales.nocheck' => 'チェックボックスが選択されていません',
    'remise_payment4.extset.admin_order_index.text.remise_payment_extset4_select_sales.confirm_msg1' => '選択された',
    'remise_payment4.extset.admin_order_index.text.remise_payment_extset4_select_sales.confirm_msg2' => '件の売上処理を行います。よろしいですか？',
    'remise_payment4.extset.admin_order_index_result.label.sub_title' => '一括売上処理結果',
    'remise_payment4.extset.admin_order_index_result.label.card_title' => '処理結果',
    'remise_payment4.extset.admin_order_index_result.label.count_inf1' => '件',
    'remise_payment4.extset.admin_order_index_result.label.count_inf2' => '(エラー',
    'remise_payment4.extset.admin_order_index_result.label.count_inf3' => ')処理されました',
    'remise_payment4.extset.admin_order_index_result.label.table.colname1' => '受注日',
    'remise_payment4.extset.admin_order_index_result.label.table.colname2' => '注文番号',
    'remise_payment4.extset.admin_order_index_result.label.table.colname3' => 'お名前',
    'remise_payment4.extset.admin_order_index_result.label.table.colname4' => '購入金額(円)',
    'remise_payment4.extset.admin_order_index_result.label.table.colname5' => '処理結果',
    'remise_payment4.extset.admin_order_edit.label.button.sales' => '売上を行う',
    'remise_payment4.extset.admin_order_edit.label.button.cancel' => 'キャンセルを行う',
    'remise_payment4.extset.admin_order_edit.label.button.change' => '金額変更を行う',
    'remise_payment4.extset.admin_order_edit.text.order_status.alert' => 'こちらの注文をキャンセルする場合は、クレジットカード決済のキャンセル処理を行ってください。
クレジットカード決済のキャンセル処理は自動では行われません。
',
    'remise_payment4.extset.admin_order_edit.text.order_payment.alert' => 'お支払方法を変更する場合は、クレジットカード決済のキャンセル処理を行ってください。
クレジットカード決済のキャンセル処理は自動では行われません。
',
    'remise_payment4.extset.admin_order_edit.text.sales.alert' => '金額が変更されています。
「金額変更を行う」後に再実行してください。
',
    'remise_payment4.extset.admin_order_edit.text.change.alert' => '金額は変更されていません。
計算結果の更新後、再実行してください。
',
    'remise_payment4.extset.admin_order_edit.text.sales.confirm_msg' => '売上処理を行います。よろしいですか？',
    'remise_payment4.extset.admin_order_edit.text.cancel.confirm_msg' => 'キャンセルを行います。よろしいですか？',
    'remise_payment4.extset.admin_order_edit.text.change.confirm_msg' => '金額変更を行います。よろしいですか？
※編集画面で変更された各設定値は更新されます。
',
    'remise_payment4.extset.admin_config.label.extset_setting' => 'カード決済拡張セット設定',
    'remise_payment4.extset.admin_config.label.extset_setting.note' => '（※この機能をご利用するには、「拡張セット」オプションのご契約が必要です。）',
    'remise_payment4.extset.admin_config.label.extset_hostid' => 'ホスト番号',
    'remise_payment4.extset.admin_config.text.extset_hostid' => 'ルミーズ加盟店バックヤードシステムにて、拡張セット専用のホストを作成いただき、そのホスト番号を入力してください。',
    'remise_payment4.extset.admin_config.text.extset_hostid.blank' => '「ホスト番号」を入力してください。',
    'remise_payment4.extset.admin_config.text.extset_hostid.unmatch.length' => '「ホスト番号」は5文字の英数字+3文字の数字で入力してください。',
    'remise_payment4.extset.admin_config.label.extset_recv_url' => '結果通知URL',
    'remise_payment4.extset.admin_config.text.extset_recv_url' => 'ルミーズ加盟店バックヤードシステムにて拡張セット専用に作成いただいたホストの「カード決済設定」タブ -「結果通知URL」に、上記URLを設定してください。',
    'remise_payment4.extset.admin_config.label.extset_card_url' => '決済情報送信先URL',
    'remise_payment4.extset.admin_config.text.extset_card_url' => '「設定情報連絡票」に記載の「カード決済情報送信先URL-拡張セット用」を設定してください。',
    'remise_payment4.extset.admin_config.text.extset_card_url.blank' => '「決済情報送信先URL」を入力してください。',
    'remise_payment4.extset.common.label.result.card.success' => '<SDBKDATA>STATUS=800</SDBKDATA>',
    'remise_payment4.ac.common.const.remise_autocharge_complete_ok' => '<SDBKDATA>STATUS=800</SDBKDATA>',
    'remise_payment4.ac.common.text.nonmember' => '非会員',
    'remise_payment4.ac.common.text.warning.plugin' => '定期購買の設定情報がありません。プラグインの設定を見直してください。',
    'remise_payment4.ac.common.text.warning.plugin.ac_result_url' => '定期購買結果取込用URLの設定がありません。プラグインの設定を見直してください。',
    'remise_payment4.ac.common.text.warning.plugin.ac_edit_url' => '定期購買更新用URLの設定がありません。プラグインの設定を見直してください。',
    'remise_payment4.ac.common.text.failed.not_connect.ac_result_url' => '定期購買結果取込用URLに接続できません。',
    'remise_payment4.ac.common.text.failed.not_connect.ac_edit_url' => '定期購買結果取込用URLに接続できません。',
    'remise_payment4.ac.common.text.failed.keizoku_result_extend.rcode_error' => 'アプリケーションID／パスワード、または加盟店コードが間違っています。',
    'remise_payment4.ac.common.text.failed.keizoku_result_extend.notfound' => '該当の「自動継続課金」の結果は存在しませんでした。',
    'remise_payment4.ac.common.text.failed.keizoku_result_extend.rcode_error_else' => 'ルミーズの「自動継続課金」の結果が取得できませんでした。(%rcode%)',
    'remise_payment4.ac.common.text.failed.keizoku_edit_extend.rcode_error' => 'アプリケーションID／パスワード、または加盟店コードが間違っています。',
    'remise_payment4.ac.common.text.failed.keizoku_edit_extend.rcode_error_else' => 'ルミーズの「自動継続課金」情報が取得できませんでした。(%rcode%)',
    'remise_payment4.ac.admin_type_edit.text.warning.notfound' => '対象の定期購買設定が見つかりませんでした。',
    'remise_payment4.ac.sale_type' => 1,
    'remise_payment4.ac.sale_type.name' => '定期購買商品',
    'remise_payment4.ac.delivery.name' => '定期購買配送業者',
    'remise_payment4.ac.delivery.service_name' => '定期購買配送',
    'remise_payment4.ac.delivery_fee.fee' => 1000,
    'remise_payment4.ac.csv_type' => 1,
    'remise_payment4.ac.csv_type.name' => '定期購買商品',
    'remise_payment4.ac.csv_type.ac_result' => 2,
    'remise_payment4.ac.csv_type.ac_result.name' => '自動継続課金取込結果',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.interval_marks.m.key' => 'M',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.interval_marks.m.value' => 'ヵ月ごと',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.interval_marks.d.key' => 'D',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.interval_marks.d.value' => '日ごと',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.day_of_month.99.value' => '購入した',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.after_marks.m.key' => 'M',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.after_marks.m.value' => 'ヵ月後',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.after_marks.d.key' => 'D',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.after_marks.d.value' => '日後',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.skip.true.key' => 1,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.skip.true.value' => 'スキップを許可',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.skip.false.key' => 0,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.skip.false.value' => 'スキップを不許可',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.stop.true.key' => 0,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.stop.true.value' => 'いつでも解約を許可',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.stop.false.key' => 1,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.stop.false.value' => '解約を不許可',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.stop.usage.key' => 2,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.stop.usage.value' => '最低利用期間中は解約を不許可',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.usage_mark.m.key' => 'M',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.usage_mark.m.value' => 'ヵ月',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.usage_mark.d.key' => 'D',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.usage_mark.d.value' => '日',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_type.count.value' => '回',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_member.status.0' => '停止',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_member.status.1' => '継続中',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_result.result.failure.key' => 0,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_result.result.failure.name' => '失敗',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_result.result.success.key' => 1,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_result.result.success.name' => '成功',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_result.result.first.key' => 9,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_result.result.first.name' => '初回購入',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import.import_flg_ini' => 0,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import.import_flg_ini.value' => '未取込',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import.import_flg_cmp' => 1,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import.import_flg_cmp.value' => '取込済',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import.import_flg_prs' => 2,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import.import_flg_prs.value' => '取込中',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import.import_flg_err' => 9,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import.import_flg_err.value' => '取込失敗',
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import_stack.exec_flg.false' => 0,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import_stack.exec_flg.true' => 1,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import_stack.complete_flg.false' => 0,
    'remise_payment4.ac.plg_remise_payment4_remise_ac_import_stack.complete_flg.true' => 1,
    'remise_payment4.ac.nav.management.title' => 'ルミーズ定期購買管理',
    'remise_payment4.ac.nav.import.title' => 'ルミーズ定期購買取込',
    'remise_payment4.ac.nav.type.edit.title' => 'ﾙﾐｰｽﾞ定期購買設定',
    'remise_payment4.ac.admin_config.label.setting' => '定期購買設定',
    'remise_payment4.ac.admin_config.label.setting.note' => '（※この機能をご利用するには、「 定期購買」オプションのご契約が必要です。）',
    'remise_payment4.ac.admin_config.label.ac_recv_url' => '継続課金結果通知URL',
    'remise_payment4.ac.admin_config.text.ac_recv_url' => 'ルミーズの「自動継続課金」の結果通知を受け取る場合は、上記URLをルミーズ加盟店バックヤードシステムの「各種設定」-「カード決済設定」-「自動継続課金結果通知URL」に設定してください。',
    'remise_payment4.ac.admin_config.label.info.1' => '以下は、オプション機能となります。',
    'remise_payment4.ac.admin_config.label.info.2' => '・ルミーズの「自動継続課金」の結果を受注情報として取り込む',
    'remise_payment4.ac.admin_config.label.info.3' => '・定期購買の設定をルミーズの「自動継続課金」に連動させる',
    'remise_payment4.ac.admin_config.label.info.4' => 'ルミーズから提供される設定資料を元に以下を設定してください。',
    'remise_payment4.ac.admin_config.label.ac_appid' => 'アプリケーションID',
    'remise_payment4.ac.admin_config.text.ac_appid.unmatch.length' => '「アプリケーションID」は8文字で入力してください。',
    'remise_payment4.ac.admin_config.text.ac_appid.blank' => '「アプリケーションID」を入力してください。',
    'remise_payment4.ac.admin_config.label.ac_password' => 'パスワード',
    'remise_payment4.ac.admin_config.text.ac_password.blank' => '「パスワード」を入力してください。',
    'remise_payment4.ac.admin_config.label.ac_result_url' => '定期購買結果取込用URL',
    'remise_payment4.ac.admin_config.text.ac_result_url' => 'ルミーズの「自動継続課金」の結果を受注情報として取り込む場合は、上記URLを設定してください。',
    'remise_payment4.ac.admin_config.label.ac_edit_url' => '定期購買更新用URL',
    'remise_payment4.ac.admin_config.text.ac_edit_url' => 'EC-CUBE上の定期購買の情報を変更する際、ルミーズの「自動継続課金」と連動させる場合は、上記URLを設定してください。',
    'remise_payment4.ac.admin_config.label.ac_acquisition_method' => '取込設定',
    'remise_payment4.ac.admin_config.label.ac_acquisition_method_real' => 'リアルタイム取込',
    'remise_payment4.ac.admin_config.label.ac_acquisition_method_batch' => 'バッチ取込',
    'remise_payment4.ac.admin_config.text.ac_acquisition_method_real' => 'リアルタイム取込：ルミーズの「自動継続課金」の結果通知を受け、リアルタイムで受注情報として取り込みます。',
    'remise_payment4.ac.admin_config.text.ac_acquisition_method_batch' => 'バッチ取込：ルミーズの「自動継続課金」の結果を「１回の処理あたりの取込件数」、受注情報として取り込みます。',
    'remise_payment4.ac.admin_config.text.ac_acquisition_method.note' => '「バッチ取込」を選択した場合、コマンドの定期実行の設定が必要です。<br>また、環境により「１回の処理あたりの取込件数」を調整する必要があります。<br>詳しくは<a href="http://www.remise.jp/data/ec-cube/" target="_blank">マニュアル</a>をご覧ください。',
    'remise_payment4.ac.admin_config.label.ac_max_number_acquisitions' => '１回の処理あたりの取込件数',
    'remise_payment4.ac.admin_config.label.ac_max_number_acquisitions.blank' => '「１回の処理あたりの取込件数」を入力してください。',
    'remise_payment4.ac.admin_config.label.ac_max_number_acquisitions.length' => '「１回の処理あたりの取込件数」は1以上9999以下で入力してください。',
    'remise_payment4.ac.masterdata.saletype.text.success' => 'ルミーズ定期購買用の販売種別を追加しました。',
    'remise_payment4.ac.masterdata.saletype.text.button' => 'ルミーズ定期購買用の販売種別を追加する',
    'remise_payment4.ac.admin_order_index.label.remise_payment4_ac_result_status' => '自動継続課金結果',
    'remise_payment4.ac.admin_order_index.label.remise_payment4_ac_member_id' => 'メンバーID(ルミーズ発番のID)',
    'remise_payment4.ac.admin_order_index.label.remise_payment4_ac_member_id.regex' => '「メンバーID」は半角英数字で入力してください。',
    'remise_payment4.ac.admin_management_index.label.title' => 'ルミーズ定期購買一覧',
    'remise_payment4.ac.admin_management_index.label.sub_title' => '受注管理',
    'remise_payment4.ac.admin_management_index.label.search.multi' => '会員番号・会員名・メンバーID',
    'remise_payment4.ac.admin_management_index.label.search.status' => '定期購買の状態',
    'remise_payment4.ac.admin_management_index.label.search.member_id' => 'メンバーID(ルミーズ発番のID)',
    'remise_payment4.ac.admin_management_index.label.search.member_id.regex' => '「メンバーID」は半角英数字で入力してください。',
    'remise_payment4.ac.admin_management_index.label.search.order_no' => '注文番号',
    'remise_payment4.ac.admin_management_index.label.search.order_no.regex' => '「注文番号」は半角数字で入力してください。',
    'remise_payment4.ac.admin_management_index.label.search.customer_id' => '会員番号',
    'remise_payment4.ac.admin_management_index.label.search.customer_id.regex' => '「会員番号」は半角数字で入力してください。',
    'remise_payment4.ac.admin_management_index.label.search.customer_name' => '会員名',
    'remise_payment4.ac.admin_management_index.label.search.customer_kana' => '会員名(フリガナ)',
    'remise_payment4.ac.admin_management_index.label.search.customer_kana.regex' => '「会員名(フリガナ)」はカタカナで入力してください。',
    'remise_payment4.ac.admin_management_index.label.search.customer_mail' => 'メールアドレス',
    'remise_payment4.ac.admin_management_index.label.search.customer_tel' => '電話番号(ハイフンなし)',
    'remise_payment4.ac.admin_management_index.label.search.customer_tel.regex' => '「電話番号」は半角数字で入力してください。',
    'remise_payment4.ac.admin_management_index.label.search.product_name' => '購入商品名',
    'remise_payment4.ac.admin_management_index.label.search.total' => '定期購買金額',
    'remise_payment4.ac.admin_management_index.label.search.total_start' => '定期購買金額(下限)',
    'remise_payment4.ac.admin_management_index.label.search.total_end' => '定期購買金額(上限)',
    'remise_payment4.ac.admin_management_index.label.search.order_date' => '受注日',
    'remise_payment4.ac.admin_management_index.label.search.order_date_start' => '受注日(下限)',
    'remise_payment4.ac.admin_management_index.label.search.order_date_end' => '受注日(上限)',
    'remise_payment4.ac.admin_management_index.label.search.next_date' => '次回課金日',
    'remise_payment4.ac.admin_management_index.label.search.next_date_start' => '次回課金日(下限)',
    'remise_payment4.ac.admin_management_index.label.search.next_date_end' => '次回課金日(上限)',
    'remise_payment4.ac.admin_management_index.label.table.colname1' => 'メンバーID',
    'remise_payment4.ac.admin_management_index.label.table.colname2' => '会員番号',
    'remise_payment4.ac.admin_management_index.label.table.colname3' => '会員名',
    'remise_payment4.ac.admin_management_index.label.table.colname4' => '商品名',
    'remise_payment4.ac.admin_management_index.label.table.colname5' => '初回注文番号',
    'remise_payment4.ac.admin_management_index.label.table.colname6' => '最新注文番号',
    'remise_payment4.ac.admin_management_index.label.table.colname7' => '定期購買金額(円)',
    'remise_payment4.ac.admin_management_index.label.table.colname8' => '次回課金日',
    'remise_payment4.ac.admin_management_index.label.table.colname9' => '状態',
    'remise_payment4.ac.admin_management_edit.label.title' => 'ルミーズ定期購買編集',
    'remise_payment4.ac.admin_management_edit.label.sub_title' => '受注管理',
    'remise_payment4.ac.admin_management_edit.label.status.status' => '定期購買の状態',
    'remise_payment4.ac.admin_management_edit.label.status.next_order_date' => '次回課金日',
    'remise_payment4.ac.admin_management_edit.label.status.first_order_date' => '初回課金日',
    'remise_payment4.ac.admin_management_edit.label.status.final_order_date' => '最終課金予定日',
    'remise_payment4.ac.admin_management_edit.label.status.update_date' => '更新日時',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.title' => '定期購買情報',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.status.stop' => '定期購買を停止する',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.status.restart' => '定期購買を再開する',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.stop_option.title1' => '＋停止オプション',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.stop_option.title2' => '－停止オプション',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.stop_option.value' => 'ルミーズの「自動継続課金」も停止',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.restart_option.title1' => '＋再開オプション',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.restart_option.title2' => '－再開オプション',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.restart_option.value' => 'ルミーズの「自動継続課金」も再開',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.restart_option.note' => '※定期購買を再開する場合、「ルミーズ加盟店バックヤードシステム」でも再開処理が必要です。',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.member_id.caption' => 'メンバーID',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.member_id.caption2' => '（ルミーズ発番のID）',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.next_date.caption' => '次回課金日',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.next_date.error' => '次回課金日は明日以降の日付を設定してください。',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.total.caption' => '定期購買金額',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.count.caption1' => '購買回数',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.count.caption2' => '回、継続して購入します。',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.count.caption3' => '回数を指定せず、無制限とする',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.count.caption4' => '回数を指定する',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.count.blank' => '「購買回数」を入力してください。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.count.unmatch.length' => '「購買回数」は1以上999以下で入力してください。',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.interval.caption1' => '課金間隔',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.interval.caption2' => 'に課金を行います。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.interval.blank1' => '「課金間隔」を入力してください。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.interval.blank2' => '「課金間隔」の単位を選択してください。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.interval.unmatch.length' => '「課金間隔」は1以上999以下で入力してください。',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.day_of_month.caption1' => '課金日',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.day_of_month.caption2' => '毎月',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.day_of_month.caption3' => '日',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.day_of_month.explain1' => '※月単位で決済を行う場合の課金日となります。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.day_of_month.explain2' => '※課金日が 28 ～ 30 日となる場合、月によっては設定された日付で課金が行われない可能性がございます。 詳しくは<a href="http://www.remise.jp/data/ec-cube/" target="_blank">マニュアル</a>をご覧ください。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.day_of_month.blank' => '「課金日」の日付を選択してください。',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.skip.caption' => 'スキップ',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.skip.explain' => '※スキップは、会員がマイページのご注文履歴詳細から次回購入分をスキップすることが可能となる機能です。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.skip.blank' => '「スキップ」の種別を選択してください。',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.stop.caption' => '定期購買の解約',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.stop.explain' => '※定期購買の解約は、会員がマイページのご注文履歴詳細から定期購買の解約をすることが可能となる機能です。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.stop.blank' => '「定期購買の解約」のリストを選択してください。',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.usage.caption1' => '最低利用期間',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.usage.caption2' => 'の間、解約をできなくします。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.usage.blank1' => '「最低利用期間」を入力してください。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.usage.blank2' => '「最低利用期間」の単位を選択してください。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.usage.unmatch.length' => '「最低利用期間」は0以上999以下で入力してください。',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.note.caption' => 'メモ',
    'remise_payment4.ac.admin_management_edit.label.block.acmember.note.button' => 'メモを保存する',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.note.explain' => '※メモのみを保存します。メモ以外の情報は保存されません。',
    'remise_payment4.ac.admin_management_edit.text.block.acmember.note.confirm_msg' => 'メモの保存を行います。よろしいですか？',
    'remise_payment4.ac.admin_management_edit.label.block.option.title' => '更新オプション',
    'remise_payment4.ac.admin_management_edit.label.block.option.update_option' => 'ルミーズとの連携',
    'remise_payment4.ac.admin_management_edit.text.block.option.update_option.explain1' => '※この機能はプラグイン設定画面にて自動継続課金APIを設定している場合のみご利用できます。',
    'remise_payment4.ac.admin_management_edit.text.block.option.update_option.explain2' => '設定変更時にルミーズの「自動継続課金」と連動させます。',
    'remise_payment4.ac.admin_management_edit.text.block.option.update_option.explain3' => '無効の場合、ECCUBE上の設定のみ更新され、ルミーズの「自動継続課金」は更新されません。ルミーズ加盟店バックヤードシステムから変更を行う必要があります。',
    'remise_payment4.ac.admin_management_edit.text.block.option.update_option.error' => '自動継続課金APIの設定が無いため、有効にできません。',
    'remise_payment4.ac.admin_management_edit.label.block.customer.title' => '注文者情報',
    'remise_payment4.ac.admin_management_edit.label.block.customer.id' => '会員ID',
    'remise_payment4.ac.admin_management_edit.label.block.customer.name' => 'お名前',
    'remise_payment4.ac.admin_management_edit.label.block.customer.kana' => 'お名前(フリガナ)',
    'remise_payment4.ac.admin_management_edit.label.block.customer.address' => '住所',
    'remise_payment4.ac.admin_management_edit.label.block.customer.mail_address' => 'メールアドレス',
    'remise_payment4.ac.admin_management_edit.label.block.customer.phone_number' => '電話番号',
    'remise_payment4.ac.admin_management_edit.label.block.customer.company_name' => '会社名',
    'remise_payment4.ac.admin_management_edit.label.block.order.title' => '受注商品情報',
    'remise_payment4.ac.admin_management_edit.label.block.shipping.title' => 'お届け先情報',
    'remise_payment4.ac.admin_management_edit.label.block.shipping.name' => 'お名前',
    'remise_payment4.ac.admin_management_edit.label.block.shipping.kana' => 'お名前(フリガナ)',
    'remise_payment4.ac.admin_management_edit.label.block.shipping.company_name' => '会社名',
    'remise_payment4.ac.admin_management_edit.label.block.shipping.address' => '住所',
    'remise_payment4.ac.admin_management_edit.label.block.shipping.phone_number' => '電話番号',
    'remise_payment4.ac.admin_management_edit.label.block.shipping.delivery_name' => '配送業者',
    'remise_payment4.ac.admin_management_edit.label.block.shipping.delivery_time' => 'お届け時間',
    'remise_payment4.ac.admin_management_edit.label.block.shipping.delivery_date' => 'お届け日',
    'remise_payment4.ac.admin_management_edit.label.block.order_history.title' => '購入履歴',
    'remise_payment4.ac.admin_management_edit.label.block.order_history.ac_result' => '課金結果',
    'remise_payment4.ac.admin_management_edit.label.block.order_history.order_date' => '購入日時',
    'remise_payment4.ac.admin_management_edit.label.block.order_history.order_id' => '注文番号',
    'remise_payment4.ac.admin_management_edit.label.block.order_history.order_total' => '購入金額',
    'remise_payment4.ac.admin_management_edit.label.block.order_history.order_shipping_date' => '出荷日',
    'remise_payment4.ac.admin_management_edit.label.block.order_history.order_status' => '対応状況',
    'remise_payment4.ac.admin_management_edit.text.submit.confirm_msg1' => 'ルミーズの「自動継続課金」と合わせて、定期購買を更新します。\\nよろしいですか？',
    'remise_payment4.ac.admin_management_edit.text.submit.confirm_msg2' => '定期購買情報を更新します。\\nよろしいですか？\\n\\n※ルミーズの「自動継続課金」は連動しません。\\n「ルミーズ加盟店バックヤードシステム」から変更を行ってください。',
    'remise_payment4.ac.admin_management_edit.text.submit.stop.confirm_msg1' => 'ルミーズの「自動継続課金」と合わせて、定期購買を停止します。\\nよろしいですか？\\n\\n※ルミーズの「自動継続課金」が既に停止している場合は、“ルミーズの「自動継続課金」も停止”のチェックを外して実行してください。',
    'remise_payment4.ac.admin_management_edit.text.submit.stop.confirm_msg2' => '定期購買を停止します。\\n≪　ルミーズの「自動継続課金」は停止処理を行いません。　≫\\n\\nよろしいですか？',
    'remise_payment4.ac.admin_management_edit.text.submit.restart.confirm_msg1' => 'ルミーズの「自動継続課金」と合わせて、定期購買を再開します。\\nよろしいですか？\\n\\n※ルミーズの「自動継続課金」が既に再開している場合は、“ルミーズの「自動継続課金」も再開”のチェックを外して実行してください。',
    'remise_payment4.ac.admin_management_edit.text.submit.restart.confirm_msg2' => '定期購買を再開します。\\n≪　ルミーズの「自動継続課金」は再開処理を行いません。　≫\\n\\nよろしいですか？',
    'remise_payment4.ac.admin_management_edit.text.warning.plugin' => '定期購買の設定情報がありません。プラグインの設定を見直してください。',
    'remise_payment4.ac.admin_management_edit.text.warning.plugin.ac_edit_url' => '定期購買更新用URLの設定がありません。プラグインの設定を見直してください。',
    'remise_payment4.ac.admin_management_edit.text.failed.url' => '定期購買更新用URLに接続できません。',
    'remise_payment4.ac.admin_management_edit.text.failed.noupdate' => 'ルミーズの「自動継続課金」が更新できませんでした。(%rcode%)',
    'remise_payment4.ac.admin_management_edit.text.success.stop' => '定期購買の停止処理が完了しました。',
    'remise_payment4.ac.admin_management_edit.text.success.restart' => '定期購買の再開処理が完了しました。',
    'remise_payment4.ac.admin_management_edit.text.success.update' => '定期購買の更新処理が完了しました。',
    'remise_payment4.ac.admin_management_edit.text.success.note' => 'メモの保存が完了しました。',
    'remise_payment4.ac.admin_management_edit.text.stop.warning.plugin' => 'プラグインの設定がありません。プラグインの設定を見直してください。',
    'remise_payment4.ac.admin_management_edit.text.stop.warning.plugin.card_url' => 'カード決済設定の決済情報送信先URLの設定がありません。プラグインの設定を見直してください。',
    'remise_payment4.ac.admin_import_index.label.title' => 'ルミーズ定期購買取込一覧',
    'remise_payment4.ac.admin_import_index.label.sub_title' => '受注管理',
    'remise_payment4.ac.admin_import_index.label.import_form.title' => 'ルミーズの「自動継続課金」の結果取込条件',
    'remise_payment4.ac.admin_import_index.label.import_form.member_id' => 'メンバーID（ルミーズ発番のID）',
    'remise_payment4.ac.admin_import_index.label.import_form.member_id.note' => 'メンバー個別で結果取込を行う場合は、上記を設定してください。',
    'remise_payment4.ac.admin_import_index.label.import_form.member_id.regex' => '「メンバーID」は半角英数字で入力してください。',
    'remise_payment4.ac.admin_import_index.label.import_form.import_date' => '取込対象の課金日',
    'remise_payment4.ac.admin_import_index.label.import_form.import_date.blank' => '「取込対象の課金日」を選択してください。',
    'remise_payment4.ac.admin_import_index.label.import_form.import_count' => '取込件数',
    'remise_payment4.ac.admin_import_index.label.import_form.import_count_all' => '全件',
    'remise_payment4.ac.admin_import_index.label.import_form.import_count_set' => '件数指定',
    'remise_payment4.ac.admin_import_index.label.import_form.import_count_start' => '取込開始件数',
    'remise_payment4.ac.admin_import_index.label.import_form.import_count_end' => '取込終了件数',
    'remise_payment4.ac.admin_import_index.label.import_form.import_count_start.length' => '「取込開始件数」は1以上9999以下で入力してください。',
    'remise_payment4.ac.admin_import_index.label.import_form.import_count_end.length' => '「取込終了件数」は1以上9999以下で入力してください。',
    'remise_payment4.ac.admin_import_index.label.import_form.import_count_start.blank' => '「取込開始件数」を入力してください。',
    'remise_payment4.ac.admin_import_index.label.import_form.import_count_end.blank' => '「取込終了件数」を入力してください。',
    'remise_payment4.ac.admin_import_index.label.import_form.import_button' => '自動継続課金の結果を受注情報に取り込む',
    'remise_payment4.ac.admin_import_index.label.import_form.submit.confirm_msg' => 'ルミーズの自動継続課金の結果を受注情報に取り込みます。\\nよろしいですか？',
    'remise_payment4.ac.admin_import_index.text.failed.notfound_member' => '該当メンバーの「自動継続課金」の結果は存在しませんでした。',
    'remise_payment4.ac.admin_import_index.label.table.count' => '自動継続課金結果通知 %count% 件',
    'remise_payment4.ac.admin_import_index.label.table.th.column1' => '課金成功件数(件)',
    'remise_payment4.ac.admin_import_index.label.table.th.column2' => '課金成功金額(円)',
    'remise_payment4.ac.admin_import_index.label.table.th.column3' => '課金失敗件数(件)',
    'remise_payment4.ac.admin_import_index.label.table.th.column4' => '課金失敗金額(円)',
    'remise_payment4.ac.admin_import_index.label.table.th.column5' => '処理総件数(件)',
    'remise_payment4.ac.admin_import_index.label.table.th.column6' => '処理総額(円)',
    'remise_payment4.ac.admin_import_index.label.table.th.column7' => '課金日時',
    'remise_payment4.ac.admin_import_index.label.table.th.column8' => '取込状況',
    'remise_payment4.ac.admin_import_index.label.table.th.column9' => '取込総件数(件)',
    'remise_payment4.ac.admin_import_index.label.table.th.column10' => '取込日時',
    'remise_payment4.ac.admin_import_index.label.table.td.column11' => '取込条件へ設定',
    'remise_payment4.ac.admin_import_result.label.table.title' => '取込結果',
    'remise_payment4.ac.admin_import_result.label.table.th.column1' => 'メンバーID',
    'remise_payment4.ac.admin_import_result.label.table.th.column2' => '会員番号',
    'remise_payment4.ac.admin_import_result.label.table.th.column3' => '注文番号',
    'remise_payment4.ac.admin_import_result.label.table.th.column4' => '定期購買金額(円)',
    'remise_payment4.ac.admin_import_result.label.table.th.column5' => '課金結果',
    'remise_payment4.ac.admin_import_result.label.table.th.column6' => '取込状況',
    'remise_payment4.ac.admin_import_result.label.table.th.column7' => '備考',
    'remise_payment4.ac.admin_import_result.text.s_kaiin_no.null' => '非会員',
    'remise_payment4.ac.admin_import_result.text.import.key' => 1,
    'remise_payment4.ac.admin_import_result.text.import.value' => '取込済み',
    'remise_payment4.ac.admin_import_result.text.not_import.key' => 0,
    'remise_payment4.ac.admin_import_result.text.not_import.value' => '未取込',
    'remise_payment4.ac.admin_import_result.text.note.captured' => '該当メンバーの受注情報は取込済みです。',
    'remise_payment4.ac.admin_import_result.text.note.member_notimport' => '該当メンバーの自動継続課金情報が取得できませんでした。(%rcode%)',
    'remise_payment4.ac.admin_import_result.text.note.member_notfound' => '該当メンバーの「自動継続課金」の結果は存在しませんでした。',
    'remise_payment4.ac.admin_import_result.text.note.member_notupdate' => 'EC-CUBEとルミーズの定期購買情報に差異があるため、定期購買情報の最新化ができませんでした。(差異のある項目：%errMsg%)<br>EC-CUBEまたはルミーズの定期購買情報の設定値を見直してください。',
    'remise_payment4.ac.admin_import_result.text.note.member_difference' => 'EC-CUBEの合計金額と、ルミーズの「自動継続課金」の定期購買金額に差額が発生しています。<br>受注情報の明細を見直してください。',
    'remise_payment4.ac.admin_import_result.text.success' => '自動継続課金の結果を取り込みました。',
    'remise_payment4.ac.admin_import_result.text.failure' => '自動継続課金の結果取込に失敗しました。',
    'remise_payment4.ac.admin_type_edit_index.label.title' => 'ルミーズ定期購買設定一覧',
    'remise_payment4.ac.admin_type_edit_index.label.sub_title' => '店舗設定',
    'remise_payment4.ac.admin_type_edit_index.label.table.colname1' => 'ID',
    'remise_payment4.ac.admin_type_edit_index.label.table.colname2' => '名称',
    'remise_payment4.ac.admin_type_edit_index.label.table.colname3' => '購買回数',
    'remise_payment4.ac.admin_type_edit_index.label.table.colname4' => '課金間隔',
    'remise_payment4.ac.admin_type_edit_index.label.table.colname5' => '課金日',
    'remise_payment4.ac.admin_type_edit_index.label.table.colname6' => '開始時期',
    'remise_payment4.ac.admin_type_edit_index.text.count.limit' => '回',
    'remise_payment4.ac.admin_type_edit_index.text.count.limitless' => '無制限',
    'remise_payment4.ac.admin_type_edit_index.text.day_of_month.day' => '日',
    'remise_payment4.ac.admin_type_edit_index.text.error.delete' => '対象の定期購買設定は既に商品管理で使用されているため削除できません。',
    'remise_payment4.ac.admin_type_edit.label.title' => 'ルミーズ定期購買設定',
    'remise_payment4.ac.admin_type_edit.label.sub_title' => '店舗設定',
    'remise_payment4.ac.admin_type_edit.label.block.edit.title' => '定期購買登録・編集',
    'remise_payment4.ac.admin_type_edit.label.block.edit.name.caption' => '名称',
    'remise_payment4.ac.admin_type_edit.text.block.edit.name.blank' => '「名称」を入力してください。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.name.unmatch.length' => '「名称」は255byte以内で入力してください。',
    'remise_payment4.ac.admin_type_edit.label.block.edit.count.caption1' => '購買回数',
    'remise_payment4.ac.admin_type_edit.label.block.edit.count.caption2' => '回、継続して購入します。',
    'remise_payment4.ac.admin_type_edit.label.block.edit.count.caption3' => '回数を指定せず、無制限とする',
    'remise_payment4.ac.admin_type_edit.label.block.edit.count.caption4' => '回数を指定する',
    'remise_payment4.ac.admin_type_edit.text.block.edit.count.explain' => '※初回購入分は上記回数に含まれません。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.count.blank' => '「購買回数」を入力してください。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.count.unmatch.length' => '「購買回数」は1以上999以下で入力してください。',
    'remise_payment4.ac.admin_type_edit.label.block.edit.interval.caption1' => '課金間隔',
    'remise_payment4.ac.admin_type_edit.label.block.edit.interval.caption2' => 'に課金を行います。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.interval.blank1' => '「課金間隔」を入力してください。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.interval.blank2' => '「課金間隔」の単位を選択してください。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.interval.unmatch.length' => '「課金間隔」は1以上999以下で入力してください。',
    'remise_payment4.ac.admin_type_edit.label.block.edit.day_of_month.caption1' => '課金日',
    'remise_payment4.ac.admin_type_edit.label.block.edit.day_of_month.caption2' => '毎月',
    'remise_payment4.ac.admin_type_edit.label.block.edit.day_of_month.caption3' => '日',
    'remise_payment4.ac.admin_type_edit.text.block.edit.day_of_month.explain1' => '※月単位で決済を行う場合の課金日となります。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.day_of_month.explain2' => '※課金日が 28 ～ 30 日となる場合、月によっては設定された日付で課金が行われない可能性がございます。 詳しくは<a href="http://www.remise.jp/data/ec-cube/" target="_blank">マニュアル</a>をご覧ください。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.day_of_month.blank' => '「課金日」の日付を選択してください。',
    'remise_payment4.ac.admin_type_edit.label.block.edit.after.caption1' => '開始時期',
    'remise_payment4.ac.admin_type_edit.label.block.edit.after.caption2' => '購入後、',
    'remise_payment4.ac.admin_type_edit.label.block.edit.after.caption3' => 'より、課金を開始します。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.after.blank1' => '「開始時期」を入力してください。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.after.blank2' => '「開始時期」の単位を選択してください。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.after.unmatch.length' => '「開始時期」は1以上999以下で入力してください。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.after.month_select_error' => '月単位の課金間隔を指定した場合は、月単位「ヵ月後」を選択してください。',
    'remise_payment4.ac.admin_type_edit.label.block.edit.skip.caption' => 'スキップ',
    'remise_payment4.ac.admin_type_edit.text.block.edit.skip.explain' => '※スキップは、会員がマイページのご注文履歴詳細から次回購入分をスキップすることが可能となる機能です。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.skip.blank' => '「スキップ」の種別を選択してください。',
    'remise_payment4.ac.admin_type_edit.label.block.edit.stop.caption' => '定期購買の解約',
    'remise_payment4.ac.admin_type_edit.text.block.edit.stop.explain' => '※定期購買の解約は、会員がマイページのご注文履歴詳細から定期購買の解約をすることが可能となる機能です。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.stop.blank' => '「定期購買の解約」のリストを選択してください。',
    'remise_payment4.ac.admin_type_edit.label.block.edit.usage.caption1' => '最低利用期間',
    'remise_payment4.ac.admin_type_edit.label.block.edit.usage.caption2' => 'の間、解約をできなくします。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.usage.blank1' => '「最低利用期間」を入力してください。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.usage.blank2' => '「最低利用期間」の単位を選択してください。',
    'remise_payment4.ac.admin_type_edit.text.block.edit.usage.unmatch.length' => '「最低利用期間」は0以上999以下で入力してください。',
    'remise_payment4.ac.admin_type_edit.label.block.simulation.title' => '購入シミュレーション',
    'remise_payment4.ac.admin_type_edit.text.block.simulation.title.explain' => '上記設定値を用い、入力された購入日から初回課金日を算出します。',
    'remise_payment4.ac.admin_type_edit.label.block.simulation.purchase date.caption' => '課金日',
    'remise_payment4.ac.admin_type_edit.text.block.simulation.purchase date.notformat' => '「課金日」を正しく入力してください。',
    'remise_payment4.ac.admin_type_edit.label.block.simulation.initial_billing_date.caption' => '初回課金日',
    'remise_payment4.ac.admin_type_edit.label.block.simulation.final_billing_due_date.caption' => '最終課金予定日',
    'remise_payment4.ac.admin_type_edit.text.block.simulation.default_date' => '----/--/--',
    'remise_payment4.ac.admin_product.label.title' => 'ルミーズ定期購買設定',
    'remise_payment4.ac.admin_product.text.tooltip' => '対象商品が定期購買商品の場合のみ表示されます。',
    'remise_payment4.ac.admin_product.label.amount.caption' => '定期購買金額',
    'remise_payment4.ac.admin_product.text.amount.blank' => '「定期購買金額」を入力してください。',
    'remise_payment4.ac.admin_product.text.amount.error' => '販売種別に定期購買商品以外が選択されているため、入力できません。',
    'remise_payment4.ac.admin_product.text.amount.unmatch.length' => '「定期購買金額」は1以上99999999以下で入力してください。',
    'remise_payment4.ac.admin_product.label.actype.caption' => '定期購買設定',
    'remise_payment4.ac.admin_product.text.actype.blank' => '「定期購買設定」を選択してください。',
    'remise_payment4.ac.admin_product.text.actype.error' => '販売種別に定期購買商品以外が選択されているため、入力できません。',
    'remise_payment4.ac.admin_product.label.acpoint.caption' => '定期購買ポイント設定',
    'remise_payment4.ac.admin_product.text.acpoint.note' => 'EC-CUBEのポイント機能が有効の場合、定期購買取込時にポイントが付与されます。<br>※無効にしても、初回購入時はポイントが付与されます。',
    'remise_payment4.ac.admin_product_class.label.thead.th.amount.title' => 'ルミーズ<br>定期購買金額',
    'remise_payment4.ac.admin_product_class.label.thead.th.actype.title' => 'ルミーズ<br>定期購買設定',
    'remise_payment4.ac.admin_product_class.label.thead.th.acpoint.title' => 'ルミーズ<br>ポイント設定',
    'remise_payment4.ac.admin_customer_index.text.alert_msg' => '定期購買継続中の会員のため、削除ができません。定期購買の解約を先に行ってください。',
    'remise_payment4.ac.admin_delivery_edit.text.payments_err' => 'クレジットカード決済が指定されていない、もしくはクレジットカード決済以外の支払方法が指定されています。',
    'remise_payment4.ac.front.cart.duplicate.text' => '恐れ入りますが、定期購買の商品を含む場合は１商品ずつの購入をお願い致します。',
    'remise_payment4.ac.front.shopping.acinfo.title' => '定期購買情報',
    'remise_payment4.ac.front.payment.senddata.autocharge' => 1,
    'remise_payment4.ac.front.payment.senddata.autocharge.stop' => 0,
    'remise_payment4.ac.front.payment.senddata.ac_tax' => 0,
    'remise_payment4.ac.front.payment.senddata.job.check' => 'CHECK',
    'remise_payment4.ac.remise_payment4_ac_result.error' => '自動継続課金結果通知にてエラーが発生しました。',
    'remise_payment4.ac.front.mypage_history_autocharge.label.title' => '定期購買情報',
    'remise_payment4.ac.front.mypage_history_autocharge.label.sub_title.autocharge_info' => '購買情報',
    'remise_payment4.ac.front.mypage_history_autocharge.label.member_id' => 'メンバーID：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.total' => '定期購買金額：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.start_date' => '課金開始日：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.count' => '購買回数：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.interval' => '課金間隔：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.next_date' => '次回課金日：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.stop_date' => '課金停止予定日：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.usage' => '最低利用期間：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.skip' => 'スキップ：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.skip_button' => 'スキップを行う',
    'remise_payment4.ac.front.mypage_history_autocharge.label.stop' => '解約について：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.status' => '状態：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.stoped' => '解約済み',
    'remise_payment4.ac.front.mypage_history_autocharge.label.stop_button' => '解約を行う',
    'remise_payment4.ac.front.mypage_history_autocharge.label.sub_title.card_info' => 'カード情報',
    'remise_payment4.ac.front.mypage_history_autocharge.label.cardparts' => 'カード番号：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.expire' => '有効期限：',
    'remise_payment4.ac.front.mypage_history_autocharge.label.card_update_button' => 'カード情報を更新する',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.label.title' => 'マイページ/ご注文履歴詳細/登録カード情報更新',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.label.cardparts' => 'カード番号',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.label.expire' => '有効期限',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.text.card_info' => '現在のご登録のカード情報は以下の通りです。',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.label.update' => '更新する',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.label.back' => '戻る',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.text.update.warning.plugin' => '登録カード情報の更新に失敗しました。',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.text.update.warning.plugin.card_url' => '登録カード情報の更新に失敗しました。',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.text.update.error' => '登録カード情報の更新に失敗しました。',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.text.update.error_else' => '登録カード情報の更新処理にて想定外のエラーが発生。',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.text.update.success' => '登録カード情報の更新に成功しました。',
    'remise_payment4.ac.front.sub_mypage_ac_card_update.text.update.success2' => '今後ともご愛顧賜りますよう、よろしくお願い申し上げます。',
    'remise_payment4.ac.front.sub_mypage_ac_skip.label.title' => 'マイページ/ご注文履歴詳細/定期購買スキップ',
    'remise_payment4.ac.front.sub_mypage_ac_skip.label.member_id' => '定期購買　メンバーID',
    'remise_payment4.ac.front.sub_mypage_ac_skip.label.total' => '定期購買金額',
    'remise_payment4.ac.front.sub_mypage_ac_skip.label.skip_next_date_before' => 'スキップする次回課金日',
    'remise_payment4.ac.front.sub_mypage_ac_skip.label.skip_next_date_after' => 'スキップ後の次回課金日',
    'remise_payment4.ac.front.sub_mypage_ac_skip.label.next_date' => '次回課金日',
    'remise_payment4.ac.front.sub_mypage_ac_skip.label.skip' => 'スキップする',
    'remise_payment4.ac.front.sub_mypage_ac_skip.label.back' => '戻る',
    'remise_payment4.ac.front.sub_mypage_ac_skip.text.skip_info' => '以下の定期購買のご注文を１回分スキップします。<br>一度スキップすると、次回課金日までスキップはできなくなります。',
    'remise_payment4.ac.front.sub_mypage_ac_skip.text.skipped_info' => '以下の定期購買のご注文につきまして、１回分スキップしました。',
    'remise_payment4.ac.front.sub_mypage_ac_skip.text.skip_confirm' => '以上の内容でよろしければ、「スキップする」ボタンをクリックしてください。',
    'remise_payment4.ac.front.sub_mypage_ac_skip.text.skip.warning.not_keizoku_edit_extend' => '自動継続課金APIの設定が無いため、スキップできません。',
    'remise_payment4.ac.front.sub_mypage_ac_skip.text.skip.warning.skipped' => 'この定期購買のご注文は既にスキップ処理済みです。',
    'remise_payment4.ac.front.sub_mypage_ac_skip.text.skip.error' => '定期購買のスキップ処理に失敗しました。',
    'remise_payment4.ac.front.sub_mypage_ac_skip.text.skip.success' => '定期購買のスキップ処理が完了いたしました。',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.label.title' => 'マイページ/ご注文履歴詳細/定期購買解約',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.label.member_id' => '定期購買　メンバーID',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.label.total' => '定期購買金額',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.label.mail' => '登録メールアドレス',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.label.cancel' => '解約する',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.label.back' => '戻る',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.text.cancel_info' => '以下の定期購買のご注文を解約します。',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.text.canceled_info' => '以下の定期購買のご注文につきまして、解約処理が完了いたしました。',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.text.cancel_confirm' => '定期購買を解約されますと、今後はサービスを受けられなくなります。<br>以上の内容で間違いなければ、「解約する」ボタンをクリックしてください。',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.text.cancel.error' => '定期購買の解約手続きに失敗しました。',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.text.cancel.error_else' => '定期購買の解約処理にて想定外のエラーが発生。',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.text.canlel.success' => '定期購買の解約手続きが完了いたしました。',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.text.canlel.success2' => '定期購買サービスをご利用いただき誠にありがとうございました。<br>またのご利用を心よりお待ち申し上げます。',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.text.canlel.warning.plugin' => '定期購買の解約手続きに失敗しました。',
    'remise_payment4.ac.front.sub_mypage_ac_cancel.text.canlel.warning.plugin.card_url' => '定期購買の解約手続きに失敗しました。',
    'remise_payment4.ac.front.sub_mypage_withdraw.text.info1' => '退会手続きができません。',
    'remise_payment4.ac.front.sub_mypage_withdraw.text.info2' => '定期購買継続中のご注文情報があるため、退会手続きができません。<br>下記に表示されているご注文情報の解約手続きを先に行っていただく必要があります。',
    'remise_payment4.ac.front.sub_mypage_withdraw.text.info3' => '定期購買の解約は「マイページ」＞「ご注文履歴」＞「詳細を見る」ボタン＞「定期購買情報」欄の「解約を行う」ボタンから行えます。',
    'remise_payment4.ac.front.sub_mypage_withdraw.text.table.th1' => 'ご注文番号',
    'remise_payment4.ac.front.sub_mypage_withdraw.text.table.th2' => '商品名',
    'remise_payment4.ac.csv_items.active.1.disp_name' => '会員番号',
    'remise_payment4.ac.csv_items.active.1.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.active.1.field_name' => 'customer_id',
    'remise_payment4.ac.csv_items.active.1.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.active.2.disp_name' => 'お名前(姓)',
    'remise_payment4.ac.csv_items.active.2.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.active.2.field_name' => 'name01',
    'remise_payment4.ac.csv_items.active.2.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.active.3.disp_name' => 'お名前(名)',
    'remise_payment4.ac.csv_items.active.3.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.active.3.field_name' => 'name02',
    'remise_payment4.ac.csv_items.active.3.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.active.4.disp_name' => '商品名',
    'remise_payment4.ac.csv_items.active.4.entity_name' => 'Eccube\\\\Entity\\\\OrderItem',
    'remise_payment4.ac.csv_items.active.4.field_name' => 'product_name',
    'remise_payment4.ac.csv_items.active.4.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.active.5.disp_name' => '初回注文番号',
    'remise_payment4.ac.csv_items.active.5.entity_name' => 'Eccube\\Entity\\Order',
    'remise_payment4.ac.csv_items.active.5.field_name' => 'first_order_id',
    'remise_payment4.ac.csv_items.active.5.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.active.6.disp_name' => '最新注文番号',
    'remise_payment4.ac.csv_items.active.6.entity_name' => 'Eccube\\Entity\\Order',
    'remise_payment4.ac.csv_items.active.6.field_name' => 'latest_order_id',
    'remise_payment4.ac.csv_items.active.6.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.active.7.disp_name' => '定期購買金額',
    'remise_payment4.ac.csv_items.active.7.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.active.7.field_name' => 'total',
    'remise_payment4.ac.csv_items.active.7.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.active.8.disp_name' => '次回課金日',
    'remise_payment4.ac.csv_items.active.8.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.active.8.field_name' => 'next_date',
    'remise_payment4.ac.csv_items.active.8.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.active.9.disp_name' => '状態',
    'remise_payment4.ac.csv_items.active.9.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.active.9.field_name' => 'status',
    'remise_payment4.ac.csv_items.active.9.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.active.10.disp_name' => 'メンバーID',
    'remise_payment4.ac.csv_items.active.10.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.active.10.field_name' => 'member_id',
    'remise_payment4.ac.csv_items.active.10.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.active.11.disp_name' => '備考',
    'remise_payment4.ac.csv_items.active.11.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.active.11.field_name' => 'note',
    'remise_payment4.ac.csv_items.active.11.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.1.disp_name' => 'お名前(セイ)',
    'remise_payment4.ac.csv_items.nonactive.1.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.nonactive.1.field_name' => 'kana01',
    'remise_payment4.ac.csv_items.nonactive.1.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.2.disp_name' => 'お名前(メイ)',
    'remise_payment4.ac.csv_items.nonactive.2.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.nonactive.2.field_name' => 'kana02',
    'remise_payment4.ac.csv_items.nonactive.2.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.3.disp_name' => '会社名',
    'remise_payment4.ac.csv_items.nonactive.3.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.nonactive.3.field_name' => 'company_name',
    'remise_payment4.ac.csv_items.nonactive.3.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.4.disp_name' => '郵便番号',
    'remise_payment4.ac.csv_items.nonactive.4.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.nonactive.4.field_name' => 'postal_code',
    'remise_payment4.ac.csv_items.nonactive.4.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.5.disp_name' => '都道府県',
    'remise_payment4.ac.csv_items.nonactive.5.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.nonactive.5.field_name' => 'pref',
    'remise_payment4.ac.csv_items.nonactive.5.reference_field_name' => 'name',
    'remise_payment4.ac.csv_items.nonactive.6.disp_name' => '住所1',
    'remise_payment4.ac.csv_items.nonactive.6.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.nonactive.6.field_name' => 'addr01',
    'remise_payment4.ac.csv_items.nonactive.6.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.7.disp_name' => '住所2',
    'remise_payment4.ac.csv_items.nonactive.7.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.nonactive.7.field_name' => 'addr02',
    'remise_payment4.ac.csv_items.nonactive.7.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.8.disp_name' => 'メールアドレス',
    'remise_payment4.ac.csv_items.nonactive.8.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.nonactive.8.field_name' => 'email',
    'remise_payment4.ac.csv_items.nonactive.8.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.9.disp_name' => 'TEL',
    'remise_payment4.ac.csv_items.nonactive.9.entity_name' => 'Eccube\\Entity\\Customer',
    'remise_payment4.ac.csv_items.nonactive.9.field_name' => 'phone_number',
    'remise_payment4.ac.csv_items.nonactive.9.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.10.disp_name' => '課金回数',
    'remise_payment4.ac.csv_items.nonactive.10.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.nonactive.10.field_name' => 'count',
    'remise_payment4.ac.csv_items.nonactive.10.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.11.disp_name' => '課金間隔',
    'remise_payment4.ac.csv_items.nonactive.11.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.nonactive.11.field_name' => 'interval',
    'remise_payment4.ac.csv_items.nonactive.11.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.12.disp_name' => '課金日',
    'remise_payment4.ac.csv_items.nonactive.12.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.nonactive.12.field_name' => 'day_of_month',
    'remise_payment4.ac.csv_items.nonactive.12.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.13.disp_name' => '開始時期',
    'remise_payment4.ac.csv_items.nonactive.13.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.nonactive.13.field_name' => 'after',
    'remise_payment4.ac.csv_items.nonactive.13.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.14.disp_name' => 'スキップ',
    'remise_payment4.ac.csv_items.nonactive.14.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.nonactive.14.field_name' => 'skip_flg',
    'remise_payment4.ac.csv_items.nonactive.14.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.15.disp_name' => '解約',
    'remise_payment4.ac.csv_items.nonactive.15.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.nonactive.15.field_name' => 'stop_flg',
    'remise_payment4.ac.csv_items.nonactive.15.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.16.disp_name' => '最低利用期間',
    'remise_payment4.ac.csv_items.nonactive.16.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.nonactive.16.field_name' => 'usage',
    'remise_payment4.ac.csv_items.nonactive.16.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.17.disp_name' => '課金開始日',
    'remise_payment4.ac.csv_items.nonactive.17.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.nonactive.17.field_name' => 'start_date',
    'remise_payment4.ac.csv_items.nonactive.17.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.18.disp_name' => '課金停止予定日',
    'remise_payment4.ac.csv_items.nonactive.18.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.nonactive.18.field_name' => 'stop_date',
    'remise_payment4.ac.csv_items.nonactive.18.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.19.disp_name' => '作成日時',
    'remise_payment4.ac.csv_items.nonactive.19.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.nonactive.19.field_name' => 'create_date',
    'remise_payment4.ac.csv_items.nonactive.19.reference_field_name' => NULL,
    'remise_payment4.ac.csv_items.nonactive.20.disp_name' => '更新日時',
    'remise_payment4.ac.csv_items.nonactive.20.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACMember',
    'remise_payment4.ac.csv_items.nonactive.20.field_name' => 'update_date',
    'remise_payment4.ac.csv_items.nonactive.20.reference_field_name' => NULL,
    'remise_payment4.ac.csv_ac_result_items.active.1.disp_name' => '注文番号',
    'remise_payment4.ac.csv_ac_result_items.active.1.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACImportInfo',
    'remise_payment4.ac.csv_ac_result_items.active.1.field_name' => 'order_id',
    'remise_payment4.ac.csv_ac_result_items.active.1.reference_field_name' => NULL,
    'remise_payment4.ac.csv_ac_result_items.active.2.disp_name' => 'メンバーID',
    'remise_payment4.ac.csv_ac_result_items.active.2.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACImportInfo',
    'remise_payment4.ac.csv_ac_result_items.active.2.field_name' => 'member_id',
    'remise_payment4.ac.csv_ac_result_items.active.2.reference_field_name' => NULL,
    'remise_payment4.ac.csv_ac_result_items.active.3.disp_name' => '会員番号',
    'remise_payment4.ac.csv_ac_result_items.active.3.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACImportInfo',
    'remise_payment4.ac.csv_ac_result_items.active.3.field_name' => 's_kaiin_no',
    'remise_payment4.ac.csv_ac_result_items.active.3.reference_field_name' => NULL,
    'remise_payment4.ac.csv_ac_result_items.active.4.disp_name' => '定期購買金額',
    'remise_payment4.ac.csv_ac_result_items.active.4.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACImportInfo',
    'remise_payment4.ac.csv_ac_result_items.active.4.field_name' => 'ac_amount',
    'remise_payment4.ac.csv_ac_result_items.active.4.reference_field_name' => NULL,
    'remise_payment4.ac.csv_ac_result_items.active.5.disp_name' => '課金結果',
    'remise_payment4.ac.csv_ac_result_items.active.5.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACImportInfo',
    'remise_payment4.ac.csv_ac_result_items.active.5.field_name' => 'ac_result',
    'remise_payment4.ac.csv_ac_result_items.active.5.reference_field_name' => NULL,
    'remise_payment4.ac.csv_ac_result_items.active.6.disp_name' => '取込状況',
    'remise_payment4.ac.csv_ac_result_items.active.6.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACImportInfo',
    'remise_payment4.ac.csv_ac_result_items.active.6.field_name' => 'status',
    'remise_payment4.ac.csv_ac_result_items.active.6.reference_field_name' => NULL,
    'remise_payment4.ac.csv_ac_result_items.active.7.disp_name' => '備考',
    'remise_payment4.ac.csv_ac_result_items.active.7.entity_name' => 'Plugin\\RemisePayment4\\Entity\\RemiseACImportInfo',
    'remise_payment4.ac.csv_ac_result_items.active.7.field_name' => 'note',
    'remise_payment4.ac.csv_ac_result_items.active.7.reference_field_name' => NULL,
    'related_product.type.comment.placeholder' => '説明文を入力してください(HTMLタグ使用可)。',
    'related_product.modal.product_search.title' => '商品検索',
    'related_product.modal.product_search.input_name' => '商品名・ID・コード',
    'related_product.select_product' => '商品を選択',
    'related_product.remove_product' => '削除',
    'related_product.block.title' => '関連商品',
    'plugin_recommend.admin.navi' => 'おすすめ管理',
    'plugin_recommend.admin.not_found' => 'おすすめ商品が存在しません。',
    'plugin_recommend.admin.register.success' => 'おすすめ商品を登録しました。',
    'plugin_recommend.admin.update.success' => 'おすすめ商品を修正しました。',
    'plugin_recommend.admin.delete.success' => 'おすすめ商品を削除しました。',
    'plugin_recommend.admin.delete.confirm' => 'おすすめ情報を削除してもよろしいですか？',
    'plugin_recommend.admin.type.product.not_found' => '商品を追加してください。',
    'plugin_recommend.admin.type.comment.placeholder' => '説明文を入力してください(HTMLタグ使用可)。',
    'plugin_recommend.admin.index.title' => 'おすすめ商品管理',
    'plugin_recommend.admin.index.subtitle' => 'おすすめ商品内容設定',
    'plugin_recommend.admin.index.total_num' => '<strong>%number% 件</strong> が該当しました',
    'plugin_recommend.admin.index.col2' => '商品画像',
    'plugin_recommend.admin.index.col3' => '商品名',
    'plugin_recommend.admin.index.col4' => '説明文',
    'plugin_recommend.admin.index.delete.confirm' => 'このおすすめ商品を削除しても宜しいですか？',
    'plugin_recommend.admin.notice' => '項目の順番はドラッグ＆ドロップでも変更可能です。',
    'plugin_recommend.admin.new' => 'おすすめ商品を新規登録',
    'plugin_recommend.admin.edit.title' => 'おすすめ商品管理',
    'plugin_recommend.admin.edit.subtitle' => 'おすすめ商品内容設定',
    'plugin_recommend.admin.edit.header' => 'おすすめ商品情報',
    'plugin_recommend.admin.edit.product' => '商品',
    'plugin_recommend.admin.edit.comment' => '説明文',
    'plugin_recommend.admin.edit.comment.help' => '（最大%number%文字）',
    'plugin_recommend.admin.edit.existed' => 'この商品はすでにおすすめ商品として登録されています。',
    'plugin_recommend.admin.edit.search' => '商品の追加',
    'plugin_recommend.admin.edit.product_search.header' => '商品検索',
    'plugin_recommend.admin.edit.product_search.button' => '検索',
    'common.select' => '選択してください',
    'common.select__pref' => '都道府県を選択',
    'common.select__unspecified' => '指定なし',
    'common.select__all_products' => '全ての商品',
    'common.required' => '必須',
    'common.back' => '戻る',
    'common.close' => '閉じる',
    'common.send' => '送信する',
    'common.registration' => '登録する',
    'common.change' => '変更',
    'common.delete' => '削除',
    'common.ok' => 'OK',
    'common.cancel' => 'キャンセル',
    'common.go_to_top' => 'トップページへ',
    'common.go_to_cart' => 'カートへ進む',
    'common.go_to_confirm' => '確認ページへ',
    'common.go_to_next' => '次のページへ',
    'common.move_to_page_top' => 'ページトップへ',
    'common.prev' => '前へ',
    'common.next' => '次へ',
    'common.first' => '最初へ',
    'common.last' => '最後へ',
    'common.name' => 'お名前',
    'common.kana' => 'お名前(カナ)',
    'common.first_name' => '名',
    'common.last_name' => '姓',
    'common.first_name_kana' => 'メイ',
    'common.last_name_kana' => 'セイ',
    'common.company_name' => '会社名',
    'common.shop_name' => '店名',
    'common.address' => '住所',
    'common.pref' => '都道府県',
    'common.postal_symbol' => '〒',
    'common.postal_code_sample' => '例：5300001',
    'common.search_postal_code' => '郵便番号検索',
    'common.address_sample_01' => '市区町村名(例：大阪市北区)',
    'common.address_sample_02' => '番地・ビル名(例：西梅田1丁目6-8)',
    'common.phone_number' => '電話番号',
    'common.phone_number_sample' => '例：11122223333',
    'common.mail_address' => 'メールアドレス',
    'common.mail_address_sample' => '例：ec-cube@example.com',
    'common.repeated_confirm' => '確認のためもう一度入力してください',
    'common.password' => 'パスワード',
    'common.password_sample' => '半角英数記号%min%〜%max%文字',
    'common.password_eq_email' => 'パスワードはメールアドレスと同じ値を設定できません。',
    'common.password_for_confirmation' => 'パスワード(確認)',
    'common.gender' => '性別',
    'common.job' => '職業',
    'common.birth_day' => '生年月日',
    'common.tax_include' => '税込',
    'common.separator__range' => '〜',
    'common.separator__colon' => '：',
    'common.quantity' => '数量',
    'common.quantity__with_separator' => '数量：',
    'common.subtotal' => '小計',
    'common.subtotal__with_separator' => '小計：',
    'common.total' => '合計',
    'common.total__with_separator' => '合計：',
    'common.payment_total' => 'お支払い合計',
    'common.reduced_tax_rate_symbol' => '※',
    'common.reduced_tax_rate_messeage' => '※ は軽減税率対象商品です。',
    'common.tax_rate_target' => '税率 %rate% %対象',
    'common.delivery_fee' => '送料',
    'common.charge' => '手数料',
    'common.discount' => '値引き',
    'common.point' => 'ポイント',
    'common.enabled' => '有効',
    'common.disabled' => '無効',
    'common.user_name' => '%last_name% %first_name% 様',
    'common.user_name.honor' => '様',
    'common.login' => 'ログイン',
    'common.remember_me' => '次回から自動的にログインする',
    'common.signup' => '新規会員登録',
    'common.forgot_login' => 'ログイン情報をお忘れですか？',
    'common.customer_address_count_is_over' => 'お届け先登録の上限の%count%件に達しています。お届け先を入力したい場合は、削除か変更を行ってください。',
    'common.search_keyword' => 'キーワードを入力',
    'common.delete_confirm' => '削除してもよろしいですか?',
    'common.pagetop' => 'ページトップへ',
    'common.name.prefix' => '',
    'common.name.suffix' => ' 様',
    'front.block.cart.go_to_cart' => 'カートへ進む',
    'front.block.cart.no_item' => '現在カート内に商品はございません。',
    'front.block.footer.about_us' => '当サイトについて',
    'front.block.footer.privacy_policy' => 'プライバシーポリシー',
    'front.block.footer.inquiry' => 'お問い合わせ',
    'front.block.footer.act_on_specified_commercial_transactions' => '特定商取引法に基づく表記',
    'front.block.category.list' => 'カテゴリ一覧',
    'front.block.category.category__en' => 'CATEGORY',
    'front.block.category.category__ja' => 'カテゴリ',
    'front.block.topic.topic__en' => 'TOPICS',
    'front.block.topic.topic__ja' => '特集',
    'front.block.topic.title__gelato' => '濃厚なのにアイスよりヘルシー!! ジェラート特集',
    'front.block.topic.title__ice' => 'サクサク食感が魅力!! コーンアイス特集',
    'front.block.eyecatch.title__en' => 'CUBE GELATO ICE',
    'front.block.eyecatch.title__ja' => '彩のジェラート"CUBE"をご堪能ください。',
    'front.block.eyecatch.descriptiron' => 'ジェラートとはイタリアン・アイスクリームのことで、一般的なアイスクリームに比べて、乳脂肪分が低いのが特徴です。
当店では厳選した旬の果物のおいしさをそのままジェラートに仕上げました。風味が濃厚でありながら、甘さ控えめでヘルシーなキューブジェラートをご堪能ください。
さらにジェラートの製法を活かした、アイスキャンディ・アイスサンドも販売しております。
',
    'front.block.eyecatch.description' => 'ジェラートとはイタリアン・アイスクリームのことで、一般的なアイスクリームに比べて、乳脂肪分が低くいのが特徴です。
当店では厳選した旬の果物のおいしさをそのままジェラートに仕上げました。風味が濃厚でありながら、甘さ控えめでヘルシーなキューブジェラートをご堪能ください。
さらにジェラートの製法を活かした、アイスキャンディ・アイスサンドも販売しております。
',
    'front.block.eyecatch.view_list' => '一覧を見る',
    'front.block.new_item.title__en' => 'NEW ITEM',
    'front.block.new_item.title__ja' => '新着商品',
    'front.block.new_item.more' => 'more',
    'front.block.new_item.item_1_name' => '彩のジェラート"CUBE"',
    'front.block.new_item.item_1_price' => '￥1,200(税込)',
    'front.block.new_item.item_2_name' => 'チェリーアイスサンド',
    'front.block.new_item.item_2_price' => '￥800(税込)',
    'front.block.new_item.item_3_name' => '彩のジェラート"CUBE" NEO',
    'front.block.new_item.item_3_price' => '￥600(税込)',
    'front.block.news.title__en' => 'NEWS',
    'front.block.news.title__ja' => '新着情報',
    'front.block.news.read_more' => 'more',
    'front.block.news.see_details' => '詳しくはこちら',
    'front.block.login.customer_registration' => '新規会員登録',
    'front.block.login.mypage' => 'マイページ',
    'front.block.login.favorite' => 'お気に入り',
    'front.block.login.login' => 'ログイン',
    'front.block.login.logout' => 'ログアウト',
    'front.block.login.to_cart' => 'カートを見る',
    'front.block.login.to_home' => 'ホームに戻る',
    'front.contact.title' => 'お問い合わせ',
    'front.contact.inquiry_notice' => '内容によっては回答をさしあげるのにお時間をいただくこともございます。
また、休業日は翌営業日以降の対応となりますのでご了承ください。
',
    'front.contact.order_notice' => 'ご注文に関するお問い合わせには、必ず「ご注文番号」をご記入くださいますようお願いいたします。',
    'front.contact.inquiry_contents' => 'お問い合わせ内容',
    'front.contact.complete_title' => 'お問い合わせ(完了)',
    'front.contact.complete_message__title' => 'お問い合わせ内容の送信が完了いたしました',
    'front.contact.complete_message__body' => '万一、ご確認メールが届かない場合は、トラブルの可能性もありますので大変お手数ではございますがもう一度お問い合わせいただくか、お電話にてお問い合わせくださいませ。',
    'front.entry.title' => '新規会員登録',
    'front.entry.terms' => '利用規約',
    'front.entry.agree_with_terms' => '<a class="ec-link" href="%url%" target="_blank">利用規約</a>に同意してお進みください',
    'front.entry.agree' => '同意する',
    'front.entry.disagree' => '同意しない',
    'front.entry.confirm_title' => '新規会員登録(確認)',
    'front.entry.confirm_message' => '下記の内容で登録してもよろしいでしょうか？
よろしければ、一番下の「会員登録をする」ボタンをクリックしてください。
',
    'front.entry.do_register' => '会員登録をする',
    'front.entry.complete_title' => '新規会員登録(完了)',
    'front.entry.complete_title__temporary' => '新規会員登録(仮登録完了)',
    'front.entry.complete_message__title' => '会員登録ありがとうございます',
    'front.entry.complete_message__temporary' => '現在、仮会員の状態です。ただいま、ご入力いただいたメールアドレス宛に、ご本人様確認用のメールをお送りいたしました。
メール本文内のURLをクリックすると、本会員登録が完了となります。
',
    'front.entry.complete_message__activated' => '会員登録が完了しました。
それでは、ショッピングをお楽しみください。
',
    'front.forgot.title' => 'パスワードの再発行',
    'front.forgot.message1' => 'ご登録時のメールアドレスを入力して「次へ」ボタンをクリックしてください。',
    'front.forgot.message2' => '※パスワード再発行メールを送信します。メールの内容をご確認の上、新しいパスワードを登録してください。',
    'front.forgot.complete_title' => 'パスワードの再発行(メール送信)',
    'front.forgot.complete_message__title' => 'パスワード再発行メールの送信が完了しました。',
    'front.forgot.complete_message__body' => 'ご登録メールアドレスにパスワードを再発行するためのメールを送信いたしました。
メールの内容をご確認いただきますよう、お願いいたします。
※メールが届かない場合はメールアドレスをご確認の上、再度お試しください。
',
    'front.forgot.reset_title' => 'パスワード再発行(再設定)',
    'front.forgot.reset_complete' => 'パスワードを更新しました。',
    'front.forgot.reset_error' => '有効期限が切れているか、無効なURLです。',
    'front.forgot.reset_not_found' => '入力内容を確認してください。',
    'front.about.title' => '当サイトについて',
    'front.about.business_hour' => '店舗営業時間',
    'front.about.good_traded' => '取り扱い商品',
    'front.about.message' => 'メッセージ',
    'front.agreement.title' => '利用規約',
    'front.tradelaw.title' => '特定商取引法に基づく表記',
    'front.privacy.title' => 'プライバシーポリシー',
    'front.guide.title' => 'ご利用ガイド',
    'front.mypage.welcome' => 'ようこそ%last_name% %first_name%さん',
    'front.mypage.title' => 'マイページ',
    'front.mypage.welcome__point' => '現在の所持ポイントは %point%pt です。',
    'front.mypage.nav__history' => 'ご注文履歴',
    'front.mypage.nav__history_detail' => 'ご注文履歴詳細',
    'front.mypage.nav__favorite' => 'お気に入り一覧',
    'front.mypage.nav__customer' => '会員情報編集',
    'front.mypage.nav__customer_complete' => '会員情報編集(完了)',
    'front.mypage.nav__customer_address' => 'お届け先一覧',
    'front.mypage.nav__withdrow' => '退会手続き',
    'front.mypage.history_count' => '%count%件の履歴があります',
    'front.mypage.history_not_found' => 'ご注文履歴はありません。',
    'front.mypage.message_not_found' => '記載なし',
    'front.mypage.view_detail' => '詳細を見る',
    'front.mypage.order_no' => 'ご注文番号',
    'front.mypage.order_status' => 'ご注文状況',
    'front.mypage.order_date' => 'ご注文日時',
    'front.mypage.use_point' => 'ご利用ポイント',
    'front.mypage.add_point' => '加算ポイント',
    'front.mypage.delivery_info' => '配送情報',
    'front.mypage.delivery' => 'お届け先',
    'front.mypage.delivery_provider' => '配送方法',
    'front.mypage.delivery_date' => 'お届け日',
    'front.mypage.delivery_time' => 'お届け時間',
    'front.mypage.current_price' => '【現在価格】',
    'front.mypage.reorder' => '再注文する',
    'front.mypage.payment_info' => 'お支払い情報',
    'front.mypage.payment' => 'お支払い方法',
    'front.mypage.message' => 'お問い合わせ',
    'front.mypage.reorder_message' => '※金額が変更されている商品があるため、再注文時はご注意ください。',
    'front.mypage.mail_not_found' => 'メール履歴はありません。',
    'front.mypage.mail_list' => 'メール配信履歴一覧',
    'front.mypage.customer_complete_message__title' => '会員登録内容の変更が完了いたしました',
    'front.mypage.customer_complete_message__body' => 'それでは、引き続きショッピングをお楽しみください。',
    'front.mypage.favorite_count' => '%count%件のお気に入りがあります',
    'front.mypage.favorite_not_found' => 'お気に入りは登録されていません。',
    'front.mypage.customer_address_count' => '%count%件のお届け先があります',
    'front.mypage.customer_address_not_found' => 'お届け先は登録されていません。',
    'front.mypage.add_customer_address' => '新規お届け先を追加する',
    'front.mypage.withdraw_message__title' => '退会手続きの前にご確認ください',
    'front.mypage.withdraw_message__body' => '退会手続きが完了した時点で、現在保存されている購入履歴やお届け先等の情報は、すべて削除されますのでご注意ください。',
    'front.mypage.withdraw_execute_message__title' => '退会手続きを実行してもよろしいでしょうか？',
    'front.mypage.withdraw_confirm' => '退会手続きへ',
    'front.mypage.withdraw_cancel' => 'いいえ、退会しません',
    'front.mypage.withdraw_execute' => 'はい、退会します',
    'front.mypage.withdraw_complete_message__title' => '退会が完了いたしました',
    'front.mypage.withdraw_complete_message__body' => 'ご利用いただき誠にありがとうございました。
またのご来店をお待ちしております。
',
    'front.product.all_category' => '全て',
    'front.product.search_result' => '検索結果',
    'front.product.all_products' => '全商品',
    'front.product.search__category_not_found' => 'ご指定のカテゴリは存在しません',
    'front.product.search__product_not_found' => 'お探しの商品は見つかりませんでした',
    'front.product.search_result__keyword' => '「%name%」の検索結果',
    'front.product.search_result__detail' => '<span class="ec-font-bold">%count%件</span><span>の商品が見つかりました</span>',
    'front.product.add_cart' => 'カートに入れる',
    'front.product.add_cart_complete' => 'カートに追加しました。',
    'front.product.add_cart_error' => 'カートへの追加に失敗しました。',
    'front.product.add_favorite' => 'お気に入りに追加',
    'front.product.add_favorite_alrady' => 'お気に入りに追加済です。',
    'front.product.out_of_stock' => 'ただいま品切れ中です。',
    'front.product.out_of_stock_label' => '(品切れ中)',
    'front.product.added_to_favorite' => 'お気に入りに追加済です。',
    'front.product.normal_price' => '通常価格',
    'front.product.sale_price' => '販売価格',
    'front.product.code' => '商品コード',
    'front.product.related_category' => '関連カテゴリ',
    'front.product.continue' => 'お買い物を続ける',
    'front.product.invalid_quantity' => '1以上で入力してください。',
    'front.product.product_class_unselected' => '項目が選択されていません',
    'front.cart.title' => 'ショッピングカート',
    'front.cart.nav__cart_items' => 'カートの商品',
    'front.cart.nav__customer_info' => 'お客様情報',
    'front.cart.nav__order' => 'ご注文手続き',
    'front.cart.nav__confirm' => 'ご注文内容確認',
    'front.cart.nav__complete' => '完了',
    'front.cart.total_price' => '商品の合計金額は「<strong>%price%</strong>」です。',
    'front.cart.divide_cart' => '同時購入できない商品がカートに含まれています。',
    'front.cart.delete' => '削除',
    'front.cart.delete__confirm' => 'カートから商品を削除してよろしいですか？',
    'front.cart.product' => '商品内容',
    'front.cart.checkout' => 'レジに進む',
    'front.cart.continue' => 'お買い物を続ける',
    'front.cart.no_items' => '現在カート内に商品はございません。',
    'front.cart.delivery_fee_free__now' => '現在送料無料です。',
    'front.cart.delivery_fee_free__price_and_quantity' => 'あと「<strong>%price%</strong>」または「<strong>%quantity%個</strong>」のお買い上げで<strong class="ec-color-red">送料無料</strong>になります。',
    'front.cart.delivery_fee_free__price' => 'あと「<strong>%price%</strong>」のお買い上げで<strong class="ec-color-red">送料無料</strong>になります。',
    'front.cart.delivery_fee_free__quantity' => 'あと「<strong>%quantity%個</strong>」のお買い上げで<strong class="ec-color-red">送料無料</strong>になります。',
    'front.shopping.title' => 'ご注文手続き',
    'front.shopping.order_no' => 'ご注文番号',
    'front.shopping.customer_info' => 'お客様情報',
    'front.shopping.delivery_info' => '配送情報',
    'front.shopping.delivery_to' => 'お届け先',
    'front.shopping.delivery_provider' => '配送方法',
    'front.shopping.delivery_date' => 'お届け日',
    'front.shopping.delivery_time' => 'お届け時間',
    'front.shopping.to_multiple' => 'お届け先を追加する',
    'front.shopping.payment_info' => 'お支払方法',
    'front.shopping.point_info' => '利用ポイント',
    'front.shopping.available_point' => '%point% pt が利用可能です。',
    'front.shopping.point_prev' => '利用ポイント',
    'front.shopping.prev_point' => 'ご注文前のポイント',
    'front.shopping.next_point' => 'ご注文後のポイント',
    'front.shopping.add_point' => '加算ポイント',
    'front.shopping.use_point' => 'ご利用ポイント',
    'front.shopping.message_info' => 'お問い合わせ',
    'front.shopping.message_placeholder' => 'お問い合わせ事項がございましたら、こちらにご入力ください。(3000文字まで)',
    'front.shopping.go_to_confirm' => '確認する',
    'front.shopping.back_to_cart' => 'カートに戻る',
    'front.shopping.shipping_title' => 'お届け先の指定',
    'front.shopping.shipping_add_new_shipping' => '新規お届け先を追加する',
    'front.shopping.shipping_add_new_shipping__short' => 'お届け先追加',
    'front.shopping.shipping_unselected' => 'お届け先を指定してください',
    'front.shopping.shipping_send_selected_shipping' => '選択したお届け先に送る',
    'front.shopping.shipping_multiple_title' => 'お届け先の複数指定',
    'front.shopping.shipping_multiple_message' => '各商品のお届け先を選択してください。',
    'front.shppping.shipping_multiple_add_shipping' => '各商品のお届け先を選択してください。',
    'front.shopping.confirm_title' => 'ご注文内容のご確認',
    'front.shopping.checkout' => '注文する',
    'front.shopping.back_to_order' => 'ご注文手続きに戻る',
    'front.shopping.complete_title' => 'ご注文完了',
    'front.shopping.complete_message__title' => 'ご注文ありがとうございました',
    'front.shopping.complete_message__body' => 'ただいま、ご注文の確認メールをお送りさせていただきました。
万一、ご確認メールが届かない場合は、トラブルの可能性もありますので大変お手数ではございますがお問い合わせくださいますようお願いいたします。
',
    'front.shopping.continue' => '購入を続ける',
    'front.shopping.guest_purchase_message' => '会員登録をせずに購入手続きをされたい方は、下記よりお進みください。',
    'front.shopping.guest_purchase' => 'ゲスト購入',
    'front.shopping.nonmember' => 'お客様情報の入力',
    'front.shopping.shipping_edit_title_nomember' => '商品購入/お届け先の変更',
    'front.shopping.shipping_edit_header_customer' => 'お届け先の追加',
    'front.shopping.shipping_edit_header_nonmember' => 'お届け先の変更',
    'front.shopping.error' => '購入エラー',
    'front.shopping.order_error' => '購入処理でエラーが発生しました。',
    'front.shopping.system_error' => '購入処理で予期しないエラーが発生しました。恐れ入りますがお問い合わせページよりご連絡ください。',
    'front.shopping.empty_items_error' => 'ご注文手続きが正常に完了しませんでした。大変お手数ですが、再度ご注文手続きをお願いします。',
    'front.shopping.out_of_stock' => '「%product%」の在庫が不足しております。一度に在庫数を超える購入はできません。',
    'front.shopping.over_sale_limit' => '「%product%」は販売制限しております。一度に販売制限数を超える購入はできません。',
    'front.shopping.out_of_stock_zero' => '「%product%」の在庫が不足しております。該当商品をカートから削除しました。',
    'front.shopping.over_price_limit' => '商品を購入できる金額の上限を超えております。数量を調整してください。',
    'front.shopping.in_preparation' => '「%product%」はまだ配送の準備ができておりません。恐れ入りますがお問い合わせページよりお問い合わせください。',
    'front.shopping.not_purchase' => '現時点で購入できない商品が含まれておりました。該当商品をカートから削除しました。',
    'front.shopping.price_changed' => '「%product%」の販売価格が変更されました。',
    'front.shopping.payment_total_invalid' => '合計金額が不正です。',
    'front.shopping.different_payment_methods' => '支払い方法が異なる商品が含まれているため、同時に購入することはできません。',
    'front.shopping.payment_method_unselected' => 'お支払い方法を選択してください。',
    'front.shopping.payment_method_not_fount' => '選択できるお支払い方法がありません。配送方法が異なる場合は同じ配送方法を選んでください。',
    'admin.common.save_complete' => '保存しました',
    'admin.common.save_error' => '保存に失敗しました',
    'admin.common.delete_complete' => '削除しました',
    'admin.common.delete_error' => '削除に失敗しました',
    'admin.common.delete_error_foreign_key' => '関連するデータがあるため「%name%」を削除できませんでした',
    'admin.common.delete_error_already_deleted' => '既に削除されています',
    'admin.common.move_complete' => '並び順を更新しました',
    'admin.common.move_error' => '並び順の更新に失敗しました',
    'admin.common.upload_complete' => 'アップロードしました',
    'admin.common.upload_error' => 'アップロードに失敗しました',
    'admin.common.csv_upload_complete' => 'CSVファイルをアップロードしました',
    'admin.common.csv_upload_error' => 'CSVファイルのアップロードに失敗しました',
    'admin.common.send_complete' => 'メールを送信しました',
    'admin.common.send_error' => 'メールの送信に失敗しました',
    'admin.common.create_complete' => '作成しました',
    'admin.common.system_error' => 'システムエラーが発生しました',
    'admin.common.to_show_complete' => '「%name%」を表示にしました。',
    'admin.common.to_hide_complete' => '「%name%」を非表示にしました。',
    'admin.common.save' => '保存',
    'admin.common.registration' => '登録',
    'admin.common.registration__new' => '新規登録',
    'admin.common.edit' => '編集',
    'admin.common.copy' => '複製',
    'admin.common.display' => '表示',
    'admin.common.copy_path' => 'パスをコピー',
    'admin.common.copy_path_complete' => 'パスをコピーしました',
    'admin.common.delete' => '削除',
    'admin.common.cancel' => 'キャンセル',
    'admin.common.search' => '検索',
    'admin.common.send' => '送信',
    'admin.common.confirm' => '確認',
    'admin.common.execute' => '実行',
    'admin.common.close' => '閉じる',
    'admin.common.bulk_registration' => '一括登録を実行',
    'admin.common.decision' => '決定',
    'admin.common.create' => '作成',
    'admin.common.create__new' => '新規作成',
    'admin.common.up' => '上へ',
    'admin.common.down' => '下へ',
    'admin.common.upload' => 'アップロード',
    'admin.common.download' => 'ダウンロード',
    'admin.common.prev' => '前へ',
    'admin.common.next' => '次へ',
    'admin.common.first' => '最初へ',
    'admin.common.last' => '最後へ',
    'admin.common.back' => '戻る',
    'admin.common.show' => '表示',
    'admin.common.hide' => '非表示',
    'admin.common.hidden_label' => '(非表示)',
    'admin.common.to_show' => '非表示中 | 表示にする',
    'admin.common.to_hide' => '表示中 | 非表示にする',
    'admin.common.required' => '必須',
    'admin.common.bulk_actions' => '一括操作',
    'admin.common.select' => '選択してください',
    'admin.common.select__pref' => '都道府県を選択',
    'admin.common.select__unspecified' => '指定なし',
    'admin.common.separator__range' => '〜',
    'admin.common.separator__colon' => '：',
    'admin.common.count' => '%count%件',
    'admin.common.search_detail' => '詳細検索',
    'admin.common.search_result' => '検索結果：%count%件が該当しました',
    'admin.common.search_invalid_condition' => '検索条件に誤りがあります',
    'admin.common.search_no_result' => '検索条件に合致するデータが見つかりませんでした',
    'admin.common.search_try_change_condition' => '検索条件を変えて、再度検索をお試しください',
    'admin.common.search_try_advanced_search' => '[詳細検索]も試してみましょう',
    'admin.common.csv_download' => 'CSVダウンロード',
    'admin.common.csv_upload' => 'CSVファイルをアップロード',
    'admin.common.csv_skeleton_download' => '雛形ファイルダウンロード',
    'admin.common.csv_format' => 'CSVファイルフォーマット',
    'admin.common.csv_select' => 'CSVファイルを選択',
    'admin.common.file_select' => 'ファイルを選択',
    'admin.common.file_select_empty' => '選択されていません',
    'admin.common.csv_invalid_format' => 'CSVのフォーマットが一致しません',
    'admin.common.csv_invalid_no_data' => 'CSVデータが存在しません',
    'admin.common.csv_invalid_required' => '%line%行目の%name%が設定されていません',
    'admin.common.csv_invalid_greater_than_zero' => '%line%行目の%name%は0以上の数値を設定してください。',
    'admin.common.csv_invalid_format_line' => '%line%行目のCSVフォーマットが一致しません',
    'admin.common.csv_invalid_date_format' => '%line%行目の%name%の日付フォーマットが異なります',
    'admin.common.csv_invalid_not_found' => '%line%行目の%name%が存在しません',
    'admin.common.csv_invalid_not_found_target' => '%line%行目の%name%「%target_name%」が存在しません',
    'admin.common.csv_invalid_not_same' => '%line%行目の%name1%と%name2%には同じ値を使用できません',
    'admin.common.csv_invalid_can_not' => '%line%行目の%name%は設定できません',
    'admin.common.csv_invalid_image' => '%line%行目の%name%には末尾に"/"や"../"を使用できません',
    'admin.common.csv_invalid_foreign_key' => '%line%行目の%name%は関連するデータがあるため削除できません',
    'admin.common.csv_invalid_description_detail_upper_limit' => '%line%行目の%name%は%max%文字以下の文字列を指定してください。',
    'admin.common.drag_and_drop_description' => '項目の順番はドラッグ＆ドロップでも変更可能です。',
    'admin.common.drag_and_drop_image_description' => '画像をドラッグ＆ドロップまたは',
    'admin.common.delete_modal__title' => '削除します',
    'admin.common.delete_modal__message' => 'この操作はあとから取り消すことができません。「%name%」を削除してよろしいですか？',
    'admin.common.move_to_confirm_title' => 'ページを移動します',
    'admin.common.move_to_confirm_message' => '%name%に移動します。編集内容を保存してから移動しますか？',
    'admin.common.move_to_confirm_move_only' => '保存せずに移動',
    'admin.common.move_to_confirm_save_and_move' => '保存して移動',
    'admin.common.admin_url_warning' => '管理画面URLは、セキュリティのため推測されにくいものを設定してください。「<a href="%url%">セキュリティ管理</a>」から設定できます。',
    'admin.common.id' => 'ID',
    'admin.common.name' => 'お名前',
    'admin.common.kana' => 'お名前(カナ)',
    'admin.common.first_name' => '名',
    'admin.common.last_name' => '姓',
    'admin.common.company_name' => '会社名',
    'admin.common.company_name_kana' => '会社名(カナ)',
    'admin.common.address' => '住所',
    'admin.common.pref' => '都道府県',
    'admin.common.postal_symbol' => '〒',
    'admin.common.postal_code_sample' => '例：5300001',
    'admin.common.address_sample_01' => '市区町村名(例：大阪市北区)',
    'admin.common.address_sample_02' => '番地・ビル名(例：西梅田1丁目6-8)',
    'admin.common.phone_number' => '電話番号',
    'admin.common.mail_address' => 'メールアドレス',
    'admin.common.password' => 'パスワード',
    'admin.common.password_for_confirmation' => 'パスワード(確認用)',
    'admin.common.gender' => '性別',
    'admin.common.job' => '職業',
    'admin.common.birth_day' => '誕生日',
    'admin.common.birth_day__start' => '誕生日(開始)',
    'admin.common.birth_day__end' => '誕生日(終了)',
    'admin.common.point' => 'ポイント',
    'admin.common.shop_memo' => 'ショップ用メモ欄',
    'admin.common.create_date' => '登録日',
    'admin.common.create_date__start' => '登録日(開始)',
    'admin.common.create_date__end' => '登録日(終了)',
    'admin.common.update_date' => '更新日',
    'admin.common.update_date__start' => '更新日(開始)',
    'admin.common.update_date__end' => '更新日(終了)',
    'admin.common.last_update_date' => '最終更新日',
    'admin.common.last_updater' => '最終更新者',
    'admin.common.device_type' => '端末種別',
    'admin.common.authority' => '権限',
    'admin.common.payment_method' => '支払方法',
    'admin.common.charge' => '手数料',
    'admin.home' => 'ホーム',
    'admin.login' => 'ログイン',
    'admin.home.order_status_title' => '注文状況',
    'admin.home.shop_status_title' => 'ショップ状況',
    'admin.home.shop_status_out_of_stock' => '在庫切れ商品数',
    'admin.home.shop_status_products' => '取扱商品数',
    'admin.home.shop_status_customers' => '会員数',
    'admin.home.sales_summary_title' => '売上状況',
    'admin.home.sales_summary_value' => '%amount% / %count% 件',
    'admin.home.sales_summary_this_month' => '今月の売上金額 / 売上件数',
    'admin.home.sales_summary_today' => '今日の売上金額 / 売上件数',
    'admin.home.sales_summary_yesterday' => '昨日の売上金額 / 売上件数',
    'admin.home.sales_summary_weekly' => '週間',
    'admin.home.sales_summary_monthly' => '月間',
    'admin.home.sales_summary_yearly' => '年間',
    'admin.home.sales_summary_amount' => '売上金額',
    'admin.home.sales_summary_count' => '売上件数',
    'admin.home.recommend_plugins_title' => 'おすすめのプラグイン',
    'admin.home.recommend_plugins.owner_store' => 'オーナーズストア',
    'admin.home.news_title' => 'お知らせ',
    'admin.header.user_name' => '%name% 様',
    'admin.header.logout' => 'ログアウト',
    'admin.header.last_login' => '最終ログイン',
    'admin.header.change_password' => 'パスワード変更',
    'admin.login.enable_javascript' => 'JavaScript を有効にしてご利用ください',
    'admin.login.login' => 'ログイン',
    'admin.login.login_id' => 'ログインID',
    'admin.login.password' => 'パスワード',
    'admin.change_password' => 'パスワード変更',
    'admin.change_password.current_password' => '現在のパスワード',
    'admin.change_password.new_password' => '新しいパスワード',
    'admin.change_password.new_password_confirm' => '新しいパスワード(確認)',
    'admin.change_password.password_changed' => 'パスワードを更新しました',
    'admin.error.go_to_login' => 'ログイン画面へ',
    'admin.product.product_management' => '商品管理',
    'admin.product.product_list' => '商品一覧',
    'admin.product.product_registration' => '商品登録',
    'admin.product.product_class_registration' => '商品規格登録',
    'admin.product.class_management' => '規格管理',
    'admin.product.class_category_management' => '規格分類管理',
    'admin.product.category_management' => 'カテゴリ管理',
    'admin.product.tag_management' => 'タグ管理',
    'admin.product.product_csv_upload' => '商品CSV登録',
    'admin.product.category_csv_upload' => 'カテゴリCSV登録',
    'admin.product.bulk_change_status_complete' => '%status%: %count%件が正常に適用されました',
    'admin.product.copy_complete' => '商品を複製しました',
    'admin.product.copy_error' => '商品の複製に失敗しました',
    'admin.product.reset_complete' => '商品規格を初期化しました',
    'admin.product.product' => '商品',
    'admin.product.product__card_title' => '商品情報',
    'admin.product.preview' => '商品を確認',
    'admin.product.product_id' => '商品ID',
    'admin.product.product_id__short' => 'ID',
    'admin.product.display_status' => '公開ステータス',
    'admin.product.display_status__short' => '公開状態',
    'admin.product.display_status__show' => '公開',
    'admin.product.display_status__hide' => '非公開',
    'admin.product.display_status__abolished' => '廃止',
    'admin.product.permanently_delete' => '削除',
    'admin.product.permanently_delete__confirm_title' => '商品を削除します',
    'admin.product.permanently_delete__confirm_message' => '商品を削除してよろしいですか？',
    'admin.product.permanently_delete__in_progress' => '削除中...',
    'admin.product.permanently_delete__complete_message' => '商品の削除処理が完了しました',
    'admin.product.permanently_delete__complete' => '完了',
    'admin.product.permanently_delete__system_error' => 'システムエラーが発生しました',
    'admin.product.copy__confirm_title' => '商品を複製します',
    'admin.product.copy__confirm_message' => '商品を複製してよろしいですか？',
    'admin.product.name' => '商品名',
    'admin.product.image' => '商品画像',
    'admin.product.image__short' => '画像',
    'admin.product.image_size' => '推奨サイズ : 600px x 600px以上',
    'admin.product.image__invalid_path' => '画像のパスが不正です。',
    'admin.product.sale_type' => '販売種別',
    'admin.product.description_detail' => '商品説明',
    'admin.product.description_list' => '商品説明(一覧)',
    'admin.product.description_list__add' => '商品説明(一覧)を追加',
    'admin.product.price' => '価格',
    'admin.product.sale_price' => '販売価格',
    'admin.product.normal_price' => '通常価格',
    'admin.product.stock' => '在庫数',
    'admin.product.stock__short' => '在庫',
    'admin.product.stock__in_stock' => 'あり',
    'admin.product.stock__out_of_stock' => 'なし',
    'admin.product.search_word' => '検索ワード',
    'admin.product.product_code' => '商品コード',
    'admin.product.product_code__short' => 'コード',
    'admin.product.product_name_and_code' => '商品名・商品コード',
    'admin.product.sale_limit' => '販売制限数',
    'admin.product.delivery_duration' => '発送日目安',
    'admin.product.delivery_fee' => '商品送料',
    'admin.product.tax_rate' => '税率',
    'admin.product.free_area' => 'フリーエリア',
    'admin.product.free_area__card_title' => 'フリーエリア',
    'admin.product.delete_flag' => '商品削除フラグ',
    'admin.product.search_category' => 'カテゴリ検索',
    'admin.product.save_tag' => 'タグ登録',
    'admin.product.create_date__card_title' => '登録日・更新日',
    'admin.product.move_to_category' => 'カテゴリの追加・編集',
    'admin.product.move_to_tag' => 'タグの追加・編集',
    'admin.product.move_to_product_class' => '商品規格の編集',
    'admin.product.move_to_product_class__confirm_title' => '「%name%」の商品規格',
    'admin.product.multi_search_label' => '商品名・商品ID・商品コード',
    'admin.product.product_class' => '商品規格',
    'admin.product.product_class__short' => '規格',
    'admin.product.product_class__create' => '商品規格の設定',
    'admin.product.product_class__confirm' => '規格確認',
    'admin.product.product_class__confirm_of_product' => 'この商品の規格を確認',
    'admin.product.product_class__card_title' => '商品規格情報',
    'admin.product.product_class__reset' => '商品規格の初期化',
    'admin.product.product_class__reset_confirm_title' => 'この商品の規格を初期化します',
    'admin.product.product_class__reset_confirm_message' => 'この商品に登録された規格を初期化します。
これまでの販売データには影響はありませんが、この操作は取り消すことができません。
初期化しますか？
',
    'admin.product.product_class__reset_confirm_excecute' => '規格を初期化',
    'admin.product.product_class_set_stock_quantity' => '在庫数を入力、もしくは在庫無制限を設定してください。',
    'admin.product.copy_first_line' => '1行目をすべての行に複製',
    'admin.product.procuct_class_count' => '%count%件の組み合わせがあります',
    'admin.product.stock_unlimited' => '在庫数無制限',
    'admin.product.stock_unlimited__short' => '無制限',
    'admin.product.class_name' => '規格名',
    'admin.product.class_name__backend_name' => '管理名',
    'admin.product.class_name__card_title' => '規格情報',
    'admin.product.class_category' => '規格分類',
    'admin.product.class_category__backend_name' => '管理名',
    'admin.product.class_category__card_title' => '規格分類情報',
    'admin.product.class_category_name' => '規格分類名',
    'admin.product.class_category_name__short' => '分類名',
    'admin.product.class_category1' => '規格分類1',
    'admin.product.class_category1__short' => '規格1',
    'admin.product.class_category2' => '規格分類2',
    'admin.product.class_category2__short' => '規格2',
    'admin.product.category' => 'カテゴリ',
    'admin.product.category__product_card_title' => 'カテゴリ',
    'admin.product.category_id' => 'カテゴリID
既存カテゴリの更新はカテゴリIDを設定
',
    'admin.product.category_name' => 'カテゴリ名',
    'admin.product.parent_category_id' => '親カテゴリID',
    'admin.product.category_all' => 'すべてのカテゴリ',
    'admin.product.tag' => 'タグ',
    'admin.product.tag__product_card_title' => 'タグ',
    'admin.product.select__class1' => '規格1を選択してください',
    'admin.product.select__class2' => '規格2を選択してください',
    'admin.product.select__can_not_select_same_class' => '規格1と同じ規格は選択できません',
    'admin.product.unselected_class' => '選択されていません',
    'admin.product.product_csv.product_id_col' => '商品ID',
    'admin.product.product_csv.product_id_description' => '新規登録の場合は空にしてください。既存の商品を更新する場合は、商品IDを指定してください。',
    'admin.product.product_csv.display_status_col' => '公開ステータス(ID)',
    'admin.product.product_csv.display_status_description' => '',
    'admin.product.product_csv.product_name_col' => '商品名',
    'admin.product.product_csv.product_name_description' => '',
    'admin.product.product_csv.shop_memo_col' => 'ショップ用メモ欄',
    'admin.product.product_csv.shop_memo_description' => '',
    'admin.product.product_csv.description_list_col' => '商品説明(一覧)',
    'admin.product.product_csv.description_list_description' => '',
    'admin.product.product_csv.description_detail_col' => '商品説明(詳細)',
    'admin.product.product_csv.description_detail_description' => '',
    'admin.product.product_csv.keyword_col' => '検索ワード',
    'admin.product.product_csv.keyword_description' => '',
    'admin.product.product_csv.free_area_col' => 'フリーエリア',
    'admin.product.product_csv.free_area_description' => '',
    'admin.product.product_csv.delete_flag_col' => '商品削除フラグ',
    'admin.product.product_csv.delete_flag_description' => '0:登録 1:削除を指定します。未指定の場合、0として扱います。',
    'admin.product.product_csv.product_image_col' => '商品画像',
    'admin.product.product_csv.product_image_description' => '画像のファイル名を指定します。複数画像の場合、画像ファイル名をカンマ区切りで「"」で囲んでください。',
    'admin.product.product_csv.category_col' => '商品カテゴリ(ID)',
    'admin.product.product_csv.category_description' => 'カテゴリIDを指定します。複数カテゴリの場合、商品カテゴリIDをカンマ区切りで「"」で囲んでください。',
    'admin.product.product_csv.tag_col' => 'タグ(ID)',
    'admin.product.product_csv.tag_description' => 'タグIDを指定します。複数タグの場合、タグIDをカンマ区切りで「"」で囲んでください。',
    'admin.product.product_csv.sale_type_col' => '販売種別(ID)',
    'admin.product.product_csv.sale_type_description' => '',
    'admin.product.product_csv.class_category1_col' => '規格分類1(ID)',
    'admin.product.product_csv.class_category1_description' => '',
    'admin.product.product_csv.class_category2_col' => '規格分類2(ID)',
    'admin.product.product_csv.class_category2_description' => '',
    'admin.product.product_csv.delivery_duration_col' => '発送日目安(ID)',
    'admin.product.product_csv.delivery_duration_description' => '',
    'admin.product.product_csv.product_code_col' => '商品コード',
    'admin.product.product_csv.product_code_description' => '',
    'admin.product.product_csv.stock_col' => '在庫数',
    'admin.product.product_csv.stock_description' => '在庫数無制限フラグが0の場合、0以上の数値を設定してください。',
    'admin.product.product_csv.stock_unlimited_col' => '在庫数無制限フラグ',
    'admin.product.product_csv.stock_unlimited_description' => '0:制限 1: 無制限を指定します。',
    'admin.product.product_csv.sale_limit_col' => '販売制限数',
    'admin.product.product_csv.sale_limit_description' => '1以上の数値を設定',
    'admin.product.product_csv.normal_price_col' => '通常価格',
    'admin.product.product_csv.normal_price_description' => '0以上の数値を設定',
    'admin.product.product_csv.sale_price_col' => '販売価格',
    'admin.product.product_csv.sale_price_description' => '0以上の数値を設定',
    'admin.product.product_csv.delivery_fee_col' => '送料',
    'admin.product.product_csv.delivery_fee_description' => '商品ごとの送料設定が有効の場合、0以上の数値を設定',
    'admin.product.product_csv.tax_rate_col' => '税率',
    'admin.product.product_csv.tax_rate_description' => '商品別税率機能設定が有効の場合、0以上の数値を設定',
    'admin.product.category_csv.category_id_col' => 'カテゴリID',
    'admin.product.category_csv.category_id_description' => '新規登録の場合は空にしてください。既存のカテゴリを更新する場合は、カテゴリIDを指定してください。',
    'admin.product.category_csv.category_name_col' => 'カテゴリ名',
    'admin.product.category_csv.category_name_description' => '',
    'admin.product.category_csv.parent_category_id_col' => '親カテゴリID',
    'admin.product.category_csv.parent_category_id_description' => '',
    'admin.product.category_csv.delete_flag_col' => 'カテゴリ削除フラグ',
    'admin.product.category_csv.delete_flag_description' => '0:登録 1:削除を指定します。未指定の場合、0として扱います。',
    'admin.order.order_management' => '受注管理',
    'admin.order.order_list' => '受注一覧',
    'admin.order.order_registration' => '受注登録',
    'admin.order.shipping_registration' => '出荷登録',
    'admin.order.shipping_csv_upload' => '出荷CSV登録',
    'admin.order.mail' => 'メール通知',
    'admin.order.shipping_save_message' => '出荷に関わる情報が変更されました。送料の変更が必要な場合は、受注管理より手動で変更してください。',
    'admin.order.multi_search_label' => '注文番号・お名前・会社名・メールアドレス・電話番号',
    'admin.order.order_info' => '注文情報',
    'admin.order.order_date' => '注文日',
    'admin.order.order_date__start' => '注文日(開始)',
    'admin.order.order_date__end' => '注文日(終了)',
    'admin.order.payment_date' => '入金日',
    'admin.order.payment_date__start' => '入金日(開始)',
    'admin.order.payment_date__end' => '入金日(終了)',
    'admin.order.delivery_date__start' => 'お届け日(開始)',
    'admin.order.delivery_date__end' => 'お届け日(終了)',
    'admin.order.order_no' => '注文番号',
    'admin.order.shipping_date' => '出荷日',
    'admin.order.message' => 'お問い合わせ',
    'admin.order.message_short' => 'お問合せ',
    'admin.order.purchase_price' => '購入金額',
    'admin.order.purchase_price__start' => '購入金額(開始)',
    'admin.order.purchase_price__end' => '購入金額(終了)',
    'admin.order.orderer' => '注文者',
    'admin.order.orderer_name' => '注文者名',
    'admin.order.orderer_kana' => '注文者名(カナ)',
    'admin.order.orderer_company_name' => '注文者会社名',
    'admin.order.copy_orderer' => '注文者情報をコピー',
    'admin.order.output_delivery_note' => '納品書を出力',
    'admin.order.output_delivery_note_short' => '納品書出力',
    'admin.order.add_shipping' => '出荷情報の追加',
    'admin.order.delete_shipping' => '出荷情報を削除',
    'admin.order.delete_shipping_error__confirm_title' => '出荷情報を削除できません',
    'admin.order.delete_shipping_error__confirm_message' => 'まず出荷情報に設定されている明細を削除してから、出荷情報を削除してください',
    'admin.order.delete_shipping__confirm_message' => '出荷情報は注文から削除されます。出荷情報(%num%)を削除しますか？',
    'admin.order.order_item_info' => '注文商品情報',
    'admin.order.order_item_type' => '明細種別',
    'admin.order.add_product_item' => '商品を追加',
    'admin.order.add_other_item' => 'その他の明細を追加',
    'admin.order.update_calculation_results' => '計算結果を更新',
    'admin.order.amount' => '金額',
    'admin.order.quantity' => '数量',
    'admin.order.tax_rate' => '税率',
    'admin.order.tax_type' => '課税区分',
    'admin.order.subtotal' => '小計',
    'admin.order.discount' => '値引き',
    'admin.order.delivery_fee' => '送料',
    'admin.order.add_point' => '加算ポイント',
    'admin.order.use_point' => '利用ポイント',
    'admin.order.total' => '合計',
    'admin.order.payment_total' => 'お支払い合計',
    'admin.order.order_status' => '対応状況',
    'admin.order.last_buy_date' => '最終購入日',
    'admin.order.last_buy_date__start' => '最終購入日(開始)',
    'admin.order.last_buy_date__end' => '最終購入日(終了)',
    'admin.order.purchase_product' => '購入商品名',
    'admin.order.purchase_count' => '購入件数',
    'admin.order.purchase_count__start' => '購入件数(開始)',
    'admin.order.purchase_count__end' => '購入件数(終了)',
    'admin.order.tracking_number' => 'お問い合わせ番号',
    'admin.order.tracking_number_error' => 'お問い合わせ番号は半角英数字かハイフンのみを入力してください。',
    'admin.order.mail_purchase_product_count' => '他%count%点',
    'admin.order.mail_history' => 'メール送信履歴',
    'admin.order.mail_send_date' => 'メール送信日時',
    'admin.order.mail_subject' => '件名',
    'admin.order.mail_body' => '本文',
    'admin.order.mail_create' => 'メールを作成',
    'admin.order.mail_destination_info' => 'メール送信先',
    'admin.order.mail_mail_info' => 'メール内容',
    'admin.order.mail_confirm' => '送信内容を確認',
    'admin.order.mail_template' => 'テンプレート',
    'admin.order.mail_confirm_title' => '下の内容でメールを送信してもよろしいですか？ 確認の上、［送信］ボタンを押してください。',
    'admin.order.mail_send' => '送信',
    'admin.order.mail_send_complete' => 'メールを送信しました。',
    'admin.order.shipping_info' => '出荷情報',
    'admin.order.delivery_date' => 'お届け日',
    'admin.order.delivery_time' => 'お届け時間',
    'admin.order.delivery_provider' => '配送方法',
    'admin.order.to_shipped' => '出荷済にする',
    'admin.order.send_mail' => 'メールする',
    'admin.order.shop_memo_for_shipped' => '出荷用メモ欄',
    'admin.order.shipping__card_title' => '出荷情報',
    'admin.order.shipping_id' => '出荷ID',
    'admin.order.shipping_mail' => '出荷メール',
    'admin.order.shipping_mail__completed' => '%date%に出荷メールを送信済です。',
    'admin.order.shipping_mail__sent' => '送信済',
    'admin.order.shipping_mail__unsent' => '未送信',
    'admin.order.bulk_action__confirm_view_mail_body' => 'メールの文面を確認',
    'admin.order.bulk_action__confirm_message' => 'この操作は保存済みのデータに対して処理を行います。また、編集中で登録が完了していない情報は失われます。登録が完了していない情報がある場合は先に登録を完了してください。',
    'admin.order.bulk_action__in_progress_message' => '処理中...',
    'admin.order.bulk_action__complete_message' => '完了しました。',
    'admin.order.shipping_mail_send' => '出荷メール送信',
    'admin.order.shipping_mail_send__confirm_title' => '出荷お知らせメールを送信します',
    'admin.order.shipping_mail_send__confirm_message' => '出荷お知らせメールを送信します。メールの文面を確認してから［送信］ボタンを押してください。この操作は取り消すことができません。ご注意ください。',
    'admin.order.shipping_mail_send__complete_message' => '%count%件のメールを送信しました。',
    'admin.order.to_shipped__confirm_title' => '出荷済に更新します',
    'admin.order.to_shipped__confirm_message' => '出荷情報を出荷済みにします。同時におこなう操作を選択してから［実行］ボタンを押してください。この操作は取り消すことができません。ご注意ください。',
    'admin.order.to_shipped__confirm_send_mail' => 'メールの送信',
    'admin.order.to_shipped__confirm_send_mail_in_same_time' => '出荷お知らせメールを同時に送る',
    'admin.order.change_status' => '対応状況の変更',
    'admin.order.csv_shipping_date_description' => '出荷日を「YYYY-MM-DD」の形式で設定',
    'admin.order.order_csv' => '受注CSV',
    'admin.order.shipping_csv' => '出荷CSV',
    'admin.order.shipping_status' => '出荷状況',
    'admin.order.delivery' => 'お届け先',
    'admin.order.not_payment' => '未入金',
    'admin.order.unshipped' => '未出荷',
    'admin.order.delete__confirm_title' => '注文情報を削除します',
    'admin.order.delete__confirm_message' => '注文情報を削除してよろしいですか？',
    'admin.order.delete_item__confirm_message' => '明細は注文から削除されます。「%name%」を削除してよろしいですか？',
    'admin.order.change_payment_method_message' => 'お支払方法の変更に伴う手数料の変更は手動にてお願いします',
    'admin.order.non_member' => '非会員',
    'admin.order.search_from_customer' => '会員から検索・入力',
    'admin.order.search_customer_title' => '会員を検索',
    'admin.order.product_info' => '商品情報',
    'admin.order.edit_multiple_shipping' => 'お届け先を編集',
    'admin.order.edit_multiple_shipping_description' => '複数配送を指定している場合は、こちらのボタンからそれぞれの配送設定の編集ができます',
    'admin.order.product_item_not_found' => '商品が追加されていません',
    'admin.order.delivery_note_create_date' => '発行日',
    'admin.order.delivery_note_title' => 'タイトル',
    'admin.order.delivery_note_title__default' => 'お買上げ明細書(納品書)',
    'admin.order.delivery_note_output_format' => '出力形式',
    'admin.order.delivery_note_output_format__browser' => 'ブラウザで開く',
    'admin.order.delivery_note_output_format__file' => 'ファイルに保存',
    'admin.order.delivery_note_message' => 'メッセージ',
    'admin.order.delivery_note_message__default1' => 'このたびはお買上げいただきありがとうございます。',
    'admin.order.delivery_note_message__default2' => '下記の内容にて納品させていただきます。',
    'admin.order.delivery_note_message__default3' => 'ご確認くださいますよう、お願いいたします。',
    'admin.order.delivery_note_memo' => '備考',
    'admin.order.delivery_note_line1' => '1行目',
    'admin.order.delivery_note_line2' => '2行目',
    'admin.order.delivery_note_line3' => '3行目',
    'admin.order.delivery_note_save_input' => '入力内容を保存する',
    'admin.order.delivery_note_download_error' => 'ダウンロードに失敗しました',
    'admin.order.delivery_note_parameter_error' => '出荷IDが指定されていません',
    'admin.order.failed_to_change_status' => '%name%: %from% から %to% にはステータス変更できません',
    'admin.order.failed_to_change_status__short' => '%from% から %to% にはステータス変更できません',
    'admin.order.skip_change_status' => '%name%: ステータス変更をスキップしました',
    'admin.order.shipping_csv.shipping_id_col' => '出荷ID',
    'admin.order.shipping_csv.shipping_id_description' => '',
    'admin.order.shipping_csv.tracking_number_col' => 'お問い合わせ番号',
    'admin.order.shipping_csv.tracking_number_description' => '',
    'admin.order.shipping_csv.shipping_date_col' => '出荷日',
    'admin.order.shipping_csv.shipping_date_description' => '出荷日を「YYYY-MM-DD」の形式で設定',
    'admin.customer.customer_management' => '会員管理',
    'admin.customer.customer_list' => '会員一覧',
    'admin.customer.customer_registration' => '会員登録',
    'admin.customer.customer_address_registration' => 'お届け先登録',
    'admin.customer.customer_id' => '会員ID',
    'admin.customer.customer_info' => '会員情報',
    'admin.customer.purchase_history' => '注文履歴',
    'admin.customer.purchase_history__not_found' => '注文履歴がありません',
    'admin.customer.customer_address' => 'お届け先住所',
    'admin.customer.customer_address__not_found' => 'お届け先住所がありません',
    'admin.customer.customer_address__add' => 'お届け先住所を追加',
    'admin.customer.customer_address_count_is_over' => 'お届け先登録の上限の%eccube_deliv_addr_max%件に達しています。お届け先を入力したい場合は、削除か変更を行ってください。',
    'admin.customer.customer_address_id' => 'お届け先ID',
    'admin.customer.customer_address_info' => 'お届け先情報',
    'admin.customer.multi_search_label' => '会員ID・メールアドレス・お名前',
    'admin.customer.customer_status' => '会員種別',
    'admin.customer.birth_month' => '誕生月',
    'admin.customer.resend' => '仮会員メール再送',
    'admin.customer.resend_confirm_title' => '仮会員メールを再送します。',
    'admin.customer.resend_confirm_message' => '仮登録メールを再送してもよろしいですか？',
    'admin.customer.no_customer_address' => 'この会員のお届け先がありません',
    'admin.customer.no_purchase_history' => 'この会員の購入履歴がありません',
    'admin.content.contents_management' => 'コンテンツ管理',
    'admin.content.news_management' => '新着情報管理',
    'admin.content.file_management' => 'ファイル管理',
    'admin.content.layout_management' => 'レイアウト管理',
    'admin.content.page_management' => 'ページ管理',
    'admin.content.css_management' => 'CSS管理',
    'admin.content.js_management' => 'JavaScript管理',
    'admin.content.block_management' => 'ブロック管理',
    'admin.content.cache_management' => 'キャッシュ管理',
    'admin.content.maintenance_management' => 'メンテナンス管理',
    'admin.content.file.add_file__card_title' => 'ファイル・フォルダを追加',
    'admin.content.file.add_file' => 'ファイルを追加',
    'admin.content.file.add_directory' => 'フォルダを追加',
    'admin.content.file.directory_name' => 'フォルダ名',
    'admin.content.file.file_list__card_title' => 'このフォルダ内のファイル',
    'admin.content.file.updated' => '更新',
    'admin.content.file.directory_tree' => 'フォルダ構成',
    'admin.content.file.upload_complete' => '%success%件のファイルをアップロードしました。(%success%/%count%)',
    'admin.content.file.upload_error' => '%file_name% のアップロードに失敗しました。(%error%)',
    'admin.content.layout_delete' => 'レイアウトを削除',
    'admin.content.layout_no_page' => 'ページが登録されていません',
    'admin.content.layout__card_title' => 'レイアウト概要',
    'admin.content.layout_name' => 'レイアウト名',
    'admin.content.layout_edit__card_title' => 'レイアウト編集',
    'admin.content.layout_drag_and_drop_message' => 'ブロックをドラッグ＆ドロップ',
    'admin.content.layout_up' => '上に移動',
    'admin.content.layout_down' => '下に移動',
    'admin.content.layout_move_to' => 'セクションに移動',
    'admin.content.layout_preview' => 'プレビュー',
    'admin.content.layout_preview__select_page' => 'ページを選択してください',
    'admin.content.layout_preview_select_page' => 'プレビューするページを選択してください',
    'admin.content.layout_preview_code' => 'コードプレビュー',
    'admin.content.layout_preview_code__confirm_title' => 'ブロックのコードプレビュー',
    'admin.content.layout_preview_code__confirm_message' => '編集が必要な場合はブロック編集画面から編集してください（この時レイアウト設定は保存されません）',
    'admin.content.layout_preview_code__confirm_move_to_block' => 'コードを編集',
    'admin.content.layout_move_to__confirm_title' => 'ブロックを移動',
    'admin.content.layout_move_to__confirm_message' => 'ブロックの移動先を選択してください',
    'admin.content.layout_move_to__execute' => '移動',
    'admin.content.layout_section__unused' => '未使用ブロック',
    'admin.content.layout_section__head' => '<head></head>タグ内',
    'admin.content.layout_section__body_after' => '<body>タグ直後',
    'admin.content.layout_section__header' => '#header',
    'admin.content.layout_section__contents_top' => '#contents_top',
    'admin.content.layout_section__side_left' => '#side_left',
    'admin.content.layout_section__main' => 'Main',
    'admin.content.layout_section__main_top' => '#main_top',
    'admin.content.layout_section__main_bottom' => '#main_bottom',
    'admin.content.layout_section__side_right' => '#side_right',
    'admin.content.layout_section__contents_bottom' => '#contents_bottom',
    'admin.content.layout_section__footer' => '#footer',
    'admin.content.layout_section__drawer' => '#drawer',
    'admin.content.layout_section__close_body_before' => '</body>タグ直前',
    'admin.content.page_name' => 'ページ名',
    'admin.content.page__card_title' => 'ページ設定',
    'admin.content.page_url' => 'URL',
    'admin.content.page_url_exists' => '既にURLが存在しています。',
    'admin.content.page_file_name' => 'ファイル名',
    'admin.content.page_source_code' => 'コード',
    'admin.content.page_layout__card_title' => 'レイアウト設定',
    'admin.content.page_pc' => 'PC',
    'admin.content.page_mobile' => 'モバイル',
    'admin.content.page_meta__card_title' => 'メタ設定',
    'admin.content.page_meta_author' => 'author',
    'admin.content.page_meta_description' => 'description',
    'admin.content.page_meta_keyword' => 'keyword',
    'admin.content.page_meta_robot' => 'robot',
    'admin.content.page_meta_metatag' => 'metatag',
    'admin.content.page_meta_metatag_placeholder' => '商品詳細ページでの記載例
  <meta property="og:type" content="og:product" />
  <meta property="og:title" content="{{ Product.name }}" />
  <meta property="og:image" content="{{ url(\'homepage\') }}{{ asset(Product.main_list_image|no_image_product, \'save_image\') }}" />
  <meta property="og:description" content="{{ Product.description_list|striptags }}" />
  <meta property="og:url" content="{{ url(\'product_detail\', {\'id\': Product.id}) }}" />
  <meta property="product:price:amount" content="{{ Product.getPrice02IncTaxMin }}"/>
  <meta property="product:price:currency" content="{{ eccube_config.currency }}"/>
  <meta property="product:product_link" content="{{ url(\'product_detail\', {\'id\': Product.id}) }}"/>
  <meta property="product:retailer_title" content="{{ Product.name }}"/>
',
    'admin.content.page_file_name_exists' => '同じファイル名のデータが存在しています。別のファイル名を入力してください。',
    'admin.content.css__card_title' => 'CSS設定',
    'admin.content.js__card_title' => 'JavaScript設定',
    'admin.content.block_name' => 'ブロック名',
    'admin.content.block__card_title' => 'ブロック設定',
    'admin.content.block_file_name' => 'ファイル名',
    'admin.content.block_file_name_exists' => '同じファイル名のデータが存在しています。別のファイル名を入力してください。',
    'admin.content.block_source_code' => 'コード',
    'admin.content.cache__card_title' => 'キャッシュ管理',
    'admin.content.cache_message' => '本番環境にFTPなどでTwigファイルをアップロードして入れ替えた場合、画面を反映させるにはTwigキャッシュを削除する必要があります。',
    'admin.content.cache_delete' => 'キャッシュ削除',
    'admin.content.news.publish_date' => '公開日時',
    'admin.content.news.display_status' => '公開状態',
    'admin.content.news.display_status__show' => '公開',
    'admin.content.news.display_status__hide' => '非公開',
    'admin.content.news.title' => 'タイトル',
    'admin.content.news.url' => 'URL',
    'admin.content.news.body' => '本文',
    'admin.content.news.news_registration' => '新着情報登録',
    'admin.content.news.new_window' => '別ウィンドウで開く',
    'admin.content.maintenance__card_title' => 'メンテナンスモード',
    'admin.content.maintenance_message' => 'メンテナンスモードを有効にすると、SHOPの機能を一時的に停止し、管理画面のみアクセス可能な状態となります。
※プラグインのインストール/有効/無効/削除時には、自動的にメンテナンスモードに切り替わります。
',
    'admin.content.maintenance_switch__on' => '有効にする',
    'admin.content.maintenance_switch__off' => '無効にする',
    'admin.content.maintenance_switch__on_message' => 'メンテナンスモードを有効にしました。',
    'admin.content.maintenance_switch__off_message' => 'メンテナンスモードを無効にしました。',
    'admin.setting' => '設定',
    'admin.setting.shop' => '店舗設定',
    'admin.setting.shop.shop_setting' => '基本設定',
    'admin.setting.shop.tradelaw_setting' => '特定商取引法設定',
    'admin.setting.shop.agreement_setting' => '利用規約設定',
    'admin.setting.shop.payment_list' => '支払方法一覧',
    'admin.setting.shop.payment_setting' => '支払方法設定',
    'admin.setting.shop.delivery_list' => '配送方法一覧',
    'admin.setting.shop.delivery_setting' => '配送方法設定',
    'admin.setting.shop.tax_setting' => '税率設定',
    'admin.setting.shop.mail_setting' => 'メール設定',
    'admin.setting.shop.csv_setting' => 'CSV出力項目設定',
    'admin.setting.system' => 'システム設定',
    'admin.setting.system.member_management' => 'メンバー管理',
    'admin.setting.system.member_password_change' => 'パスワード変更',
    'admin.setting.system.authority_management' => '権限管理',
    'admin.setting.system.security_management' => 'セキュリティ管理',
    'admin.setting.system.log_display' => 'ログ表示',
    'admin.setting.system.master_data_management' => 'マスタデータ管理',
    'admin.setting.system.system_info' => 'システム情報',
    'admin.setting.shop.shop.base_info' => '店舗情報',
    'admin.setting.shop.company_name_kana' => '会社名(カナ)',
    'admin.setting.shop.shop.shop_name' => '店名',
    'admin.setting.shop.shop.shop_name_kana' => '店名(カナ)',
    'admin.setting.shop.shop.shop_name_en' => '店名(英語表記)',
    'admin.setting.shop.shop.business_hour' => '店舗営業時間',
    'admin.setting.shop.shop.email_from' => '送信元メールアドレス(From)',
    'admin.setting.shop.shop.email_for_inquiries' => '問い合わせ受付メールアドレス(From, ReplyTo)',
    'admin.setting.shop.shop.email_reply_to' => '返信受付メールアドレス(ReplyTo)',
    'admin.setting.shop.shop.email_return_path' => '送信エラー受付メールアドレス(ReturnPath)',
    'admin.setting.shop.shop.good_traded' => '取り扱い商品説明文',
    'admin.setting.shop.shop.message' => '店舗からのメッセージ',
    'admin.setting.shop.shop.option_delivery_fee' => '送料設定',
    'admin.setting.shop.shop.option_delivery_fee_free_amount' => '送料無料条件（金額）',
    'admin.setting.shop.shop.option_delivery_fee_free_quantity' => '送料無料条件（数量）',
    'admin.setting.shop.shop.option_delivery_fee_by_product' => '商品ごとの送料設定',
    'admin.setting.shop.shop.option_customer' => '会員設定',
    'admin.setting.shop.shop.option_customer_activate' => '仮会員機能',
    'admin.setting.shop.shop.option_mypage_order_status_display' => 'マイページに注文状況を表示',
    'admin.setting.shop.shop.option_favorite_product' => 'お気に入り商品機能',
    'admin.setting.shop.shop.option_remember_me' => '自動ログイン機能',
    'admin.setting.shop.shop.option_product' => '商品設定',
    'admin.setting.shop.shop.nostock_hidden' => '在庫切れ商品の非表示',
    'admin.setting.shop.shop.option_tax' => '税設定',
    'admin.setting.shop.shop.option_product_tax' => '商品別税率機能',
    'admin.setting.shop.shop.option_point' => 'ポイント設定',
    'admin.setting.shop.shop.option_point_enabled' => 'ポイント機能',
    'admin.setting.shop.shop.option_point_rate' => 'ポイント付与率',
    'admin.setting.shop.shop.option_point_conversion_rate' => 'ポイント換算レート',
    'admin.setting.shop.payment.terms_of_use' => '利用条件',
    'admin.setting.shop.payment.terms_of_use_error' => '下限・上限の値を確認してください',
    'admin.setting.shop.payment.unlimited' => '無制限',
    'admin.setting.shop.payment.payment_id' => 'ID',
    'admin.setting.shop.payment.payment_name' => '支払方法名',
    'admin.setting.shop.payment.logo_image' => 'ロゴ画像',
    'admin.setting.shop.payment.logo_image_size' => '推奨サイズ : 500px × 100px',
    'admin.setting.shop.delivery.base_info' => '基本情報',
    'admin.setting.shop.delivery.delivery_name' => '配送業者名',
    'admin.setting.shop.delivery.delivery_sevice_name' => '配送方法名称',
    'admin.setting.shop.delivery.tracking_number_url' => 'お問い合わせ番号URL',
    'admin.setting.shop.delivery.sale_type' => '販売種別',
    'admin.setting.shop.delivery.payment_method' => '取り扱う支払方法',
    'admin.setting.shop.delivery.delivery_time_setting' => 'お届け時間設定',
    'admin.setting.shop.delivery.delivery_fee_by_pref' => '都道府県別送料設定',
    'admin.setting.shop.delivery.apply_to_pref__title' => '全国一律に設定',
    'admin.setting.shop.delivery.apply_to_pref__button' => '各都道府県に適用',
    'admin.setting.shop.delivery.fee.invalid' => '数字で入力してください。',
    'admin.setting.shop.tax.rounding_type' => '課税規則',
    'admin.setting.shop.tax.base_rate_setting' => '基本税率設定',
    'admin.setting.shop.tax.tax_rate' => '税率',
    'admin.setting.shop.tax.apply_date' => '適用日時',
    'admin.setting.shop.tax.apply_date.available_error' => '同時刻の適用日時を設定できません。',
    'admin.setting.shop.mail.mail_template_edit' => 'テンプレート編集',
    'admin.setting.shop.mail.mail_template' => 'テンプレート',
    'admin.setting.shop.mail.mail_subject' => '件名',
    'admin.setting.shop.mail.mail_body' => '本文',
    'admin.setting.shop.mail.mail_text' => 'テキスト',
    'admin.setting.shop.mail.mail_html' => 'HTML',
    'admin.setting.shop.mail.preview' => 'プレビュー',
    'admin.setting.shop.csv.csv_columns' => 'CSV出力項目',
    'admin.setting.shop.csv.csv_type' => 'CSV種別',
    'admin.setting.shop.csv.non_output_colmuns' => '出力しない項目',
    'admin.setting.shop.csv.output_colmuns' => '出力する項目',
    'admin.setting.shop.csv.operation' => '操作項目',
    'admin.setting.shop.csv.operation__output' => '出力',
    'admin.setting.shop.csv.operation__release' => '解除',
    'admin.setting.shop.csv.operation__all_output' => 'すべて出力',
    'admin.setting.shop.csv.operation__all_release' => 'すべて解除',
    'admin.setting.shop.csv.order' => '項目順序',
    'admin.setting.shop.csv.order__up' => 'ひとつ上へ',
    'admin.setting.shop.csv.order__down' => 'ひとつ下へ',
    'admin.setting.shop.csv.order__top' => '一番上へ',
    'admin.setting.shop.csv.order__bottom' => '一番下へ',
    'admin.setting.shop.csv.how_to_use' => '任意の項目を押して選択してから［項目操作］ボタンで移動し、CSV出力する項目を設定してください。
出力する項目の順序は［項目順序］ボタンで変更することができます。
複数の項目を選択する場合はctrlキー（Macの場合はcommandキー）を押しながら項目を押します。shiftキーを押しながら選択すると範囲選択ができます。
',
    'admin.setting.system.member.member_registration' => 'メンバー登録',
    'admin.setting.system.member.name' => '名前',
    'admin.setting.system.member.department' => '所属',
    'admin.setting.system.member.login_id' => 'ログインID',
    'admin.setting.system.member.password' => 'パスワード',
    'admin.setting.system.member.password_confirm' => 'パスワード(確認)',
    'admin.setting.system.member.work' => '稼働',
    'admin.setting.system.member.delete__confirm_title' => 'メンバーを削除します。',
    'admin.setting.system.member.delete__confirm_message' => 'メンバーを削除してよろしいですか？',
    'admin.setting.system.member.work_can_not_change' => '非稼働に変更することはできません。',
    'admin.setting.system.authority__card_title' => '権限設定',
    'admin.setting.system.authority.description' => '%url%以降からのURLを拒否URLに入力してください。
拒否URL以降がアクセス拒否されます。(URLは前方一致)
',
    'admin.setting.system.authority.example' => '例) /setting <span class="text-danger">「/」を必ず記入してください</span>',
    'admin.setting.system.authority.authority' => '権限',
    'admin.setting.system.authority.deny_url' => '拒否URL',
    'admin.setting.system.authority.add_row' => '行を追加',
    'admin.setting.system.authority.authority_not_selected' => '権限が選択されていません。',
    'admin.setting.system.authority.deny_url_is_empty' => '拒否URLが入力されていません。',
    'admin.setting.system.authority.deny_url_is_invalid' => '「/」を必ず記入してください。',
    'admin.setting.system.security__card_title' => 'セキュリティ設定',
    'admin.setting.system.security.admin_url' => '管理画面URL',
    'admin.setting.system.security.admin_url_description' => '推測されにくいURLを設定することを推奨します。',
    'admin.setting.system.security.admin_url_changed' => '管理画面のURLを変更しました。再度ログインを行ってください。',
    'admin.setting.system.security.ip_limit' => 'IP制限',
    'admin.setting.system.security.ip_limit_description' => '管理機能へのアクセスを特定のIPアドレスからの接続のみに制限します。
アクセスを許可するIPアドレスを1行ずつ入力してください。何も入力しない場合は全てを許可します。
',
    'admin.setting.system.security.ip_limit_sample' => '127.0.0.1
192.0.2.1
',
    'admin.setting.system.security.force_ssl' => 'SSLを強制',
    'admin.setting.system.security.force_ssl_description' => 'httpsからの接続でなければSSL制限を設定できません。',
    'admin.setting.system.security.ip_limit_invalid_ipv4' => '%ip%はIPv4アドレスではありません。',
    'admin.setting.system.security.ip_limit_invalid_https' => 'httpの場合には設定できません。',
    'admin.setting.system.security.admin_url_warning' => '管理画面URLは、セキュリティのため推測されにくいものを設定してください。',
    'admin.setting.system.security.not_found_env_file' => '.envファイルが見つかりません。.envを利用していない場合はセキュリティ設定を管理画面から変更できません。',
    'admin.setting.system.log.line_number' => '行',
    'admin.setting.system.log.read' => '読み込む',
    'admin.setting.system.master_data.select' => '選択',
    'admin.setting.system.master_data.description' => 'マスターデータの値を設定できます。
重複したIDを登録することはできません。
空のIDを登録すると、値は削除されます。
設定値によってはサイトが機能しなくなる場合もありますので、十分ご注意下さい。
',
    'admin.setting.system.master_data.id' => 'ID',
    'admin.setting.system.master_data.name' => 'Name',
    'admin.setting.system.master_data.duplicate_id' => '重複したIDを登録することはできません。',
    'admin.setting.system.system.eccube' => 'EC-CUBE',
    'admin.setting.system.system.server_os' => 'サーバーOS',
    'admin.setting.system.system.database_server' => 'DBサーバー',
    'admin.setting.system.system.web_server' => 'WEBサーバー',
    'admin.setting.system.system.php' => 'PHP',
    'admin.setting.system.system.user_agent' => 'User Agent',
    'admin.setting.system.system.php_info' => 'PHP情報',
    'admin.store' => 'オーナーズストア',
    'admin.store.template' => 'テンプレート',
    'admin.store.template.template_list' => 'テンプレート一覧',
    'admin.store.template.template_install' => 'アップロード',
    'admin.store.template.template_install__page_title' => 'テンプレートのアップロード',
    'admin.store.template.select' => '選択',
    'admin.store.template.save_path' => '保存先',
    'admin.store.template.download' => 'ダウンロード',
    'admin.store.template.upload_new_template' => '新規テンプレートアップロード',
    'admin.store.template.template_name' => 'テンプレート名',
    'admin.store.template.template_code' => 'テンプレートコード',
    'admin.store.template.template_file' => 'テンプレートファイル',
    'admin.store.template.file_format' => 'File format: zip,tar,tar.gz',
    'admin.store.template.delete_error__default_template' => 'デフォルトテンプレートは削除できません',
    'admin.store.template.delete_error__current_template' => '設定中のテンプレートは削除できません',
    'admin.store.template.template_code_already_exists' => 'テンプレートコードは既に利用されています',
    'admin.store.template.upload_failed' => 'アップロードに失敗しました',
    'admin.store.template.invalid_upload_file' => 'ファイルの拡張子に誤りがあります',
    'admin.store.plugin' => 'プラグイン',
    'admin.store.plugin.plugin_owners_install' => 'プラグインを探す',
    'admin.store.plugin.plugin_list' => 'プラグイン一覧',
    'admin.store.plugin.search.not_found' => '検索条件に該当するデータがありませんでした。',
    'admin.store.plugin.search.not_auth' => '認証キーを設定してください。',
    'admin.store.plugin.installed' => 'インストール済み',
    'admin.store.plugin.update' => 'アップデート',
    'admin.store.plugin.install.complete' => 'プラグインをインストールしました。',
    'admin.store.plugin.install.failed' => 'プラグインのインストールに失敗しました。',
    'admin.store.plugin.enable.complete' => '「%plugin_name%」を有効にしました。',
    'admin.store.plugin.already.enabled' => '「%plugin_name%」は既に有効です。',
    'admin.store.plugin.disable.complete' => '「%plugin_name%」を無効にしました。',
    'admin.store.plugin.already.disabled' => '「%plugin_name%」は既に無効です。',
    'admin.store.plugin.uninstall.complete' => 'プラグインを削除しました。',
    'admin.store.plugin.update.complete' => '「%plugin_name%」をアップデートしました。',
    'admin.store.plugin.update.failed' => '「%plugin_name%」のアップデートに失敗しました。',
    'admin.store.plugin.mkdir.error' => 'ディレクトリ「%dir_name%」の作成に失敗しました。',
    'admin.store.setting' => '認証キー設定',
    'admin.store.setting.api_key_setting' => '認証キー設定',
    'admin.store.setting.api_key_setting_info' => '認証キーをお持ちの場合は入力後、「登録」ボタンを押して下さい。',
    'admin.store.setting.api_key' => '認証キー',
    'admin.store.setting.api_key_tooltip' => '購入したプラグイン等のインストールに必要となるキーです。',
    'admin.store.setting.get_api_key' => '認証キー新規発行',
    'admin.store.setting.get_api_key_info' => '認証キーの新規発行と登録を行います。',
    'admin.store.setting.captcha_message' => '画像に表示されている文字を入力してください。',
    'admin.store.setting.php_path_setting' => 'PHPパスの設定',
    'admin.store.setting.php_path' => 'PHPパス',
    'admin.store.setting.invalid_captcha' => '入力された文字列が正しくありません。',
    'admin.store.setting.captcha_error' => 'エラー',
    'admin.store.package.api.0.error' => 'オーナーズストアとの通信に失敗しました。時間を置いてもう一度お試しください。',
    'admin.store.package.api.403.error' => 'オーナーズストアの認証に失敗しました。認証キーの設定を確認してください。',
    'admin.store.package.api.500.error' => 'オーナーズストアとの通信に失敗しました。時間を置いてもう一度お試しください。',
    'admin.plugin.uninstall.error.not_disable' => 'プラグインを無効にしてください。',
    'admin.plugin.uninstall.depend' => '「%depend_name%」が「%name%」に依存しているため削除できません。',
    'admin.plugin.disable.depend' => '「%name%」を無効にする前に、「%depend_name%」を無効にしてください。 ',
    'admin.store.plugin.popup.delete.confirm.title' => 'プラグインの削除を確認する',
    'admin.store.plugin.popup.delete.confirm.message' => 'このプラグインを削除してもよろしいですか？',
    'admin.store.authentication_setting.803' => 'オーナーズストア',
    'admin.store.authentication_setting.804' => 'プラグイン認証キーの設定',
    'admin.store.authentication_setting.805' => '認証キーの設定',
    'admin.store.authentication_setting.806' => '認証キー',
    'admin.store.authentication_setting.807' => '※認証キーは<a target="_blank" href="owners_store_url">EC-CUBEオーナーズストア</a>で取得できます。',
    'admin.store.authentication_setting.808' => '設定',
    'admin.store.plugin.809' => 'インストールプラグイン一覧',
    'admin.store.plugin.810' => 'オーナーズストア',
    'admin.store.plugin.811' => 'オーナーズストアから新規追加',
    'admin.store.plugin.812' => 'オーナーズストアのプラグイン',
    'admin.store.plugin.813' => 'アップロードして新規追加',
    'admin.store.plugin.814' => 'ユーザー独自プラグイン',
    'admin.store.plugin.815' => '未登録プラグイン',
    'admin.store.plugin.816' => 'プラグイン名',
    'admin.store.plugin.help' => 'オーナーズストアへの接続に問題があるため、詳細な情報を取得できませんでした。',
    'admin.store.plugin.install' => 'インストール',
    'admin.store.plugin.upgrade' => 'アップデート',
    'admin.store.plugin.price' => '販売価格',
    'admin.store.plugin.detail.download' => 'ダウンロード数',
    'admin.store.plugin.detail.version' => 'プラグインバージョン',
    'admin.store.plugin.detail.support' => 'EC-CUBE対応バージョン',
    'admin.store.plugin.detail.public_date' => '公開日',
    'admin.store.plugin.detail.update_date' => '最終更新日',
    'admin.store.plugin.detail.size' => 'ファイルサイズ',
    'admin.store.plugin.detail.size.format' => '約 %size% KB',
    'admin.store.plugin.detail.license' => 'ライセンス',
    'admin.store.plugin.detail.develop' => '制作者',
    'admin.store.plugin_confirm.title.upgrade' => 'アップデート',
    'admin.store.plugin_confirm.title' => 'インストール確認',
    'admin.store.plugin_confirm.subtitle' => 'オーナーズストア',
    'admin.store.plugin_confirm.header' => '以下のプラグインをインストールします',
    'admin.store.plugin_confirm.header.upgrade' => '以下のプラグインを最新版にアップデートします',
    'admin.store.plugin_confirm.require.header' => '「%name%」には以下のプラグインが必須です。同時にインストールされます',
    'admin.store.plugin_confirm_uninstall.823' => 'オーナーズストア',
    'admin.store.plugin_confirm_uninstall.824' => 'プラグイン削除',
    'admin.store.plugin_confirm_uninstall.825' => '以下のプラグインを削除します。',
    'admin.store.plugin_confirm_uninstall.826' => '削除',
    'admin.store.plugin_confirm_uninstall.827' => '戻る',
    'admin.store.plugin_handler.828' => 'オーナーズストア',
    'admin.store.plugin_handler.829' => '高度な設定',
    'admin.store.plugin_handler.830' => 'プラグイン名',
    'admin.store.plugin_handler.831' => 'ハンドラ名',
    'admin.store.plugin_handler.832' => '優先度',
    'admin.store.plugin_handler.833' => '操作',
    'admin.store.plugin_handler.834' => '上へ',
    'admin.store.plugin_handler.835' => '下へ',
    'admin.store.plugin_handler.836' => 'プラグインハンドラー管理',
    'admin.store.plugin_handler.837' => '検索条件に該当するデータがありませんでした',
    'admin.store.plugin_install.838' => 'オーナーズストア',
    'admin.store.plugin_install.839' => 'プラグインのアップロード',
    'admin.store.plugin_install.840' => '新規プラグインアップロード',
    'admin.store.plugin_install.841' => 'プラグイン<br>(zip、tar、tar.gz形式)',
    'admin.store.plugin_install.842' => 'アップロード',
    'admin.store.plugin_owners_confirm.843' => '価格',
    'admin.store.plugin_owners_confirm.844' => 'DL数',
    'admin.store.plugin_owners_confirm.845' => 'プラグインバージョン',
    'admin.store.plugin_owners_confirm.846' => '最終更新日',
    'admin.store.plugin_owners_confirm.847' => 'EC-CUBE対応バージョン',
    'admin.store.plugin_owners_confirm.848' => 'ファイルサイズ<br>約 %size% KB',
    'admin.store.plugin_owners_confirm.848.1' => 'ファイルサイズ',
    'admin.store.plugin_owners_confirm.848.2' => '約',
    'admin.store.plugin_owners_confirm.849' => 'ライセンス',
    'admin.store.plugin_owners_confirm.850' => 'このプラグインはEC-CUBE %version%をサポートしていないため、正常に動作しない可能性があります。',
    'admin.store.plugin_owners_confirm.851' => '%dependency%が必要です。同時にインストールされます。',
    'admin.store.plugin_owners_confirm.852' => '<strong>制作者</strong> : ',
    'admin.store.plugin_owners_install.853' => 'オーナーズストア',
    'admin.store.plugin_owners_install.854' => '購入済プラグイン',
    'admin.store.plugin_owners_install.855' => 'プラグイン一覧',
    'admin.store.plugin_owners_install.856' => '認証キーを設定してください',
    'admin.store.plugin_owners_install.857' => '認証キー設定画面へ',
    'admin.store.plugin_owners_panel.858' => 'おすすめ追加機能',
    'admin.store.plugin_owners_panel.859' => 'インストール済',
    'admin.store.plugin_owners_panel.860' => '今すぐ更新',
    'admin.store.plugin_owners_panel.861' => '今すぐ購入',
    'admin.store.plugin_owners_panel.862' => '今すぐインストール',
    'admin.store.plugin_owners_panel.863' => 'プラグインバージョン',
    'admin.store.plugin_owners_panel.864' => '更新日',
    'admin.store.plugin_owners_panel.865' => 'EC-CUBE対応バージョン',
    'admin.store.plugin_owners_panel.866' => 'ファイルサイズ<br>約 %size% KB',
    'admin.store.plugin_owners_panel.867' => 'このプラグインはEC-CUBE %version%をサポートしていないため、正常に動作しない可能性があります。',
    'admin.store.plugin_owners_panel.868' => '<strong>提供元</strong> : ',
    'admin.store.plugin_owners_search.form.placeholder' => 'すべて',
    'admin.store.plugin_owners_search.form.category' => 'カテゴリ',
    'admin.store.plugin_owners_search.form.price_type' => '有料／無料',
    'admin.store.plugin_owners_search.form.price_type.fee' => '有料',
    'admin.store.plugin_owners_search.form.price_type.free' => '無料',
    'admin.store.plugin_owners_search.form.keyword' => 'キーワード',
    'admin.store.plugin_owners_search.form.sort.new' => '新着順',
    'admin.store.plugin_owners_search.form.sort.price' => '価格が低い順',
    'admin.store.plugin_owners_search.form.sort.dl' => 'DL',
    'admin.store.plugin_owners_search.search_button' => '検索',
    'admin.store.plugin_owners_search.search_results' => '検索結果（%number%／%total%件）',
    'admin.store.plugin_owners_search.latest' => '最新バージョン：',
    'admin.store.plugin_owners_search.dl' => 'DL数',
    'admin.store.plugin_owners_search.support' => '対応バージョン',
    'admin.store.plugin_owners_search.detail' => '詳細',
    'admin.store.plugin_owners_search.install.free' => '入手する',
    'admin.store.plugin_owners_search.install.fee' => '購入する',
    'admin.store.plugin_owners_search.install' => 'インストール済み',
    'admin.store.plugin_owners_search.modal.header' => '商品詳細',
    'admin.store.plugin_owners_search.modal.contact' => '資料請求・お問い合わせ',
    'admin.store.plugin_owners_search.modal.manual' => 'マニュアルダウンロード',
    'admin.store.plugin_owners_search.modal.note' => 'このプラグインはEC-CUBE %version%をサポートしていないため、正常に動作しない可能性があります。',
    'admin.store.plugin_owners_search.modal.cancel' => '一覧に戻る',
    'admin.store.plugin_owners_search.modal.submit' => 'インストール確認へ',
    'admin.store.plugin_owners_search.modal.dependency' => '%dependency%が必要です。同時にインストールされます。',
    'admin.store.plugin_search.884' => 'オーナーズストア',
    'admin.store.plugin_search.885' => 'プラグインを探す',
    'admin.store.plugin_search.886' => '検索結果',
    'admin.store.plugin_table.887' => 'プラグイン名称',
    'admin.store.plugin_table.888' => 'バージョン',
    'admin.store.plugin_table.889' => 'コード',
    'admin.store.plugin_table.890' => 'アップデート',
    'admin.store.plugin_table.891' => '設定',
    'admin.store.plugin_table.892' => '(停止中)',
    'admin.store.plugin_table.893' => '無効にする',
    'admin.store.plugin_table.894' => '有効にする',
    'admin.store.plugin_table.895' => 'このプラグインを削除してもよろしいですか？',
    'admin.store.plugin_table.896' => '削除',
    'admin.store.plugin_table.897' => '詳細を表示',
    'admin.store.plugin_table.898' => 'アップデート',
    'admin.store.plugin_table.900' => 'インストールされているプラグインはありません。',
    'admin.store.plugin_table.901' => 'ステータス',
    'admin.store.plugin_table.902' => '有効化',
    'admin.store.plugin_table.903' => '無効化',
    'admin.store.plugin_table_official.901' => 'プラグイン名',
    'admin.store.plugin_table_official.902' => 'プラグインアイコン画像',
    'admin.store.plugin_table_official.903' => 'プラグインバージョン',
    'admin.store.plugin_table_official.904' => 'プラグインコード',
    'admin.store.plugin_table_official.905' => 'アップデート',
    'admin.store.plugin_table_official.906' => '設定',
    'admin.store.plugin_table_official.907' => '制作者',
    'admin.store.plugin_table_official.908' => '(停止中)',
    'admin.store.plugin_table_official.909' => '無効にする',
    'admin.store.plugin_table_official.910' => '有効にする',
    'admin.store.plugin_table_official.911' => '削除',
    'admin.store.plugin_table_official.912' => '詳細を表示',
    'admin.store.plugin_table_official.913' => 'アップロード',
    'admin.store.plugin_table_official.914' => '新バージョンのプラグインが利用可能です。',
    'admin.store.plugin_table_official.915' => '無効にする状態で利用可能',
    'admin.store.plugin_table_official.916' => 'アップデート',
    'admin.store.plugin_table_official.917' => 'プラグインバージョン：%version%',
    'admin.store.plugin_table_official.918' => 'EC-CUBE対応バージョン：%versions%',
    'admin.store.plugin_table_official.919' => '更新日：%update_date%',
    'admin.store.plugin_table_official.920' => 'アップデート対象プラグインはありません',
    'admin.store.plugin_table_official.921' => '詳細情報',
    'admin.store.plugin_table_official.924' => '有効化',
    'admin.store.plugin_table_official.925' => '無効化',
    'admin.store.plugin_table_official.923' => 'インストールされているプラグインはありません。',
    'admin.store.unregistered_plugin_table.941' => 'プラグイン',
    'admin.store.unregistered_plugin_table.942' => 'バージョン',
    'admin.store.unregistered_plugin_table.943' => 'コード',
    'admin.store.unregistered_plugin_table.944' => 'アップデート',
    'admin.store.unregistered_plugin_table.945' => '設定',
    'admin.store.unregistered_plugin_table.946' => '不明',
    'admin.store.unregistered_plugin_table.947' => '不明',
    'admin.store.unregistered_plugin_table.948' => '詳細を表示',
    'admin.store.unregistered_plugin_table.949' => '不明',
    'admin.store.unregistered_plugin_table.950' => '設定',
    'admin.store.install.label' => 'プラグイン (zip、tar、tar.gz形式)',
    'admin.info' => '情報',
    'admin.info.official_site' => '公式サイト',
    'admin.info.community' => '開発コミュニティ',
    'admin.info.document' => 'ドキュメント',
    'tooltip.product.multi_search_label' => '情報を入力して一覧の絞り込み検索ができます。より詳細な条件を指定するには［詳細検索］を開いてください。',
    'tooltip.product.product_id' => '自動的に採番される商品のIDです。',
    'tooltip.product.sale_type' => '通常商品やダウンロード商品といった販売方法が異なる場合に利用します。販売種別のリストは［マスターデータ管理］のmtb_sale_typeから編集できます。',
    'tooltip.product.image' => '複数の商品画像をドラッグ＆ドロップで登録できます。',
    'tooltip.product.description_detail' => '商品ページに表示される説明文です。HTMLタグが利用可能です。',
    'tooltip.product.description_list' => '商品一覧ページに表示される商品説明文です。未設定の場合、商品一覧画面に説明は表示されません。',
    'tooltip.product.normal_price' => '販売価格が特別な価格である場合、通常価格を併せて表示することができます。',
    'tooltip.product.search_word' => 'サイト内検索で利用されるキーワードです。',
    'tooltip.product.product_code' => '自由に設定できる商品コードです。',
    'tooltip.product.sale_limit' => '購入者が一度に購入できる個数を制限することができます。',
    'tooltip.product.delivery_duration' => '発送日の目安期間を商品ごとに登録できます。',
    'tooltip.product.product_class' => 'この商品に設定された規格を確認・管理できます。',
    'tooltip.product.free_area' => '商品詳細ページに入力内容が表示されます。表示位置はデザインテンプレートによって異なります。',
    'tooltip.product.shop_memo' => '店舗用のメモ欄です。フロント画面には表示されません。',
    'tooltip.product.backend_name' => '管理者用に別名を登録しておくことができます（例：規格名：サイズ　管理名：サイズ（服）、サイズ（靴）等 ）。フロント画面には表示されません。',
    'tooltip.product.csv_upload' => '所定の型のCSVデータを用いて商品を一括で登録することができます。',
    'tooltip.product.csv_format' => '雛形ファイルをダウンロードして編集すれば、簡単に所定の型のCSVデータを作成できます。',
    'tooltip.category.csv_upload' => '所定の型のCSVデータを用いてカテゴリを一括で登録することができます。',
    'tooltip.category.csv_format' => '雛形ファイルをダウンロードして編集すれば、簡単に所定の型のCSVデータを作成できます。',
    'tooltip.order.multi_search_label' => '情報を入力して一覧の絞り込み検索ができます。より詳細な条件を指定するには［詳細検索］を開いてください。',
    'tooltip.order.order_search_status' => '受注の対応状況による絞り込み検索ができます。カッコ内は対応すべき受注の件数が表示されています。',
    'tooltip.order.bulk_actions' => 'チェックを入れた受注に対して、一括処理を行います。充分に確認をしてから実行してください。',
    'tooltip.order.order_info' => '受注（注文）の基本情報です。',
    'tooltip.order.order_no' => '注文時に自動で採番される管理番号です。',
    'tooltip.order.order_status' => '新規受注登録以外は受注の対応状況を変更できます。1受注で出荷先が複数ある場合は、全て出荷されると対応状況が「出荷済」となります。',
    'tooltip.order.customer_id' => '自動的に採番される会員のIDです。',
    'tooltip.order.shipping_info' => '出荷先情報を表示します。出荷先の追加も可能です。1受注で複数の出荷先がある場合は「お届け先を編集」から出荷先詳細情報が確認できます。',
    'tooltip.order.shipping_info.tracking_number' => 'お問い合せ番号（出荷伝票番号）がある場合、こちらから入力できます。受注一覧からまとめて入力することも可能です。',
    'tooltip.order.shipping_info.delivery_provider' => '配達業者、配達方法を変更できます。変更後、送料が変わる可能性がありますので、ご注意ください。',
    'tooltip.order.shipping_info.shop_memo' => '出荷担当者、及び配送業者用のメモを保存しておけます。出荷用CSV等で確認が可能です。',
    'tooltip.order.product_info' => '購入された商品情報、及び、送料、手数料を含めた計算結果が表示されます。商品の追加や金額変更を行った場合は、計算結果の更新を行ってください。',
    'tooltip.order.shop_memo' => '店舗用メモを保存しておけます。フロント画面には表示されません。',
    'tooltip.order.mail_history' => 'これまでに配信したメールの確認・新規メールの作成ができます。',
    'tooltip.order.mail_destination_info' => '注文者にメールが送信できます。',
    'tooltip.order.mail_template' => 'メールのテンプレートを選択します。',
    'tooltip.order.mail_subject' => 'メールの件名を修正できます。',
    'tooltip.shipping.csv_upload' => '所定の型のCSVデータを用いて出荷情報を一括で登録することができます。',
    'tooltip.shipping.csv_format' => '雛形ファイルをダウンロードして編集すれば、簡単に所定の型のCSVデータを作成できます。',
    'tooltip.customer.multi_search_label' => '情報を入力して一覧の絞り込み検索ができます。より詳細な条件を指定するには［詳細検索］を開いてください。',
    'tooltip.customer.customer_id' => '自動的に採番される会員のIDです。',
    'tooltip.customer.customer_address' => 'この会員が登録しているお届け先です。この画面から追加することもできます。',
    'tooltip.customer.purchase_history' => 'この会員が注文をした履歴が表示されます。',
    'tooltip.customer.shop_memo' => '店舗用のメモ欄です。フロント側には表示されません。',
    'tooltip.content.news.url' => 'この新着情報の詳細な内容を記したウェブページある場合、URLを入力します。外部サイトのURLなどを利用することもできます。',
    'tooltip.content.news.body' => 'HTMLタグが利用可能です。',
    'tooltip.content.file.upload_file' => 'ファイルの追加は複数ファイルを選択してアップロードできます。',
    'tooltip.content.layout_edit' => 'テンプレートのセクションごとにブロックをドラッグ＆ドロップで配置することができます。',
    'tooltip.content.page_file_name' => 'ページの内容を記述したtwigテンプレートファイルの名前です。',
    'tooltip.content.page_source_code' => 'テンプレートファイルを編集します。twigで記述します。',
    'tooltip.content.page_layout' => 'このページに適用するレイアウトを選択します。',
    'tooltip.content.page_meta' => 'ページのMETAタグの内容を指定できます。',
    'tooltip.content.page_meta_tags' => '自由にMETAタグを追加できます。twig内で利用されている変数も利用できます。',
    'tooltip.content.css_source_code' => 'カスタマイズ用CSSファイルを編集します。CSSで記述します。',
    'tooltip.content.js_source_code' => 'カスタマイズ用JavaScriptファイルを編集します。JavaScriptで記述します。',
    'tooltip.content.block_name' => 'ブロックの管理用名称です。',
    'tooltip.content.block_file_name' => 'このブロックの内容を記述したtwigテンプレートファイルの名前です。管理画面ではあとから変更できません。',
    'tooltip.content.block_source_code' => 'テンプレートファイルを編集します。twigで記述します。',
    'tooltip.setting.shop.shop.email_from' => '店舗からメールを送信した場合の送信元になるメールアドレスです。',
    'tooltip.setting.shop.shop.email_for_inquiries' => '問い合わせフォームから問い合わせがあった場合に、その通知を受信するメールアドレスです。',
    'tooltip.setting.shop.shop.email_reply_to' => '返信メールを受け付けるメールアドレスです。',
    'tooltip.setting.shop.shop.email_return_path' => '店舗からメールを送信しエラーが生じた場合に、その通知を受信するメールアドレスです。',
    'tooltip.setting.shop.shop.good_traded' => '店舗が取り扱う商品についての簡単な説明文です。',
    'tooltip.setting.shop.shop.message' => 'フロント側に表示されます。表示位置はデザインテンプレートによって異なります。',
    'tooltip.setting.shop.shop.option_delivery_fee_free_amount' => 'この金額を超える購入があった場合、送料を無料とします。',
    'tooltip.setting.shop.shop.option_delivery_fee_free_quantity' => 'この個数を超える購入があった場合、送料を無料とします。',
    'tooltip.setting.shop.shop.option_delivery_fee_by_product' => 'ここをオンにすると、商品ごとに送料を指定できるようになります。',
    'tooltip.setting.shop.shop.option_customer_activate' => '顧客の会員登録直後は仮会員とし、メールアドレスの確認などを経て本会員として登録できる機能です。',
    'tooltip.setting.shop.shop.option_favorite_product' => '顧客が任意の商品をお気に入りとして登録できるようにする機能です。',
    'tooltip.setting.shop.shop.option_remember_me' => '顧客に一定期間の自動ログインを許可します。',
    'tooltip.setting.shop.shop.option_product_tax' => 'オンにすると、商品別に税率を設定することができるようになります。',
    'tooltip.setting.shop.shop.option_point_enabled' => 'オンにすると、ポイント機能を有効化できます。',
    'tooltip.setting.shop.shop.option_point_rate' => '購入金額に対するポイント付与率を編集できます。',
    'tooltip.setting.shop.shop.option_point_conversion_rate' => '1ポイントあたりの換算レートです。例：「1」と設定すると1ポイント「1円」として利用可能になります。',
    'tooltip.setting.shop.payment.logo_image' => '購入フローのお支払い方法に表示される画像を登録できます。登録がない場合は画像なしで表示されます。',
    'tooltip.setting.shop.delivery.tracking_number_url' => '配送業者のお問い合わせページURLを指定します。',
    'tooltip.setting.shop.delivery.sale_type' => 'この配送方法で取り扱える販売種別を指定します。',
    'tooltip.setting.shop.delivery.apply_to_pref' => 'すべての都道府県に同じ送料を一括で設定できます。あとから個々の都道府県の送料を書き換えることも可能です。',
    'tooltip.setting.shop.delivery.shop_memo' => '店舗用のメモ欄です。フロント側には表示されません。',
    'tooltip.setting.shop.tax_setting' => '商品共通の税率を設定できます。新しい税率を追加することで基本税率設定を上書きすることが可能です。',
    'tooltip.setting.shop.mail.mail_template' => '既存のメールテンプレートを選択してください。以下に内容が表示されます。',
    'tooltip.setting.shop.csv.csv_columns' => '各種のデータをCSVで出力できます。出力したい項目をこちらで設定することが可能です。',
    'tooltip.setting.shop.csv.csv_type' => '設定したいCSVの種類を指定してください。',
    'tooltip.setting.system.member.authority' => '権限管理で設定した権限を選択できます。',
    'tooltip.setting.system.member.work' => '一時的に非稼働にすることが可能です。必要ない場合はメンバー一覧より削除してください。',
    'tooltip.setting.system.security.admin_url' => '管理画面にログインするためのURLを指定します。推測されにくいURLを指定して下さい。',
    'tooltip.setting.system.security.ip_limit' => '管理画面にログインできる接続元のIPアドレスを制限します。',
    'tooltip.setting.system.security.force_ssl' => 'ショップサイトと管理画面への接続をSSL(https)での接続に制限します。',
    'tooltip.setting.system.log_display' => 'アクセスやエラー状況などのログを確認できます。',
    'tooltip.setting.system.master_data_management' => '各種マスターデータを管理します。',
    'tooltip.setting.system.system_info' => 'このEC-CUBEに関係しているシステム環境の情報を表示しています。',
    'tooltip.setting.system.system.php_info' => 'このEC-CUBEに関係しているPHPの詳細な情報を表示しています。',
    'install.next' => '次へ進む',
    'install.back' => '前へ戻る',
    'install.update' => '更新する',
    'install.title' => 'ようこそ | EC-CUBEインストール',
    'install.welcom' => 'ようこそ',
    'install.check_permission' => '権限チェック',
    'install.site_configuration' => 'サイトの設定',
    'install.database_configuration' => 'データベースの設定',
    'install.database_initalization' => 'データベースの初期化',
    'install.install_completed' => 'インストール完了',
    'install.start_eccube_installation' => '<p>EC-CUBEのインストールを開始します。</p><p>あらかじめ、使用するデータベースの情報（DB名など）をご準備ください。</p>',
    'install.cooperation_of_providing_information' => 'EC-CUBEのシステム向上・デバッグのため、サイト情報の提供にご協力おねがいいたします。<br>目的以外で利用することはございません。<br><span class="small">（サイト情報：お店のURL、PHPバージョン、DBバージョン）</span>',
    'install.accept_infomation_provision' => '送信を承諾する',
    'install.permission_is_valid' => 'アクセス権限は正常です',
    'install.permission_is_invalid' => '以下のファイルまたはディレクトリに書き込み権限を付与してください。',
    'install.system_requirement' => 'システム要件をご確認ください',
    'install.required_extension_disabled' => '[必須] %module%拡張モジュールが有効になっていません。',
    'install.required_database_extension_disabled' => '[必須] pdo_pgsql又はpdo_mysql 拡張モジュールを有効にしてください。',
    'install.recommend_extension_disabled' => '[推奨] %module%拡張モジュールが有効になっていません。',
    'install.mod_rewrite_unknown' => 'mod_rewrite が有効になっているか不明です。',
    'install.mod_rewrite_disabled' => '[必須] mod_rewrite が有効になっていません。',
    'install.member_name' => '管理者',
    'install.member_department' => NULL,
    'install.shop_name' => 'あなたの店名',
    'install.mail_address' => 'メールアドレス（受注メールなどの宛先になります）',
    'install.login_id' => '管理画面ログインID（半角英数字%min%～%max%文字）',
    'install.login_password' => '管理画面パスワード（半角英数字%min%～%max%文字）',
    'install.security_configuration' => 'セキュリティの設定',
    'install.directory_name' => '管理画面のディレクトリ名（半角英数字%min%～%max%文字）',
    'install.directory_name_notice' => 'セキュリティのため推測されにくいディレクトリ名を入力して下さい',
    'install.https_only' => 'サイトへのアクセスを、SSL（https）経由に制限します',
    'install.https_only_notice' => 'httpsからの接続でなければSSL制限を設定できません。',
    'install.ip_restriction' => '管理画面へのアクセスを、以下のIPに制限します',
    'install.ip_is_invalid' => '%ip%はIPv4アドレスではありません。',
    'install.mail_configuration' => 'メールの設定',
    'install.smtp_host' => 'SMTPホスト',
    'install.smtp_port' => 'SMTPポート',
    'install.smtp_user' => 'SMTPユーザー',
    'install.smtp_password' => 'SMTPパスワード',
    'install.database_type' => 'データベースの種類',
    'install.database_pgsql' => 'PostgreSQL',
    'install.database_mysql' => 'MySQL',
    'install.database_sqlite' => 'SQLite(開発者用)',
    'install.database_host' => 'データベースのホスト名',
    'install.database_port' => 'データベースのポート番号',
    'install.database_name' => 'データベース名',
    'install.database_user' => 'ユーザ名',
    'install.database_password' => 'パスワード',
    'install.database_connection_error' => 'データベースに接続できませんでした。',
    'install.database_do_initialize' => 'データベースの初期化を行います。初期化には少し時間がかかる場合があります。<br>すでにテーブル等が作成されている場合は中断されます。',
    'install.database_skip_notice' => '旧バージョンをインストールしていて、既存の情報を削除したくない場合はチェックをいれてください',
    'install.database_skip' => 'データベースの初期化を行わない',
    'install.completed' => 'インストールが完了しました！',
    'install.access_admin_page' => '管理画面にアクセスしてみましょう',
    'install.perform_initial_setting' => '先ほど登録したログインID・パスワードで、管理画面にログインすることができます。デザインの編集や商品を登録してみましょう！',
    'install.go_to_admin_page' => '管理画面を表示',
    'exception.error_title' => 'システムエラーが発生しました。',
    'exception.error_message' => '大変お手数ですが、サイト管理者までご連絡ください。',
    'exception.error_title_can_not_access' => 'アクセスできません。',
    'exception.error_message_can_not_access' => 'お探しのページはアクセスができない状況にあるか、移動もしくは削除された可能性があります。',
    'exception.error_title_not_found' => 'ページがみつかりません。',
    'exception.error_message_not_found' => 'URLに間違いがないかご確認ください。',
    'purchase_flow.delivery_fee_update' => '送料が更新されました。金額をご確認ください。',
    'purchase_flow.charge_update' => '手数料が更新されました。金額をご確認ください。',
    'purchase_flow.over_customer_point' => '利用ポイントが所有ポイントを上回っています。',
    'purchase_flow.over_payment_total' => '利用ポイントがお支払い金額を上回っています。',
    'purchase_flow.over_stock' => '「%name%」の在庫が足りません。',
    'command.composer_require_already_installed.not_supported_plugin' => '%name% %plugin_version% は EC-CUBE %eccube_version% には対応していません。続行しますか？',
  ),
));


return $catalogue;
