<?php

namespace Plugin\Atobaraidotcom4\Form\Type\Admin;

use Eccube\Common\EccubeConfig;
use Plugin\Atobaraidotcom4\Entity\Config;
use Plugin\Atobaraidotcom4\Util\PaymentUtil;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Context\ExecutionContextInterface;
use Plugin\Atobaraidotcom4\Repository\ConfigRepository;
use Plugin\Atobaraidotcom4\Service\AtobaraidotcomRequestService;
use Symfony\Component\DependencyInjection\ContainerInterface;

class ConfigType extends AbstractType
{
    /**
     * @var EccubeConfig
     */
    protected $eccubeConfig;

    /**
     * ConfigType constructor.
     *
     * @param EccubeConfig $eccubeConfig
     */
    public function __construct(
        EccubeConfig $eccubeConfig,
        AtobaraidotcomRequestService $atobaraidotcomRequestService,
        ConfigRepository $configRepository,
        ContainerInterface $container
    )
    {
        $this->eccubeConfig = $eccubeConfig;
        $this->Config = $configRepository->get();
        $this->atobaraidotcomRequestService = $atobaraidotcomRequestService;
        $this->container = $container;
    }

    /**
     * Build config type form
     *
     * @param FormBuilderInterface $builder
     * @param array $options
     * @return type
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        // $arrRequests['O_EnterpriseId'] = $this->Config->getEnterpriseId();
        // $arrRequests['O_SiteId'] = $this->Config->getSiteId();
        // $arrRequests['O_ApiUserId'] = $this->Config->getApiUserId();

        $delivery_option = array( "配送会社を選んでください" => "0" );
        if (!empty($this->Config->getEnterpriseId()) && !empty($this->Config->getApiUserId())) {

            $arrRequests['EnterpriseId'] = $this->Config->getEnterpriseId();
            $arrRequests['ApiUserId'] = $this->Config->getApiUserId();

            $arrXML = $this->atobaraidotcomRequestService->sendRequest( $this->container->getParameter('WC_TRUSTRING_ATOBARAIDOTCOM_DELIVLIST'), $arrRequests);

            $xml_obj = simplexml_load_string($arrXML);

            $arrResponse = $this->atobaraidotcomRequestService->xml2arr($xml_obj);
            logs('atobaraidotcom')->info('DELIVLIST LOAD status :'.$arrResponse["status"]);
            // $arrResponse = Atobaraidotcom_Config::sendRequest(WC_TRUSTRING_ATOBARAIDOTCOM_DELIVLIST, $arrRequests);
            // $xml_obj = simplexml_load_string($arrResponse);

            // $arrResponse = Atobaraidotcom_Config::xml2arr($xml_obj,2);
            // var_dump($arrResponse);
            if ($arrResponse["status"] == "success") {
                // var_dump($arrResponse["result"]["delivId"]);
                foreach ($arrResponse["resultdeliv"] as $key => $value) {
                    $delivery_option[$value["name"]] = $value["delivId"];
                }
                
                // array_push($delivery_option, array( $arrResponse["result"]["delivId"] => $arrResponse["result"]["name"]));
                 
            }
            // var_dump($delivery_option);
        }

        $builder

            ->add('enterprise_id', TextType::class, [
                'constraints' => [
                    new Assert\NotBlank(['message' => '※ 事業者IDが入力されていません。']),
                ],
            ])

            ->add('site_id', TextType::class, [
                'constraints' => [
                    new Assert\NotBlank(['message' => '※ サイトIDが入力されていません。']),
                ],
            ])

            ->add('api_user_id', TextType::class, [
                'constraints' => [
                    new Assert\NotBlank(['message' => '※ APIユーザーIDが入力されていません。']),
                ],
            ])

            ->add('tax_rate', ChoiceType::class, [
                'choices'  => array(    "8%" => "8",
                                        "10%" => "10" )
            ])

            ->add('delivery', ChoiceType::class, [
                'choices'  => $delivery_option,
            ])
        ;
    }
    /**
     * Config.
     *
     * @param OptionsResolver $resolver
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Config::class,
        ]);
    }
}
