<?php


namespace Plugin\AdminOrderPlus\Repository\Query;

use Eccube\Doctrine\Query\WhereClause;
use Eccube\Doctrine\Query\WhereCustomizer;
use Eccube\Repository\QueryKey;

class AdminOrderPlusCustomizer extends WhereCustomizer
{
    /**
     * 出荷日で絞り込み
     *
     * @param array $params
     * @param $queryKey
     *
     * @return WhereClause[]
     */
    protected function createStatements($params, $queryKey)
    {
        $rtn = [];
        if (!empty($params['shipping_schedule_date_start']) && $params['shipping_schedule_date_start']) {
            $rtn[] = WhereClause::gte('s.shipping_schedule_date', ':shipping_schedule_date_start', ['shipping_schedule_date_start' => $params['shipping_schedule_date_start']]);
        }

        if (!empty($params['shipping_schedule_date_end']) && $params['shipping_schedule_date_end']) {
            $shippingDateEnd = clone $params['shipping_schedule_date_end'];
            $shippingDateEnd = $shippingDateEnd->modify('+1 days');
            $rtn[] = WhereClause::lt('s.shipping_schedule_date', ':shipping_schedule_date_end', ['shipping_schedule_date_end' => $shippingDateEnd]);
        }

        return $rtn;
    }

    /**
     * カスタマイズ対象のキーを返します。
     *
     * @return string
     */
    public function getQueryKey()
    {
        return QueryKey::ORDER_SEARCH_ADMIN;
    }
}