<?php

namespace Plugin\SendAllMails4\Form\Extension;

use Eccube\Form\Type\Admin\OrderMailType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Regex;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\OptionsResolver\OptionsResolver;

class OrderMailTypeExtension extends AbstractTypeExtension
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        // 強引
        if ($options['add_form']) {
            $builder
                ->add('message', TextareaType::class, [
                    'label' => false,
                    'mapped' => false,
                    'required' => false,
                    'constraints' => [
                        //new TwigLint(),
                    ],
                ])
                ;
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(
            [
                'add_form' => false,
            ]
        );
    }

    public function getExtendedType()
    {
        return OrderMailType::class;
    }
}
