# images-generator

Generator of placeholder-type images using **GD** for **[fzaninotto/Faker](https://github.com/fzaninotto/Faker)**

![Sample image](https://cloud.githubusercontent.com/assets/3966713/10469009/a205715e-7202-11e5-8603-cdcf2191c5e1.png)

[![Build Status](https://travis-ci.org/bruceheller/images-generator.svg?branch=master)](https://travis-ci.org/bruceheller/images-generator)

## What is the goal of this project?

[Faker](https://github.com/fzaninotto/Faker) is an amazing tool to quickly generate bunch of fake data that looks real. You can refer to its documentation to learn more about the powerful things it can do.

One of the great option of [Faker](https://github.com/fzaninotto/Faker) is to be able to use [LoremPixel](http://lorempixel.com/) to get pretty pictures. It works great but has a few drawbacks:

 - By using an external source of data, image generation needs to be done on a connected environment. It might be ok for most usage, but can be a problem if you need to generate data on the go or somewhere not connected to the internet.
 - Also, because of the same reason, getting a lot of pictures can take a very loooong time as it downloads every picture. If you want to fill your data with hundreds of pictures, it might be problematic.
 - Finally, [LoremPixel](http://lorempixel.com/) only generates JPEG pictures, that can takes a large amount of storage.

**images-generator** comes in order to solve this problem. All pictures are directly generated by your current PHP setup using GD,  the almost standard for image manipulation in PHP.

**images-generator** can gets very useful for unit tests, integration servers, fixtures and many other cases...

Advantages of using **images-generator**:

 - **Fast image generation**
 - **No need of internet connection**
 - **Can generate both JPEG and PNG pictures**

Drawbacks of using **images-generator**:

 - Can't generate realistic pictures: That would be more complex to do (and slower). If you need real content, the only option for now is to stick with **LoremPixel** content.

## Installation

The easiest way is to use composer:

    composer require bheller/images-generator

Or if you prefer by modifying your composer.json file, add this line to the "require" section:

    "bheller/images-generator": "~1.0"

## Usage

Use the `ImagesGeneratorProvider` class in combinaison with [Faker](https://github.com/fzaninotto/Faker) to produce new images:

    <?php
    require __DIR__ .'/vendor/autoload.php';
    
    use bheller\ImagesGenerator\ImagesGeneratorProvider;

    $faker = Faker\Factory::create();
    $faker->addProvider(new ImagesGeneratorProvider($faker));
    $image = $faker->imageGenerator();
    ?>
    <img src="<?php echo $image; ?>">
It will generate a black png picture of 640*480 pixels inside your temp directory (if available) and return the full path of the picture like this: `'/tmp/13b73edae8443990be1aa8f1a483bc27.png'`.

## Parameters

The `imageGenerator()` method has many arguments. Here are the default values:

    imageGenerator($dir = null, $width = 640, $height = 480, $format = 'png', $fullPath = true, $text = null, $backgroundColor = null, $textColor = null)

Description:

 - **$dir**: (string) Path of the generated picture file. Must be writable. If omited, will default to the system temp directory (usualy /tmp on Linux systems).
 - **$width**: (integer) width in pixels of the picture, default to 640.
 - **$height**: (integer) height in pixels of the picture, default to 480.
 - **$format**: (string) format of the output picture file, can takes `jpg, jpeg or png` as valid values, default to png.
 - **$fullPath**: (boolean) If true, returns the full path of the file generated, otherwise will only return the filename, default to true.
 - **$text**: (string) If given, will output the text on the picture. Will try to make the font-size fit the picture size. Default to null (no text). *A special value can be used*, if set to `true`, will return the width and height as text of the picture (example: `640x480`).
 - **$backgroundColor**: (string) The hexadecimal color value (such as `'#1f1f1f'` or `'1f1f1f'`), default to black.
 - **$textColor**: (string) The hexadecimal color value (such as `'#ff2222'` or `'ff2222'`), default to white.

## Examples:

 - `$faker->imageGenerator(null, 640, 480, 'png', false, true, '#1f1f1f', '#ff2222')`
Will generate a 640x480 dark grey png picture with the text '640x480' in red and return the filename like this:

![Sample image](https://cloud.githubusercontent.com/assets/3966713/10468673/9a8dfe70-7200-11e5-814d-b82c852f520d.png)
 - `$faker->imageGenerator('img', 640, 480, 'png', true, 'Faker', '#0018ff', '#ffd800')`
Will generate a 640x480 blue png picture with the text 'Faker' in yellow inside an `img` directory of your project and return the full path such as `'img/f523f8bec6ed65fb1d63ae8d09850f9c.png'` like this:

![Sample image](https://cloud.githubusercontent.com/assets/3966713/10468752/12c05ce4-7201-11e5-8829-e58bb16e4262.png)

More complex example using the power of [Faker](https://github.com/fzaninotto/Faker):

 - `$faker->imageGenerator('img', $faker->numberBetween(600, 800), $faker->numberBetween(400, 600), 'jpg', true, $faker->word, $faker->hexColor, $faker->hexColor)`
Will return a jpeg of a random color picture with a width between 600 and 800 pixels, height between 400 and 600 pixels, with a random word written in a random color! This could generate pictures like theses:

![Sample image](https://cloud.githubusercontent.com/assets/3966713/10468916/143a28ec-7202-11e5-8afd-95a6b80096ac.png)

## Seeding the generator

The **images-generator** doesn't directly uses the seeding power of [Faker](https://github.com/fzaninotto/Faker). But you still can use it to generate the different parameters values. For example, this code will always output the same green picture with the same text (dolorum):

    $faker->seed(1234);
    $image = $faker->imageGenerator('img', $faker->numberBetween(600, 800), $faker->numberBetween(400, 600), 'jpg', true, $faker->word, $faker->hexColor, $faker->hexColor);

![Sample image](https://cloud.githubusercontent.com/assets/3966713/10468926/34711e2c-7202-11e5-9583-cd125a2ec9bf.png)

## Future developments

This is the first release, and it already should work for most usages. But I already have some goals for future releases to come:

 - Add support for **ImageMagick** and/or **GraphicsMagick** for faster generation of pictures.
 - Add support for **images-generator** in [Nelmio/Alice](https://github.com/nelmio/alice).
 - Add the ability to generate [identicon](https://en.wikipedia.org/wiki/Identicon) type of pictures
 - Add unit tests

Otherwise, any suggestion is welcome! You can fork this project and submit your PR.

## Tests

There are no unit tests included currently (see *Future developments*).

## License

**images-generator** is released under the MIT Licence. See the bundled LICENSE file for details.

The **[Roboto](https://github.com/google/roboto)** font file included in this project is under Apache Licence 2.0 as mentioned on the [Roboto](https://github.com/google/roboto) repository.