<?php

/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) Apteq CO.,LTD. All Rights Reserved.
 *
 */

namespace Plugin\ApteqPeriodical\Entity;

use Doctrine\ORM\Mapping as ORM;
use Eccube\Entity\AbstractEntity;
use Eccube\Entity\Order;
use Eccube\Entity\OrderItem;
use Eccube\Entity\Shipping;
use Plugin\ApteqPeriodical\Entity\Periodical;

/**
 * ApteqPeriodicalDetail
 *
 * @ORM\Table(name="plg_apteq_periodical_detail")
 * @ORM\Entity(repositoryClass="Plugin\ApteqPeriodical\Repository\PeriodicalDetailRepository")
 */
class PeriodicalDetail extends AbstractEntity
{

    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", options={"unsigned":true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="periodical_id", type="integer", options={"unsigned":true})
     */
    private $periodical_id;
    
    /**
     * @var int
     *
     * @ORM\Column(name="order_id", type="integer", options={"unsigned":true})
     */
    private $order_id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="last_shipping_date", type="datetimetz", nullable=true)
     */
    private $last_shipping_date;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="this_shipping_date", type="datetimetz", nullable=true)
     */
    private $this_shipping_date;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="next_shipping_date", type="datetimetz", nullable=true)
     */
    private $next_shipping_date;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="create_date", type="datetimetz")
     */
    private $create_date;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="update_date", type="datetimetz")
     */
    private $update_date;
    
    /**
     * Set id.
     *
     * @param int $id
     *
     * @return PeriodicalDetail
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }
    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    
    /**
     * Set periodical_id.
     *
     * @param int $periodical_id
     *
     * @return PeriodicalDetail
     */
    public function setPeriodicalId($periodical_id)
    {
        $this->periodical_id = $periodical_id;

        return $this;
    }
    /**
     * Get periodical_id.
     *
     * @return int
     */
    public function getPeriodicalId()
    {
        return $this->periodical_id;
    }
    
    /**
     * Set count.
     *
     * @param int $order_id
     *
     * @return PeriodicalDetail
     */
    public function setOrderId($order_id)
    {
        $this->order_id = $order_id;

        return $this;
    }
    /**
     * Get order_id.
     *
     * @return int
     */
    public function getOrderId()
    {
        return $this->order_id;
    }

     /**
     * Set last_shipping_date.
     *
     * @param \DateTime|null $last_shipping_date
     *
     * @return PeriodicalDetail
     */
    public function setLastShippingDate($last_shipping_date = null)
    {
        $this->last_shipping_date = $last_shipping_date;

        return $this;
    }
    /**
     * Get last_shipping_date.
     *
     * @return \DateTime|null
     */
    public function getLastShippingDate()
    {
        return $this->last_shipping_date;
    }
     /**
     * Set this_shipping_date.
     *
     * @param \DateTime|null $this_shipping_date
     *
     * @return PeriodicalDetail
     */
    public function setThisShippingDate($this_shipping_date = null)
    {
        $this->this_shipping_date = $this_shipping_date;

        return $this;
    }
    /**
     * Get this_shipping_date.
     *
     * @return \DateTime|null
     */
    public function getThisShippingDate()
    {
        return $this->this_shipping_date;
    }
    /**
     * Set next_shipping_date.
     *
     * @param \DateTime|null $next_shipping_date
     *
     * @return PeriodicalDetail
     */
    public function setNextShippingDate($next_shipping_date = null)
    {
        $this->next_shipping_date = $next_shipping_date;

        return $this;
    }
    /**
     * Get next_shipping_date.
     *
     * @return \DateTime|null
     */
    public function getNextShippingDate()
    {
        return $this->next_shipping_date;
    }
    
    /**
     * Set create_date.
     *
     * @param \DateTime $create_date
     *
     * @return PeriodicalDetail
     */
    public function setCreateDate($create_date)
    {
        $this->create_date = $create_date;

        return $this;
    }
    /**
     * Get create_date.
     *
     * @return \DateTime
     */
    public function getCreateDate()
    {
        return $this->create_date;
    }

    /**
     * Set update_date.
     *
     * @param \DateTime $updateDate
     *
     * @return PeriodicalDetail
     */
    public function setUpdateDate($update_date)
    {
        $this->update_date = $update_date;

        return $this;
    }
    /**
     * Get updateDate.
     *
     * @return \DateTime
     */
    public function getUpdateDate()
    {
        return $this->update_date;
    }

}