<?php

namespace Plugin\ApteqPeriodical\Controller\Admin;

use Plugin\ApteqPeriodical\Entity\Periodical;
use Plugin\ApteqPeriodical\Entity\PeriodicalDetail;
use Plugin\ApteqPeriodical\Repository\PeriodicalRepository;
use Plugin\ApteqPeriodical\Repository\PeriodicalDetailRepository;
use Eccube\Controller\AbstractController;
use Eccube\Repository\OrderRepository;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class PeriodicalStatusChangePageController.
 */
class PeriodicalStatusChangePageController extends AbstractController
{ 
    /**
     * @var PeriodicalRepository
     */
    protected $periodicalRepository;
/**
     * @var PeriodicalDetailRepository
     */
    protected $periodicalDetailRepository;

    /**
     * PeriodicalController constructor.
     *
     * @param PeriodicalRepository $periodicalRepository
     * @param PeriodicalDetailRepository $periodicalDetailRepository
     * 
     */
    public function __construct(
        PeriodicalRepository $periodicalRepository,
        PeriodicalDetailRepository $periodicalDetailRepository
    ) {
        $this->periodicalRepository = $periodicalRepository;
        $this->periodicalDetailRepository = $periodicalDetailRepository;
    }
    
    /**
     * 定期購入継続状況を変更する
     *
     * @Route("/%eccube_admin_route%/order/{id}/periodical_status_cahnge", requirements={"id" = "\d+"}, name="apteq_periodical_admin_order_cahnge_periodical_status")
     */
    public function index(Request $request, $id = null, RouterInterface $router)
    {    
        log_info('定期購入継続状況変更開始');
        
        $status = $request->query->get('status');
        $result = $this->periodicalDetailRepository->searchByOrderId($id);
        $result2 = $this->periodicalRepository->searchByPeriodicalId($result[0]->getPeriodicalId());
        $Periodical = $result2[0];
        
        $Periodical->setPeriodicalStatus($status);       
        
        
        $this->entityManager->persist($Periodical);
        $this->entityManager->flush();
        
        log_info('定期購入継続状況変更終了', [$result[0]->getPeriodicalId()]);
        
        //受注登録画面に戻る
        return $this->redirectToRoute('admin_order_edit', ['id' => $id, '_fragment' => 'teikiInfo']);
    }    
}
