<?php

namespace Plugin\RemisePayment4\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ルミーズ販売種別
 *
 * @ORM\Table(name="plg_remise_payment4_remise_sale_type")
 * @ORM\Entity(repositoryClass="Plugin\RemisePayment4\Repository\RemiseSaleTypeRepository")
 */
class RemiseSaleType
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="smallint", options={"unsigned":true})
     * @ORM\Id
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @var int
     *
     * @ORM\Column(name="sale_type", type="smallint", options={"unsigned":true})
     */
    private $sale_type;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="create_date", type="datetimetz")
     */
    private $create_date;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="update_date", type="datetimetz")
     */
    private $update_date;

    /**
     * Set id.
     *
     * @param int $id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name.
     *
     * @param string $name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set sale_type.
     *
     * @param int $sale_type
     *
     * @return $this
     */
    public function setSaleType($sale_type)
    {
        $this->sale_type = $sale_type;

        return $this;
    }

    /**
     * Get sale_type.
     *
     * @return int
     */
    public function getSaleType()
    {
        return $this->sale_type;
    }

    /**
     * @param \DateTime $create_date
     *
     * @return $this;
     */
    public function setCreateDate($create_date)
    {
        $this->create_date = $create_date;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreateDate()
    {
        return $this->create_date;
    }

    /**
     * @param \DateTime $update_date
     *
     * @return $this;
     */
    public function setUpdateDate($update_date)
    {
        $this->update_date = $update_date;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdateDate()
    {
        return $this->update_date;
    }
}
