<?php

namespace Plugin\Atobaraidotcom4\Controller\Admin;

use Eccube\Common\EccubeConfig;
use Eccube\Controller\AbstractController;
use Eccube\Entity\Payment;
use Eccube\Repository\PaymentRepository;
use Plugin\Atobaraidotcom4\Form\Type\Admin\ConfigType;
use Plugin\Atobaraidotcom4\Repository\ConfigRepository;
use Plugin\Atobaraidotcom4\Service\Method\AtobaraidotcomMethod;
use Symfony\Component\Form\FormError;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;

class ConfigController extends AbstractController
{

    /**
     * @var ConfigRepository
     */
    protected $configRepository;

    /**
     * ConfigController constructor.
     *
     * @param ValidatorInterface $validator
     * @param ConfigRepository $configRepository
     */
    public function __construct(
        EccubeConfig $eccubeConfig,
        ConfigRepository $configRepository,
        PaymentRepository $paymentRepository
    ) {
        $this->eccubeConfig = $eccubeConfig;
        $this->configRepository = $configRepository;
        $this->paymentRepository = $paymentRepository;
    }

    /**
     * @Route("/%eccube_admin_route%/atobaraidotcom/config", name="atobaraidotcom4_admin_config")
     * @Template("@Atobaraidotcom4/admin/config.twig")
     */
    public function index(Request $request)
    {
        $Config = $this->configRepository->get();

        $form = $this->createForm(ConfigType::class, $Config);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $Config = $form->getData();

            if ($form->isValid()) {
                // 決済方法を追加
                $this->savePaymentData();

                $this->entityManager->persist($Config);
                $this->entityManager->flush($Config);

                $this->addSuccess('登録しました。', 'admin');
                return $this->redirectToRoute('atobaraidotcom4_admin_config');
            }

        }

        return [
            'form' => $form->createView(),
        ];
    }

    /**
     * プラグイン設定情報、決済情報を登録
     *
     * @param array payment method name $Payments
     */
    public function savePaymentData()
    {
        $Payment = $this->paymentRepository->findOneBy([], ['sort_no' => 'DESC']);
        $sortNo = $Payment ? $Payment->getSortNo() + 1 : 1;

        $Payment = $this->paymentRepository->findOneBy(['method_class' => AtobaraidotcomMethod::class]);
        if (!$Payment) {
            $Payment = new Payment();
        }

        $Payment->setCharge(0);
        $Payment->setRuleMin(1);
        $Payment->setRuleMax(49999);
        $Payment->setSortNo($sortNo);
        $Payment->setVisible(true);
        $Payment->setMethod("後払い.com");
        $Payment->setMethodClass(AtobaraidotcomMethod::class);

        $this->entityManager->persist($Payment);
        $this->entityManager->flush($Payment);
    }

}
