<?php

namespace Plugin\ApteqPeriodical\Form\Extension;

use Eccube\Form\Type\Admin\SearchOrderType;
use Eccube\Entity\Shipping;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

/**
 * Class SearchOrderApteqPeriodicalExtension
 * @FormExtension
 */
class SearchOrderApteqPeriodicalExtension extends AbstractTypeExtension
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('sale_type', ChoiceType::class, array(
                'label' => '通常商品／定期購買商品',
                'required' => false,
                'choices'  => array(
                    '通常商品' => '1',
                    '定期購買商品' => '5',
                    //'旧）定期購買商品' => '3',
                ),
                'expanded' => true,
                'multiple' => true,
            ))
            ->add('periodical_status', ChoiceType::class, array(
                'label' => '定期購入継続状況',
                'required' => false,
                'choices'  => array(
                    '継続' => '1',
                    '休止' => '2',
                    '解約' => '3',
                ),
                'expanded' => true,
                'multiple' => true,
            ));
    }

    public function getExtendedType()
    {
        return SearchOrderType::class;
    }
}