<?php

namespace Plugin\ApgSimpleCalendar\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Config
 *
 * @ORM\Table(name="plg_apg_simple_calendar_config")
 * @ORM\Entity(repositoryClass="Plugin\ApgSimpleCalendar\Repository\ConfigRepository")
 */
class Config
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", options={"unsigned":true})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string|null
     *
     * @ORM\Column(name="regular_holidays", type="string", length=255)
     */
    private $regular_holidays;

    /**
     * @return string
     */
    public function getShowRegularHolidays()
    {
        $holidays = $this->getRegularHolidaysArr();
        $showStr = '';
        foreach ($holidays as $holiday) {
            $tmp = '';
            switch ($holiday) {
                case 1:
                    $tmp = '月曜日';
                    break;
                case 2:
                    $tmp = '火曜日';
                    break;
                case 3:
                    $tmp = '水曜日';
                    break;
                case 4:
                    $tmp = '木曜日';
                    break;
                case 5:
                    $tmp = '金曜日';
                    break;
                case 6:
                    $tmp = '土曜日';
                    break;
                case 7:
                    $tmp = '日曜日';
                    break;
            }
            if (!empty($showStr)) {
                $showStr .= ' / ';
            }
            $showStr .= $tmp;
        }
        return $showStr;
    }

    /**
     * @return null|string
     */
    public function getRegularHolidays(): ?string
    {
        return $this->regular_holidays;
    }

    /**
     * @param null|string $regular_holidays
     * @return Config
     */
    public function setRegularHolidays(?string $regular_holidays): Config
    {
        $this->regular_holidays = $regular_holidays;
        return $this;
    }

    /**
     * @return null|array
     */
    public function getRegularHolidaysArr(): ?array
    {
        if (!empty($this->regular_holidays)) {
            $tmp = explode(",", $this->regular_holidays);
        } else {
            $tmp = [];
        }
        return $tmp;
    }

    /**
     * @param null|array $regular_holidays
     * @return Config
     */
    public function setRegularHolidaysArr(?array $regular_holidays): Config
    {
        if (!empty($regular_holidays)) {
            $tmp = implode(",", $regular_holidays);
            $this->regular_holidays = $tmp;
        } else {
            $tmp = [];
            $this->regular_holidays = '';
        }
        return $this;
    }

}
