<?php

namespace Plugin\AdminOrderPlus\Entity;

use Doctrine\ORM\Mapping as ORM;
use Eccube\Annotation as Eccube;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Eccube\EntityExtension("Eccube\Entity\Shipping")
 */
trait ShippingTrait {

    /**
     * @ORM\Column(name="shipping_schedule_date", type="datetimetz", nullable=true)
     * @Eccube\FormAppend(
     *  auto_render=true,
     *  type="\Symfony\Component\Form\Extension\Core\Type\DateType",
     *  options={
     *    "required": false,
     *    "label": "発送予定日"
     *  }
     * )
     */
    private $shipping_schedule_date;

    public function getShippingScheduleDate() {
        return $this->shipping_schedule_date;
    }

    public function setShippingScheduleDate($shipping_schedule_date) {
        $this->shipping_schedule_date = $shipping_schedule_date;

        return $this;
    }
}